/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.util.Arrays;
import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.ArrayIndexScalar;
import mikera.vectorz.impl.ArraySubVector;

public abstract class ArrayVector
extends AVector {
    public abstract double[] getArray();

    public abstract int getArrayOffset();

    @Override
    public ArraySubVector subVector(int offset, int length) {
        int len = this.length();
        if (offset + length > len) {
            throw new IndexOutOfBoundsException("Upper bound " + len + " breached:" + (offset + length));
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Lower bound breached:" + offset);
        }
        return new ArraySubVector(this, offset, length);
    }

    @Override
    public AScalar slice(int position) {
        assert (position >= 0 && position < this.length());
        return new ArrayIndexScalar(this.getArray(), this.getArrayOffset() + position);
    }

    @Override
    public void copyTo(double[] data, int offset) {
        System.arraycopy(this.getArray(), this.getArrayOffset(), data, offset, this.length());
    }

    @Override
    public void fillRange(int offset, int length, double value) {
        if (offset < 0 || offset + length > this.length()) {
            throw new IndexOutOfBoundsException("Filling range offset=" + offset + " length=" + length);
        }
        double[] arr = this.getArray();
        int off = this.getArrayOffset();
        Arrays.fill(arr, off + offset, off + offset + length, value);
    }

    @Override
    public void set(AVector a) {
        assert (a.length() == this.length());
        a.copyTo(this.getArray(), this.getArrayOffset());
    }

    @Override
    public void set(AVector a, int offset) {
        assert (offset >= 0);
        assert (offset + this.length() <= a.length());
        a.copy(offset, this.length(), this, 0);
    }

    @Override
    public void add(AVector src) {
        if (src instanceof ArrayVector) {
            this.add((ArrayVector)src, 0);
            return;
        }
        int length = this.length();
        src.addToArray(0, this.getArray(), this.getArrayOffset(), length);
    }

    public void add(ArrayVector v) {
        assert (this.length() == v.length());
        this.add(v, 0);
    }

    @Override
    public void add(AVector src, int srcOffset) {
        if (src instanceof ArrayVector) {
            this.add((ArrayVector)src, srcOffset);
            return;
        }
        int length = this.length();
        src.addToArray(srcOffset, this.getArray(), this.getArrayOffset(), length);
    }

    @Override
    public void addMultiple(AVector v, double factor) {
        if (v instanceof ArrayVector) {
            this.addMultiple((ArrayVector)v, factor);
            return;
        }
        int length = this.length();
        v.addMultipleToArray(factor, 0, this.getArray(), this.getArrayOffset(), length);
    }

    @Override
    public void addProduct(AVector a, int aOffset, AVector b, int bOffset, double factor) {
        int length = this.length();
        double[] array = this.getArray();
        int offset = this.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = i + offset;
            array[n] = array[n] + a.get(i + aOffset) * b.get(i + bOffset) * factor;
        }
    }

    @Override
    public void addToArray(int offset, double[] array, int arrayOffset, int length) {
        double[] data = this.getArray();
        int dataOffset = this.getArrayOffset() + offset;
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + data[i + dataOffset];
        }
    }

    @Override
    public void addMultipleToArray(double factor, int offset, double[] array, int arrayOffset, int length) {
        double[] data = this.getArray();
        int dataOffset = this.getArrayOffset() + offset;
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * data[i + dataOffset];
        }
    }

    public void add(ArrayVector src, int srcOffset) {
        int length = this.length();
        double[] vdata = src.getArray();
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        int voffset = src.getArrayOffset() + srcOffset;
        for (int i = 0; i < length; ++i) {
            int n = offset + i;
            data[n] = data[n] + vdata[voffset + i];
        }
    }

    @Override
    public double elementSum() {
        double result = 0.0;
        int offset = this.getArrayOffset();
        int length = this.length();
        double[] array = this.getArray();
        for (int i = 0; i < length; ++i) {
            result += array[offset + i];
        }
        return result;
    }

    @Override
    public void multiply(AVector v) {
        v.multiplyTo(this.getArray(), this.getArrayOffset());
    }

    @Override
    public void multiply(double[] data, int offset) {
        int len = this.length();
        double[] cdata = this.getArray();
        int coffset = this.getArrayOffset();
        for (int i = 0; i < len; ++i) {
            this.set(i, cdata[i + coffset] * data[i + offset]);
        }
    }

    @Override
    public void multiplyTo(double[] data, int offset) {
        int len = this.length();
        double[] cdata = this.getArray();
        int coffset = this.getArrayOffset();
        for (int i = 0; i < len; ++i) {
            int n = i + offset;
            data[n] = data[n] * cdata[i + coffset];
        }
    }

    @Override
    public void divide(AVector v) {
        v.divideTo(this.getArray(), this.getArrayOffset());
    }

    @Override
    public void divide(double[] data, int offset) {
        int len = this.length();
        double[] cdata = this.getArray();
        int coffset = this.getArrayOffset();
        for (int i = 0; i < len; ++i) {
            this.set(i, cdata[i + coffset] / data[i + offset]);
        }
    }

    @Override
    public void divideTo(double[] data, int offset) {
        int len = this.length();
        double[] cdata = this.getArray();
        int coffset = this.getArrayOffset();
        for (int i = 0; i < len; ++i) {
            int n = i + offset;
            data[n] = data[n] / cdata[i + coffset];
        }
    }

    @Override
    public void copy(int start, int length, AVector dest, int destOffset) {
        if (dest instanceof ArrayVector) {
            this.copy(start, length, (ArrayVector)dest, destOffset);
            return;
        }
        double[] src = this.getArray();
        int off = this.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            dest.set(destOffset + i, src[off + start + i]);
        }
    }

    public void copy(int start, int length, ArrayVector dest, int destOffset) {
        double[] src = this.getArray();
        int off = this.getArrayOffset();
        double[] dst = dest.getArray();
        System.arraycopy(src, off + start, dst, destOffset, length);
    }

    public void addMultiple(ArrayVector v, double factor) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new Error("Source vector has different size: " + vlength);
        }
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = offset + i;
            data[n] = data[n] + vdata[voffset + i] * factor;
        }
    }

    @Override
    public double magnitudeSquared() {
        int length = this.length();
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            double v = data[offset + i];
            result += v * v;
        }
        return result;
    }

    @Override
    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }
}

