(ns net.molequedeideias.inga
  (:require [com.wsscode.pathom.core :as p]
            [com.wsscode.pathom.connect :as pc]
            [ring.util.mime-type :as mime]
            [io.pedestal.http :as http]
            [net.molequedeideias.inga.rest :as rest]
            [spec-coerce.core :as sc]))

(defn parse-boolean
  [x]
  (case x
    "true" true
    "false" false
    "on" true
    x))


(defmethod sc/sym->coercer `boolean? [_] parse-boolean)


(defmulti render ::render)

(defn std-parser
  [{::keys [register]
    :as    args}]
  (p/parser
    {::p/mutate  pc/mutate
     ::p/env     (assoc args ::p/reader [p/map-reader
                                         pc/reader2
                                         pc/open-ident-reader
                                         p/env-placeholder-reader]
                             ::p/placeholder-prefixes #{">"})
     ::p/plugins [(pc/connect-plugin {::pc/register (if (fn? register)
                                                      (register)
                                                      register)})
                  p/error-handler-plugin
                  p/elide-special-outputs-plugin]}))

(defn +parser
  [{::keys [parser]
    :as    args}]
  {:name  ::+parser
   :enter (fn [ctx]
            (let [parser (or parser
                             (std-parser args))]

              (-> ctx
                  (assoc-in [:request ::parser] parser)
                  (update :request (fn [req]
                                     (merge args req))))))})

(defn index-get
  [{::keys [parser index]
    :as    req}]
  (when index
    (let [result (parser req [index])
          body (get result index)]
      (when body
        {:body    body
         :headers {"Cache-Control"           "no-store"
                   "Content-Security-Policy" ""
                   "Content-Type"            (mime/default-mime-types "html")}
         :status  200}))))

(defn export
  ([args] (export nil args))
  ([prefix {::keys [register] :as args}]
   (let [parser (when-not (fn? register)
                  (std-parser args))
         args (assoc args
                ::parser parser)]
     `#{[~(str "/" prefix) :get [~(+parser args) index-get]
         :route-name ~(keyword "net.molequedeideias.inga" (str "index-" prefix))]
        [~(str (when prefix
                 (str "/" prefix))
               "/*path") :get [~(+parser args) index-get rest/get-rest]
         :route-name ~(keyword "net.molequedeideias.inga" (str "index*-" prefix))]
        [~(str (when prefix
                 (str "/" prefix))
               "/*path") :post [~(+parser args) rest/index-post]
         :route-name ~(keyword "net.molequedeideias.inga" (str "post-" prefix))]})))

(defn generate-routes
  [{::http/keys [routes]
    ::keys      [apps]
    :or         {routes #{}}
    :as         service-map}]
  (let [routes (into routes
                     cat
                     (for [{::keys [prefix] :as env} apps]
                       (export prefix (merge service-map
                                             env))))]
    (assoc service-map ::http/routes routes)))
