(ns net.molequedeideias.inga.task
  (:require [net.molequedeideias.inga :as inga]
            [com.wsscode.pathom.connect :as pc]
            [clojure.string :as string]
            [ring.util.mime-type :as mime]
            [spec-coerce.core :as sc]
            [io.pedestal.http.csrf :as csrf])
  (:import (java.net URLEncoder)))

(pc/defresolver all-mutation [{:keys       [parser]
                               ::inga/keys [mutation]
                               :as         env} {::pc/keys [indexes]}]
  {::pc/input  #{::pc/indexes}
   ::pc/output [::select-values
                ::args
                ::mutation]}
  (let [{::pc/keys [params]} (get-in indexes [::pc/index-mutations mutation])
        select-values (when params (parser env params))]
    {::select-values select-values
     ::args          params
     ::mutation      mutation}))


(defn paginated?
  [{::pc/keys [params]}]
  (boolean (some #{:edn-query-language.pagination/current-page
                   :edn-query-language.pagination/elements-per-page
                   :edn-query-language.pagination/cursor}
                 params)))

(defn match-routes
  [prefix router query]
  (comment
    (->> [["/a/{user/id}/b"]
          ["/b"
           ["/{user/id}"
            ["/c"]
            ["/d"]]]
          ["/e/{user/name}"]
          ["/f"]]
         (r/router)
         (r/routes)
         (filterv #(-> %
                       first
                       (impl/parse nil)
                       :path-params
                       :user/id)))
    #_[["/a/{user/id}/b" {}]
       ["/b/{user/id}/c" {}]
       ["/b/{user/id}/d" {}]])
  (when (coll? router)
    (into {} (for [ident query
                   :let [fqname (subs (str ident) 1)]]
               [ident (first (for [[id {::inga/keys [path]}] router
                                   :when (and (string? path)
                                              (string/includes? path (str "{" fqname "}")))]
                               (fn [v]
                                 (str (when prefix
                                        (str "/" prefix))
                                      (string/replace path (re-pattern (str "\\{" fqname "\\}"))
                                                      v)))))]))))

(pc/defresolver anti-forgery-token [{::csrf/keys [anti-forgery-token]} input]
  {::pc/output [::anti-forgery-token]}
  (when anti-forgery-token
    {::anti-forgery-token anti-forgery-token}))

(pc/defresolver prefix [{::inga/keys [prefix]} input]
  {::pc/output [::prefix]}
  {::prefix prefix})

(pc/defresolver default-params [{::inga/keys [default-params]} input]
  {::pc/output [::default-params]}
  {::default-params default-params})

(pc/defresolver query-params [{:keys [query-params]} {::keys [default-params]}]
  {::pc/output [::query-params]
   ::pc/input  #{::default-params}}
  {::query-params (merge default-params (sc/coerce-structure query-params))})


(pc/defresolver path-params [{::inga/keys [path-params]} input]
  {::pc/output [::path-params]}
  {::path-params (sc/coerce-structure path-params)})

(pc/defresolver downloads [{::inga/keys [dispatch-key display-properties]
                            :or         {dispatch-key :>/data}} {::keys [path-params prefix query-params]}]
  {::pc/input  #{::prefix ::query-params ::path-params}
   ::pc/output [::downloads]}
  (let [downloads (for [[k v] (select-keys mime/default-mime-types ["xls" "json"])
                        :let [href (str (when prefix
                                          (str "/" prefix))
                                        "/"
                                        (namespace dispatch-key)
                                        "/"
                                        (name dispatch-key)
                                        "?"
                                        (when (contains? path-params dispatch-key)
                                          (str "&ident-value=" (get path-params dispatch-key) "&"))
                                        (string/join "&"
                                                     (for [[k v] query-params
                                                           :when (not= (namespace k)
                                                                       "edn-query-language.pagination")]
                                                       (str (namespace k) "/" (name k)
                                                            "=" (str v))))
                                        (when query-params
                                          "&")
                                        (string/join "&"
                                                     (for [q (filterv keyword? display-properties)]

                                                       (str
                                                         "children="
                                                         (namespace q)
                                                         "/"
                                                         (name q))))
                                        "&content-type=" (URLEncoder/encode v))]]
                    {:label k
                     :href  href})]
    {::downloads downloads}))

(pc/defresolver all-opts [{::inga/keys [dispatch-key display-properties resolver ask-for]
                           :or         {dispatch-key :>/data}
                           :keys       [parser]
                           :as         env} {::inga/keys [router]
                                             ::pc/keys   [indexes]
                                             ::keys      [query-params path-params prefix]}]
  {::pc/input  #{::query-params
                 ::path-params
                 ::pc/indexes
                 ::inga/router
                 ::prefix}
   ::pc/output [::display-properties
                ::data
                ::single?
                ::paginated?
                ::ident->href-fn
                ::ask-for
                ::params]}
  (let [{::pc/keys [params]
         :as       resolver-data} (get-in indexes [::pc/index-resolvers resolver])
        all-resolvers (-> indexes ::pc/index-oir (get dispatch-key) vals (->> (mapcat identity)))
        key (if (contains? path-params dispatch-key)
              (find path-params dispatch-key)
              dispatch-key)
        key-with-params (if (empty? query-params)
                          key
                          `(~key ~query-params))
        paginated? (or (paginated? resolver-data)
                       (boolean (some #{:edn-query-language.pagination/elements-per-page
                                        :edn-query-language.pagination/current-page
                                        :edn-query-language.pagination/cursor}
                                      (for [resolver all-resolvers
                                            param (get-in indexes [::pc/index-resolvers resolver ::pc/params])]
                                        param))))
        query-keys (into []
                         (comp cat
                               (distinct))
                         [(filterv keyword? display-properties)
                          (for [mutation (filter symbol? display-properties)
                                arg (::pc/params (get-in indexes [::pc/index-mutations mutation]))]
                            arg)
                          (for [[k v] ask-for
                                :when (map? v)
                                v (concat (keys v) (vals v))]
                            v)])
        query* [{key-with-params (if paginated?
                                   [{:edn-query-language.pagination/edges query-keys}
                                    :edn-query-language.pagination/first-element-index
                                    :edn-query-language.pagination/last-element-index
                                    :edn-query-language.pagination/elements-per-page
                                    :edn-query-language.pagination/current-page
                                    :edn-query-language.pagination/cursor
                                    :edn-query-language.pagination/total-count]
                                   query-keys)}]
        result (parser env query*)
        data (get result key)
        ident->href-fn (match-routes prefix router query-keys)
        single? (and (not paginated?)
                     (map? data))
        data (cond
               paginated? data
               (map? data) {:edn-query-language.pagination/edges [data]}
               :else {:edn-query-language.pagination/edges data})]
    {::display-properties display-properties
     ::data               data
     ::single?            single?
     ::paginated?         paginated?
     ::ident->href-fn     ident->href-fn
     ::ask-for            ask-for
     ::params             params}))

(pc/defresolver key-labels [{::inga/keys [key-labels]} input]
  {::pc/output [::key-labels]}
  {::key-labels key-labels})

(defn register
  []
  [all-opts key-labels anti-forgery-token query-params path-params prefix default-params all-mutation downloads])
