(ns net.mynarz.az-kviz.macros
  (:require [clojure.zip :as zip]
            [hickory.core :as hickory]
            [hickory.zip :refer [hiccup-zip]]))

(defmacro read-file
  [file-path]
  (slurp file-path))

(defmacro load-svg
  "Load SVG from `file-path`, unwrap the root <svg> element, return as Hiccup."
  [file-path]
  (-> file-path
      slurp
      hickory/parse-fragment
      first
      hickory/as-hiccup
      hiccup-zip
      zip/down
      zip/node))
