// Compiled by ClojureScript 1.10.516 {}
goog.provide('net.mynarz.az_kviz.logic');
goog.require('cljs.core');
goog.require('net.mynarz.az_kviz.spec');
goog.require('net.mynarz.az_kviz.util');
goog.require('cljs.spec.alpha');
goog.require('clojure.set');
/**
 * Given a board with `side` length,
 *   test if coordinate [x y] is in the board.
 */
net.mynarz.az_kviz.logic.in_board_QMARK_ = (function net$mynarz$az_kviz$logic$in_board_QMARK_(side,p__13487){
var vec__13488 = p__13487;
var x = cljs.core.nth.call(null,vec__13488,(0),null);
var y = cljs.core.nth.call(null,vec__13488,(1),null);
var in_QMARK_ = ((function (vec__13488,x,y){
return (function net$mynarz$az_kviz$logic$in_board_QMARK__$_in_QMARK_(coord){
return (((coord >= (0))) && ((coord < side)));
});})(vec__13488,x,y))
;
var and__4120__auto__ = (x <= y);
if(and__4120__auto__){
var and__4120__auto____$1 = in_QMARK_.call(null,x);
if(cljs.core.truth_(and__4120__auto____$1)){
return in_QMARK_.call(null,y);
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});
/**
 * Given a board with `side` length,
 *   return neighbours of coordinate `coords`.
 */
net.mynarz.az_kviz.logic.neighbours = (function (){var possible_offsets = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-1),(-1)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(-1)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(0)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(1)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-1),(0)], null)], null);
return ((function (possible_offsets){
return (function (side,coords){
if(cljs.core.truth_(net.mynarz.az_kviz.logic.in_board_QMARK_.call(null,side,coords))){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,cljs.core.partial.call(null,net.mynarz.az_kviz.logic.in_board_QMARK_,side),cljs.core.map.call(null,cljs.core.partial.call(null,cljs.core.mapv,cljs.core._PLUS_,coords),possible_offsets)));
} else {
return null;
}
});
;})(possible_offsets))
})();
/**
 * Given a board with `side` length,
 *   return the board sides a coordinate [x y] is at.
 */
net.mynarz.az_kviz.logic.sides = (function net$mynarz$az_kviz$logic$sides(side,p__13491){
var vec__13492 = p__13491;
var x = cljs.core.nth.call(null,vec__13492,(0),null);
var y = cljs.core.nth.call(null,vec__13492,(1),null);
var G__13495 = cljs.core.PersistentHashSet.EMPTY;
var G__13495__$1 = (((x === (0)))?cljs.core.conj.call(null,G__13495,new cljs.core.Keyword(null,"a","a",-2123407586)):G__13495);
var G__13495__$2 = ((cljs.core._EQ_.call(null,x,y))?cljs.core.conj.call(null,G__13495__$1,new cljs.core.Keyword(null,"b","b",1482224470)):G__13495__$1);
if(cljs.core._EQ_.call(null,y,(side - (1)))){
return cljs.core.conj.call(null,G__13495__$2,new cljs.core.Keyword(null,"c","c",-1763192079));
} else {
return G__13495__$2;
}
});
/**
 * Initialize state of a tile in a board with `side` length,
 *   The tile has `id` and is located as `coords`.
 */
net.mynarz.az_kviz.logic.init_tile_state = (function net$mynarz$az_kviz$logic$init_tile_state(side,id,coords){
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"coords","coords",-599429112),coords,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"neighbours","neighbours",1596930053),net.mynarz.az_kviz.logic.neighbours.call(null,side,coords),new cljs.core.Keyword(null,"sides","sides",482708052),net.mynarz.az_kviz.logic.sides.call(null,side,coords),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.str.cljs$core$IFn$_invoke$arity$1((id + (1)))], null);
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("net.mynarz.az-kviz.logic","init-board-state","net.mynarz.az-kviz.logic/init-board-state",-2111008204,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Keyword("net.mynarz.az-kviz.spec","side","net.mynarz.az-kviz.spec/side",-1336193274)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Keyword("net.mynarz.az-kviz.spec","side","net.mynarz.az-kviz.spec/side",-1336193274)),cljs.spec.alpha.maybe_impl.call(null,new cljs.core.Keyword("net.mynarz.az-kviz.spec","side","net.mynarz.az-kviz.spec/side",-1336193274),new cljs.core.Keyword("net.mynarz.az-kviz.spec","side","net.mynarz.az-kviz.spec/side",-1336193274)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Keyword("net.mynarz.az-kviz.spec","side","net.mynarz.az-kviz.spec/side",-1336193274)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),null,null),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),null,null,null));
/**
 * Initialize the data for board with `side` length.
 *   Defaults to side lenght = 7, just like in AZ-kvíz.
 */
net.mynarz.az_kviz.logic.init_board_state = (function (){var row = (function net$mynarz$az_kviz$logic$row(y,length){
return cljs.core.map.call(null,cljs.core.vector,cljs.core.range.call(null,length),cljs.core.repeat.call(null,y));
});
return (function() {
var G__13496 = null;
var G__13496__0 = (function (){
return net.mynarz.az_kviz.logic.init_board_state.call(null,(7));
});
var G__13496__1 = (function (side){
var size = net.mynarz.az_kviz.util.triangular_number.call(null,side);
var ids = cljs.core.range.call(null,size);
var coords = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map_indexed.call(null,row,cljs.core.range.call(null,(1),(size + (1)))));
return cljs.core.mapv.call(null,cljs.core.partial.call(null,net.mynarz.az_kviz.logic.init_tile_state,side),ids,coords);
});
G__13496 = function(side){
switch(arguments.length){
case 0:
return G__13496__0.call(this);
case 1:
return G__13496__1.call(this,side);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13496.cljs$core$IFn$_invoke$arity$0 = G__13496__0;
G__13496.cljs$core$IFn$_invoke$arity$1 = G__13496__1;
return G__13496;
})()
})();
/**
 * Test if played owning `tiles` reached all sides of the board.
 */
net.mynarz.az_kviz.logic.owns_all_sides_QMARK_ = (function net$mynarz$az_kviz$logic$owns_all_sides_QMARK_(tiles){
return cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"c","c",-1763192079),null,new cljs.core.Keyword(null,"b","b",1482224470),null,new cljs.core.Keyword(null,"a","a",-2123407586),null], null), null),cljs.core.reduce.call(null,clojure.set.union,cljs.core.map.call(null,new cljs.core.Keyword(null,"sides","sides",482708052),tiles)));
});
/**
 * Look up tile by its `coords` in `tiles`.
 */
net.mynarz.az_kviz.logic.coords__GT_tile = (function net$mynarz$az_kviz$logic$coords__GT_tile(tiles,coords){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([coords]),new cljs.core.Keyword(null,"coords","coords",-599429112)),tiles));
});
/**
 * Test if `tiles` connect all sides of the board, starting from `tile`.
 */
net.mynarz.az_kviz.logic.all_sides_connected_from_tile_QMARK_ = (function net$mynarz$az_kviz$logic$all_sides_connected_from_tile_QMARK_(tiles,tile){
var owns_QMARK_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,new cljs.core.Keyword(null,"coords","coords",-599429112),tiles));
var __GT_tile = cljs.core.partial.call(null,net.mynarz.az_kviz.logic.coords__GT_tile,tiles);
var visited_sides = new cljs.core.Keyword(null,"sides","sides",482708052).cljs$core$IFn$_invoke$arity$1(tile);
var visited_coords = cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"coords","coords",-599429112).cljs$core$IFn$_invoke$arity$1(tile)]);
var coords_to_visit = cljs.core.filter.call(null,owns_QMARK_,new cljs.core.Keyword(null,"neighbours","neighbours",1596930053).cljs$core$IFn$_invoke$arity$1(tile));
while(true){
var or__4131__auto__ = cljs.core._EQ_.call(null,visited_sides,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"c","c",-1763192079),null,new cljs.core.Keyword(null,"b","b",1482224470),null,new cljs.core.Keyword(null,"a","a",-2123407586),null], null), null));
if(or__4131__auto__){
return or__4131__auto__;
} else {
var and__4120__auto__ = cljs.core.seq.call(null,coords_to_visit);
if(and__4120__auto__){
var next_coords = cljs.core.first.call(null,coords_to_visit);
var map__13511 = __GT_tile.call(null,next_coords);
var map__13511__$1 = (((((!((map__13511 == null))))?(((((map__13511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13511):map__13511);
var neighbours = cljs.core.get.call(null,map__13511__$1,new cljs.core.Keyword(null,"neighbours","neighbours",1596930053));
var sides = cljs.core.get.call(null,map__13511__$1,new cljs.core.Keyword(null,"sides","sides",482708052));
var G__13513 = clojure.set.union.call(null,visited_sides,sides);
var G__13514 = cljs.core.conj.call(null,visited_coords,next_coords);
var G__13515 = cljs.core.into.call(null,cljs.core.rest.call(null,coords_to_visit),cljs.core.filter.call(null,cljs.core.every_pred.call(null,cljs.core.complement.call(null,visited_coords),owns_QMARK_),neighbours));
visited_sides = G__13513;
visited_coords = G__13514;
coords_to_visit = G__13515;
continue;
} else {
return and__4120__auto__;
}
}
break;
}
});
/**
 * Test if `tiles` connect all sides of the board.
 */
net.mynarz.az_kviz.logic.all_sides_connected_QMARK_ = (function net$mynarz$az_kviz$logic$all_sides_connected_QMARK_(tiles){
return cljs.core.some.call(null,cljs.core.partial.call(null,net.mynarz.az_kviz.logic.all_sides_connected_from_tile_QMARK_,tiles),cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.seq,new cljs.core.Keyword(null,"sides","sides",482708052)),tiles)) === true;
});
/**
 * Does owning `tiles` in the `board-state` wins the game?
 */
net.mynarz.az_kviz.logic.winning_tiles_QMARK_ = (function net$mynarz$az_kviz$logic$winning_tiles_QMARK_(board_state,tiles){
var side = net.mynarz.az_kviz.util.triangle_size__GT_side.call(null,cljs.core.count.call(null,board_state));
return (((side <= cljs.core.count.call(null,tiles))) && (net.mynarz.az_kviz.logic.owns_all_sides_QMARK_.call(null,tiles)) && (net.mynarz.az_kviz.logic.all_sides_connected_QMARK_.call(null,tiles)));
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("net.mynarz.az-kviz.logic","player-won?","net.mynarz.az-kviz.logic/player-won?",353764899,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword(null,"player","player",-97687400),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword(null,"player","player",-97687400),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword(null,"player","player",-97687400)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword(null,"player","player",-97687400),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_,null,null),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),null,null,null));
/**
 * Given a `board-state` test if `player` has won the game.
 */
net.mynarz.az_kviz.logic.player_won_QMARK_ = (function net$mynarz$az_kviz$logic$player_won_QMARK_(board_state,player){
var owned_tiles = cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([player]),new cljs.core.Keyword(null,"status","status",-1997798413)),board_state);
return net.mynarz.az_kviz.logic.winning_tiles_QMARK_.call(null,board_state,owned_tiles);
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("net.mynarz.az-kviz.logic","who-won","net.mynarz.az-kviz.logic/who-won",-45617843,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585)),new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617))),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"board-state","board-state",1654825192)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585)),cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)),cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617),null),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)),null,null,null));
/**
 * Given a `board-state`, return the player who won or nil when there is no winner.
 */
net.mynarz.az_kviz.logic.who_won = (function net$mynarz$az_kviz$logic$who_won(board_state){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.partial.call(null,net.mynarz.az_kviz.logic.player_won_QMARK_,board_state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"player-1","player-1",-857374100),new cljs.core.Keyword(null,"player-2","player-2",-227455796)], null)));
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("net.mynarz.az-kviz.logic","can-win?","net.mynarz.az-kviz.logic/can-win?",-1077899211,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword(null,"player","player",-97687400),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword(null,"player","player",-97687400),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword(null,"player","player",-97687400)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585),new cljs.core.Keyword(null,"player","player",-97687400),new cljs.core.Keyword("net.mynarz.az-kviz.spec","player","net.mynarz.az-kviz.spec/player",-1861314617)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_,null,null),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),null,null,null));
/**
 * Given a `board-state`, test if `player` can still win.
 */
net.mynarz.az_kviz.logic.can_win_QMARK_ = (function net$mynarz$az_kviz$logic$can_win_QMARK_(board_state,player){
return net.mynarz.az_kviz.logic.winning_tiles_QMARK_.call(null,board_state,cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"missed","missed",-318745819),new cljs.core.Keyword(null,"default","default",-1987822328),player]),new cljs.core.Keyword(null,"status","status",-1997798413)),board_state));
});

//# sourceMappingURL=logic.js.map
