// Compiled by ClojureScript 1.10.516 {}
goog.provide('thi.ng.geom.vector');
goog.require('cljs.core');
goog.require('thi.ng.geom.core');
goog.require('thi.ng.math.core');
goog.require('thi.ng.dstruct.streams');
goog.require('thi.ng.xerror.core');









/**
* @constructor
 * @implements {thi.ng.geom.core.ITranslate}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {thi.ng.math.core.IDotProduct}
 * @implements {cljs.core.IReversible}
 * @implements {thi.ng.math.core.IMutableMathOps}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {thi.ng.math.core.ICrossProduct}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {thi.ng.math.core.IDeltaEquals}
 * @implements {thi.ng.geom.core.IPolar}
 * @implements {thi.ng.geom.vector.Object}
 * @implements {thi.ng.geom.core.IClear}
 * @implements {thi.ng.math.core.IInvert}
 * @implements {cljs.core.ICounted}
 * @implements {thi.ng.math.core.ILimit}
 * @implements {thi.ng.dstruct.streams.IBuffer}
 * @implements {cljs.core.ISeq}
 * @implements {thi.ng.math.core.IInterpolate}
 * @implements {cljs.core.INext}
 * @implements {thi.ng.math.core.IMathOps}
 * @implements {thi.ng.geom.core.ITransform}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {thi.ng.math.core.IMinMax}
 * @implements {thi.ng.geom.core.IRotate}
 * @implements {thi.ng.math.core.INormalize}
 * @implements {thi.ng.math.core.IMagnitude}
 * @implements {thi.ng.geom.core.IScale}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {thi.ng.geom.core.IReflect}
 * @implements {thi.ng.geom.core.IHeading}
 * @implements {thi.ng.geom.core.IDistance}
 * @implements {cljs.core.IComparable}
 * @implements {thi.ng.dstruct.streams.IIntoBuffer}
 * @implements {cljs.core.ISequential}
 * @implements {thi.ng.geom.core.INormal}
 * @implements {cljs.core.IWithMeta}
 * @implements {thi.ng.geom.core.IVectorReduce}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
thi.ng.geom.vector.Vec2 = (function (buf,_hash,_meta){
this.buf = buf;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2314101723;
this.cljs$lang$protocol_mask$partition1$ = 10240;
});
thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITransform$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITransform$transform$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.transform_vector.call(null,m,___$1);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = (- (self__.buf[(0)])));

(self__.buf[(1)] = (- (self__.buf[(1)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19258_19607 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19259_19608 = v.buf;
(self__.buf[(0)] = ((G__19258_19607[(0)]) - (G__19259_19608[(0)])));

(self__.buf[(1)] = ((G__19258_19607[(1)]) - (G__19259_19608[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__19258_19607[(0)]) - v));

(self__.buf[(1)] = ((G__19258_19607[(1)]) - v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__19258_19607[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__19258_19607[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19267_19609 = typeof v1 === 'number';
var G__19268_19610 = typeof v2 === 'number';
if(((G__19267_19609)?G__19268_19610:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) - v1));

(self__.buf[(1)] = ((self__.buf[(1)]) - v2));
} else {
var G__19269_19611 = (((!(G__19267_19609)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__19270_19612 = (((!(G__19268_19610)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__19261_19613 = (cljs.core.truth_(G__19269_19611)?v1.buf:null);
var G__19262_19614 = (cljs.core.truth_(G__19270_19612)?v2.buf:null);
var G__19263_19615 = (cljs.core.truth_(G__19269_19611)?(G__19261_19613[(0)]):((G__19267_19609)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19264_19616 = (cljs.core.truth_(G__19269_19611)?(G__19261_19613[(1)]):((G__19267_19609)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19265_19617 = (cljs.core.truth_(G__19270_19612)?(G__19262_19614[(0)]):((G__19268_19610)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19266_19618 = (cljs.core.truth_(G__19270_19612)?(G__19262_19614[(1)]):((G__19268_19610)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) - G__19263_19615) - G__19265_19617));

(self__.buf[(1)] = (((self__.buf[(1)]) - G__19264_19616) - G__19266_19618));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19271_19619 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19272_19620 = v.buf;
(self__.buf[(0)] = ((G__19271_19619[(0)]) * (G__19272_19620[(0)])));

(self__.buf[(1)] = ((G__19271_19619[(1)]) * (G__19272_19620[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__19271_19619[(0)]) * v));

(self__.buf[(1)] = ((G__19271_19619[(1)]) * v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__19271_19619[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__19271_19619[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19280_19621 = typeof v1 === 'number';
var G__19281_19622 = typeof v2 === 'number';
if(((G__19280_19621)?G__19281_19622:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) * v1));

(self__.buf[(1)] = ((self__.buf[(1)]) * v2));
} else {
var G__19282_19623 = (((!(G__19280_19621)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__19283_19624 = (((!(G__19281_19622)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__19274_19625 = (cljs.core.truth_(G__19282_19623)?v1.buf:null);
var G__19275_19626 = (cljs.core.truth_(G__19283_19624)?v2.buf:null);
var G__19276_19627 = (cljs.core.truth_(G__19282_19623)?(G__19274_19625[(0)]):((G__19280_19621)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19277_19628 = (cljs.core.truth_(G__19282_19623)?(G__19274_19625[(1)]):((G__19280_19621)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19278_19629 = (cljs.core.truth_(G__19283_19624)?(G__19275_19626[(0)]):((G__19281_19622)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19279_19630 = (cljs.core.truth_(G__19283_19624)?(G__19275_19626[(1)]):((G__19281_19622)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) * G__19276_19627) * G__19278_19629));

(self__.buf[(1)] = (((self__.buf[(1)]) * G__19277_19628) * G__19279_19630));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$subm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__19293_19631 = (a instanceof thi.ng.geom.vector.Vec2);
var G__19294_19632 = (b instanceof thi.ng.geom.vector.Vec2);
var G__19295_19633 = (((!(G__19293_19631)))?typeof a === 'number':null);
var G__19296_19634 = (((!(G__19294_19632)))?typeof b === 'number':null);
var G__19284_19635 = self__.buf;
var G__19285_19636 = ((G__19293_19631)?a.buf:null);
var G__19286_19637 = ((G__19294_19632)?b.buf:null);
var G__19287_19638 = (G__19284_19635[(0)]);
var G__19288_19639 = (G__19284_19635[(1)]);
var G__19289_19640 = ((G__19293_19631)?(G__19285_19636[(0)]):(cljs.core.truth_(G__19295_19633)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__19290_19641 = ((G__19293_19631)?(G__19285_19636[(1)]):(cljs.core.truth_(G__19295_19633)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__19291_19642 = ((G__19294_19632)?(G__19286_19637[(0)]):(cljs.core.truth_(G__19296_19634)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__19292_19643 = ((G__19294_19632)?(G__19286_19637[(1)]):(cljs.core.truth_(G__19296_19634)?b:cljs.core.nth.call(null,b,(1),1.0)));
(self__.buf[(0)] = ((G__19287_19638 - G__19289_19640) * G__19291_19642));

(self__.buf[(1)] = ((G__19288_19639 - G__19290_19641) * G__19292_19643));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$msub_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__19306_19644 = (a instanceof thi.ng.geom.vector.Vec2);
var G__19307_19645 = (b instanceof thi.ng.geom.vector.Vec2);
var G__19308_19646 = (((!(G__19306_19644)))?typeof a === 'number':null);
var G__19309_19647 = (((!(G__19307_19645)))?typeof b === 'number':null);
var G__19297_19648 = self__.buf;
var G__19298_19649 = ((G__19306_19644)?a.buf:null);
var G__19299_19650 = ((G__19307_19645)?b.buf:null);
var G__19300_19651 = (G__19297_19648[(0)]);
var G__19301_19652 = (G__19297_19648[(1)]);
var G__19302_19653 = ((G__19306_19644)?(G__19298_19649[(0)]):(cljs.core.truth_(G__19308_19646)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__19303_19654 = ((G__19306_19644)?(G__19298_19649[(1)]):(cljs.core.truth_(G__19308_19646)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__19304_19655 = ((G__19307_19645)?(G__19299_19650[(0)]):(cljs.core.truth_(G__19309_19647)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__19305_19656 = ((G__19307_19645)?(G__19299_19650[(1)]):(cljs.core.truth_(G__19309_19647)?b:cljs.core.nth.call(null,b,(1),0.0)));
(self__.buf[(0)] = ((G__19300_19651 * G__19302_19653) - G__19304_19655));

(self__.buf[(1)] = ((G__19301_19652 * G__19303_19654) - G__19305_19656));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$abs_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(0)])));

(self__.buf[(1)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(1)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$madd_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__19319_19657 = (a instanceof thi.ng.geom.vector.Vec2);
var G__19320_19658 = (b instanceof thi.ng.geom.vector.Vec2);
var G__19321_19659 = (((!(G__19319_19657)))?typeof a === 'number':null);
var G__19322_19660 = (((!(G__19320_19658)))?typeof b === 'number':null);
var G__19310_19661 = self__.buf;
var G__19311_19662 = ((G__19319_19657)?a.buf:null);
var G__19312_19663 = ((G__19320_19658)?b.buf:null);
var G__19313_19664 = (G__19310_19661[(0)]);
var G__19314_19665 = (G__19310_19661[(1)]);
var G__19315_19666 = ((G__19319_19657)?(G__19311_19662[(0)]):(cljs.core.truth_(G__19321_19659)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__19316_19667 = ((G__19319_19657)?(G__19311_19662[(1)]):(cljs.core.truth_(G__19321_19659)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__19317_19668 = ((G__19320_19658)?(G__19312_19663[(0)]):(cljs.core.truth_(G__19322_19660)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__19318_19669 = ((G__19320_19658)?(G__19312_19663[(1)]):(cljs.core.truth_(G__19322_19660)?b:cljs.core.nth.call(null,b,(1),0.0)));
(self__.buf[(0)] = ((G__19313_19664 * G__19315_19666) + G__19317_19668));

(self__.buf[(1)] = ((G__19314_19665 * G__19316_19667) + G__19318_19669));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((1) / (self__.buf[(0)])));

(self__.buf[(1)] = ((1) / (self__.buf[(1)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19323_19670 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19324_19671 = v.buf;
(self__.buf[(0)] = ((G__19323_19670[(0)]) / (G__19324_19671[(0)])));

(self__.buf[(1)] = ((G__19323_19670[(1)]) / (G__19324_19671[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__19323_19670[(0)]) / v));

(self__.buf[(1)] = ((G__19323_19670[(1)]) / v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__19323_19670[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__19323_19670[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19332_19672 = typeof v1 === 'number';
var G__19333_19673 = typeof v2 === 'number';
if(((G__19332_19672)?G__19333_19673:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) / v1));

(self__.buf[(1)] = ((self__.buf[(1)]) / v2));
} else {
var G__19334_19674 = (((!(G__19332_19672)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__19335_19675 = (((!(G__19333_19673)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__19326_19676 = (cljs.core.truth_(G__19334_19674)?v1.buf:null);
var G__19327_19677 = (cljs.core.truth_(G__19335_19675)?v2.buf:null);
var G__19328_19678 = (cljs.core.truth_(G__19334_19674)?(G__19326_19676[(0)]):((G__19332_19672)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19329_19679 = (cljs.core.truth_(G__19334_19674)?(G__19326_19676[(1)]):((G__19332_19672)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19330_19680 = (cljs.core.truth_(G__19335_19675)?(G__19327_19677[(0)]):((G__19333_19673)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19331_19681 = (cljs.core.truth_(G__19335_19675)?(G__19327_19677[(1)]):((G__19333_19673)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) / G__19328_19678) / G__19330_19680));

(self__.buf[(1)] = (((self__.buf[(1)]) / G__19329_19679) / G__19331_19681));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19336_19682 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19337_19683 = v.buf;
(self__.buf[(0)] = ((G__19336_19682[(0)]) + (G__19337_19683[(0)])));

(self__.buf[(1)] = ((G__19336_19682[(1)]) + (G__19337_19683[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__19336_19682[(0)]) + v));

(self__.buf[(1)] = ((G__19336_19682[(1)]) + v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__19336_19682[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__19336_19682[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19345_19684 = typeof v1 === 'number';
var G__19346_19685 = typeof v2 === 'number';
if(((G__19345_19684)?G__19346_19685:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) + v1));

(self__.buf[(1)] = ((self__.buf[(1)]) + v2));
} else {
var G__19347_19686 = (((!(G__19345_19684)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__19348_19687 = (((!(G__19346_19685)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__19339_19688 = (cljs.core.truth_(G__19347_19686)?v1.buf:null);
var G__19340_19689 = (cljs.core.truth_(G__19348_19687)?v2.buf:null);
var G__19341_19690 = (cljs.core.truth_(G__19347_19686)?(G__19339_19688[(0)]):((G__19345_19684)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19342_19691 = (cljs.core.truth_(G__19347_19686)?(G__19339_19688[(1)]):((G__19345_19684)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19343_19692 = (cljs.core.truth_(G__19348_19687)?(G__19340_19689[(0)]):((G__19346_19685)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19344_19693 = (cljs.core.truth_(G__19348_19687)?(G__19340_19689[(1)]):((G__19346_19685)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) + G__19341_19690) + G__19343_19692));

(self__.buf[(1)] = (((self__.buf[(1)]) + G__19342_19691) + G__19344_19693));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$addm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__19358_19694 = (a instanceof thi.ng.geom.vector.Vec2);
var G__19359_19695 = (b instanceof thi.ng.geom.vector.Vec2);
var G__19360_19696 = (((!(G__19358_19694)))?typeof a === 'number':null);
var G__19361_19697 = (((!(G__19359_19695)))?typeof b === 'number':null);
var G__19349_19698 = self__.buf;
var G__19350_19699 = ((G__19358_19694)?a.buf:null);
var G__19351_19700 = ((G__19359_19695)?b.buf:null);
var G__19352_19701 = (G__19349_19698[(0)]);
var G__19353_19702 = (G__19349_19698[(1)]);
var G__19354_19703 = ((G__19358_19694)?(G__19350_19699[(0)]):(cljs.core.truth_(G__19360_19696)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__19355_19704 = ((G__19358_19694)?(G__19350_19699[(1)]):(cljs.core.truth_(G__19360_19696)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__19356_19705 = ((G__19359_19695)?(G__19351_19700[(0)]):(cljs.core.truth_(G__19361_19697)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__19357_19706 = ((G__19359_19695)?(G__19351_19700[(1)]):(cljs.core.truth_(G__19361_19697)?b:cljs.core.nth.call(null,b,(1),1.0)));
(self__.buf[(0)] = ((G__19352_19701 + G__19354_19703) * G__19356_19705));

(self__.buf[(1)] = ((G__19353_19702 + G__19355_19704) * G__19357_19706));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IBuffer$get_float_buffer$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.buf;
});

thi.ng.geom.vector.Vec2.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(0)]))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(1)])),"]"].join('');
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,___$1);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (_,k,nf){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,___$1);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ICrossProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ICrossProduct$cross$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19362 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19363 = v.buf;
return (((G__19362[(0)]) * (G__19363[(1)])) - ((G__19362[(1)]) * (G__19363[(0)])));
} else {
return (((G__19362[(0)]) * cljs.core.nth.call(null,v,(1),0.0)) - ((G__19362[(1)]) * cljs.core.nth.call(null,v,(0),0.0)));
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (_,n){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (2))){
return (self__.buf[n]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,n);
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (_,n,nf){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (2))){
return (self__.buf[n]);
} else {
return nf;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (_,writer,opts){
var self__ = this;
var ___$1 = this;
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,"#vec2 ["," ","]",opts,cljs.core.seq.call(null,___$1));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (_,n,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array(self__.buf));
(b[n] = v);

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec2((new Float32Array(self__.buf)),self__._hash,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IReflect$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IReflect$reflect$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__19364 = self__.buf;
var G__19366 = (G__19364[(0)]);
var G__19367 = (G__19364[(1)]);
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19365 = v.buf;
var G__19368 = (G__19365[(0)]);
var G__19369 = (G__19365[(1)]);
var d = (((G__19366 * G__19368) + (G__19367 * G__19369)) * 2.0);
(b[(0)] = ((G__19368 * d) - G__19366));

(b[(1)] = ((G__19369 * d) - G__19367));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
var G__19368 = cljs.core.nth.call(null,v,(0),0.0);
var G__19369 = cljs.core.nth.call(null,v,(1),0.0);
var d = (((G__19366 * G__19368) + (G__19367 * G__19369)) * 2.0);
(b[(0)] = ((G__19368 * d) - G__19366));

(b[(1)] = ((G__19369 * d) - G__19367));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),null);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (2);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IDistance$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IDistance$dist$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return Math.sqrt(thi.ng.geom.core.dist_squared.call(null,___$1,v));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IDistance$dist_squared$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19370 = self__.buf;
var G__19372 = (G__19370[(0)]);
var G__19373 = (G__19370[(1)]);
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19371 = v.buf;
var G__19374 = (G__19371[(0)]);
var G__19375 = (G__19371[(1)]);
var dx = (G__19372 - G__19374);
var dy = (G__19373 - G__19375);
return ((dx * dx) + (dy * dy));
} else {
var G__19374 = cljs.core.nth.call(null,v,(0),0.0);
var G__19375 = cljs.core.nth.call(null,v,(1),0.0);
var dx = (G__19372 - G__19374);
var dy = (G__19373 - G__19375);
return ((dx * dx) + (dy * dy));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IRotate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IRotate$rotate$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((2)));
var G__19376 = self__.buf;
var G__19377 = (G__19376[(0)]);
var G__19378 = (G__19376[(1)]);
(b[(0)] = ((G__19377 * c) - (G__19378 * s)));

(b[(1)] = ((G__19377 * s) + (G__19378 * c)));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IStack$_peek$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(1)]);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IStack$_pop$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.buf[(0)])], null),self__._meta);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInvert$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInvert$invert$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core._.call(null,___$1);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.vector.swizzle2_fns.call(null,new cljs.core.Keyword(null,"yx","yx",1696579752)).call(null,___$1);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ILimit$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ILimit$limit$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
if((thi.ng.math.core.mag_squared.call(null,___$1) > (len * len))){
return thi.ng.math.core.normalize.call(null,___$1,len);
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IScale$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IScale$scale$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14087__auto__ = (new Float32Array((2)));
var G__19379_19707 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19380_19708 = v.buf;
(dest__14087__auto__[(0)] = ((G__19379_19707[(0)]) * (G__19380_19708[(0)])));

(dest__14087__auto__[(1)] = ((G__19379_19707[(1)]) * (G__19380_19708[(1)])));
} else {
if(typeof v === 'number'){
(dest__14087__auto__[(0)] = ((G__19379_19707[(0)]) * v));

(dest__14087__auto__[(1)] = ((G__19379_19707[(1)]) * v));
} else {
(dest__14087__auto__[(0)] = ((G__19379_19707[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__14087__auto__[(1)] = ((G__19379_19707[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__14087__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var or__4131__auto__ = self__._hash;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return ___$1._hash = cljs.core.mix_collection_hash.call(null,((cljs.core.imul.call(null,(((31) + cljs.core.hash.call(null,(self__.buf[(0)]))) | (0)),(31)) + cljs.core.hash.call(null,(self__.buf[(1)]))) | (0)),(2));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDeltaEquals$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,___$1,v,thi.ng.math.core._STAR_eps_STAR_);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$3 = (function (_,v,eps){
var self__ = this;
var ___$1 = this;
if(cljs.core.sequential_QMARK_.call(null,v)){
if(((2) === cljs.core.count.call(null,v))){
var G__19381 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19382 = v.buf;
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__19381[(0)]),(G__19382[(0)]),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__19381[(1)]),(G__19382[(1)]),eps);
} else {
return null;
}
} else {
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__19381[(0)]),cljs.core.nth.call(null,v,(0),0.0),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__19381[(1)]),cljs.core.nth.call(null,v,(1),0.0),eps);
} else {
return null;
}
}
} else {
return null;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec2)){
var b_SINGLEQUOTE_ = o.buf;
return ((((self__.buf[(0)]) === (b_SINGLEQUOTE_[(0)]))) && (((self__.buf[(1)]) === (b_SINGLEQUOTE_[(1)]))));
} else {
return ((cljs.core.sequential_QMARK_.call(null,o)) && (((2) === cljs.core.count.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(0)]),cljs.core.first.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(1)]),cljs.core.nth.call(null,o,(1)))));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IVectorReduce$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$3 = (function (_,f,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
return (new thi.ng.geom.vector.Vec2(thi.ng.geom.vector.vec2_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs),null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$4 = (function (_,f,f2,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
thi.ng.geom.vector.vec2_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs);

(buf_SINGLEQUOTE_[(0)] = f2.call(null,(buf_SINGLEQUOTE_[(0)]),(0)));

(buf_SINGLEQUOTE_[(1)] = f2.call(null,(buf_SINGLEQUOTE_[(1)]),(1)));

return (new thi.ng.geom.vector.Vec2(buf_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IIntoBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IIntoBuffer$into_float_buffer$arity$4 = (function (_,dest,stride,idx){
var self__ = this;
var ___$1 = this;
dest.set(self__.buf,idx);

return (idx + stride);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDotProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDotProduct$dot$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19383 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19384 = v.buf;
return (((G__19383[(0)]) * (G__19384[(0)])) + ((G__19383[(1)]) * (G__19384[(1)])));
} else {
return (((G__19383[(0)]) * cljs.core.nth.call(null,v,(0),0.0)) + ((G__19383[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$INormal$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$INormal$normal$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
(b[(0)] = (- (self__.buf[(1)])));

(b[(1)] = (self__.buf[(0)]));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,(self__.buf[(0)]),(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
return acc;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,start,(self__.buf[(0)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
var acc__$1 = f.call(null,acc,(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$1)){
return cljs.core.deref.call(null,acc__$1);
} else {
return acc__$1;
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITranslate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITranslate$translate$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14087__auto__ = (new Float32Array((2)));
var G__19385_19709 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19386_19710 = v.buf;
(dest__14087__auto__[(0)] = ((G__19385_19709[(0)]) + (G__19386_19710[(0)])));

(dest__14087__auto__[(1)] = ((G__19385_19709[(1)]) + (G__19386_19710[(1)])));
} else {
if(typeof v === 'number'){
(dest__14087__auto__[(0)] = ((G__19385_19709[(0)]) + v));

(dest__14087__auto__[(1)] = ((G__19385_19709[(1)]) + v));
} else {
(dest__14087__auto__[(0)] = ((G__19385_19709[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__14087__auto__[(1)] = ((G__19385_19709[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__14087__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(0)]);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),null);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$heading$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(1)]),(self__.buf[(0)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$heading_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.heading.call(null,___$1);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$angle_between$arity$2 = (function (_,a){
var self__ = this;
var ___$1 = this;
var t = (thi.ng.geom.core.heading.call(null,a) - thi.ng.geom.core.heading.call(null,___$1));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$slope_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(1)]) / (self__.buf[(0)]));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__19387_19711 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19388_19712 = v.buf;
(b[(0)] = (((G__19387_19711[(0)]) + (G__19388_19712[(0)])) * 0.5));

(b[(1)] = (((G__19387_19711[(1)]) + (G__19388_19712[(1)])) * 0.5));
} else {
if(typeof v === 'number'){
(b[(0)] = (((G__19387_19711[(0)]) + v) * 0.5));

(b[(1)] = (((G__19387_19711[(1)]) + v) * 0.5));
} else {
(b[(0)] = (((G__19387_19711[(0)]) + cljs.core.nth.call(null,v,(0),0.0)) * 0.5));

(b[(1)] = (((G__19387_19711[(1)]) + cljs.core.nth.call(null,v,(1),0.0)) * 0.5));
}
}

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix$arity$3 = (function (_,v,t){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__19398_19713 = (v instanceof thi.ng.geom.vector.Vec2);
var G__19399_19714 = (t instanceof thi.ng.geom.vector.Vec2);
var G__19400_19715 = (((!(G__19398_19713)))?typeof v === 'number':null);
var G__19401_19716 = (((!(G__19399_19714)))?typeof t === 'number':null);
var G__19389_19717 = self__.buf;
var G__19390_19718 = ((G__19398_19713)?v.buf:null);
var G__19391_19719 = ((G__19399_19714)?t.buf:null);
var G__19392_19720 = (G__19389_19717[(0)]);
var G__19393_19721 = (G__19389_19717[(1)]);
var G__19394_19722 = ((G__19398_19713)?(G__19390_19718[(0)]):(cljs.core.truth_(G__19400_19715)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__19395_19723 = ((G__19398_19713)?(G__19390_19718[(1)]):(cljs.core.truth_(G__19400_19715)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__19396_19724 = ((G__19399_19714)?(G__19391_19719[(0)]):(cljs.core.truth_(G__19401_19716)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__19397_19725 = ((G__19399_19714)?(G__19391_19719[(1)]):(cljs.core.truth_(G__19401_19716)?t:cljs.core.nth.call(null,t,(1),0.0)));
(b[(0)] = (((G__19394_19722 - G__19392_19720) * G__19396_19724) + G__19392_19720));

(b[(1)] = (((G__19395_19723 - G__19393_19721) * G__19397_19725) + G__19393_19721));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix$arity$6 = (function (_,b,c,d,u,v){
var self__ = this;
var ___$1 = this;
var b_SINGLEQUOTE_ = (new Float32Array((2)));
var dv_QMARK_ = (d instanceof thi.ng.geom.vector.Vec2);
var dn_QMARK_ = typeof d === 'number';
var dv = ((dv_QMARK_)?d.buf:null);
var dx = ((dv_QMARK_)?(dv[(0)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(0),0.0)));
var dy = ((dv_QMARK_)?(dv[(1)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(1),0.0)));
var G__19411_19726 = (b instanceof thi.ng.geom.vector.Vec2);
var G__19412_19727 = (c instanceof thi.ng.geom.vector.Vec2);
var G__19413_19728 = (((!(G__19411_19726)))?typeof b === 'number':null);
var G__19414_19729 = (((!(G__19412_19727)))?typeof c === 'number':null);
var G__19402_19730 = self__.buf;
var G__19403_19731 = ((G__19411_19726)?b.buf:null);
var G__19404_19732 = ((G__19412_19727)?c.buf:null);
var G__19405_19733 = (G__19402_19730[(0)]);
var G__19406_19734 = (G__19402_19730[(1)]);
var G__19407_19735 = ((G__19411_19726)?(G__19403_19731[(0)]):(cljs.core.truth_(G__19413_19728)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__19408_19736 = ((G__19411_19726)?(G__19403_19731[(1)]):(cljs.core.truth_(G__19413_19728)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__19409_19737 = ((G__19412_19727)?(G__19404_19732[(0)]):(cljs.core.truth_(G__19414_19729)?c:cljs.core.nth.call(null,c,(0),0.0)));
var G__19410_19738 = ((G__19412_19727)?(G__19404_19732[(1)]):(cljs.core.truth_(G__19414_19729)?c:cljs.core.nth.call(null,c,(1),0.0)));
var x1_19739 = (((G__19407_19735 - G__19405_19733) * u) + G__19405_19733);
var y1_19740 = (((G__19408_19736 - G__19406_19734) * u) + G__19406_19734);
(b_SINGLEQUOTE_[(0)] = ((((((dx - G__19409_19737) * u) + G__19409_19737) - x1_19739) * v) + x1_19739));

(b_SINGLEQUOTE_[(1)] = ((((((dy - G__19410_19738) * u) + G__19410_19738) - y1_19740) * v) + y1_19740));

return (new thi.ng.geom.vector.Vec2(b_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix_with$arity$4 = (function (_,v,t,f){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__19424_19741 = (v instanceof thi.ng.geom.vector.Vec2);
var G__19425_19742 = (t instanceof thi.ng.geom.vector.Vec2);
var G__19426_19743 = (((!(G__19424_19741)))?typeof v === 'number':null);
var G__19427_19744 = (((!(G__19425_19742)))?typeof t === 'number':null);
var G__19415_19745 = self__.buf;
var G__19416_19746 = ((G__19424_19741)?v.buf:null);
var G__19417_19747 = ((G__19425_19742)?t.buf:null);
var G__19418_19748 = (G__19415_19745[(0)]);
var G__19419_19749 = (G__19415_19745[(1)]);
var G__19420_19750 = ((G__19424_19741)?(G__19416_19746[(0)]):(cljs.core.truth_(G__19426_19743)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__19421_19751 = ((G__19424_19741)?(G__19416_19746[(1)]):(cljs.core.truth_(G__19426_19743)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__19422_19752 = ((G__19425_19742)?(G__19417_19747[(0)]):(cljs.core.truth_(G__19427_19744)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__19423_19753 = ((G__19425_19742)?(G__19417_19747[(1)]):(cljs.core.truth_(G__19427_19744)?t:cljs.core.nth.call(null,t,(1),0.0)));
(b[(0)] = f.call(null,G__19418_19748,G__19420_19750,G__19422_19752));

(b[(1)] = f.call(null,G__19419_19749,G__19421_19751,G__19423_19753));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$step$arity$2 = (function (_,e){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__19428_19754 = self__.buf;
if((e instanceof thi.ng.geom.vector.Vec2)){
var G__19429_19755 = e.buf;
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,(G__19429_19755[(0)]),(G__19428_19754[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,(G__19429_19755[(1)]),(G__19428_19754[(1)])));
} else {
if(typeof e === 'number'){
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,e,(G__19428_19754[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,e,(G__19428_19754[(1)])));
} else {
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(0),0.0),(G__19428_19754[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(1),0.0),(G__19428_19754[(1)])));
}
}

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$smoothstep$arity$3 = (function (_,e1,e2){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__19439_19756 = (e1 instanceof thi.ng.geom.vector.Vec2);
var G__19440_19757 = (e2 instanceof thi.ng.geom.vector.Vec2);
var G__19441_19758 = (((!(G__19439_19756)))?typeof e1 === 'number':null);
var G__19442_19759 = (((!(G__19440_19757)))?typeof e2 === 'number':null);
var G__19430_19760 = self__.buf;
var G__19431_19761 = ((G__19439_19756)?e1.buf:null);
var G__19432_19762 = ((G__19440_19757)?e2.buf:null);
var G__19433_19763 = (G__19430_19760[(0)]);
var G__19434_19764 = (G__19430_19760[(1)]);
var G__19435_19765 = ((G__19439_19756)?(G__19431_19761[(0)]):(cljs.core.truth_(G__19441_19758)?e1:cljs.core.nth.call(null,e1,(0),0.0)));
var G__19436_19766 = ((G__19439_19756)?(G__19431_19761[(1)]):(cljs.core.truth_(G__19441_19758)?e1:cljs.core.nth.call(null,e1,(1),0.0)));
var G__19437_19767 = ((G__19440_19757)?(G__19432_19762[(0)]):(cljs.core.truth_(G__19442_19759)?e2:cljs.core.nth.call(null,e2,(0),0.0)));
var G__19438_19768 = ((G__19440_19757)?(G__19432_19762[(1)]):(cljs.core.truth_(G__19442_19759)?e2:cljs.core.nth.call(null,e2,(1),0.0)));
(b[(0)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__19435_19765,G__19437_19767,G__19433_19763));

(b[(1)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__19435_19765,G__19438_19768,G__19434_19764));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
return (((k >= (0))) && ((k < (2))));
} else {
if(cljs.core.truth_(thi.ng.geom.vector.swizzle2_fns.call(null,k))){
return true;
} else {
return false;
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (_,k,v){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
if((((k === (0))) || ((k === (1))))){
var b = (new Float32Array(self__.buf));
(b[k] = v);

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
if((k === (2))){
return cljs.core.conj.call(null,___$1,v);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
} else {
if((k instanceof cljs.core.Keyword)){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"z","z",-789527183),k)){
return cljs.core.conj.call(null,___$1,v);
} else {
return (new thi.ng.geom.vector.Vec2(thi.ng.geom.vector.swizzle_assoc_STAR_.call(null,self__.buf,(new Float32Array(self__.buf)),new cljs.core.PersistentArrayMap(null, 2, ["x",(0),"y",(1)], null),k,v),null,self__._meta));
}
} else {
return null;
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$min$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14087__auto__ = (new Float32Array((2)));
var G__19443_19769 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19444_19770 = v.buf;
(dest__14087__auto__[(0)] = (function (){var a__13835__auto__ = (G__19443_19769[(0)]);
var b__13836__auto__ = (G__19444_19770[(0)]);
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14087__auto__[(1)] = (function (){var a__13835__auto__ = (G__19443_19769[(1)]);
var b__13836__auto__ = (G__19444_19770[(1)]);
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__14087__auto__[(0)] = (function (){var a__13835__auto__ = (G__19443_19769[(0)]);
var b__13836__auto__ = v;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14087__auto__[(1)] = (function (){var a__13835__auto__ = (G__19443_19769[(1)]);
var b__13836__auto__ = v;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());
} else {
(dest__14087__auto__[(0)] = (function (){var a__13835__auto__ = (G__19443_19769[(0)]);
var b__13836__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14087__auto__[(1)] = (function (){var a__13835__auto__ = (G__19443_19769[(1)]);
var b__13836__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec2(dest__14087__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$min$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__14098__auto__ = (new Float32Array((2)));
var G__19454_19771 = (v instanceof thi.ng.geom.vector.Vec2);
var G__19455_19772 = (v2 instanceof thi.ng.geom.vector.Vec2);
var G__19456_19773 = (((!(G__19454_19771)))?typeof v === 'number':null);
var G__19457_19774 = (((!(G__19455_19772)))?typeof v2 === 'number':null);
var G__19445_19775 = self__.buf;
var G__19446_19776 = ((G__19454_19771)?v.buf:null);
var G__19447_19777 = ((G__19455_19772)?v2.buf:null);
var G__19448_19778 = (G__19445_19775[(0)]);
var G__19449_19779 = (G__19445_19775[(1)]);
var G__19450_19780 = ((G__19454_19771)?(G__19446_19776[(0)]):(cljs.core.truth_(G__19456_19773)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__19451_19781 = ((G__19454_19771)?(G__19446_19776[(1)]):(cljs.core.truth_(G__19456_19773)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__19452_19782 = ((G__19455_19772)?(G__19447_19777[(0)]):(cljs.core.truth_(G__19457_19774)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19453_19783 = ((G__19455_19772)?(G__19447_19777[(1)]):(cljs.core.truth_(G__19457_19774)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(dest__14098__auto__[(0)] = (function (){var a__13835__auto__ = (function (){var a__13835__auto__ = G__19448_19778;
var b__13836__auto__ = G__19450_19780;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})();
var b__13836__auto__ = G__19452_19782;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14098__auto__[(1)] = (function (){var a__13835__auto__ = (function (){var a__13835__auto__ = G__19449_19779;
var b__13836__auto__ = G__19451_19781;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})();
var b__13836__auto__ = G__19453_19783;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

return (new thi.ng.geom.vector.Vec2(dest__14098__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$max$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14087__auto__ = (new Float32Array((2)));
var G__19458_19784 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19459_19785 = v.buf;
(dest__14087__auto__[(0)] = (function (){var a__13842__auto__ = (G__19458_19784[(0)]);
var b__13843__auto__ = (G__19459_19785[(0)]);
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14087__auto__[(1)] = (function (){var a__13842__auto__ = (G__19458_19784[(1)]);
var b__13843__auto__ = (G__19459_19785[(1)]);
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__14087__auto__[(0)] = (function (){var a__13842__auto__ = (G__19458_19784[(0)]);
var b__13843__auto__ = v;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14087__auto__[(1)] = (function (){var a__13842__auto__ = (G__19458_19784[(1)]);
var b__13843__auto__ = v;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());
} else {
(dest__14087__auto__[(0)] = (function (){var a__13842__auto__ = (G__19458_19784[(0)]);
var b__13843__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14087__auto__[(1)] = (function (){var a__13842__auto__ = (G__19458_19784[(1)]);
var b__13843__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec2(dest__14087__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$max$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__14098__auto__ = (new Float32Array((2)));
var G__19469_19786 = (v instanceof thi.ng.geom.vector.Vec2);
var G__19470_19787 = (v2 instanceof thi.ng.geom.vector.Vec2);
var G__19471_19788 = (((!(G__19469_19786)))?typeof v === 'number':null);
var G__19472_19789 = (((!(G__19470_19787)))?typeof v2 === 'number':null);
var G__19460_19790 = self__.buf;
var G__19461_19791 = ((G__19469_19786)?v.buf:null);
var G__19462_19792 = ((G__19470_19787)?v2.buf:null);
var G__19463_19793 = (G__19460_19790[(0)]);
var G__19464_19794 = (G__19460_19790[(1)]);
var G__19465_19795 = ((G__19469_19786)?(G__19461_19791[(0)]):(cljs.core.truth_(G__19471_19788)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__19466_19796 = ((G__19469_19786)?(G__19461_19791[(1)]):(cljs.core.truth_(G__19471_19788)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__19467_19797 = ((G__19470_19787)?(G__19462_19792[(0)]):(cljs.core.truth_(G__19472_19789)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19468_19798 = ((G__19470_19787)?(G__19462_19792[(1)]):(cljs.core.truth_(G__19472_19789)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(dest__14098__auto__[(0)] = (function (){var a__13842__auto__ = (function (){var a__13842__auto__ = G__19463_19793;
var b__13843__auto__ = G__19465_19795;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})();
var b__13843__auto__ = G__19467_19797;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14098__auto__[(1)] = (function (){var a__13842__auto__ = (function (){var a__13842__auto__ = G__19464_19794;
var b__13843__auto__ = G__19466_19796;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})();
var b__13843__auto__ = G__19468_19798;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

return (new thi.ng.geom.vector.Vec2(dest__14098__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec2((new Float32Array(self__.buf)),self__._hash,m));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IClear$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IClear$clear_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec2((new Float32Array((2))),null,null));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IClear$clear_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = 0.0);

(self__.buf[(1)] = 0.0);

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ICollection$_conj$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
return cljs.core.with_meta.call(null,thi.ng.geom.vector.vec3.call(null,(self__.buf[(0)]),(self__.buf[(1)]),x),self__._meta);
});

thi.ng.geom.vector.Vec2.prototype.call = (function() {
var G__19799 = null;
var G__19799__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});
var G__19799__3 = (function (self__,k,nf){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});
G__19799 = function(self__,k,nf){
switch(arguments.length){
case 2:
return G__19799__2.call(this,self__,k);
case 3:
return G__19799__3.call(this,self__,k,nf);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__19799.cljs$core$IFn$_invoke$arity$2 = G__19799__2;
G__19799.cljs$core$IFn$_invoke$arity$3 = G__19799__3;
return G__19799;
})()
;

thi.ng.geom.vector.Vec2.prototype.apply = (function (self__,args19257){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args19257)));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,nf){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IPolar$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IPolar$as_polar$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
(b[(0)] = thi.ng.math.core.mag.call(null,___$1));

(b[(1)] = thi.ng.geom.core.heading.call(null,___$1));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IPolar$as_cartesian$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__19473 = self__.buf;
var G__19474 = (G__19473[(0)]);
var G__19475 = (G__19473[(1)]);
var b = (new Float32Array((2)));
(b[(0)] = (G__19474 * Math.cos(G__19475)));

(b[(1)] = (G__19474 * Math.sin(G__19475)));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IComparable$_compare$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec2)){
var b_SINGLEQUOTE_ = o.buf;
var c = cljs.core.compare.call(null,(self__.buf[(0)]),(b_SINGLEQUOTE_[(0)]));
if(((0) === c)){
return cljs.core.compare.call(null,(self__.buf[(1)]),(b_SINGLEQUOTE_[(1)]));
} else {
return c;
}
} else {
var c = cljs.core.count.call(null,o);
if(((2) === c)){
return (- cljs.core.compare.call(null,o,___$1));
} else {
return ((2) - c);
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$normalize$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__19476 = self__.buf;
var G__19477 = (G__19476[(0)]);
var G__19478 = (G__19476[(1)]);
var l = Math.sqrt(((G__19477 * G__19477) + (G__19478 * G__19478)));
if((l > (0))){
var b = (new Float32Array((2)));
(b[(0)] = (G__19477 / l));

(b[(1)] = (G__19478 / l));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$normalize$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
var G__19479 = self__.buf;
var G__19480 = (G__19479[(0)]);
var G__19481 = (G__19479[(1)]);
var l = Math.sqrt(((G__19480 * G__19480) + (G__19481 * G__19481)));
if((l > (0))){
var l__$1 = (len / l);
var b = (new Float32Array((2)));
(b[(0)] = (G__19480 * l__$1));

(b[(1)] = (G__19481 * l__$1));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$normalized_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,1.0,thi.ng.math.core.mag_squared.call(null,___$1));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMagnitude$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMagnitude$mag$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__19482 = self__.buf;
var G__19483 = (G__19482[(0)]);
var G__19484 = (G__19482[(1)]);
return Math.sqrt(((G__19483 * G__19483) + (G__19484 * G__19484)));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMagnitude$mag_squared$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__19485 = self__.buf;
var G__19486 = (G__19485[(0)]);
var G__19487 = (G__19485[(1)]);
return ((G__19486 * G__19486) + (G__19487 * G__19487));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$msub$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__14098__auto__ = (new Float32Array((2)));
var G__19497_19800 = (a instanceof thi.ng.geom.vector.Vec2);
var G__19498_19801 = (b instanceof thi.ng.geom.vector.Vec2);
var G__19499_19802 = (((!(G__19497_19800)))?typeof a === 'number':null);
var G__19500_19803 = (((!(G__19498_19801)))?typeof b === 'number':null);
var G__19488_19804 = self__.buf;
var G__19489_19805 = ((G__19497_19800)?a.buf:null);
var G__19490_19806 = ((G__19498_19801)?b.buf:null);
var G__19491_19807 = (G__19488_19804[(0)]);
var G__19492_19808 = (G__19488_19804[(1)]);
var G__19493_19809 = ((G__19497_19800)?(G__19489_19805[(0)]):(cljs.core.truth_(G__19499_19802)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__19494_19810 = ((G__19497_19800)?(G__19489_19805[(1)]):(cljs.core.truth_(G__19499_19802)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__19495_19811 = ((G__19498_19801)?(G__19490_19806[(0)]):(cljs.core.truth_(G__19500_19803)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__19496_19812 = ((G__19498_19801)?(G__19490_19806[(1)]):(cljs.core.truth_(G__19500_19803)?b:cljs.core.nth.call(null,b,(1),0.0)));
(dest__14098__auto__[(0)] = ((G__19491_19807 * G__19493_19809) - G__19495_19811));

(dest__14098__auto__[(1)] = ((G__19492_19808 * G__19494_19810) - G__19496_19812));

return (new thi.ng.geom.vector.Vec2(dest__14098__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14087__auto__ = (new Float32Array((2)));
var G__19501_19813 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19502_19814 = v.buf;
(dest__14087__auto__[(0)] = ((G__19501_19813[(0)]) * (G__19502_19814[(0)])));

(dest__14087__auto__[(1)] = ((G__19501_19813[(1)]) * (G__19502_19814[(1)])));
} else {
if(typeof v === 'number'){
(dest__14087__auto__[(0)] = ((G__19501_19813[(0)]) * v));

(dest__14087__auto__[(1)] = ((G__19501_19813[(1)]) * v));
} else {
(dest__14087__auto__[(0)] = ((G__19501_19813[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__14087__auto__[(1)] = ((G__19501_19813[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__14087__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19503 = self__.buf;
var G__19506 = (new Float32Array((2)));
var G__19507 = (G__19503[(0)]);
var G__19508 = (G__19503[(1)]);
var G__19513 = typeof v1 === 'number';
var G__19514 = typeof v2 === 'number';
if(((G__19513)?G__19514:false)){
(G__19506[(0)] = (G__19507 * v1));

(G__19506[(1)] = (G__19508 * v2));
} else {
var G__19515_19815 = (((!(G__19513)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__19516_19816 = (((!(G__19514)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__19504_19817 = (cljs.core.truth_(G__19515_19815)?v1.buf:null);
var G__19505_19818 = (cljs.core.truth_(G__19516_19816)?v2.buf:null);
var G__19509_19819 = (cljs.core.truth_(G__19515_19815)?(G__19504_19817[(0)]):((G__19513)?v1:cljs.core.nth.call(null,v1,(0),1.0)));
var G__19510_19820 = (cljs.core.truth_(G__19515_19815)?(G__19504_19817[(1)]):((G__19513)?v1:cljs.core.nth.call(null,v1,(1),1.0)));
var G__19511_19821 = (cljs.core.truth_(G__19516_19816)?(G__19505_19818[(0)]):((G__19514)?v2:cljs.core.nth.call(null,v2,(0),1.0)));
var G__19512_19822 = (cljs.core.truth_(G__19516_19816)?(G__19505_19818[(1)]):((G__19514)?v2:cljs.core.nth.call(null,v2,(1),1.0)));
(G__19506[(0)] = ((G__19507 * G__19509_19819) * G__19511_19821));

(G__19506[(1)] = ((G__19508 * G__19510_19820) * G__19512_19822));
}

return (new thi.ng.geom.vector.Vec2(G__19506,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__14057__auto__ = (new Float32Array((2)));
var G__19517_19823 = self__.buf;
(dest__14057__auto__[(0)] = (- (G__19517_19823[(0)])));

(dest__14057__auto__[(1)] = (- (G__19517_19823[(1)])));

return (new thi.ng.geom.vector.Vec2(dest__14057__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14087__auto__ = (new Float32Array((2)));
var G__19518_19824 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19519_19825 = v.buf;
(dest__14087__auto__[(0)] = ((G__19518_19824[(0)]) - (G__19519_19825[(0)])));

(dest__14087__auto__[(1)] = ((G__19518_19824[(1)]) - (G__19519_19825[(1)])));
} else {
if(typeof v === 'number'){
(dest__14087__auto__[(0)] = ((G__19518_19824[(0)]) - v));

(dest__14087__auto__[(1)] = ((G__19518_19824[(1)]) - v));
} else {
(dest__14087__auto__[(0)] = ((G__19518_19824[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(dest__14087__auto__[(1)] = ((G__19518_19824[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__14087__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19520 = self__.buf;
var G__19523 = (new Float32Array((2)));
var G__19524 = (G__19520[(0)]);
var G__19525 = (G__19520[(1)]);
var G__19530 = typeof v1 === 'number';
var G__19531 = typeof v2 === 'number';
if(((G__19530)?G__19531:false)){
(G__19523[(0)] = (G__19524 - v1));

(G__19523[(1)] = (G__19525 - v2));
} else {
var G__19532_19826 = (((!(G__19530)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__19533_19827 = (((!(G__19531)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__19521_19828 = (cljs.core.truth_(G__19532_19826)?v1.buf:null);
var G__19522_19829 = (cljs.core.truth_(G__19533_19827)?v2.buf:null);
var G__19526_19830 = (cljs.core.truth_(G__19532_19826)?(G__19521_19828[(0)]):((G__19530)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19527_19831 = (cljs.core.truth_(G__19532_19826)?(G__19521_19828[(1)]):((G__19530)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19528_19832 = (cljs.core.truth_(G__19533_19827)?(G__19522_19829[(0)]):((G__19531)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19529_19833 = (cljs.core.truth_(G__19533_19827)?(G__19522_19829[(1)]):((G__19531)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(G__19523[(0)] = ((G__19524 - G__19526_19830) - G__19528_19832));

(G__19523[(1)] = ((G__19525 - G__19527_19831) - G__19529_19833));
}

return (new thi.ng.geom.vector.Vec2(G__19523,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$madd$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__14098__auto__ = (new Float32Array((2)));
var G__19543_19834 = (a instanceof thi.ng.geom.vector.Vec2);
var G__19544_19835 = (b instanceof thi.ng.geom.vector.Vec2);
var G__19545_19836 = (((!(G__19543_19834)))?typeof a === 'number':null);
var G__19546_19837 = (((!(G__19544_19835)))?typeof b === 'number':null);
var G__19534_19838 = self__.buf;
var G__19535_19839 = ((G__19543_19834)?a.buf:null);
var G__19536_19840 = ((G__19544_19835)?b.buf:null);
var G__19537_19841 = (G__19534_19838[(0)]);
var G__19538_19842 = (G__19534_19838[(1)]);
var G__19539_19843 = ((G__19543_19834)?(G__19535_19839[(0)]):(cljs.core.truth_(G__19545_19836)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__19540_19844 = ((G__19543_19834)?(G__19535_19839[(1)]):(cljs.core.truth_(G__19545_19836)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__19541_19845 = ((G__19544_19835)?(G__19536_19840[(0)]):(cljs.core.truth_(G__19546_19837)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__19542_19846 = ((G__19544_19835)?(G__19536_19840[(1)]):(cljs.core.truth_(G__19546_19837)?b:cljs.core.nth.call(null,b,(1),0.0)));
(dest__14098__auto__[(0)] = ((G__19537_19841 * G__19539_19843) + G__19541_19845));

(dest__14098__auto__[(1)] = ((G__19538_19842 * G__19540_19844) + G__19542_19846));

return (new thi.ng.geom.vector.Vec2(dest__14098__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$addm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__14098__auto__ = (new Float32Array((2)));
var G__19556_19847 = (a instanceof thi.ng.geom.vector.Vec2);
var G__19557_19848 = (b instanceof thi.ng.geom.vector.Vec2);
var G__19558_19849 = (((!(G__19556_19847)))?typeof a === 'number':null);
var G__19559_19850 = (((!(G__19557_19848)))?typeof b === 'number':null);
var G__19547_19851 = self__.buf;
var G__19548_19852 = ((G__19556_19847)?a.buf:null);
var G__19549_19853 = ((G__19557_19848)?b.buf:null);
var G__19550_19854 = (G__19547_19851[(0)]);
var G__19551_19855 = (G__19547_19851[(1)]);
var G__19552_19856 = ((G__19556_19847)?(G__19548_19852[(0)]):(cljs.core.truth_(G__19558_19849)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__19553_19857 = ((G__19556_19847)?(G__19548_19852[(1)]):(cljs.core.truth_(G__19558_19849)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__19554_19858 = ((G__19557_19848)?(G__19549_19853[(0)]):(cljs.core.truth_(G__19559_19850)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__19555_19859 = ((G__19557_19848)?(G__19549_19853[(1)]):(cljs.core.truth_(G__19559_19850)?b:cljs.core.nth.call(null,b,(1),1.0)));
(dest__14098__auto__[(0)] = ((G__19550_19854 + G__19552_19856) * G__19554_19858));

(dest__14098__auto__[(1)] = ((G__19551_19855 + G__19553_19857) * G__19555_19859));

return (new thi.ng.geom.vector.Vec2(dest__14098__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$div$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__14057__auto__ = (new Float32Array((2)));
var G__19560_19860 = self__.buf;
(dest__14057__auto__[(0)] = ((1) / (G__19560_19860[(0)])));

(dest__14057__auto__[(1)] = ((1) / (G__19560_19860[(1)])));

return (new thi.ng.geom.vector.Vec2(dest__14057__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$div$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14087__auto__ = (new Float32Array((2)));
var G__19561_19861 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19562_19862 = v.buf;
(dest__14087__auto__[(0)] = ((G__19561_19861[(0)]) / (G__19562_19862[(0)])));

(dest__14087__auto__[(1)] = ((G__19561_19861[(1)]) / (G__19562_19862[(1)])));
} else {
if(typeof v === 'number'){
(dest__14087__auto__[(0)] = ((G__19561_19861[(0)]) / v));

(dest__14087__auto__[(1)] = ((G__19561_19861[(1)]) / v));
} else {
(dest__14087__auto__[(0)] = ((G__19561_19861[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(dest__14087__auto__[(1)] = ((G__19561_19861[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__14087__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$div$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19563 = self__.buf;
var G__19566 = (new Float32Array((2)));
var G__19567 = (G__19563[(0)]);
var G__19568 = (G__19563[(1)]);
var G__19573 = typeof v1 === 'number';
var G__19574 = typeof v2 === 'number';
if(((G__19573)?G__19574:false)){
(G__19566[(0)] = (G__19567 / v1));

(G__19566[(1)] = (G__19568 / v2));
} else {
var G__19575_19863 = (((!(G__19573)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__19576_19864 = (((!(G__19574)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__19564_19865 = (cljs.core.truth_(G__19575_19863)?v1.buf:null);
var G__19565_19866 = (cljs.core.truth_(G__19576_19864)?v2.buf:null);
var G__19569_19867 = (cljs.core.truth_(G__19575_19863)?(G__19564_19865[(0)]):((G__19573)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19570_19868 = (cljs.core.truth_(G__19575_19863)?(G__19564_19865[(1)]):((G__19573)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19571_19869 = (cljs.core.truth_(G__19576_19864)?(G__19565_19866[(0)]):((G__19574)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19572_19870 = (cljs.core.truth_(G__19576_19864)?(G__19565_19866[(1)]):((G__19574)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(G__19566[(0)] = ((G__19567 / G__19569_19867) / G__19571_19869));

(G__19566[(1)] = ((G__19568 / G__19570_19868) / G__19572_19870));
}

return (new thi.ng.geom.vector.Vec2(G__19566,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14087__auto__ = (new Float32Array((2)));
var G__19577_19871 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__19578_19872 = v.buf;
(dest__14087__auto__[(0)] = ((G__19577_19871[(0)]) + (G__19578_19872[(0)])));

(dest__14087__auto__[(1)] = ((G__19577_19871[(1)]) + (G__19578_19872[(1)])));
} else {
if(typeof v === 'number'){
(dest__14087__auto__[(0)] = ((G__19577_19871[(0)]) + v));

(dest__14087__auto__[(1)] = ((G__19577_19871[(1)]) + v));
} else {
(dest__14087__auto__[(0)] = ((G__19577_19871[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__14087__auto__[(1)] = ((G__19577_19871[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__14087__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19579 = self__.buf;
var G__19582 = (new Float32Array((2)));
var G__19583 = (G__19579[(0)]);
var G__19584 = (G__19579[(1)]);
var G__19589 = typeof v1 === 'number';
var G__19590 = typeof v2 === 'number';
if(((G__19589)?G__19590:false)){
(G__19582[(0)] = (G__19583 + v1));

(G__19582[(1)] = (G__19584 + v2));
} else {
var G__19591_19873 = (((!(G__19589)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__19592_19874 = (((!(G__19590)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__19580_19875 = (cljs.core.truth_(G__19591_19873)?v1.buf:null);
var G__19581_19876 = (cljs.core.truth_(G__19592_19874)?v2.buf:null);
var G__19585_19877 = (cljs.core.truth_(G__19591_19873)?(G__19580_19875[(0)]):((G__19589)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19586_19878 = (cljs.core.truth_(G__19591_19873)?(G__19580_19875[(1)]):((G__19589)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19587_19879 = (cljs.core.truth_(G__19592_19874)?(G__19581_19876[(0)]):((G__19590)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19588_19880 = (cljs.core.truth_(G__19592_19874)?(G__19581_19876[(1)]):((G__19590)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(G__19582[(0)] = ((G__19583 + G__19585_19877) + G__19587_19879));

(G__19582[(1)] = ((G__19584 + G__19586_19878) + G__19588_19880));
}

return (new thi.ng.geom.vector.Vec2(G__19582,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$abs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__14057__auto__ = (new Float32Array((2)));
var G__19593_19881 = self__.buf;
(dest__14057__auto__[(0)] = thi.ng.math.core.abs_STAR_.call(null,(G__19593_19881[(0)])));

(dest__14057__auto__[(1)] = thi.ng.math.core.abs_STAR_.call(null,(G__19593_19881[(1)])));

return (new thi.ng.geom.vector.Vec2(dest__14057__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$subm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__14098__auto__ = (new Float32Array((2)));
var G__19603_19882 = (a instanceof thi.ng.geom.vector.Vec2);
var G__19604_19883 = (b instanceof thi.ng.geom.vector.Vec2);
var G__19605_19884 = (((!(G__19603_19882)))?typeof a === 'number':null);
var G__19606_19885 = (((!(G__19604_19883)))?typeof b === 'number':null);
var G__19594_19886 = self__.buf;
var G__19595_19887 = ((G__19603_19882)?a.buf:null);
var G__19596_19888 = ((G__19604_19883)?b.buf:null);
var G__19597_19889 = (G__19594_19886[(0)]);
var G__19598_19890 = (G__19594_19886[(1)]);
var G__19599_19891 = ((G__19603_19882)?(G__19595_19887[(0)]):(cljs.core.truth_(G__19605_19884)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__19600_19892 = ((G__19603_19882)?(G__19595_19887[(1)]):(cljs.core.truth_(G__19605_19884)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__19601_19893 = ((G__19604_19883)?(G__19596_19888[(0)]):(cljs.core.truth_(G__19606_19885)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__19602_19894 = ((G__19604_19883)?(G__19596_19888[(1)]):(cljs.core.truth_(G__19606_19885)?b:cljs.core.nth.call(null,b,(1),1.0)));
(dest__14098__auto__[(0)] = ((G__19597_19889 - G__19599_19891) * G__19601_19893));

(dest__14098__auto__[(1)] = ((G__19598_19890 - G__19600_19892) * G__19602_19894));

return (new thi.ng.geom.vector.Vec2(dest__14098__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"buf","buf",1426618187,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

thi.ng.geom.vector.Vec2.cljs$lang$type = true;

thi.ng.geom.vector.Vec2.cljs$lang$ctorStr = "thi.ng.geom.vector/Vec2";

thi.ng.geom.vector.Vec2.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"thi.ng.geom.vector/Vec2");
});

/**
 * Positional factory function for thi.ng.geom.vector/Vec2.
 */
thi.ng.geom.vector.__GT_Vec2 = (function thi$ng$geom$vector$__GT_Vec2(buf,_hash,_meta){
return (new thi.ng.geom.vector.Vec2(buf,_hash,_meta));
});


/**
* @constructor
 * @implements {thi.ng.geom.core.ITranslate}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {thi.ng.math.core.IDotProduct}
 * @implements {cljs.core.IReversible}
 * @implements {thi.ng.math.core.IMutableMathOps}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {thi.ng.math.core.ICrossProduct}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {thi.ng.math.core.IDeltaEquals}
 * @implements {thi.ng.geom.core.IPolar}
 * @implements {thi.ng.geom.core.IRotate3D}
 * @implements {thi.ng.geom.vector.Object}
 * @implements {thi.ng.geom.core.IClear}
 * @implements {thi.ng.math.core.IInvert}
 * @implements {cljs.core.ICounted}
 * @implements {thi.ng.math.core.ILimit}
 * @implements {thi.ng.dstruct.streams.IBuffer}
 * @implements {cljs.core.ISeq}
 * @implements {thi.ng.math.core.IInterpolate}
 * @implements {cljs.core.INext}
 * @implements {thi.ng.math.core.IMathOps}
 * @implements {thi.ng.geom.core.ITransform}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {thi.ng.math.core.IMinMax}
 * @implements {thi.ng.geom.core.IRotate}
 * @implements {thi.ng.math.core.INormalize}
 * @implements {thi.ng.math.core.IMagnitude}
 * @implements {thi.ng.geom.core.IScale}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {thi.ng.geom.core.IReflect}
 * @implements {thi.ng.geom.core.IHeading}
 * @implements {thi.ng.geom.core.IDistance}
 * @implements {cljs.core.IComparable}
 * @implements {thi.ng.dstruct.streams.IIntoBuffer}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {thi.ng.geom.core.IVectorReduce}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
thi.ng.geom.vector.Vec3 = (function (buf,_hash,_meta){
this.buf = buf;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2314101723;
this.cljs$lang$protocol_mask$partition1$ = 10240;
});
thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITransform$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITransform$transform$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.transform_vector.call(null,m,___$1);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = (- (self__.buf[(0)])));

(self__.buf[(1)] = (- (self__.buf[(1)])));

(self__.buf[(2)] = (- (self__.buf[(2)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19896_20347 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__19897_20348 = v.buf;
(self__.buf[(0)] = ((G__19896_20347[(0)]) - (G__19897_20348[(0)])));

(self__.buf[(1)] = ((G__19896_20347[(1)]) - (G__19897_20348[(1)])));

(self__.buf[(2)] = ((G__19896_20347[(2)]) - (G__19897_20348[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__19896_20347[(0)]) - v));

(self__.buf[(1)] = ((G__19896_20347[(1)]) - v));

(self__.buf[(2)] = ((G__19896_20347[(2)]) - v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__19896_20347[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__19896_20347[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__19896_20347[(2)]) - cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19910_20349 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__19911_20350 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__19912_20351 = (((!(G__19910_20349)))?typeof v1 === 'number':null);
var G__19913_20352 = (((!(G__19911_20350)))?typeof v2 === 'number':null);
var G__19898_20353 = self__.buf;
var G__19899_20354 = ((G__19910_20349)?v1.buf:null);
var G__19900_20355 = ((G__19911_20350)?v2.buf:null);
var G__19901_20356 = (G__19898_20353[(0)]);
var G__19902_20357 = (G__19898_20353[(1)]);
var G__19903_20358 = (G__19898_20353[(2)]);
var G__19904_20359 = ((G__19910_20349)?(G__19899_20354[(0)]):(cljs.core.truth_(G__19912_20351)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19905_20360 = ((G__19910_20349)?(G__19899_20354[(1)]):(cljs.core.truth_(G__19912_20351)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19906_20361 = ((G__19910_20349)?(G__19899_20354[(2)]):(cljs.core.truth_(G__19912_20351)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__19907_20362 = ((G__19911_20350)?(G__19900_20355[(0)]):(cljs.core.truth_(G__19913_20352)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19908_20363 = ((G__19911_20350)?(G__19900_20355[(1)]):(cljs.core.truth_(G__19913_20352)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__19909_20364 = ((G__19911_20350)?(G__19900_20355[(2)]):(cljs.core.truth_(G__19913_20352)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__19901_20356 - G__19904_20359) - G__19907_20362));

(self__.buf[(1)] = ((G__19902_20357 - G__19905_20360) - G__19908_20363));

(self__.buf[(2)] = ((G__19903_20358 - G__19906_20361) - G__19909_20364));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) - x));

(self__.buf[(1)] = ((self__.buf[(1)]) - y));

(self__.buf[(2)] = ((self__.buf[(2)]) - z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19914_20365 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__19915_20366 = v.buf;
(self__.buf[(0)] = ((G__19914_20365[(0)]) * (G__19915_20366[(0)])));

(self__.buf[(1)] = ((G__19914_20365[(1)]) * (G__19915_20366[(1)])));

(self__.buf[(2)] = ((G__19914_20365[(2)]) * (G__19915_20366[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__19914_20365[(0)]) * v));

(self__.buf[(1)] = ((G__19914_20365[(1)]) * v));

(self__.buf[(2)] = ((G__19914_20365[(2)]) * v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__19914_20365[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__19914_20365[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__19914_20365[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19928_20367 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__19929_20368 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__19930_20369 = (((!(G__19928_20367)))?typeof v1 === 'number':null);
var G__19931_20370 = (((!(G__19929_20368)))?typeof v2 === 'number':null);
var G__19916_20371 = self__.buf;
var G__19917_20372 = ((G__19928_20367)?v1.buf:null);
var G__19918_20373 = ((G__19929_20368)?v2.buf:null);
var G__19919_20374 = (G__19916_20371[(0)]);
var G__19920_20375 = (G__19916_20371[(1)]);
var G__19921_20376 = (G__19916_20371[(2)]);
var G__19922_20377 = ((G__19928_20367)?(G__19917_20372[(0)]):(cljs.core.truth_(G__19930_20369)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19923_20378 = ((G__19928_20367)?(G__19917_20372[(1)]):(cljs.core.truth_(G__19930_20369)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19924_20379 = ((G__19928_20367)?(G__19917_20372[(2)]):(cljs.core.truth_(G__19930_20369)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__19925_20380 = ((G__19929_20368)?(G__19918_20373[(0)]):(cljs.core.truth_(G__19931_20370)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19926_20381 = ((G__19929_20368)?(G__19918_20373[(1)]):(cljs.core.truth_(G__19931_20370)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__19927_20382 = ((G__19929_20368)?(G__19918_20373[(2)]):(cljs.core.truth_(G__19931_20370)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__19919_20374 * G__19922_20377) * G__19925_20380));

(self__.buf[(1)] = ((G__19920_20375 * G__19923_20378) * G__19926_20381));

(self__.buf[(2)] = ((G__19921_20376 * G__19924_20379) * G__19927_20382));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) * x));

(self__.buf[(1)] = ((self__.buf[(1)]) * y));

(self__.buf[(2)] = ((self__.buf[(2)]) * z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$subm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__19944_20383 = (a instanceof thi.ng.geom.vector.Vec3);
var G__19945_20384 = (b instanceof thi.ng.geom.vector.Vec3);
var G__19946_20385 = (((!(G__19944_20383)))?typeof a === 'number':null);
var G__19947_20386 = (((!(G__19945_20384)))?typeof b === 'number':null);
var G__19932_20387 = self__.buf;
var G__19933_20388 = ((G__19944_20383)?a.buf:null);
var G__19934_20389 = ((G__19945_20384)?b.buf:null);
var G__19935_20390 = (G__19932_20387[(0)]);
var G__19936_20391 = (G__19932_20387[(1)]);
var G__19937_20392 = (G__19932_20387[(2)]);
var G__19938_20393 = ((G__19944_20383)?(G__19933_20388[(0)]):(cljs.core.truth_(G__19946_20385)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__19939_20394 = ((G__19944_20383)?(G__19933_20388[(1)]):(cljs.core.truth_(G__19946_20385)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__19940_20395 = ((G__19944_20383)?(G__19933_20388[(2)]):(cljs.core.truth_(G__19946_20385)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__19941_20396 = ((G__19945_20384)?(G__19934_20389[(0)]):(cljs.core.truth_(G__19947_20386)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__19942_20397 = ((G__19945_20384)?(G__19934_20389[(1)]):(cljs.core.truth_(G__19947_20386)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__19943_20398 = ((G__19945_20384)?(G__19934_20389[(2)]):(cljs.core.truth_(G__19947_20386)?b:cljs.core.nth.call(null,b,(2),1.0)));
(self__.buf[(0)] = ((G__19935_20390 - G__19938_20393) * G__19941_20396));

(self__.buf[(1)] = ((G__19936_20391 - G__19939_20394) * G__19942_20397));

(self__.buf[(2)] = ((G__19937_20392 - G__19940_20395) * G__19943_20398));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$msub_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__19960_20399 = (a instanceof thi.ng.geom.vector.Vec3);
var G__19961_20400 = (b instanceof thi.ng.geom.vector.Vec3);
var G__19962_20401 = (((!(G__19960_20399)))?typeof a === 'number':null);
var G__19963_20402 = (((!(G__19961_20400)))?typeof b === 'number':null);
var G__19948_20403 = self__.buf;
var G__19949_20404 = ((G__19960_20399)?a.buf:null);
var G__19950_20405 = ((G__19961_20400)?b.buf:null);
var G__19951_20406 = (G__19948_20403[(0)]);
var G__19952_20407 = (G__19948_20403[(1)]);
var G__19953_20408 = (G__19948_20403[(2)]);
var G__19954_20409 = ((G__19960_20399)?(G__19949_20404[(0)]):(cljs.core.truth_(G__19962_20401)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__19955_20410 = ((G__19960_20399)?(G__19949_20404[(1)]):(cljs.core.truth_(G__19962_20401)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__19956_20411 = ((G__19960_20399)?(G__19949_20404[(2)]):(cljs.core.truth_(G__19962_20401)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__19957_20412 = ((G__19961_20400)?(G__19950_20405[(0)]):(cljs.core.truth_(G__19963_20402)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__19958_20413 = ((G__19961_20400)?(G__19950_20405[(1)]):(cljs.core.truth_(G__19963_20402)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__19959_20414 = ((G__19961_20400)?(G__19950_20405[(2)]):(cljs.core.truth_(G__19963_20402)?b:cljs.core.nth.call(null,b,(2),0.0)));
(self__.buf[(0)] = ((G__19951_20406 * G__19954_20409) - G__19957_20412));

(self__.buf[(1)] = ((G__19952_20407 * G__19955_20410) - G__19958_20413));

(self__.buf[(2)] = ((G__19953_20408 * G__19956_20411) - G__19959_20414));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$abs_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(0)])));

(self__.buf[(1)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(1)])));

(self__.buf[(2)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(2)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$madd_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__19976_20415 = (a instanceof thi.ng.geom.vector.Vec3);
var G__19977_20416 = (b instanceof thi.ng.geom.vector.Vec3);
var G__19978_20417 = (((!(G__19976_20415)))?typeof a === 'number':null);
var G__19979_20418 = (((!(G__19977_20416)))?typeof b === 'number':null);
var G__19964_20419 = self__.buf;
var G__19965_20420 = ((G__19976_20415)?a.buf:null);
var G__19966_20421 = ((G__19977_20416)?b.buf:null);
var G__19967_20422 = (G__19964_20419[(0)]);
var G__19968_20423 = (G__19964_20419[(1)]);
var G__19969_20424 = (G__19964_20419[(2)]);
var G__19970_20425 = ((G__19976_20415)?(G__19965_20420[(0)]):(cljs.core.truth_(G__19978_20417)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__19971_20426 = ((G__19976_20415)?(G__19965_20420[(1)]):(cljs.core.truth_(G__19978_20417)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__19972_20427 = ((G__19976_20415)?(G__19965_20420[(2)]):(cljs.core.truth_(G__19978_20417)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__19973_20428 = ((G__19977_20416)?(G__19966_20421[(0)]):(cljs.core.truth_(G__19979_20418)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__19974_20429 = ((G__19977_20416)?(G__19966_20421[(1)]):(cljs.core.truth_(G__19979_20418)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__19975_20430 = ((G__19977_20416)?(G__19966_20421[(2)]):(cljs.core.truth_(G__19979_20418)?b:cljs.core.nth.call(null,b,(2),0.0)));
(self__.buf[(0)] = ((G__19967_20422 * G__19970_20425) + G__19973_20428));

(self__.buf[(1)] = ((G__19968_20423 * G__19971_20426) + G__19974_20429));

(self__.buf[(2)] = ((G__19969_20424 * G__19972_20427) + G__19975_20430));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((1) / (self__.buf[(0)])));

(self__.buf[(1)] = ((1) / (self__.buf[(1)])));

(self__.buf[(2)] = ((1) / (self__.buf[(2)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19980_20431 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__19981_20432 = v.buf;
(self__.buf[(0)] = ((G__19980_20431[(0)]) / (G__19981_20432[(0)])));

(self__.buf[(1)] = ((G__19980_20431[(1)]) / (G__19981_20432[(1)])));

(self__.buf[(2)] = ((G__19980_20431[(2)]) / (G__19981_20432[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__19980_20431[(0)]) / v));

(self__.buf[(1)] = ((G__19980_20431[(1)]) / v));

(self__.buf[(2)] = ((G__19980_20431[(2)]) / v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__19980_20431[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__19980_20431[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__19980_20431[(2)]) / cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__19994_20433 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__19995_20434 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__19996_20435 = (((!(G__19994_20433)))?typeof v1 === 'number':null);
var G__19997_20436 = (((!(G__19995_20434)))?typeof v2 === 'number':null);
var G__19982_20437 = self__.buf;
var G__19983_20438 = ((G__19994_20433)?v1.buf:null);
var G__19984_20439 = ((G__19995_20434)?v2.buf:null);
var G__19985_20440 = (G__19982_20437[(0)]);
var G__19986_20441 = (G__19982_20437[(1)]);
var G__19987_20442 = (G__19982_20437[(2)]);
var G__19988_20443 = ((G__19994_20433)?(G__19983_20438[(0)]):(cljs.core.truth_(G__19996_20435)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19989_20444 = ((G__19994_20433)?(G__19983_20438[(1)]):(cljs.core.truth_(G__19996_20435)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19990_20445 = ((G__19994_20433)?(G__19983_20438[(2)]):(cljs.core.truth_(G__19996_20435)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__19991_20446 = ((G__19995_20434)?(G__19984_20439[(0)]):(cljs.core.truth_(G__19997_20436)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19992_20447 = ((G__19995_20434)?(G__19984_20439[(1)]):(cljs.core.truth_(G__19997_20436)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__19993_20448 = ((G__19995_20434)?(G__19984_20439[(2)]):(cljs.core.truth_(G__19997_20436)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__19985_20440 / G__19988_20443) / G__19991_20446));

(self__.buf[(1)] = ((G__19986_20441 / G__19989_20444) / G__19992_20447));

(self__.buf[(2)] = ((G__19987_20442 / G__19990_20445) / G__19993_20448));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) / x));

(self__.buf[(1)] = ((self__.buf[(1)]) / y));

(self__.buf[(2)] = ((self__.buf[(2)]) / z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__19998_20449 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__19999_20450 = v.buf;
(self__.buf[(0)] = ((G__19998_20449[(0)]) + (G__19999_20450[(0)])));

(self__.buf[(1)] = ((G__19998_20449[(1)]) + (G__19999_20450[(1)])));

(self__.buf[(2)] = ((G__19998_20449[(2)]) + (G__19999_20450[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__19998_20449[(0)]) + v));

(self__.buf[(1)] = ((G__19998_20449[(1)]) + v));

(self__.buf[(2)] = ((G__19998_20449[(2)]) + v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__19998_20449[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__19998_20449[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__19998_20449[(2)]) + cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__20012_20451 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__20013_20452 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__20014_20453 = (((!(G__20012_20451)))?typeof v1 === 'number':null);
var G__20015_20454 = (((!(G__20013_20452)))?typeof v2 === 'number':null);
var G__20000_20455 = self__.buf;
var G__20001_20456 = ((G__20012_20451)?v1.buf:null);
var G__20002_20457 = ((G__20013_20452)?v2.buf:null);
var G__20003_20458 = (G__20000_20455[(0)]);
var G__20004_20459 = (G__20000_20455[(1)]);
var G__20005_20460 = (G__20000_20455[(2)]);
var G__20006_20461 = ((G__20012_20451)?(G__20001_20456[(0)]):(cljs.core.truth_(G__20014_20453)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__20007_20462 = ((G__20012_20451)?(G__20001_20456[(1)]):(cljs.core.truth_(G__20014_20453)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__20008_20463 = ((G__20012_20451)?(G__20001_20456[(2)]):(cljs.core.truth_(G__20014_20453)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__20009_20464 = ((G__20013_20452)?(G__20002_20457[(0)]):(cljs.core.truth_(G__20015_20454)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__20010_20465 = ((G__20013_20452)?(G__20002_20457[(1)]):(cljs.core.truth_(G__20015_20454)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__20011_20466 = ((G__20013_20452)?(G__20002_20457[(2)]):(cljs.core.truth_(G__20015_20454)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__20003_20458 + G__20006_20461) + G__20009_20464));

(self__.buf[(1)] = ((G__20004_20459 + G__20007_20462) + G__20010_20465));

(self__.buf[(2)] = ((G__20005_20460 + G__20008_20463) + G__20011_20466));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) + x));

(self__.buf[(1)] = ((self__.buf[(1)]) + y));

(self__.buf[(2)] = ((self__.buf[(2)]) + z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$addm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__20028_20467 = (a instanceof thi.ng.geom.vector.Vec3);
var G__20029_20468 = (b instanceof thi.ng.geom.vector.Vec3);
var G__20030_20469 = (((!(G__20028_20467)))?typeof a === 'number':null);
var G__20031_20470 = (((!(G__20029_20468)))?typeof b === 'number':null);
var G__20016_20471 = self__.buf;
var G__20017_20472 = ((G__20028_20467)?a.buf:null);
var G__20018_20473 = ((G__20029_20468)?b.buf:null);
var G__20019_20474 = (G__20016_20471[(0)]);
var G__20020_20475 = (G__20016_20471[(1)]);
var G__20021_20476 = (G__20016_20471[(2)]);
var G__20022_20477 = ((G__20028_20467)?(G__20017_20472[(0)]):(cljs.core.truth_(G__20030_20469)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__20023_20478 = ((G__20028_20467)?(G__20017_20472[(1)]):(cljs.core.truth_(G__20030_20469)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__20024_20479 = ((G__20028_20467)?(G__20017_20472[(2)]):(cljs.core.truth_(G__20030_20469)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__20025_20480 = ((G__20029_20468)?(G__20018_20473[(0)]):(cljs.core.truth_(G__20031_20470)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__20026_20481 = ((G__20029_20468)?(G__20018_20473[(1)]):(cljs.core.truth_(G__20031_20470)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__20027_20482 = ((G__20029_20468)?(G__20018_20473[(2)]):(cljs.core.truth_(G__20031_20470)?b:cljs.core.nth.call(null,b,(2),1.0)));
(self__.buf[(0)] = ((G__20019_20474 + G__20022_20477) * G__20025_20480));

(self__.buf[(1)] = ((G__20020_20475 + G__20023_20478) * G__20026_20481));

(self__.buf[(2)] = ((G__20021_20476 + G__20024_20479) * G__20027_20482));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IBuffer$get_float_buffer$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.buf;
});

thi.ng.geom.vector.Vec3.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(0)]))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(1)]))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(2)])),"]"].join('');
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,___$1);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (_,k,nf){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,___$1);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ICrossProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ICrossProduct$cross$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__20032_20483 = self__.buf;
var G__20034_20484 = (G__20032_20483[(0)]);
var G__20035_20485 = (G__20032_20483[(1)]);
var G__20036_20486 = (G__20032_20483[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20033_20487 = v.buf;
var G__20037_20488 = (G__20033_20487[(0)]);
var G__20038_20489 = (G__20033_20487[(1)]);
var G__20039_20490 = (G__20033_20487[(2)]);
(b[(0)] = ((G__20035_20485 * G__20039_20490) - (G__20038_20489 * G__20036_20486)));

(b[(1)] = ((G__20036_20486 * G__20037_20488) - (G__20039_20490 * G__20034_20484)));

(b[(2)] = ((G__20034_20484 * G__20038_20489) - (G__20037_20488 * G__20035_20485)));
} else {
var G__20037_20491 = cljs.core.nth.call(null,v,(0),0.0);
var G__20038_20492 = cljs.core.nth.call(null,v,(1),0.0);
var G__20039_20493 = cljs.core.nth.call(null,v,(2),0.0);
(b[(0)] = ((G__20035_20485 * G__20039_20493) - (G__20038_20492 * G__20036_20486)));

(b[(1)] = ((G__20036_20486 * G__20037_20491) - (G__20039_20493 * G__20034_20484)));

(b[(2)] = ((G__20034_20484 * G__20038_20492) - (G__20037_20491 * G__20035_20485)));
}

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (_,n){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (3))){
return (self__.buf[n]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,n);
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (_,n,nf){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (3))){
return (self__.buf[n]);
} else {
return nf;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (_,writer,opts){
var self__ = this;
var ___$1 = this;
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,"#vec3 ["," ","]",opts,cljs.core.seq.call(null,___$1));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (_,n,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array(self__.buf));
(b[n] = v);

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec3((new Float32Array(self__.buf)),self__._hash,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IReflect$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IReflect$reflect$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__20040 = self__.buf;
var G__20042 = (G__20040[(0)]);
var G__20043 = (G__20040[(1)]);
var G__20044 = (G__20040[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20041 = v.buf;
var G__20045 = (G__20041[(0)]);
var G__20046 = (G__20041[(1)]);
var G__20047 = (G__20041[(2)]);
var d = ((((G__20042 * G__20045) + (G__20043 * G__20046)) + (G__20044 * G__20047)) * 2.0);
(b[(0)] = ((G__20045 * d) - G__20042));

(b[(1)] = ((G__20046 * d) - G__20043));

(b[(2)] = ((G__20047 * d) - G__20044));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
var G__20045 = cljs.core.nth.call(null,v,(0),0.0);
var G__20046 = cljs.core.nth.call(null,v,(1),0.0);
var G__20047 = cljs.core.nth.call(null,v,(2),0.0);
var d = ((((G__20042 * G__20045) + (G__20043 * G__20046)) + (G__20044 * G__20047)) * 2.0);
(b[(0)] = ((G__20045 * d) - G__20042));

(b[(1)] = ((G__20046 * d) - G__20043));

(b[(2)] = ((G__20047 * d) - G__20044));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),cljs.core.cons.call(null,(self__.buf[(2)]),null));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (3);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IDistance$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IDistance$dist$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return Math.sqrt(thi.ng.geom.core.dist_squared.call(null,___$1,v));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IDistance$dist_squared$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__20048 = self__.buf;
var G__20050 = (G__20048[(0)]);
var G__20051 = (G__20048[(1)]);
var G__20052 = (G__20048[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20049 = v.buf;
var G__20053 = (G__20049[(0)]);
var G__20054 = (G__20049[(1)]);
var G__20055 = (G__20049[(2)]);
var dx = (G__20050 - G__20053);
var dy = (G__20051 - G__20054);
var dz = (G__20052 - G__20055);
return (((dx * dx) + (dy * dy)) + (dz * dz));
} else {
var G__20053 = cljs.core.nth.call(null,v,(0),0.0);
var G__20054 = cljs.core.nth.call(null,v,(1),0.0);
var G__20055 = cljs.core.nth.call(null,v,(2),0.0);
var dx = (G__20050 - G__20053);
var dy = (G__20051 - G__20054);
var dz = (G__20052 - G__20055);
return (((dx * dx) + (dy * dy)) + (dz * dz));
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate$rotate$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.rotate_z.call(null,___$1,theta);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IStack$_peek$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(2)]);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IStack$_pop$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
(b[(0)] = (self__.buf[(0)]));

(b[(1)] = (self__.buf[(1)]));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInvert$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInvert$invert$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core._.call(null,___$1);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.vector.swizzle3_fns.call(null,new cljs.core.Keyword(null,"zyx","zyx",1752527951)).call(null,___$1);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ILimit$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ILimit$limit$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
if((thi.ng.math.core.mag_squared.call(null,___$1) > (len * len))){
return thi.ng.math.core.normalize.call(null,___$1,len);
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IScale$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IScale$scale$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14192__auto__ = (new Float32Array((3)));
var G__20056_20494 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20057_20495 = v.buf;
(dest__14192__auto__[(0)] = ((G__20056_20494[(0)]) * (G__20057_20495[(0)])));

(dest__14192__auto__[(1)] = ((G__20056_20494[(1)]) * (G__20057_20495[(1)])));

(dest__14192__auto__[(2)] = ((G__20056_20494[(2)]) * (G__20057_20495[(2)])));
} else {
if(typeof v === 'number'){
(dest__14192__auto__[(0)] = ((G__20056_20494[(0)]) * v));

(dest__14192__auto__[(1)] = ((G__20056_20494[(1)]) * v));

(dest__14192__auto__[(2)] = ((G__20056_20494[(2)]) * v));
} else {
(dest__14192__auto__[(0)] = ((G__20056_20494[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__14192__auto__[(1)] = ((G__20056_20494[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

(dest__14192__auto__[(2)] = ((G__20056_20494[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__14192__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var or__4131__auto__ = self__._hash;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return ___$1._hash = cljs.core.mix_collection_hash.call(null,((cljs.core.imul.call(null,((cljs.core.imul.call(null,(((31) + cljs.core.hash.call(null,(self__.buf[(0)]))) | (0)),(31)) + cljs.core.hash.call(null,(self__.buf[(1)]))) | (0)),(31)) + cljs.core.hash.call(null,(self__.buf[(2)]))) | (0)),(3));
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDeltaEquals$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,___$1,v,thi.ng.math.core._STAR_eps_STAR_);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$3 = (function (_,v,eps){
var self__ = this;
var ___$1 = this;
if(cljs.core.sequential_QMARK_.call(null,v)){
if(((3) === cljs.core.count.call(null,v))){
var G__20058 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20059 = v.buf;
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__20058[(0)]),(G__20059[(0)]),eps))){
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__20058[(1)]),(G__20059[(1)]),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__20058[(2)]),(G__20059[(2)]),eps);
} else {
return null;
}
} else {
return null;
}
} else {
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__20058[(0)]),cljs.core.nth.call(null,v,(0),0.0),eps))){
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__20058[(1)]),cljs.core.nth.call(null,v,(1),0.0),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__20058[(2)]),cljs.core.nth.call(null,v,(2),0.0),eps);
} else {
return null;
}
} else {
return null;
}
}
} else {
return null;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec3)){
var b_SINGLEQUOTE_ = o.buf;
return ((((self__.buf[(0)]) === (b_SINGLEQUOTE_[(0)]))) && (((self__.buf[(1)]) === (b_SINGLEQUOTE_[(1)]))) && (((self__.buf[(2)]) === (b_SINGLEQUOTE_[(2)]))));
} else {
return ((cljs.core.sequential_QMARK_.call(null,o)) && (((3) === cljs.core.count.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(0)]),cljs.core.first.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(1)]),cljs.core.nth.call(null,o,(1)))) && (cljs.core._EQ_.call(null,(self__.buf[(2)]),cljs.core.nth.call(null,o,(2)))));
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IVectorReduce$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$3 = (function (_,f,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
return (new thi.ng.geom.vector.Vec3(thi.ng.geom.vector.vec3_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs),null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$4 = (function (_,f,f2,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
thi.ng.geom.vector.vec3_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs);

(buf_SINGLEQUOTE_[(0)] = f2.call(null,(buf_SINGLEQUOTE_[(0)]),(0)));

(buf_SINGLEQUOTE_[(1)] = f2.call(null,(buf_SINGLEQUOTE_[(1)]),(1)));

(buf_SINGLEQUOTE_[(2)] = f2.call(null,(buf_SINGLEQUOTE_[(2)]),(2)));

return (new thi.ng.geom.vector.Vec3(buf_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IIntoBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IIntoBuffer$into_float_buffer$arity$4 = (function (_,dest,stride,idx){
var self__ = this;
var ___$1 = this;
dest.set(self__.buf,idx);

return (idx + stride);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDotProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDotProduct$dot$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__20060 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20061 = v.buf;
return ((((G__20060[(0)]) * (G__20061[(0)])) + ((G__20060[(1)]) * (G__20061[(1)]))) + ((G__20060[(2)]) * (G__20061[(2)])));
} else {
return ((((G__20060[(0)]) * cljs.core.nth.call(null,v,(0),0.0)) + ((G__20060[(1)]) * cljs.core.nth.call(null,v,(1),0.0))) + ((G__20060[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,(self__.buf[(0)]),(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
var acc__$1 = f.call(null,acc,(self__.buf[(2)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$1)){
return cljs.core.deref.call(null,acc__$1);
} else {
return acc__$1;
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,start,(self__.buf[(0)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
var acc__$1 = f.call(null,acc,(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$1)){
return cljs.core.deref.call(null,acc__$1);
} else {
var acc__$2 = f.call(null,acc__$1,(self__.buf[(2)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$2)){
return cljs.core.deref.call(null,acc__$2);
} else {
return acc__$2;
}
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITranslate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITranslate$translate$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14192__auto__ = (new Float32Array((3)));
var G__20062_20496 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20063_20497 = v.buf;
(dest__14192__auto__[(0)] = ((G__20062_20496[(0)]) + (G__20063_20497[(0)])));

(dest__14192__auto__[(1)] = ((G__20062_20496[(1)]) + (G__20063_20497[(1)])));

(dest__14192__auto__[(2)] = ((G__20062_20496[(2)]) + (G__20063_20497[(2)])));
} else {
if(typeof v === 'number'){
(dest__14192__auto__[(0)] = ((G__20062_20496[(0)]) + v));

(dest__14192__auto__[(1)] = ((G__20062_20496[(1)]) + v));

(dest__14192__auto__[(2)] = ((G__20062_20496[(2)]) + v));
} else {
(dest__14192__auto__[(0)] = ((G__20062_20496[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__14192__auto__[(1)] = ((G__20062_20496[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

(dest__14192__auto__[(2)] = ((G__20062_20496[(2)]) + cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__14192__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(0)]);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),cljs.core.cons.call(null,(self__.buf[(2)]),null));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.heading_xy.call(null,___$1);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(1)]),(self__.buf[(0)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading_xz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(2)]),(self__.buf[(0)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading_yz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(2)]),(self__.buf[(1)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$angle_between$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var v__$1 = (((v instanceof thi.ng.geom.vector.Vec3))?v:thi.ng.geom.vector.vec3.call(null,v));
return Math.acos(thi.ng.math.core.dot.call(null,thi.ng.math.core.normalize.call(null,___$1),thi.ng.math.core.normalize.call(null,v__$1)));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$slope_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(1)]) / (self__.buf[(0)]));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$slope_xz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(2)]) / (self__.buf[(0)]));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$slope_yz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(2)]) / (self__.buf[(1)]));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__20064_20498 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20065_20499 = v.buf;
(b[(0)] = (((G__20064_20498[(0)]) + (G__20065_20499[(0)])) * 0.5));

(b[(1)] = (((G__20064_20498[(1)]) + (G__20065_20499[(1)])) * 0.5));

(b[(2)] = (((G__20064_20498[(2)]) + (G__20065_20499[(2)])) * 0.5));
} else {
if(typeof v === 'number'){
(b[(0)] = (((G__20064_20498[(0)]) + v) * 0.5));

(b[(1)] = (((G__20064_20498[(1)]) + v) * 0.5));

(b[(2)] = (((G__20064_20498[(2)]) + v) * 0.5));
} else {
(b[(0)] = (((G__20064_20498[(0)]) + cljs.core.nth.call(null,v,(0),0.0)) * 0.5));

(b[(1)] = (((G__20064_20498[(1)]) + cljs.core.nth.call(null,v,(1),0.0)) * 0.5));

(b[(2)] = (((G__20064_20498[(2)]) + cljs.core.nth.call(null,v,(2),0.0)) * 0.5));
}
}

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix$arity$3 = (function (_,v,t){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__20078_20500 = (v instanceof thi.ng.geom.vector.Vec3);
var G__20079_20501 = (t instanceof thi.ng.geom.vector.Vec3);
var G__20080_20502 = (((!(G__20078_20500)))?typeof v === 'number':null);
var G__20081_20503 = (((!(G__20079_20501)))?typeof t === 'number':null);
var G__20066_20504 = self__.buf;
var G__20067_20505 = ((G__20078_20500)?v.buf:null);
var G__20068_20506 = ((G__20079_20501)?t.buf:null);
var G__20069_20507 = (G__20066_20504[(0)]);
var G__20070_20508 = (G__20066_20504[(1)]);
var G__20071_20509 = (G__20066_20504[(2)]);
var G__20072_20510 = ((G__20078_20500)?(G__20067_20505[(0)]):(cljs.core.truth_(G__20080_20502)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__20073_20511 = ((G__20078_20500)?(G__20067_20505[(1)]):(cljs.core.truth_(G__20080_20502)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__20074_20512 = ((G__20078_20500)?(G__20067_20505[(2)]):(cljs.core.truth_(G__20080_20502)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__20075_20513 = ((G__20079_20501)?(G__20068_20506[(0)]):(cljs.core.truth_(G__20081_20503)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__20076_20514 = ((G__20079_20501)?(G__20068_20506[(1)]):(cljs.core.truth_(G__20081_20503)?t:cljs.core.nth.call(null,t,(1),0.0)));
var G__20077_20515 = ((G__20079_20501)?(G__20068_20506[(2)]):(cljs.core.truth_(G__20081_20503)?t:cljs.core.nth.call(null,t,(2),0.0)));
(b[(0)] = (((G__20072_20510 - G__20069_20507) * G__20075_20513) + G__20069_20507));

(b[(1)] = (((G__20073_20511 - G__20070_20508) * G__20076_20514) + G__20070_20508));

(b[(2)] = (((G__20074_20512 - G__20071_20509) * G__20077_20515) + G__20071_20509));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix$arity$6 = (function (_,b,c,d,u,v){
var self__ = this;
var ___$1 = this;
var b_SINGLEQUOTE_ = (new Float32Array((3)));
var dv_QMARK_ = (d instanceof thi.ng.geom.vector.Vec3);
var dn_QMARK_ = typeof d === 'number';
var dv = ((dv_QMARK_)?d.buf:null);
var dx = ((dv_QMARK_)?(dv[(0)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(0),0.0)));
var dy = ((dv_QMARK_)?(dv[(1)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(1),0.0)));
var dz = ((dv_QMARK_)?(dv[(2)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(2),0.0)));
var G__20094_20516 = (b instanceof thi.ng.geom.vector.Vec3);
var G__20095_20517 = (c instanceof thi.ng.geom.vector.Vec3);
var G__20096_20518 = (((!(G__20094_20516)))?typeof b === 'number':null);
var G__20097_20519 = (((!(G__20095_20517)))?typeof c === 'number':null);
var G__20082_20520 = self__.buf;
var G__20083_20521 = ((G__20094_20516)?b.buf:null);
var G__20084_20522 = ((G__20095_20517)?c.buf:null);
var G__20085_20523 = (G__20082_20520[(0)]);
var G__20086_20524 = (G__20082_20520[(1)]);
var G__20087_20525 = (G__20082_20520[(2)]);
var G__20088_20526 = ((G__20094_20516)?(G__20083_20521[(0)]):(cljs.core.truth_(G__20096_20518)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__20089_20527 = ((G__20094_20516)?(G__20083_20521[(1)]):(cljs.core.truth_(G__20096_20518)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__20090_20528 = ((G__20094_20516)?(G__20083_20521[(2)]):(cljs.core.truth_(G__20096_20518)?b:cljs.core.nth.call(null,b,(2),0.0)));
var G__20091_20529 = ((G__20095_20517)?(G__20084_20522[(0)]):(cljs.core.truth_(G__20097_20519)?c:cljs.core.nth.call(null,c,(0),0.0)));
var G__20092_20530 = ((G__20095_20517)?(G__20084_20522[(1)]):(cljs.core.truth_(G__20097_20519)?c:cljs.core.nth.call(null,c,(1),0.0)));
var G__20093_20531 = ((G__20095_20517)?(G__20084_20522[(2)]):(cljs.core.truth_(G__20097_20519)?c:cljs.core.nth.call(null,c,(2),0.0)));
var x1_20532 = (((G__20088_20526 - G__20085_20523) * u) + G__20085_20523);
var y1_20533 = (((G__20089_20527 - G__20086_20524) * u) + G__20086_20524);
var z1_20534 = (((G__20090_20528 - G__20087_20525) * u) + G__20087_20525);
(b_SINGLEQUOTE_[(0)] = ((((((dx - G__20091_20529) * u) + G__20091_20529) - x1_20532) * v) + x1_20532));

(b_SINGLEQUOTE_[(1)] = ((((((dy - G__20092_20530) * u) + G__20092_20530) - y1_20533) * v) + y1_20533));

(b_SINGLEQUOTE_[(2)] = ((((((dz - G__20093_20531) * u) + G__20093_20531) - z1_20534) * v) + z1_20534));

return (new thi.ng.geom.vector.Vec3(b_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix_with$arity$4 = (function (_,v,t,f){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__20110_20535 = (v instanceof thi.ng.geom.vector.Vec3);
var G__20111_20536 = (t instanceof thi.ng.geom.vector.Vec3);
var G__20112_20537 = (((!(G__20110_20535)))?typeof v === 'number':null);
var G__20113_20538 = (((!(G__20111_20536)))?typeof t === 'number':null);
var G__20098_20539 = self__.buf;
var G__20099_20540 = ((G__20110_20535)?v.buf:null);
var G__20100_20541 = ((G__20111_20536)?t.buf:null);
var G__20101_20542 = (G__20098_20539[(0)]);
var G__20102_20543 = (G__20098_20539[(1)]);
var G__20103_20544 = (G__20098_20539[(2)]);
var G__20104_20545 = ((G__20110_20535)?(G__20099_20540[(0)]):(cljs.core.truth_(G__20112_20537)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__20105_20546 = ((G__20110_20535)?(G__20099_20540[(1)]):(cljs.core.truth_(G__20112_20537)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__20106_20547 = ((G__20110_20535)?(G__20099_20540[(2)]):(cljs.core.truth_(G__20112_20537)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__20107_20548 = ((G__20111_20536)?(G__20100_20541[(0)]):(cljs.core.truth_(G__20113_20538)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__20108_20549 = ((G__20111_20536)?(G__20100_20541[(1)]):(cljs.core.truth_(G__20113_20538)?t:cljs.core.nth.call(null,t,(1),0.0)));
var G__20109_20550 = ((G__20111_20536)?(G__20100_20541[(2)]):(cljs.core.truth_(G__20113_20538)?t:cljs.core.nth.call(null,t,(2),0.0)));
(b[(0)] = f.call(null,G__20101_20542,G__20104_20545,G__20107_20548));

(b[(1)] = f.call(null,G__20102_20543,G__20105_20546,G__20108_20549));

(b[(2)] = f.call(null,G__20103_20544,G__20106_20547,G__20109_20550));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$step$arity$2 = (function (_,e){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__20114_20551 = self__.buf;
if((e instanceof thi.ng.geom.vector.Vec3)){
var G__20115_20552 = e.buf;
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,(G__20115_20552[(0)]),(G__20114_20551[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,(G__20115_20552[(1)]),(G__20114_20551[(1)])));

(b[(2)] = thi.ng.math.core.step_STAR_.call(null,(G__20115_20552[(2)]),(G__20114_20551[(2)])));
} else {
if(typeof e === 'number'){
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,e,(G__20114_20551[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,e,(G__20114_20551[(1)])));

(b[(2)] = thi.ng.math.core.step_STAR_.call(null,e,(G__20114_20551[(2)])));
} else {
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(0),0.0),(G__20114_20551[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(1),0.0),(G__20114_20551[(1)])));

(b[(2)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(2),0.0),(G__20114_20551[(2)])));
}
}

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$smoothstep$arity$3 = (function (_,e1,e2){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__20128_20553 = (e1 instanceof thi.ng.geom.vector.Vec3);
var G__20129_20554 = (e2 instanceof thi.ng.geom.vector.Vec3);
var G__20130_20555 = (((!(G__20128_20553)))?typeof e1 === 'number':null);
var G__20131_20556 = (((!(G__20129_20554)))?typeof e2 === 'number':null);
var G__20116_20557 = self__.buf;
var G__20117_20558 = ((G__20128_20553)?e1.buf:null);
var G__20118_20559 = ((G__20129_20554)?e2.buf:null);
var G__20119_20560 = (G__20116_20557[(0)]);
var G__20120_20561 = (G__20116_20557[(1)]);
var G__20121_20562 = (G__20116_20557[(2)]);
var G__20122_20563 = ((G__20128_20553)?(G__20117_20558[(0)]):(cljs.core.truth_(G__20130_20555)?e1:cljs.core.nth.call(null,e1,(0),0.0)));
var G__20123_20564 = ((G__20128_20553)?(G__20117_20558[(1)]):(cljs.core.truth_(G__20130_20555)?e1:cljs.core.nth.call(null,e1,(1),0.0)));
var G__20124_20565 = ((G__20128_20553)?(G__20117_20558[(2)]):(cljs.core.truth_(G__20130_20555)?e1:cljs.core.nth.call(null,e1,(2),0.0)));
var G__20125_20566 = ((G__20129_20554)?(G__20118_20559[(0)]):(cljs.core.truth_(G__20131_20556)?e2:cljs.core.nth.call(null,e2,(0),0.0)));
var G__20126_20567 = ((G__20129_20554)?(G__20118_20559[(1)]):(cljs.core.truth_(G__20131_20556)?e2:cljs.core.nth.call(null,e2,(1),0.0)));
var G__20127_20568 = ((G__20129_20554)?(G__20118_20559[(2)]):(cljs.core.truth_(G__20131_20556)?e2:cljs.core.nth.call(null,e2,(2),0.0)));
(b[(0)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__20122_20563,G__20125_20566,G__20119_20560));

(b[(1)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__20123_20564,G__20126_20567,G__20120_20561));

(b[(2)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__20124_20565,G__20127_20568,G__20121_20562));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
return (((k >= (0))) && ((k <= (2))));
} else {
if(cljs.core.truth_(thi.ng.geom.vector.swizzle3_fns.call(null,k))){
return true;
} else {
return false;
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (_,k,v){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
if((((k >= (0))) && ((k <= (2))))){
var b = (new Float32Array(self__.buf));
(b[k] = v);

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
if((k === (3))){
return cljs.core.conj.call(null,___$1,v);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
} else {
if((k instanceof cljs.core.Keyword)){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"w","w",354169001),k)){
return cljs.core.conj.call(null,___$1,v);
} else {
return (new thi.ng.geom.vector.Vec3(thi.ng.geom.vector.swizzle_assoc_STAR_.call(null,self__.buf,(new Float32Array(self__.buf)),new cljs.core.PersistentArrayMap(null, 3, ["x",(0),"y",(1),"z",(2)], null),k,v),null,self__._meta));
}
} else {
return null;
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$min$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14192__auto__ = (new Float32Array((3)));
var G__20132_20569 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20133_20570 = v.buf;
(dest__14192__auto__[(0)] = (function (){var a__13835__auto__ = (G__20132_20569[(0)]);
var b__13836__auto__ = (G__20133_20570[(0)]);
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14192__auto__[(1)] = (function (){var a__13835__auto__ = (G__20132_20569[(1)]);
var b__13836__auto__ = (G__20133_20570[(1)]);
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14192__auto__[(2)] = (function (){var a__13835__auto__ = (G__20132_20569[(2)]);
var b__13836__auto__ = (G__20133_20570[(2)]);
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__14192__auto__[(0)] = (function (){var a__13835__auto__ = (G__20132_20569[(0)]);
var b__13836__auto__ = v;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14192__auto__[(1)] = (function (){var a__13835__auto__ = (G__20132_20569[(1)]);
var b__13836__auto__ = v;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14192__auto__[(2)] = (function (){var a__13835__auto__ = (G__20132_20569[(2)]);
var b__13836__auto__ = v;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());
} else {
(dest__14192__auto__[(0)] = (function (){var a__13835__auto__ = (G__20132_20569[(0)]);
var b__13836__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14192__auto__[(1)] = (function (){var a__13835__auto__ = (G__20132_20569[(1)]);
var b__13836__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14192__auto__[(2)] = (function (){var a__13835__auto__ = (G__20132_20569[(2)]);
var b__13836__auto__ = cljs.core.nth.call(null,v,(2),0.0);
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec3(dest__14192__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$min$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__14203__auto__ = (new Float32Array((3)));
var G__20146_20571 = (v instanceof thi.ng.geom.vector.Vec3);
var G__20147_20572 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__20148_20573 = (((!(G__20146_20571)))?typeof v === 'number':null);
var G__20149_20574 = (((!(G__20147_20572)))?typeof v2 === 'number':null);
var G__20134_20575 = self__.buf;
var G__20135_20576 = ((G__20146_20571)?v.buf:null);
var G__20136_20577 = ((G__20147_20572)?v2.buf:null);
var G__20137_20578 = (G__20134_20575[(0)]);
var G__20138_20579 = (G__20134_20575[(1)]);
var G__20139_20580 = (G__20134_20575[(2)]);
var G__20140_20581 = ((G__20146_20571)?(G__20135_20576[(0)]):(cljs.core.truth_(G__20148_20573)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__20141_20582 = ((G__20146_20571)?(G__20135_20576[(1)]):(cljs.core.truth_(G__20148_20573)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__20142_20583 = ((G__20146_20571)?(G__20135_20576[(2)]):(cljs.core.truth_(G__20148_20573)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__20143_20584 = ((G__20147_20572)?(G__20136_20577[(0)]):(cljs.core.truth_(G__20149_20574)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__20144_20585 = ((G__20147_20572)?(G__20136_20577[(1)]):(cljs.core.truth_(G__20149_20574)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__20145_20586 = ((G__20147_20572)?(G__20136_20577[(2)]):(cljs.core.truth_(G__20149_20574)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__14203__auto__[(0)] = (function (){var a__13835__auto__ = (function (){var a__13835__auto__ = G__20137_20578;
var b__13836__auto__ = G__20140_20581;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})();
var b__13836__auto__ = G__20143_20584;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14203__auto__[(1)] = (function (){var a__13835__auto__ = (function (){var a__13835__auto__ = G__20138_20579;
var b__13836__auto__ = G__20141_20582;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})();
var b__13836__auto__ = G__20144_20585;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

(dest__14203__auto__[(2)] = (function (){var a__13835__auto__ = (function (){var a__13835__auto__ = G__20139_20580;
var b__13836__auto__ = G__20142_20583;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})();
var b__13836__auto__ = G__20145_20586;
if((a__13835__auto__ <= b__13836__auto__)){
return a__13835__auto__;
} else {
return b__13836__auto__;
}
})());

return (new thi.ng.geom.vector.Vec3(dest__14203__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$max$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14192__auto__ = (new Float32Array((3)));
var G__20150_20587 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20151_20588 = v.buf;
(dest__14192__auto__[(0)] = (function (){var a__13842__auto__ = (G__20150_20587[(0)]);
var b__13843__auto__ = (G__20151_20588[(0)]);
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14192__auto__[(1)] = (function (){var a__13842__auto__ = (G__20150_20587[(1)]);
var b__13843__auto__ = (G__20151_20588[(1)]);
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14192__auto__[(2)] = (function (){var a__13842__auto__ = (G__20150_20587[(2)]);
var b__13843__auto__ = (G__20151_20588[(2)]);
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__14192__auto__[(0)] = (function (){var a__13842__auto__ = (G__20150_20587[(0)]);
var b__13843__auto__ = v;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14192__auto__[(1)] = (function (){var a__13842__auto__ = (G__20150_20587[(1)]);
var b__13843__auto__ = v;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14192__auto__[(2)] = (function (){var a__13842__auto__ = (G__20150_20587[(2)]);
var b__13843__auto__ = v;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());
} else {
(dest__14192__auto__[(0)] = (function (){var a__13842__auto__ = (G__20150_20587[(0)]);
var b__13843__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14192__auto__[(1)] = (function (){var a__13842__auto__ = (G__20150_20587[(1)]);
var b__13843__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14192__auto__[(2)] = (function (){var a__13842__auto__ = (G__20150_20587[(2)]);
var b__13843__auto__ = cljs.core.nth.call(null,v,(2),0.0);
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec3(dest__14192__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$max$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__14203__auto__ = (new Float32Array((3)));
var G__20164_20589 = (v instanceof thi.ng.geom.vector.Vec3);
var G__20165_20590 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__20166_20591 = (((!(G__20164_20589)))?typeof v === 'number':null);
var G__20167_20592 = (((!(G__20165_20590)))?typeof v2 === 'number':null);
var G__20152_20593 = self__.buf;
var G__20153_20594 = ((G__20164_20589)?v.buf:null);
var G__20154_20595 = ((G__20165_20590)?v2.buf:null);
var G__20155_20596 = (G__20152_20593[(0)]);
var G__20156_20597 = (G__20152_20593[(1)]);
var G__20157_20598 = (G__20152_20593[(2)]);
var G__20158_20599 = ((G__20164_20589)?(G__20153_20594[(0)]):(cljs.core.truth_(G__20166_20591)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__20159_20600 = ((G__20164_20589)?(G__20153_20594[(1)]):(cljs.core.truth_(G__20166_20591)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__20160_20601 = ((G__20164_20589)?(G__20153_20594[(2)]):(cljs.core.truth_(G__20166_20591)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__20161_20602 = ((G__20165_20590)?(G__20154_20595[(0)]):(cljs.core.truth_(G__20167_20592)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__20162_20603 = ((G__20165_20590)?(G__20154_20595[(1)]):(cljs.core.truth_(G__20167_20592)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__20163_20604 = ((G__20165_20590)?(G__20154_20595[(2)]):(cljs.core.truth_(G__20167_20592)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__14203__auto__[(0)] = (function (){var a__13842__auto__ = (function (){var a__13842__auto__ = G__20155_20596;
var b__13843__auto__ = G__20158_20599;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})();
var b__13843__auto__ = G__20161_20602;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14203__auto__[(1)] = (function (){var a__13842__auto__ = (function (){var a__13842__auto__ = G__20156_20597;
var b__13843__auto__ = G__20159_20600;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})();
var b__13843__auto__ = G__20162_20603;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

(dest__14203__auto__[(2)] = (function (){var a__13842__auto__ = (function (){var a__13842__auto__ = G__20157_20598;
var b__13843__auto__ = G__20160_20601;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})();
var b__13843__auto__ = G__20163_20604;
if((a__13842__auto__ >= b__13843__auto__)){
return a__13842__auto__;
} else {
return b__13843__auto__;
}
})());

return (new thi.ng.geom.vector.Vec3(dest__14203__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_x$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((3)));
var G__20168 = self__.buf;
var G__20169 = (G__20168[(0)]);
var G__20170 = (G__20168[(1)]);
var G__20171 = (G__20168[(2)]);
(b[(0)] = G__20169);

(b[(1)] = ((G__20170 * c) - (G__20171 * s)));

(b[(2)] = ((G__20170 * s) + (G__20171 * c)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_y$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((3)));
var G__20172 = self__.buf;
var G__20173 = (G__20172[(0)]);
var G__20174 = (G__20172[(1)]);
var G__20175 = (G__20172[(2)]);
(b[(0)] = ((G__20173 * c) + (G__20175 * s)));

(b[(1)] = G__20174);

(b[(2)] = ((G__20175 * c) - (G__20173 * s)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_z$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((3)));
var G__20176 = self__.buf;
var G__20177 = (G__20176[(0)]);
var G__20178 = (G__20176[(1)]);
var G__20179 = (G__20176[(2)]);
(b[(0)] = ((G__20177 * c) - (G__20178 * s)));

(b[(1)] = ((G__20177 * s) + (G__20178 * c)));

(b[(2)] = G__20179);

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_around_axis$arity$3 = (function (_,v,theta){
var self__ = this;
var ___$1 = this;
var G__20180 = self__.buf;
var G__20182 = (G__20180[(0)]);
var G__20183 = (G__20180[(1)]);
var G__20184 = (G__20180[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20181 = v.buf;
var G__20185 = (G__20181[(0)]);
var G__20186 = (G__20181[(1)]);
var G__20187 = (G__20181[(2)]);
var ux_SINGLEQUOTE_ = (G__20185 * G__20182);
var uy_SINGLEQUOTE_ = (G__20185 * G__20183);
var uz_SINGLEQUOTE_ = (G__20185 * G__20184);
var vx_SINGLEQUOTE_ = (G__20186 * G__20182);
var vy_SINGLEQUOTE_ = (G__20186 * G__20183);
var vz_SINGLEQUOTE_ = (G__20186 * G__20184);
var wx_SINGLEQUOTE_ = (G__20187 * G__20182);
var wy_SINGLEQUOTE_ = (G__20187 * G__20183);
var wz_SINGLEQUOTE_ = (G__20187 * G__20184);
var vx2 = (G__20185 * G__20185);
var vy2 = (G__20186 * G__20186);
var vz2 = (G__20187 * G__20187);
var s = Math.sin(theta);
var c = Math.cos(theta);
var uvw = ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) + wz_SINGLEQUOTE_);
var b = (new Float32Array((3)));
(b[(0)] = (((uvw * G__20185) + ((((vy2 + vz2) * G__20182) - ((vy_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__20185)) * c)) + ((vz_SINGLEQUOTE_ - wy_SINGLEQUOTE_) * s)));

(b[(1)] = (((uvw * G__20186) + ((((vx2 + vz2) * G__20183) - ((ux_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__20186)) * c)) + ((wx_SINGLEQUOTE_ - uz_SINGLEQUOTE_) * s)));

(b[(2)] = (((uvw * G__20187) + ((((vx2 + vy2) * G__20184) - ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) * G__20187)) * c)) + ((uy_SINGLEQUOTE_ - vx_SINGLEQUOTE_) * s)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
var G__20185 = cljs.core.nth.call(null,v,(0),0.0);
var G__20186 = cljs.core.nth.call(null,v,(1),0.0);
var G__20187 = cljs.core.nth.call(null,v,(2),0.0);
var ux_SINGLEQUOTE_ = (G__20185 * G__20182);
var uy_SINGLEQUOTE_ = (G__20185 * G__20183);
var uz_SINGLEQUOTE_ = (G__20185 * G__20184);
var vx_SINGLEQUOTE_ = (G__20186 * G__20182);
var vy_SINGLEQUOTE_ = (G__20186 * G__20183);
var vz_SINGLEQUOTE_ = (G__20186 * G__20184);
var wx_SINGLEQUOTE_ = (G__20187 * G__20182);
var wy_SINGLEQUOTE_ = (G__20187 * G__20183);
var wz_SINGLEQUOTE_ = (G__20187 * G__20184);
var vx2 = (G__20185 * G__20185);
var vy2 = (G__20186 * G__20186);
var vz2 = (G__20187 * G__20187);
var s = Math.sin(theta);
var c = Math.cos(theta);
var uvw = ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) + wz_SINGLEQUOTE_);
var b = (new Float32Array((3)));
(b[(0)] = (((uvw * G__20185) + ((((vy2 + vz2) * G__20182) - ((vy_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__20185)) * c)) + ((vz_SINGLEQUOTE_ - wy_SINGLEQUOTE_) * s)));

(b[(1)] = (((uvw * G__20186) + ((((vx2 + vz2) * G__20183) - ((ux_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__20186)) * c)) + ((wx_SINGLEQUOTE_ - uz_SINGLEQUOTE_) * s)));

(b[(2)] = (((uvw * G__20187) + ((((vx2 + vy2) * G__20184) - ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) * G__20187)) * c)) + ((uy_SINGLEQUOTE_ - vx_SINGLEQUOTE_) * s)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec3((new Float32Array(self__.buf)),self__._hash,m));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IClear$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IClear$clear_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec3((new Float32Array((3))),null,null));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IClear$clear_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = 0.0);

(self__.buf[(1)] = 0.0);

(self__.buf[(2)] = 0.0);

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ICollection$_conj$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.buf[(0)]),(self__.buf[(1)]),(self__.buf[(2)]),x], null),self__._meta);
});

thi.ng.geom.vector.Vec3.prototype.call = (function() {
var G__20605 = null;
var G__20605__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});
var G__20605__3 = (function (self__,k,nf){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});
G__20605 = function(self__,k,nf){
switch(arguments.length){
case 2:
return G__20605__2.call(this,self__,k);
case 3:
return G__20605__3.call(this,self__,k,nf);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__20605.cljs$core$IFn$_invoke$arity$2 = G__20605__2;
G__20605.cljs$core$IFn$_invoke$arity$3 = G__20605__3;
return G__20605;
})()
;

thi.ng.geom.vector.Vec3.prototype.apply = (function (self__,args19895){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args19895)));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,nf){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5718__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5718__auto__)){
var f = temp__5718__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IPolar$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IPolar$as_polar$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var r = thi.ng.math.core.mag.call(null,___$1);
var b = (new Float32Array((3)));
(b[(0)] = r);

(b[(1)] = Math.asin(((self__.buf[(2)]) / r)));

(b[(2)] = Math.atan2((self__.buf[(1)]),(self__.buf[(0)])));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IPolar$as_cartesian$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = self__.buf;
var x = (b[(0)]);
var y = (b[(1)]);
var z = (b[(2)]);
var rcos = (x * Math.cos(y));
var b_SINGLEQUOTE_ = (new Float32Array((3)));
(b_SINGLEQUOTE_[(0)] = (rcos * Math.cos(z)));

(b_SINGLEQUOTE_[(1)] = (rcos * Math.sin(z)));

(b_SINGLEQUOTE_[(2)] = (x * Math.sin(y)));

return (new thi.ng.geom.vector.Vec3(b_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IComparable$_compare$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec3)){
var b_SINGLEQUOTE_ = o.buf;
var c = cljs.core.compare.call(null,(self__.buf[(0)]),(b_SINGLEQUOTE_[(0)]));
if(((0) === c)){
var c__$1 = cljs.core.compare.call(null,(self__.buf[(1)]),(b_SINGLEQUOTE_[(1)]));
if(((0) === c__$1)){
return cljs.core.compare.call(null,(self__.buf[(2)]),(b_SINGLEQUOTE_[(2)]));
} else {
return c__$1;
}
} else {
return c;
}
} else {
var c = cljs.core.count.call(null,o);
if(((3) === c)){
return (- cljs.core.compare.call(null,o,___$1));
} else {
return ((3) - c);
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$normalize$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__20188 = self__.buf;
var G__20189 = (G__20188[(0)]);
var G__20190 = (G__20188[(1)]);
var G__20191 = (G__20188[(2)]);
var l = Math.sqrt((((G__20189 * G__20189) + (G__20190 * G__20190)) + (G__20191 * G__20191)));
if((l > (0))){
var b = (new Float32Array((3)));
(b[(0)] = (G__20189 / l));

(b[(1)] = (G__20190 / l));

(b[(2)] = (G__20191 / l));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$normalize$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
var G__20192 = self__.buf;
var G__20193 = (G__20192[(0)]);
var G__20194 = (G__20192[(1)]);
var G__20195 = (G__20192[(2)]);
var l = Math.sqrt((((G__20193 * G__20193) + (G__20194 * G__20194)) + (G__20195 * G__20195)));
if((l > (0))){
var l__$1 = (len / l);
var b = (new Float32Array((3)));
(b[(0)] = (G__20193 * l__$1));

(b[(1)] = (G__20194 * l__$1));

(b[(2)] = (G__20195 * l__$1));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$normalized_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,1.0,thi.ng.math.core.mag_squared.call(null,___$1));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMagnitude$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMagnitude$mag$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__20196 = self__.buf;
var G__20197 = (G__20196[(0)]);
var G__20198 = (G__20196[(1)]);
var G__20199 = (G__20196[(2)]);
return Math.sqrt((((G__20197 * G__20197) + (G__20198 * G__20198)) + (G__20199 * G__20199)));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMagnitude$mag_squared$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__20200 = self__.buf;
var G__20201 = (G__20200[(0)]);
var G__20202 = (G__20200[(1)]);
var G__20203 = (G__20200[(2)]);
return (((G__20201 * G__20201) + (G__20202 * G__20202)) + (G__20203 * G__20203));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$msub$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__14203__auto__ = (new Float32Array((3)));
var G__20216_20606 = (a instanceof thi.ng.geom.vector.Vec3);
var G__20217_20607 = (b instanceof thi.ng.geom.vector.Vec3);
var G__20218_20608 = (((!(G__20216_20606)))?typeof a === 'number':null);
var G__20219_20609 = (((!(G__20217_20607)))?typeof b === 'number':null);
var G__20204_20610 = self__.buf;
var G__20205_20611 = ((G__20216_20606)?a.buf:null);
var G__20206_20612 = ((G__20217_20607)?b.buf:null);
var G__20207_20613 = (G__20204_20610[(0)]);
var G__20208_20614 = (G__20204_20610[(1)]);
var G__20209_20615 = (G__20204_20610[(2)]);
var G__20210_20616 = ((G__20216_20606)?(G__20205_20611[(0)]):(cljs.core.truth_(G__20218_20608)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__20211_20617 = ((G__20216_20606)?(G__20205_20611[(1)]):(cljs.core.truth_(G__20218_20608)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__20212_20618 = ((G__20216_20606)?(G__20205_20611[(2)]):(cljs.core.truth_(G__20218_20608)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__20213_20619 = ((G__20217_20607)?(G__20206_20612[(0)]):(cljs.core.truth_(G__20219_20609)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__20214_20620 = ((G__20217_20607)?(G__20206_20612[(1)]):(cljs.core.truth_(G__20219_20609)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__20215_20621 = ((G__20217_20607)?(G__20206_20612[(2)]):(cljs.core.truth_(G__20219_20609)?b:cljs.core.nth.call(null,b,(2),0.0)));
(dest__14203__auto__[(0)] = ((G__20207_20613 * G__20210_20616) - G__20213_20619));

(dest__14203__auto__[(1)] = ((G__20208_20614 * G__20211_20617) - G__20214_20620));

(dest__14203__auto__[(2)] = ((G__20209_20615 * G__20212_20618) - G__20215_20621));

return (new thi.ng.geom.vector.Vec3(dest__14203__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14192__auto__ = (new Float32Array((3)));
var G__20220_20622 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20221_20623 = v.buf;
(dest__14192__auto__[(0)] = ((G__20220_20622[(0)]) * (G__20221_20623[(0)])));

(dest__14192__auto__[(1)] = ((G__20220_20622[(1)]) * (G__20221_20623[(1)])));

(dest__14192__auto__[(2)] = ((G__20220_20622[(2)]) * (G__20221_20623[(2)])));
} else {
if(typeof v === 'number'){
(dest__14192__auto__[(0)] = ((G__20220_20622[(0)]) * v));

(dest__14192__auto__[(1)] = ((G__20220_20622[(1)]) * v));

(dest__14192__auto__[(2)] = ((G__20220_20622[(2)]) * v));
} else {
(dest__14192__auto__[(0)] = ((G__20220_20622[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__14192__auto__[(1)] = ((G__20220_20622[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

(dest__14192__auto__[(2)] = ((G__20220_20622[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__14192__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__14203__auto__ = (new Float32Array((3)));
var G__20234_20624 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__20235_20625 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__20236_20626 = (((!(G__20234_20624)))?typeof v1 === 'number':null);
var G__20237_20627 = (((!(G__20235_20625)))?typeof v2 === 'number':null);
var G__20222_20628 = self__.buf;
var G__20223_20629 = ((G__20234_20624)?v1.buf:null);
var G__20224_20630 = ((G__20235_20625)?v2.buf:null);
var G__20225_20631 = (G__20222_20628[(0)]);
var G__20226_20632 = (G__20222_20628[(1)]);
var G__20227_20633 = (G__20222_20628[(2)]);
var G__20228_20634 = ((G__20234_20624)?(G__20223_20629[(0)]):(cljs.core.truth_(G__20236_20626)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__20229_20635 = ((G__20234_20624)?(G__20223_20629[(1)]):(cljs.core.truth_(G__20236_20626)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__20230_20636 = ((G__20234_20624)?(G__20223_20629[(2)]):(cljs.core.truth_(G__20236_20626)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__20231_20637 = ((G__20235_20625)?(G__20224_20630[(0)]):(cljs.core.truth_(G__20237_20627)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__20232_20638 = ((G__20235_20625)?(G__20224_20630[(1)]):(cljs.core.truth_(G__20237_20627)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__20233_20639 = ((G__20235_20625)?(G__20224_20630[(2)]):(cljs.core.truth_(G__20237_20627)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__14203__auto__[(0)] = ((G__20225_20631 * G__20228_20634) * G__20231_20637));

(dest__14203__auto__[(1)] = ((G__20226_20632 * G__20229_20635) * G__20232_20638));

(dest__14203__auto__[(2)] = ((G__20227_20633 * G__20230_20636) * G__20233_20639));

return (new thi.ng.geom.vector.Vec3(dest__14203__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__20238 = self__.buf;
var dest__14181__auto__ = (new Float32Array((3)));
(dest__14181__auto__[(0)] = ((G__20238[(0)]) * x));

(dest__14181__auto__[(1)] = ((G__20238[(1)]) * y));

(dest__14181__auto__[(2)] = ((G__20238[(2)]) * z));

return (new thi.ng.geom.vector.Vec3(dest__14181__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__14175__auto__ = (new Float32Array((3)));
var G__20239_20640 = self__.buf;
(dest__14175__auto__[(0)] = (- (G__20239_20640[(0)])));

(dest__14175__auto__[(1)] = (- (G__20239_20640[(1)])));

(dest__14175__auto__[(2)] = (- (G__20239_20640[(2)])));

return (new thi.ng.geom.vector.Vec3(dest__14175__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14192__auto__ = (new Float32Array((3)));
var G__20240_20641 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20241_20642 = v.buf;
(dest__14192__auto__[(0)] = ((G__20240_20641[(0)]) - (G__20241_20642[(0)])));

(dest__14192__auto__[(1)] = ((G__20240_20641[(1)]) - (G__20241_20642[(1)])));

(dest__14192__auto__[(2)] = ((G__20240_20641[(2)]) - (G__20241_20642[(2)])));
} else {
if(typeof v === 'number'){
(dest__14192__auto__[(0)] = ((G__20240_20641[(0)]) - v));

(dest__14192__auto__[(1)] = ((G__20240_20641[(1)]) - v));

(dest__14192__auto__[(2)] = ((G__20240_20641[(2)]) - v));
} else {
(dest__14192__auto__[(0)] = ((G__20240_20641[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(dest__14192__auto__[(1)] = ((G__20240_20641[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));

(dest__14192__auto__[(2)] = ((G__20240_20641[(2)]) - cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__14192__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__14203__auto__ = (new Float32Array((3)));
var G__20254_20643 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__20255_20644 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__20256_20645 = (((!(G__20254_20643)))?typeof v1 === 'number':null);
var G__20257_20646 = (((!(G__20255_20644)))?typeof v2 === 'number':null);
var G__20242_20647 = self__.buf;
var G__20243_20648 = ((G__20254_20643)?v1.buf:null);
var G__20244_20649 = ((G__20255_20644)?v2.buf:null);
var G__20245_20650 = (G__20242_20647[(0)]);
var G__20246_20651 = (G__20242_20647[(1)]);
var G__20247_20652 = (G__20242_20647[(2)]);
var G__20248_20653 = ((G__20254_20643)?(G__20243_20648[(0)]):(cljs.core.truth_(G__20256_20645)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__20249_20654 = ((G__20254_20643)?(G__20243_20648[(1)]):(cljs.core.truth_(G__20256_20645)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__20250_20655 = ((G__20254_20643)?(G__20243_20648[(2)]):(cljs.core.truth_(G__20256_20645)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__20251_20656 = ((G__20255_20644)?(G__20244_20649[(0)]):(cljs.core.truth_(G__20257_20646)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__20252_20657 = ((G__20255_20644)?(G__20244_20649[(1)]):(cljs.core.truth_(G__20257_20646)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__20253_20658 = ((G__20255_20644)?(G__20244_20649[(2)]):(cljs.core.truth_(G__20257_20646)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__14203__auto__[(0)] = ((G__20245_20650 - G__20248_20653) - G__20251_20656));

(dest__14203__auto__[(1)] = ((G__20246_20651 - G__20249_20654) - G__20252_20657));

(dest__14203__auto__[(2)] = ((G__20247_20652 - G__20250_20655) - G__20253_20658));

return (new thi.ng.geom.vector.Vec3(dest__14203__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__20258 = self__.buf;
var dest__14181__auto__ = (new Float32Array((3)));
(dest__14181__auto__[(0)] = ((G__20258[(0)]) - x));

(dest__14181__auto__[(1)] = ((G__20258[(1)]) - y));

(dest__14181__auto__[(2)] = ((G__20258[(2)]) - z));

return (new thi.ng.geom.vector.Vec3(dest__14181__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$madd$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__14203__auto__ = (new Float32Array((3)));
var G__20271_20659 = (a instanceof thi.ng.geom.vector.Vec3);
var G__20272_20660 = (b instanceof thi.ng.geom.vector.Vec3);
var G__20273_20661 = (((!(G__20271_20659)))?typeof a === 'number':null);
var G__20274_20662 = (((!(G__20272_20660)))?typeof b === 'number':null);
var G__20259_20663 = self__.buf;
var G__20260_20664 = ((G__20271_20659)?a.buf:null);
var G__20261_20665 = ((G__20272_20660)?b.buf:null);
var G__20262_20666 = (G__20259_20663[(0)]);
var G__20263_20667 = (G__20259_20663[(1)]);
var G__20264_20668 = (G__20259_20663[(2)]);
var G__20265_20669 = ((G__20271_20659)?(G__20260_20664[(0)]):(cljs.core.truth_(G__20273_20661)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__20266_20670 = ((G__20271_20659)?(G__20260_20664[(1)]):(cljs.core.truth_(G__20273_20661)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__20267_20671 = ((G__20271_20659)?(G__20260_20664[(2)]):(cljs.core.truth_(G__20273_20661)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__20268_20672 = ((G__20272_20660)?(G__20261_20665[(0)]):(cljs.core.truth_(G__20274_20662)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__20269_20673 = ((G__20272_20660)?(G__20261_20665[(1)]):(cljs.core.truth_(G__20274_20662)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__20270_20674 = ((G__20272_20660)?(G__20261_20665[(2)]):(cljs.core.truth_(G__20274_20662)?b:cljs.core.nth.call(null,b,(2),0.0)));
(dest__14203__auto__[(0)] = ((G__20262_20666 * G__20265_20669) + G__20268_20672));

(dest__14203__auto__[(1)] = ((G__20263_20667 * G__20266_20670) + G__20269_20673));

(dest__14203__auto__[(2)] = ((G__20264_20668 * G__20267_20671) + G__20270_20674));

return (new thi.ng.geom.vector.Vec3(dest__14203__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$addm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__14203__auto__ = (new Float32Array((3)));
var G__20287_20675 = (a instanceof thi.ng.geom.vector.Vec3);
var G__20288_20676 = (b instanceof thi.ng.geom.vector.Vec3);
var G__20289_20677 = (((!(G__20287_20675)))?typeof a === 'number':null);
var G__20290_20678 = (((!(G__20288_20676)))?typeof b === 'number':null);
var G__20275_20679 = self__.buf;
var G__20276_20680 = ((G__20287_20675)?a.buf:null);
var G__20277_20681 = ((G__20288_20676)?b.buf:null);
var G__20278_20682 = (G__20275_20679[(0)]);
var G__20279_20683 = (G__20275_20679[(1)]);
var G__20280_20684 = (G__20275_20679[(2)]);
var G__20281_20685 = ((G__20287_20675)?(G__20276_20680[(0)]):(cljs.core.truth_(G__20289_20677)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__20282_20686 = ((G__20287_20675)?(G__20276_20680[(1)]):(cljs.core.truth_(G__20289_20677)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__20283_20687 = ((G__20287_20675)?(G__20276_20680[(2)]):(cljs.core.truth_(G__20289_20677)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__20284_20688 = ((G__20288_20676)?(G__20277_20681[(0)]):(cljs.core.truth_(G__20290_20678)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__20285_20689 = ((G__20288_20676)?(G__20277_20681[(1)]):(cljs.core.truth_(G__20290_20678)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__20286_20690 = ((G__20288_20676)?(G__20277_20681[(2)]):(cljs.core.truth_(G__20290_20678)?b:cljs.core.nth.call(null,b,(2),1.0)));
(dest__14203__auto__[(0)] = ((G__20278_20682 + G__20281_20685) * G__20284_20688));

(dest__14203__auto__[(1)] = ((G__20279_20683 + G__20282_20686) * G__20285_20689));

(dest__14203__auto__[(2)] = ((G__20280_20684 + G__20283_20687) * G__20286_20690));

return (new thi.ng.geom.vector.Vec3(dest__14203__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__14175__auto__ = (new Float32Array((3)));
var G__20291_20691 = self__.buf;
(dest__14175__auto__[(0)] = ((1) / (G__20291_20691[(0)])));

(dest__14175__auto__[(1)] = ((1) / (G__20291_20691[(1)])));

(dest__14175__auto__[(2)] = ((1) / (G__20291_20691[(2)])));

return (new thi.ng.geom.vector.Vec3(dest__14175__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14192__auto__ = (new Float32Array((3)));
var G__20292_20692 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20293_20693 = v.buf;
(dest__14192__auto__[(0)] = ((G__20292_20692[(0)]) / (G__20293_20693[(0)])));

(dest__14192__auto__[(1)] = ((G__20292_20692[(1)]) / (G__20293_20693[(1)])));

(dest__14192__auto__[(2)] = ((G__20292_20692[(2)]) / (G__20293_20693[(2)])));
} else {
if(typeof v === 'number'){
(dest__14192__auto__[(0)] = ((G__20292_20692[(0)]) / v));

(dest__14192__auto__[(1)] = ((G__20292_20692[(1)]) / v));

(dest__14192__auto__[(2)] = ((G__20292_20692[(2)]) / v));
} else {
(dest__14192__auto__[(0)] = ((G__20292_20692[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(dest__14192__auto__[(1)] = ((G__20292_20692[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));

(dest__14192__auto__[(2)] = ((G__20292_20692[(2)]) / cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__14192__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__14203__auto__ = (new Float32Array((3)));
var G__20306_20694 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__20307_20695 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__20308_20696 = (((!(G__20306_20694)))?typeof v1 === 'number':null);
var G__20309_20697 = (((!(G__20307_20695)))?typeof v2 === 'number':null);
var G__20294_20698 = self__.buf;
var G__20295_20699 = ((G__20306_20694)?v1.buf:null);
var G__20296_20700 = ((G__20307_20695)?v2.buf:null);
var G__20297_20701 = (G__20294_20698[(0)]);
var G__20298_20702 = (G__20294_20698[(1)]);
var G__20299_20703 = (G__20294_20698[(2)]);
var G__20300_20704 = ((G__20306_20694)?(G__20295_20699[(0)]):(cljs.core.truth_(G__20308_20696)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__20301_20705 = ((G__20306_20694)?(G__20295_20699[(1)]):(cljs.core.truth_(G__20308_20696)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__20302_20706 = ((G__20306_20694)?(G__20295_20699[(2)]):(cljs.core.truth_(G__20308_20696)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__20303_20707 = ((G__20307_20695)?(G__20296_20700[(0)]):(cljs.core.truth_(G__20309_20697)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__20304_20708 = ((G__20307_20695)?(G__20296_20700[(1)]):(cljs.core.truth_(G__20309_20697)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__20305_20709 = ((G__20307_20695)?(G__20296_20700[(2)]):(cljs.core.truth_(G__20309_20697)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__14203__auto__[(0)] = ((G__20297_20701 / G__20300_20704) / G__20303_20707));

(dest__14203__auto__[(1)] = ((G__20298_20702 / G__20301_20705) / G__20304_20708));

(dest__14203__auto__[(2)] = ((G__20299_20703 / G__20302_20706) / G__20305_20709));

return (new thi.ng.geom.vector.Vec3(dest__14203__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__20310 = self__.buf;
var dest__14181__auto__ = (new Float32Array((3)));
(dest__14181__auto__[(0)] = ((G__20310[(0)]) / x));

(dest__14181__auto__[(1)] = ((G__20310[(1)]) / y));

(dest__14181__auto__[(2)] = ((G__20310[(2)]) / z));

return (new thi.ng.geom.vector.Vec3(dest__14181__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__14192__auto__ = (new Float32Array((3)));
var G__20311_20710 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__20312_20711 = v.buf;
(dest__14192__auto__[(0)] = ((G__20311_20710[(0)]) + (G__20312_20711[(0)])));

(dest__14192__auto__[(1)] = ((G__20311_20710[(1)]) + (G__20312_20711[(1)])));

(dest__14192__auto__[(2)] = ((G__20311_20710[(2)]) + (G__20312_20711[(2)])));
} else {
if(typeof v === 'number'){
(dest__14192__auto__[(0)] = ((G__20311_20710[(0)]) + v));

(dest__14192__auto__[(1)] = ((G__20311_20710[(1)]) + v));

(dest__14192__auto__[(2)] = ((G__20311_20710[(2)]) + v));
} else {
(dest__14192__auto__[(0)] = ((G__20311_20710[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__14192__auto__[(1)] = ((G__20311_20710[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

(dest__14192__auto__[(2)] = ((G__20311_20710[(2)]) + cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__14192__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__14203__auto__ = (new Float32Array((3)));
var G__20325_20712 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__20326_20713 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__20327_20714 = (((!(G__20325_20712)))?typeof v1 === 'number':null);
var G__20328_20715 = (((!(G__20326_20713)))?typeof v2 === 'number':null);
var G__20313_20716 = self__.buf;
var G__20314_20717 = ((G__20325_20712)?v1.buf:null);
var G__20315_20718 = ((G__20326_20713)?v2.buf:null);
var G__20316_20719 = (G__20313_20716[(0)]);
var G__20317_20720 = (G__20313_20716[(1)]);
var G__20318_20721 = (G__20313_20716[(2)]);
var G__20319_20722 = ((G__20325_20712)?(G__20314_20717[(0)]):(cljs.core.truth_(G__20327_20714)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__20320_20723 = ((G__20325_20712)?(G__20314_20717[(1)]):(cljs.core.truth_(G__20327_20714)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__20321_20724 = ((G__20325_20712)?(G__20314_20717[(2)]):(cljs.core.truth_(G__20327_20714)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__20322_20725 = ((G__20326_20713)?(G__20315_20718[(0)]):(cljs.core.truth_(G__20328_20715)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__20323_20726 = ((G__20326_20713)?(G__20315_20718[(1)]):(cljs.core.truth_(G__20328_20715)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__20324_20727 = ((G__20326_20713)?(G__20315_20718[(2)]):(cljs.core.truth_(G__20328_20715)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__14203__auto__[(0)] = ((G__20316_20719 + G__20319_20722) + G__20322_20725));

(dest__14203__auto__[(1)] = ((G__20317_20720 + G__20320_20723) + G__20323_20726));

(dest__14203__auto__[(2)] = ((G__20318_20721 + G__20321_20724) + G__20324_20727));

return (new thi.ng.geom.vector.Vec3(dest__14203__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__20329 = self__.buf;
var dest__14181__auto__ = (new Float32Array((3)));
(dest__14181__auto__[(0)] = ((G__20329[(0)]) + x));

(dest__14181__auto__[(1)] = ((G__20329[(1)]) + y));

(dest__14181__auto__[(2)] = ((G__20329[(2)]) + z));

return (new thi.ng.geom.vector.Vec3(dest__14181__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$abs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__14175__auto__ = (new Float32Array((3)));
var G__20330_20728 = self__.buf;
(dest__14175__auto__[(0)] = thi.ng.math.core.abs_STAR_.call(null,(G__20330_20728[(0)])));

(dest__14175__auto__[(1)] = thi.ng.math.core.abs_STAR_.call(null,(G__20330_20728[(1)])));

(dest__14175__auto__[(2)] = thi.ng.math.core.abs_STAR_.call(null,(G__20330_20728[(2)])));

return (new thi.ng.geom.vector.Vec3(dest__14175__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$subm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__14203__auto__ = (new Float32Array((3)));
var G__20343_20729 = (a instanceof thi.ng.geom.vector.Vec3);
var G__20344_20730 = (b instanceof thi.ng.geom.vector.Vec3);
var G__20345_20731 = (((!(G__20343_20729)))?typeof a === 'number':null);
var G__20346_20732 = (((!(G__20344_20730)))?typeof b === 'number':null);
var G__20331_20733 = self__.buf;
var G__20332_20734 = ((G__20343_20729)?a.buf:null);
var G__20333_20735 = ((G__20344_20730)?b.buf:null);
var G__20334_20736 = (G__20331_20733[(0)]);
var G__20335_20737 = (G__20331_20733[(1)]);
var G__20336_20738 = (G__20331_20733[(2)]);
var G__20337_20739 = ((G__20343_20729)?(G__20332_20734[(0)]):(cljs.core.truth_(G__20345_20731)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__20338_20740 = ((G__20343_20729)?(G__20332_20734[(1)]):(cljs.core.truth_(G__20345_20731)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__20339_20741 = ((G__20343_20729)?(G__20332_20734[(2)]):(cljs.core.truth_(G__20345_20731)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__20340_20742 = ((G__20344_20730)?(G__20333_20735[(0)]):(cljs.core.truth_(G__20346_20732)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__20341_20743 = ((G__20344_20730)?(G__20333_20735[(1)]):(cljs.core.truth_(G__20346_20732)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__20342_20744 = ((G__20344_20730)?(G__20333_20735[(2)]):(cljs.core.truth_(G__20346_20732)?b:cljs.core.nth.call(null,b,(2),1.0)));
(dest__14203__auto__[(0)] = ((G__20334_20736 - G__20337_20739) * G__20340_20742));

(dest__14203__auto__[(1)] = ((G__20335_20737 - G__20338_20740) * G__20341_20743));

(dest__14203__auto__[(2)] = ((G__20336_20738 - G__20339_20741) * G__20342_20744));

return (new thi.ng.geom.vector.Vec3(dest__14203__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"buf","buf",1426618187,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

thi.ng.geom.vector.Vec3.cljs$lang$type = true;

thi.ng.geom.vector.Vec3.cljs$lang$ctorStr = "thi.ng.geom.vector/Vec3";

thi.ng.geom.vector.Vec3.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"thi.ng.geom.vector/Vec3");
});

/**
 * Positional factory function for thi.ng.geom.vector/Vec3.
 */
thi.ng.geom.vector.__GT_Vec3 = (function thi$ng$geom$vector$__GT_Vec3(buf,_hash,_meta){
return (new thi.ng.geom.vector.Vec3(buf,_hash,_meta));
});

thi.ng.geom.vector.x = (function thi$ng$geom$vector$x(G__20747){
var G__20745 = (((G__20747 instanceof thi.ng.geom.vector.Vec2))?G__20747.buf:G__20747.buf);
return (G__20745[(0)]);
});
thi.ng.geom.vector.xx = (function thi$ng$geom$vector$xx(G__20750){
var G__20748 = (((G__20750 instanceof thi.ng.geom.vector.Vec2))?G__20750.buf:G__20750.buf);
var G__20749 = (new Float32Array(2));
(G__20749[(0)] = (G__20748[(0)]));

(G__20749[(1)] = (G__20748[(0)]));

return (new thi.ng.geom.vector.Vec2(G__20749,null,cljs.core.meta.call(null,G__20750)));
});
thi.ng.geom.vector.xxx = (function thi$ng$geom$vector$xxx(G__20753){
var G__20751 = (((G__20753 instanceof thi.ng.geom.vector.Vec2))?G__20753.buf:G__20753.buf);
var G__20752 = (new Float32Array(3));
(G__20752[(0)] = (G__20751[(0)]));

(G__20752[(1)] = (G__20751[(0)]));

(G__20752[(2)] = (G__20751[(0)]));

return (new thi.ng.geom.vector.Vec3(G__20752,null,cljs.core.meta.call(null,G__20753)));
});
thi.ng.geom.vector.xxy = (function thi$ng$geom$vector$xxy(G__20756){
var G__20754 = (((G__20756 instanceof thi.ng.geom.vector.Vec2))?G__20756.buf:G__20756.buf);
var G__20755 = (new Float32Array(3));
(G__20755[(0)] = (G__20754[(0)]));

(G__20755[(1)] = (G__20754[(0)]));

(G__20755[(2)] = (G__20754[(1)]));

return (new thi.ng.geom.vector.Vec3(G__20755,null,cljs.core.meta.call(null,G__20756)));
});
thi.ng.geom.vector.xxz = (function thi$ng$geom$vector$xxz(G__20759){
var G__20757 = (((G__20759 instanceof thi.ng.geom.vector.Vec2))?G__20759.buf:G__20759.buf);
var G__20758 = (new Float32Array(3));
(G__20758[(0)] = (G__20757[(0)]));

(G__20758[(1)] = (G__20757[(0)]));

(G__20758[(2)] = (G__20757[(2)]));

return (new thi.ng.geom.vector.Vec3(G__20758,null,cljs.core.meta.call(null,G__20759)));
});
thi.ng.geom.vector.xy = (function thi$ng$geom$vector$xy(G__20762){
var G__20760 = (((G__20762 instanceof thi.ng.geom.vector.Vec2))?G__20762.buf:G__20762.buf);
var G__20761 = (new Float32Array(2));
(G__20761[(0)] = (G__20760[(0)]));

(G__20761[(1)] = (G__20760[(1)]));

return (new thi.ng.geom.vector.Vec2(G__20761,null,cljs.core.meta.call(null,G__20762)));
});
thi.ng.geom.vector.xyx = (function thi$ng$geom$vector$xyx(G__20765){
var G__20763 = (((G__20765 instanceof thi.ng.geom.vector.Vec2))?G__20765.buf:G__20765.buf);
var G__20764 = (new Float32Array(3));
(G__20764[(0)] = (G__20763[(0)]));

(G__20764[(1)] = (G__20763[(1)]));

(G__20764[(2)] = (G__20763[(0)]));

return (new thi.ng.geom.vector.Vec3(G__20764,null,cljs.core.meta.call(null,G__20765)));
});
thi.ng.geom.vector.xyy = (function thi$ng$geom$vector$xyy(G__20768){
var G__20766 = (((G__20768 instanceof thi.ng.geom.vector.Vec2))?G__20768.buf:G__20768.buf);
var G__20767 = (new Float32Array(3));
(G__20767[(0)] = (G__20766[(0)]));

(G__20767[(1)] = (G__20766[(1)]));

(G__20767[(2)] = (G__20766[(1)]));

return (new thi.ng.geom.vector.Vec3(G__20767,null,cljs.core.meta.call(null,G__20768)));
});
thi.ng.geom.vector.xyz = (function thi$ng$geom$vector$xyz(G__20771){
var G__20769 = (((G__20771 instanceof thi.ng.geom.vector.Vec2))?G__20771.buf:G__20771.buf);
var G__20770 = (new Float32Array(3));
(G__20770[(0)] = (G__20769[(0)]));

(G__20770[(1)] = (G__20769[(1)]));

(G__20770[(2)] = (G__20769[(2)]));

return (new thi.ng.geom.vector.Vec3(G__20770,null,cljs.core.meta.call(null,G__20771)));
});
thi.ng.geom.vector.xz = (function thi$ng$geom$vector$xz(G__20774){
var G__20772 = (((G__20774 instanceof thi.ng.geom.vector.Vec2))?G__20774.buf:G__20774.buf);
var G__20773 = (new Float32Array(2));
(G__20773[(0)] = (G__20772[(0)]));

(G__20773[(1)] = (G__20772[(2)]));

return (new thi.ng.geom.vector.Vec2(G__20773,null,cljs.core.meta.call(null,G__20774)));
});
thi.ng.geom.vector.xzx = (function thi$ng$geom$vector$xzx(G__20777){
var G__20775 = (((G__20777 instanceof thi.ng.geom.vector.Vec2))?G__20777.buf:G__20777.buf);
var G__20776 = (new Float32Array(3));
(G__20776[(0)] = (G__20775[(0)]));

(G__20776[(1)] = (G__20775[(2)]));

(G__20776[(2)] = (G__20775[(0)]));

return (new thi.ng.geom.vector.Vec3(G__20776,null,cljs.core.meta.call(null,G__20777)));
});
thi.ng.geom.vector.xzy = (function thi$ng$geom$vector$xzy(G__20780){
var G__20778 = (((G__20780 instanceof thi.ng.geom.vector.Vec2))?G__20780.buf:G__20780.buf);
var G__20779 = (new Float32Array(3));
(G__20779[(0)] = (G__20778[(0)]));

(G__20779[(1)] = (G__20778[(2)]));

(G__20779[(2)] = (G__20778[(1)]));

return (new thi.ng.geom.vector.Vec3(G__20779,null,cljs.core.meta.call(null,G__20780)));
});
thi.ng.geom.vector.xzz = (function thi$ng$geom$vector$xzz(G__20783){
var G__20781 = (((G__20783 instanceof thi.ng.geom.vector.Vec2))?G__20783.buf:G__20783.buf);
var G__20782 = (new Float32Array(3));
(G__20782[(0)] = (G__20781[(0)]));

(G__20782[(1)] = (G__20781[(2)]));

(G__20782[(2)] = (G__20781[(2)]));

return (new thi.ng.geom.vector.Vec3(G__20782,null,cljs.core.meta.call(null,G__20783)));
});
thi.ng.geom.vector.y = (function thi$ng$geom$vector$y(G__20786){
var G__20784 = (((G__20786 instanceof thi.ng.geom.vector.Vec2))?G__20786.buf:G__20786.buf);
return (G__20784[(1)]);
});
thi.ng.geom.vector.yx = (function thi$ng$geom$vector$yx(G__20789){
var G__20787 = (((G__20789 instanceof thi.ng.geom.vector.Vec2))?G__20789.buf:G__20789.buf);
var G__20788 = (new Float32Array(2));
(G__20788[(0)] = (G__20787[(1)]));

(G__20788[(1)] = (G__20787[(0)]));

return (new thi.ng.geom.vector.Vec2(G__20788,null,cljs.core.meta.call(null,G__20789)));
});
thi.ng.geom.vector.yxx = (function thi$ng$geom$vector$yxx(G__20792){
var G__20790 = (((G__20792 instanceof thi.ng.geom.vector.Vec2))?G__20792.buf:G__20792.buf);
var G__20791 = (new Float32Array(3));
(G__20791[(0)] = (G__20790[(1)]));

(G__20791[(1)] = (G__20790[(0)]));

(G__20791[(2)] = (G__20790[(0)]));

return (new thi.ng.geom.vector.Vec3(G__20791,null,cljs.core.meta.call(null,G__20792)));
});
thi.ng.geom.vector.yxy = (function thi$ng$geom$vector$yxy(G__20795){
var G__20793 = (((G__20795 instanceof thi.ng.geom.vector.Vec2))?G__20795.buf:G__20795.buf);
var G__20794 = (new Float32Array(3));
(G__20794[(0)] = (G__20793[(1)]));

(G__20794[(1)] = (G__20793[(0)]));

(G__20794[(2)] = (G__20793[(1)]));

return (new thi.ng.geom.vector.Vec3(G__20794,null,cljs.core.meta.call(null,G__20795)));
});
thi.ng.geom.vector.yxz = (function thi$ng$geom$vector$yxz(G__20798){
var G__20796 = (((G__20798 instanceof thi.ng.geom.vector.Vec2))?G__20798.buf:G__20798.buf);
var G__20797 = (new Float32Array(3));
(G__20797[(0)] = (G__20796[(1)]));

(G__20797[(1)] = (G__20796[(0)]));

(G__20797[(2)] = (G__20796[(2)]));

return (new thi.ng.geom.vector.Vec3(G__20797,null,cljs.core.meta.call(null,G__20798)));
});
thi.ng.geom.vector.yy = (function thi$ng$geom$vector$yy(G__20801){
var G__20799 = (((G__20801 instanceof thi.ng.geom.vector.Vec2))?G__20801.buf:G__20801.buf);
var G__20800 = (new Float32Array(2));
(G__20800[(0)] = (G__20799[(1)]));

(G__20800[(1)] = (G__20799[(1)]));

return (new thi.ng.geom.vector.Vec2(G__20800,null,cljs.core.meta.call(null,G__20801)));
});
thi.ng.geom.vector.yyx = (function thi$ng$geom$vector$yyx(G__20804){
var G__20802 = (((G__20804 instanceof thi.ng.geom.vector.Vec2))?G__20804.buf:G__20804.buf);
var G__20803 = (new Float32Array(3));
(G__20803[(0)] = (G__20802[(1)]));

(G__20803[(1)] = (G__20802[(1)]));

(G__20803[(2)] = (G__20802[(0)]));

return (new thi.ng.geom.vector.Vec3(G__20803,null,cljs.core.meta.call(null,G__20804)));
});
thi.ng.geom.vector.yyy = (function thi$ng$geom$vector$yyy(G__20807){
var G__20805 = (((G__20807 instanceof thi.ng.geom.vector.Vec2))?G__20807.buf:G__20807.buf);
var G__20806 = (new Float32Array(3));
(G__20806[(0)] = (G__20805[(1)]));

(G__20806[(1)] = (G__20805[(1)]));

(G__20806[(2)] = (G__20805[(1)]));

return (new thi.ng.geom.vector.Vec3(G__20806,null,cljs.core.meta.call(null,G__20807)));
});
thi.ng.geom.vector.yyz = (function thi$ng$geom$vector$yyz(G__20810){
var G__20808 = (((G__20810 instanceof thi.ng.geom.vector.Vec2))?G__20810.buf:G__20810.buf);
var G__20809 = (new Float32Array(3));
(G__20809[(0)] = (G__20808[(1)]));

(G__20809[(1)] = (G__20808[(1)]));

(G__20809[(2)] = (G__20808[(2)]));

return (new thi.ng.geom.vector.Vec3(G__20809,null,cljs.core.meta.call(null,G__20810)));
});
thi.ng.geom.vector.yz = (function thi$ng$geom$vector$yz(G__20813){
var G__20811 = (((G__20813 instanceof thi.ng.geom.vector.Vec2))?G__20813.buf:G__20813.buf);
var G__20812 = (new Float32Array(2));
(G__20812[(0)] = (G__20811[(1)]));

(G__20812[(1)] = (G__20811[(2)]));

return (new thi.ng.geom.vector.Vec2(G__20812,null,cljs.core.meta.call(null,G__20813)));
});
thi.ng.geom.vector.yzx = (function thi$ng$geom$vector$yzx(G__20816){
var G__20814 = (((G__20816 instanceof thi.ng.geom.vector.Vec2))?G__20816.buf:G__20816.buf);
var G__20815 = (new Float32Array(3));
(G__20815[(0)] = (G__20814[(1)]));

(G__20815[(1)] = (G__20814[(2)]));

(G__20815[(2)] = (G__20814[(0)]));

return (new thi.ng.geom.vector.Vec3(G__20815,null,cljs.core.meta.call(null,G__20816)));
});
thi.ng.geom.vector.yzy = (function thi$ng$geom$vector$yzy(G__20819){
var G__20817 = (((G__20819 instanceof thi.ng.geom.vector.Vec2))?G__20819.buf:G__20819.buf);
var G__20818 = (new Float32Array(3));
(G__20818[(0)] = (G__20817[(1)]));

(G__20818[(1)] = (G__20817[(2)]));

(G__20818[(2)] = (G__20817[(1)]));

return (new thi.ng.geom.vector.Vec3(G__20818,null,cljs.core.meta.call(null,G__20819)));
});
thi.ng.geom.vector.yzz = (function thi$ng$geom$vector$yzz(G__20822){
var G__20820 = (((G__20822 instanceof thi.ng.geom.vector.Vec2))?G__20822.buf:G__20822.buf);
var G__20821 = (new Float32Array(3));
(G__20821[(0)] = (G__20820[(1)]));

(G__20821[(1)] = (G__20820[(2)]));

(G__20821[(2)] = (G__20820[(2)]));

return (new thi.ng.geom.vector.Vec3(G__20821,null,cljs.core.meta.call(null,G__20822)));
});
thi.ng.geom.vector.z = (function thi$ng$geom$vector$z(G__20825){
var G__20823 = (((G__20825 instanceof thi.ng.geom.vector.Vec2))?G__20825.buf:G__20825.buf);
return (G__20823[(2)]);
});
thi.ng.geom.vector.zx = (function thi$ng$geom$vector$zx(G__20828){
var G__20826 = (((G__20828 instanceof thi.ng.geom.vector.Vec2))?G__20828.buf:G__20828.buf);
var G__20827 = (new Float32Array(2));
(G__20827[(0)] = (G__20826[(2)]));

(G__20827[(1)] = (G__20826[(0)]));

return (new thi.ng.geom.vector.Vec2(G__20827,null,cljs.core.meta.call(null,G__20828)));
});
thi.ng.geom.vector.zxx = (function thi$ng$geom$vector$zxx(G__20831){
var G__20829 = (((G__20831 instanceof thi.ng.geom.vector.Vec2))?G__20831.buf:G__20831.buf);
var G__20830 = (new Float32Array(3));
(G__20830[(0)] = (G__20829[(2)]));

(G__20830[(1)] = (G__20829[(0)]));

(G__20830[(2)] = (G__20829[(0)]));

return (new thi.ng.geom.vector.Vec3(G__20830,null,cljs.core.meta.call(null,G__20831)));
});
thi.ng.geom.vector.zxy = (function thi$ng$geom$vector$zxy(G__20834){
var G__20832 = (((G__20834 instanceof thi.ng.geom.vector.Vec2))?G__20834.buf:G__20834.buf);
var G__20833 = (new Float32Array(3));
(G__20833[(0)] = (G__20832[(2)]));

(G__20833[(1)] = (G__20832[(0)]));

(G__20833[(2)] = (G__20832[(1)]));

return (new thi.ng.geom.vector.Vec3(G__20833,null,cljs.core.meta.call(null,G__20834)));
});
thi.ng.geom.vector.zxz = (function thi$ng$geom$vector$zxz(G__20837){
var G__20835 = (((G__20837 instanceof thi.ng.geom.vector.Vec2))?G__20837.buf:G__20837.buf);
var G__20836 = (new Float32Array(3));
(G__20836[(0)] = (G__20835[(2)]));

(G__20836[(1)] = (G__20835[(0)]));

(G__20836[(2)] = (G__20835[(2)]));

return (new thi.ng.geom.vector.Vec3(G__20836,null,cljs.core.meta.call(null,G__20837)));
});
thi.ng.geom.vector.zy = (function thi$ng$geom$vector$zy(G__20840){
var G__20838 = (((G__20840 instanceof thi.ng.geom.vector.Vec2))?G__20840.buf:G__20840.buf);
var G__20839 = (new Float32Array(2));
(G__20839[(0)] = (G__20838[(2)]));

(G__20839[(1)] = (G__20838[(1)]));

return (new thi.ng.geom.vector.Vec2(G__20839,null,cljs.core.meta.call(null,G__20840)));
});
thi.ng.geom.vector.zyx = (function thi$ng$geom$vector$zyx(G__20843){
var G__20841 = (((G__20843 instanceof thi.ng.geom.vector.Vec2))?G__20843.buf:G__20843.buf);
var G__20842 = (new Float32Array(3));
(G__20842[(0)] = (G__20841[(2)]));

(G__20842[(1)] = (G__20841[(1)]));

(G__20842[(2)] = (G__20841[(0)]));

return (new thi.ng.geom.vector.Vec3(G__20842,null,cljs.core.meta.call(null,G__20843)));
});
thi.ng.geom.vector.zyy = (function thi$ng$geom$vector$zyy(G__20846){
var G__20844 = (((G__20846 instanceof thi.ng.geom.vector.Vec2))?G__20846.buf:G__20846.buf);
var G__20845 = (new Float32Array(3));
(G__20845[(0)] = (G__20844[(2)]));

(G__20845[(1)] = (G__20844[(1)]));

(G__20845[(2)] = (G__20844[(1)]));

return (new thi.ng.geom.vector.Vec3(G__20845,null,cljs.core.meta.call(null,G__20846)));
});
thi.ng.geom.vector.zyz = (function thi$ng$geom$vector$zyz(G__20849){
var G__20847 = (((G__20849 instanceof thi.ng.geom.vector.Vec2))?G__20849.buf:G__20849.buf);
var G__20848 = (new Float32Array(3));
(G__20848[(0)] = (G__20847[(2)]));

(G__20848[(1)] = (G__20847[(1)]));

(G__20848[(2)] = (G__20847[(2)]));

return (new thi.ng.geom.vector.Vec3(G__20848,null,cljs.core.meta.call(null,G__20849)));
});
thi.ng.geom.vector.zz = (function thi$ng$geom$vector$zz(G__20852){
var G__20850 = (((G__20852 instanceof thi.ng.geom.vector.Vec2))?G__20852.buf:G__20852.buf);
var G__20851 = (new Float32Array(2));
(G__20851[(0)] = (G__20850[(2)]));

(G__20851[(1)] = (G__20850[(2)]));

return (new thi.ng.geom.vector.Vec2(G__20851,null,cljs.core.meta.call(null,G__20852)));
});
thi.ng.geom.vector.zzx = (function thi$ng$geom$vector$zzx(G__20855){
var G__20853 = (((G__20855 instanceof thi.ng.geom.vector.Vec2))?G__20855.buf:G__20855.buf);
var G__20854 = (new Float32Array(3));
(G__20854[(0)] = (G__20853[(2)]));

(G__20854[(1)] = (G__20853[(2)]));

(G__20854[(2)] = (G__20853[(0)]));

return (new thi.ng.geom.vector.Vec3(G__20854,null,cljs.core.meta.call(null,G__20855)));
});
thi.ng.geom.vector.zzy = (function thi$ng$geom$vector$zzy(G__20858){
var G__20856 = (((G__20858 instanceof thi.ng.geom.vector.Vec2))?G__20858.buf:G__20858.buf);
var G__20857 = (new Float32Array(3));
(G__20857[(0)] = (G__20856[(2)]));

(G__20857[(1)] = (G__20856[(2)]));

(G__20857[(2)] = (G__20856[(1)]));

return (new thi.ng.geom.vector.Vec3(G__20857,null,cljs.core.meta.call(null,G__20858)));
});
thi.ng.geom.vector.zzz = (function thi$ng$geom$vector$zzz(G__20861){
var G__20859 = (((G__20861 instanceof thi.ng.geom.vector.Vec2))?G__20861.buf:G__20861.buf);
var G__20860 = (new Float32Array(3));
(G__20860[(0)] = (G__20859[(2)]));

(G__20860[(1)] = (G__20859[(2)]));

(G__20860[(2)] = (G__20859[(2)]));

return (new thi.ng.geom.vector.Vec3(G__20860,null,cljs.core.meta.call(null,G__20861)));
});
thi.ng.geom.vector.swizzle2_fns = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"x","x",2099068185),thi.ng.geom.vector.x,new cljs.core.Keyword(null,"xx","xx",-1542203733),thi.ng.geom.vector.xx,new cljs.core.Keyword(null,"xy","xy",-696978232),thi.ng.geom.vector.xy,new cljs.core.Keyword(null,"y","y",-1757859776),thi.ng.geom.vector.y,new cljs.core.Keyword(null,"yx","yx",1696579752),thi.ng.geom.vector.yx,new cljs.core.Keyword(null,"yy","yy",-1432012814),thi.ng.geom.vector.yy], null);
thi.ng.geom.vector.swizzle3_fns = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"xzx","xzx",-1000197983),new cljs.core.Keyword(null,"xyz","xyz",-1605570015),new cljs.core.Keyword(null,"zzy","zzy",-874287326),new cljs.core.Keyword(null,"yx","yx",1696579752),new cljs.core.Keyword(null,"xy","xy",-696978232),new cljs.core.Keyword(null,"yyz","yyz",1133968296),new cljs.core.Keyword(null,"zxy","zxy",-1258840183),new cljs.core.Keyword(null,"xzy","xzy",1043177385),new cljs.core.Keyword(null,"zxz","zxz",1026042602),new cljs.core.Keyword(null,"zx","zx",-933582998),new cljs.core.Keyword(null,"xx","xx",-1542203733),new cljs.core.Keyword(null,"xxx","xxx",-1019301908),new cljs.core.Keyword(null,"zy","zy",-1975963090),new cljs.core.Keyword(null,"zzx","zzx",20750383),new cljs.core.Keyword(null,"zyx","zyx",1752527951),new cljs.core.Keyword(null,"yzx","yzx",-1496223025),new cljs.core.Keyword(null,"z","z",-789527183),new cljs.core.Keyword(null,"yyx","yyx",-1318218191),new cljs.core.Keyword(null,"xz","xz",426487154),new cljs.core.Keyword(null,"zyz","zyz",-1838068142),new cljs.core.Keyword(null,"yy","yy",-1432012814),new cljs.core.Keyword(null,"xxz","xxz",129827699),new cljs.core.Keyword(null,"yzy","yzy",-179510251),new cljs.core.Keyword(null,"yz","yz",679015029),new cljs.core.Keyword(null,"yxx","yxx",-332290091),new cljs.core.Keyword(null,"xyy","xyy",996073014),new cljs.core.Keyword(null,"xxy","xxy",-650102026),new cljs.core.Keyword(null,"zz","zz",122901783),new cljs.core.Keyword(null,"zzz","zzz",-77420552),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"xzz","xzz",-643126693),new cljs.core.Keyword(null,"yxz","yxz",1786796508),new cljs.core.Keyword(null,"zxx","zxx",-61980804),new cljs.core.Keyword(null,"yzz","yzz",-1034441732),new cljs.core.Keyword(null,"xyx","xyx",1899467293),new cljs.core.Keyword(null,"yxy","yxy",1369901661),new cljs.core.Keyword(null,"yyy","yyy",780595422),new cljs.core.Keyword(null,"zyy","zyy",1946268991)],[thi.ng.geom.vector.y,thi.ng.geom.vector.xzx,thi.ng.geom.vector.xyz,thi.ng.geom.vector.zzy,thi.ng.geom.vector.yx,thi.ng.geom.vector.xy,thi.ng.geom.vector.yyz,thi.ng.geom.vector.zxy,thi.ng.geom.vector.xzy,thi.ng.geom.vector.zxz,thi.ng.geom.vector.zx,thi.ng.geom.vector.xx,thi.ng.geom.vector.xxx,thi.ng.geom.vector.zy,thi.ng.geom.vector.zzx,thi.ng.geom.vector.zyx,thi.ng.geom.vector.yzx,thi.ng.geom.vector.z,thi.ng.geom.vector.yyx,thi.ng.geom.vector.xz,thi.ng.geom.vector.zyz,thi.ng.geom.vector.yy,thi.ng.geom.vector.xxz,thi.ng.geom.vector.yzy,thi.ng.geom.vector.yz,thi.ng.geom.vector.yxx,thi.ng.geom.vector.xyy,thi.ng.geom.vector.xxy,thi.ng.geom.vector.zz,thi.ng.geom.vector.zzz,thi.ng.geom.vector.x,thi.ng.geom.vector.xzz,thi.ng.geom.vector.yxz,thi.ng.geom.vector.zxx,thi.ng.geom.vector.yzz,thi.ng.geom.vector.xyx,thi.ng.geom.vector.yxy,thi.ng.geom.vector.yyy,thi.ng.geom.vector.zyy]);
thi.ng.geom.vector.swizzle_assoc_STAR_ = (function thi$ng$geom$vector$swizzle_assoc_STAR_(src,dest,keymap,k,v){
var n = cljs.core.name.call(null,k);
var c = cljs.core.count.call(null,n);
var temp__5718__auto__ = (function (){var and__4120__auto__ = ((1) === c);
if(and__4120__auto__){
return keymap.call(null,cljs.core.first.call(null,n));
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5718__auto__)){
var idx = temp__5718__auto__;
(dest[(idx | (0))] = v);

return dest;
} else {
if((((c <= cljs.core.count.call(null,keymap))) && ((((c === cljs.core.count.call(null,v))) && ((cljs.core.count.call(null,v) === cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,n)))))))){
var i = (0);
var n__$1 = n;
while(true){
if(cljs.core.truth_(n__$1)){
var temp__5718__auto____$1 = keymap.call(null,cljs.core.first.call(null,n__$1));
if(cljs.core.truth_(temp__5718__auto____$1)){
var idx = temp__5718__auto____$1;
(dest[(idx | (0))] = v.call(null,i));

var G__20862 = (i + (1));
var G__20863 = cljs.core.next.call(null,n__$1);
i = G__20862;
n__$1 = G__20863;
continue;
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
return dest;
}
break;
}
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});
thi.ng.geom.vector.vec2_reduce_STAR_ = (function thi$ng$geom$vector$vec2_reduce_STAR_(op,acc,xs){
return cljs.core.transduce.call(null,cljs.core.map.call(null,(function (x){
return x.buf;
})),(function() {
var G__20864 = null;
var G__20864__1 = (function (a){
return a;
});
var G__20864__2 = (function (a,b){
(a[(0)] = op.call(null,(a[(0)]),(b[(0)])));

(a[(1)] = op.call(null,(a[(1)]),(b[(1)])));

return a;
});
G__20864 = function(a,b){
switch(arguments.length){
case 1:
return G__20864__1.call(this,a);
case 2:
return G__20864__2.call(this,a,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20864.cljs$core$IFn$_invoke$arity$1 = G__20864__1;
G__20864.cljs$core$IFn$_invoke$arity$2 = G__20864__2;
return G__20864;
})()
,acc,xs);
});
thi.ng.geom.vector.vec3_reduce_STAR_ = (function thi$ng$geom$vector$vec3_reduce_STAR_(op,acc,xs){
return cljs.core.transduce.call(null,cljs.core.map.call(null,(function (x){
return x.buf;
})),(function() {
var G__20865 = null;
var G__20865__1 = (function (a){
return a;
});
var G__20865__2 = (function (a,b){
(a[(0)] = op.call(null,(a[(0)]),(b[(0)])));

(a[(1)] = op.call(null,(a[(1)]),(b[(1)])));

(a[(2)] = op.call(null,(a[(2)]),(b[(2)])));

return a;
});
G__20865 = function(a,b){
switch(arguments.length){
case 1:
return G__20865__1.call(this,a);
case 2:
return G__20865__2.call(this,a,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20865.cljs$core$IFn$_invoke$arity$1 = G__20865__1;
G__20865.cljs$core$IFn$_invoke$arity$2 = G__20865__2;
return G__20865;
})()
,acc,xs);
});
thi.ng.geom.vector.V2 = (new thi.ng.geom.vector.Vec2((new Float32Array((2))),null,null));
thi.ng.geom.vector.V3 = (new thi.ng.geom.vector.Vec3((new Float32Array((3))),null,null));
thi.ng.geom.vector.vec2 = (function thi$ng$geom$vector$vec2(var_args){
var G__20867 = arguments.length;
switch (G__20867) {
case 0:
return thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.geom.vector.V2;
});

thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$1 = (function (v){
if((v instanceof thi.ng.geom.vector.Vec2)){
return v;
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec2.call(null,v,v);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0));
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),(0)),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),(0)));
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec2",v);

}
}
}
}
});

thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var b = (new Float32Array((2)));
(b[(0)] = x);

(b[(1)] = y);

return (new thi.ng.geom.vector.Vec2(b,null,null));
});

thi.ng.geom.vector.vec2.cljs$lang$maxFixedArity = 2;

thi.ng.geom.vector.vec3 = (function thi$ng$geom$vector$vec3(var_args){
var G__20870 = arguments.length;
switch (G__20870) {
case 0:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.geom.vector.V3;
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$1 = (function (v){
if((v instanceof thi.ng.geom.vector.Vec3)){
return v;
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec3.call(null,v,v,v);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),cljs.core.nth.call(null,v,(2),0.0));
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"z","z",-789527183),0.0));
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec3",v);

}
}
}
}
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$2 = (function (v,z){
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),z);
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),z);
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec3.call(null,v,z,(0));
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec3",v);

}
}
}
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$3 = (function (x,y,z){
var b = (new Float32Array((3)));
(b[(0)] = x);

(b[(1)] = y);

(b[(2)] = z);

return (new thi.ng.geom.vector.Vec3(b,null,null));
});

thi.ng.geom.vector.vec3.cljs$lang$maxFixedArity = 3;

thi.ng.geom.vector.vec2_with_meta = (function thi$ng$geom$vector$vec2_with_meta(var_args){
var G__20873 = arguments.length;
switch (G__20873) {
case 2:
return thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$2 = (function (v,meta){
if((v instanceof thi.ng.geom.vector.Vec2)){
return cljs.core.with_meta.call(null,v,meta);
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec2_with_meta.call(null,v,v,meta);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2_with_meta.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),meta);
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2_with_meta.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),meta);
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec2",v);

}
}
}
}
});

thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$3 = (function (x,y,meta){
var b = (new Float32Array((2)));
(b[(0)] = x);

(b[(1)] = y);

return (new thi.ng.geom.vector.Vec2(b,null,meta));
});

thi.ng.geom.vector.vec2_with_meta.cljs$lang$maxFixedArity = 3;

thi.ng.geom.vector.vec3_with_meta = (function thi$ng$geom$vector$vec3_with_meta(var_args){
var G__20876 = arguments.length;
switch (G__20876) {
case 2:
return thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$2 = (function (v,meta){
if((v instanceof thi.ng.geom.vector.Vec3)){
return cljs.core.with_meta.call(null,v,meta);
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec3_with_meta.call(null,v,v,v,meta);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3_with_meta.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),cljs.core.nth.call(null,v,(2),0.0),meta);
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3_with_meta.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"z","z",-789527183),0.0),meta);
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec3",v);

}
}
}
}
});

thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$4 = (function (x,y,z,meta){
var b = (new Float32Array((3)));
(b[(0)] = x);

(b[(1)] = y);

(b[(2)] = z);

return (new thi.ng.geom.vector.Vec3(b,null,meta));
});

thi.ng.geom.vector.vec3_with_meta.cljs$lang$maxFixedArity = 4;

thi.ng.geom.vector.vec2_QMARK_ = (function thi$ng$geom$vector$vec2_QMARK_(x){
return (x instanceof thi.ng.geom.vector.Vec2);
});
thi.ng.geom.vector.vec3_QMARK_ = (function thi$ng$geom$vector$vec3_QMARK_(x){
return (x instanceof thi.ng.geom.vector.Vec3);
});
thi.ng.geom.vector.V2X = thi.ng.geom.vector.vec2.call(null,(1),(0));
thi.ng.geom.vector.V2Y = thi.ng.geom.vector.vec2.call(null,(0),(1));
thi.ng.geom.vector.V3X = thi.ng.geom.vector.vec3.call(null,(1),(0),(0));
thi.ng.geom.vector.V3Y = thi.ng.geom.vector.vec3.call(null,(0),(1),(0));
thi.ng.geom.vector.V3Z = thi.ng.geom.vector.vec3.call(null,(0),(0),(1));
thi.ng.geom.vector.V2INF_ = thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.INF_);
thi.ng.geom.vector.V2INF_PLUS_ = thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.INF_PLUS_);
thi.ng.geom.vector.V3INF_ = thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.INF_);
thi.ng.geom.vector.V3INF_PLUS_ = thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.INF_PLUS_);
thi.ng.geom.vector.randvec2 = (function thi$ng$geom$vector$randvec2(var_args){
var G__20879 = arguments.length;
switch (G__20879) {
case 0:
return thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)));
});

thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$1 = (function (n){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)),n);
});

thi.ng.geom.vector.randvec2.cljs$lang$maxFixedArity = 1;

thi.ng.geom.vector.randvec3 = (function thi$ng$geom$vector$randvec3(var_args){
var G__20882 = arguments.length;
switch (G__20882) {
case 0:
return thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)));
});

thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$1 = (function (n){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)),n);
});

thi.ng.geom.vector.randvec3.cljs$lang$maxFixedArity = 1;


//# sourceMappingURL=vector.js.map
