// Compiled by ClojureScript 1.10.516 {}
goog.provide('thi.ng.geom.vector');
goog.require('cljs.core');
goog.require('thi.ng.geom.core');
goog.require('thi.ng.math.core');
goog.require('thi.ng.dstruct.streams');
goog.require('thi.ng.xerror.core');









/**
* @constructor
 * @implements {thi.ng.geom.core.ITranslate}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {thi.ng.math.core.IDotProduct}
 * @implements {cljs.core.IReversible}
 * @implements {thi.ng.math.core.IMutableMathOps}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {thi.ng.math.core.ICrossProduct}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {thi.ng.math.core.IDeltaEquals}
 * @implements {thi.ng.geom.core.IPolar}
 * @implements {thi.ng.geom.vector.Object}
 * @implements {thi.ng.geom.core.IClear}
 * @implements {thi.ng.math.core.IInvert}
 * @implements {cljs.core.ICounted}
 * @implements {thi.ng.math.core.ILimit}
 * @implements {thi.ng.dstruct.streams.IBuffer}
 * @implements {cljs.core.ISeq}
 * @implements {thi.ng.math.core.IInterpolate}
 * @implements {cljs.core.INext}
 * @implements {thi.ng.math.core.IMathOps}
 * @implements {thi.ng.geom.core.ITransform}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {thi.ng.math.core.IMinMax}
 * @implements {thi.ng.geom.core.IRotate}
 * @implements {thi.ng.math.core.INormalize}
 * @implements {thi.ng.math.core.IMagnitude}
 * @implements {thi.ng.geom.core.IScale}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {thi.ng.geom.core.IReflect}
 * @implements {thi.ng.geom.core.IHeading}
 * @implements {thi.ng.geom.core.IDistance}
 * @implements {cljs.core.IComparable}
 * @implements {thi.ng.dstruct.streams.IIntoBuffer}
 * @implements {cljs.core.ISequential}
 * @implements {thi.ng.geom.core.INormal}
 * @implements {cljs.core.IWithMeta}
 * @implements {thi.ng.geom.core.IVectorReduce}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
thi.ng.geom.vector.Vec2 = (function (buf,_hash,_meta){
this.buf = buf;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2314101723;
this.cljs$lang$protocol_mask$partition1$ = 10240;
});
thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITransform$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITransform$transform$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.transform_vector.call(null,m,___$1);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = (- (self__.buf[(0)])));

(self__.buf[(1)] = (- (self__.buf[(1)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18028_18377 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18029_18378 = v.buf;
(self__.buf[(0)] = ((G__18028_18377[(0)]) - (G__18029_18378[(0)])));

(self__.buf[(1)] = ((G__18028_18377[(1)]) - (G__18029_18378[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__18028_18377[(0)]) - v));

(self__.buf[(1)] = ((G__18028_18377[(1)]) - v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__18028_18377[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__18028_18377[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18037_18379 = typeof v1 === 'number';
var G__18038_18380 = typeof v2 === 'number';
if(((G__18037_18379)?G__18038_18380:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) - v1));

(self__.buf[(1)] = ((self__.buf[(1)]) - v2));
} else {
var G__18039_18381 = (((!(G__18037_18379)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__18040_18382 = (((!(G__18038_18380)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__18031_18383 = (cljs.core.truth_(G__18039_18381)?v1.buf:null);
var G__18032_18384 = (cljs.core.truth_(G__18040_18382)?v2.buf:null);
var G__18033_18385 = (cljs.core.truth_(G__18039_18381)?(G__18031_18383[(0)]):((G__18037_18379)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18034_18386 = (cljs.core.truth_(G__18039_18381)?(G__18031_18383[(1)]):((G__18037_18379)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18035_18387 = (cljs.core.truth_(G__18040_18382)?(G__18032_18384[(0)]):((G__18038_18380)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18036_18388 = (cljs.core.truth_(G__18040_18382)?(G__18032_18384[(1)]):((G__18038_18380)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) - G__18033_18385) - G__18035_18387));

(self__.buf[(1)] = (((self__.buf[(1)]) - G__18034_18386) - G__18036_18388));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18041_18389 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18042_18390 = v.buf;
(self__.buf[(0)] = ((G__18041_18389[(0)]) * (G__18042_18390[(0)])));

(self__.buf[(1)] = ((G__18041_18389[(1)]) * (G__18042_18390[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__18041_18389[(0)]) * v));

(self__.buf[(1)] = ((G__18041_18389[(1)]) * v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__18041_18389[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__18041_18389[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18050_18391 = typeof v1 === 'number';
var G__18051_18392 = typeof v2 === 'number';
if(((G__18050_18391)?G__18051_18392:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) * v1));

(self__.buf[(1)] = ((self__.buf[(1)]) * v2));
} else {
var G__18052_18393 = (((!(G__18050_18391)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__18053_18394 = (((!(G__18051_18392)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__18044_18395 = (cljs.core.truth_(G__18052_18393)?v1.buf:null);
var G__18045_18396 = (cljs.core.truth_(G__18053_18394)?v2.buf:null);
var G__18046_18397 = (cljs.core.truth_(G__18052_18393)?(G__18044_18395[(0)]):((G__18050_18391)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18047_18398 = (cljs.core.truth_(G__18052_18393)?(G__18044_18395[(1)]):((G__18050_18391)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18048_18399 = (cljs.core.truth_(G__18053_18394)?(G__18045_18396[(0)]):((G__18051_18392)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18049_18400 = (cljs.core.truth_(G__18053_18394)?(G__18045_18396[(1)]):((G__18051_18392)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) * G__18046_18397) * G__18048_18399));

(self__.buf[(1)] = (((self__.buf[(1)]) * G__18047_18398) * G__18049_18400));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$subm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__18063_18401 = (a instanceof thi.ng.geom.vector.Vec2);
var G__18064_18402 = (b instanceof thi.ng.geom.vector.Vec2);
var G__18065_18403 = (((!(G__18063_18401)))?typeof a === 'number':null);
var G__18066_18404 = (((!(G__18064_18402)))?typeof b === 'number':null);
var G__18054_18405 = self__.buf;
var G__18055_18406 = ((G__18063_18401)?a.buf:null);
var G__18056_18407 = ((G__18064_18402)?b.buf:null);
var G__18057_18408 = (G__18054_18405[(0)]);
var G__18058_18409 = (G__18054_18405[(1)]);
var G__18059_18410 = ((G__18063_18401)?(G__18055_18406[(0)]):(cljs.core.truth_(G__18065_18403)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__18060_18411 = ((G__18063_18401)?(G__18055_18406[(1)]):(cljs.core.truth_(G__18065_18403)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__18061_18412 = ((G__18064_18402)?(G__18056_18407[(0)]):(cljs.core.truth_(G__18066_18404)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__18062_18413 = ((G__18064_18402)?(G__18056_18407[(1)]):(cljs.core.truth_(G__18066_18404)?b:cljs.core.nth.call(null,b,(1),1.0)));
(self__.buf[(0)] = ((G__18057_18408 - G__18059_18410) * G__18061_18412));

(self__.buf[(1)] = ((G__18058_18409 - G__18060_18411) * G__18062_18413));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$msub_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__18076_18414 = (a instanceof thi.ng.geom.vector.Vec2);
var G__18077_18415 = (b instanceof thi.ng.geom.vector.Vec2);
var G__18078_18416 = (((!(G__18076_18414)))?typeof a === 'number':null);
var G__18079_18417 = (((!(G__18077_18415)))?typeof b === 'number':null);
var G__18067_18418 = self__.buf;
var G__18068_18419 = ((G__18076_18414)?a.buf:null);
var G__18069_18420 = ((G__18077_18415)?b.buf:null);
var G__18070_18421 = (G__18067_18418[(0)]);
var G__18071_18422 = (G__18067_18418[(1)]);
var G__18072_18423 = ((G__18076_18414)?(G__18068_18419[(0)]):(cljs.core.truth_(G__18078_18416)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__18073_18424 = ((G__18076_18414)?(G__18068_18419[(1)]):(cljs.core.truth_(G__18078_18416)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__18074_18425 = ((G__18077_18415)?(G__18069_18420[(0)]):(cljs.core.truth_(G__18079_18417)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18075_18426 = ((G__18077_18415)?(G__18069_18420[(1)]):(cljs.core.truth_(G__18079_18417)?b:cljs.core.nth.call(null,b,(1),0.0)));
(self__.buf[(0)] = ((G__18070_18421 * G__18072_18423) - G__18074_18425));

(self__.buf[(1)] = ((G__18071_18422 * G__18073_18424) - G__18075_18426));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$abs_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(0)])));

(self__.buf[(1)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(1)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$madd_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__18089_18427 = (a instanceof thi.ng.geom.vector.Vec2);
var G__18090_18428 = (b instanceof thi.ng.geom.vector.Vec2);
var G__18091_18429 = (((!(G__18089_18427)))?typeof a === 'number':null);
var G__18092_18430 = (((!(G__18090_18428)))?typeof b === 'number':null);
var G__18080_18431 = self__.buf;
var G__18081_18432 = ((G__18089_18427)?a.buf:null);
var G__18082_18433 = ((G__18090_18428)?b.buf:null);
var G__18083_18434 = (G__18080_18431[(0)]);
var G__18084_18435 = (G__18080_18431[(1)]);
var G__18085_18436 = ((G__18089_18427)?(G__18081_18432[(0)]):(cljs.core.truth_(G__18091_18429)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__18086_18437 = ((G__18089_18427)?(G__18081_18432[(1)]):(cljs.core.truth_(G__18091_18429)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__18087_18438 = ((G__18090_18428)?(G__18082_18433[(0)]):(cljs.core.truth_(G__18092_18430)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18088_18439 = ((G__18090_18428)?(G__18082_18433[(1)]):(cljs.core.truth_(G__18092_18430)?b:cljs.core.nth.call(null,b,(1),0.0)));
(self__.buf[(0)] = ((G__18083_18434 * G__18085_18436) + G__18087_18438));

(self__.buf[(1)] = ((G__18084_18435 * G__18086_18437) + G__18088_18439));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((1) / (self__.buf[(0)])));

(self__.buf[(1)] = ((1) / (self__.buf[(1)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18093_18440 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18094_18441 = v.buf;
(self__.buf[(0)] = ((G__18093_18440[(0)]) / (G__18094_18441[(0)])));

(self__.buf[(1)] = ((G__18093_18440[(1)]) / (G__18094_18441[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__18093_18440[(0)]) / v));

(self__.buf[(1)] = ((G__18093_18440[(1)]) / v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__18093_18440[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__18093_18440[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18102_18442 = typeof v1 === 'number';
var G__18103_18443 = typeof v2 === 'number';
if(((G__18102_18442)?G__18103_18443:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) / v1));

(self__.buf[(1)] = ((self__.buf[(1)]) / v2));
} else {
var G__18104_18444 = (((!(G__18102_18442)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__18105_18445 = (((!(G__18103_18443)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__18096_18446 = (cljs.core.truth_(G__18104_18444)?v1.buf:null);
var G__18097_18447 = (cljs.core.truth_(G__18105_18445)?v2.buf:null);
var G__18098_18448 = (cljs.core.truth_(G__18104_18444)?(G__18096_18446[(0)]):((G__18102_18442)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18099_18449 = (cljs.core.truth_(G__18104_18444)?(G__18096_18446[(1)]):((G__18102_18442)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18100_18450 = (cljs.core.truth_(G__18105_18445)?(G__18097_18447[(0)]):((G__18103_18443)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18101_18451 = (cljs.core.truth_(G__18105_18445)?(G__18097_18447[(1)]):((G__18103_18443)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) / G__18098_18448) / G__18100_18450));

(self__.buf[(1)] = (((self__.buf[(1)]) / G__18099_18449) / G__18101_18451));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18106_18452 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18107_18453 = v.buf;
(self__.buf[(0)] = ((G__18106_18452[(0)]) + (G__18107_18453[(0)])));

(self__.buf[(1)] = ((G__18106_18452[(1)]) + (G__18107_18453[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__18106_18452[(0)]) + v));

(self__.buf[(1)] = ((G__18106_18452[(1)]) + v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__18106_18452[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__18106_18452[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18115_18454 = typeof v1 === 'number';
var G__18116_18455 = typeof v2 === 'number';
if(((G__18115_18454)?G__18116_18455:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) + v1));

(self__.buf[(1)] = ((self__.buf[(1)]) + v2));
} else {
var G__18117_18456 = (((!(G__18115_18454)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__18118_18457 = (((!(G__18116_18455)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__18109_18458 = (cljs.core.truth_(G__18117_18456)?v1.buf:null);
var G__18110_18459 = (cljs.core.truth_(G__18118_18457)?v2.buf:null);
var G__18111_18460 = (cljs.core.truth_(G__18117_18456)?(G__18109_18458[(0)]):((G__18115_18454)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18112_18461 = (cljs.core.truth_(G__18117_18456)?(G__18109_18458[(1)]):((G__18115_18454)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18113_18462 = (cljs.core.truth_(G__18118_18457)?(G__18110_18459[(0)]):((G__18116_18455)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18114_18463 = (cljs.core.truth_(G__18118_18457)?(G__18110_18459[(1)]):((G__18116_18455)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) + G__18111_18460) + G__18113_18462));

(self__.buf[(1)] = (((self__.buf[(1)]) + G__18112_18461) + G__18114_18463));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$addm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__18128_18464 = (a instanceof thi.ng.geom.vector.Vec2);
var G__18129_18465 = (b instanceof thi.ng.geom.vector.Vec2);
var G__18130_18466 = (((!(G__18128_18464)))?typeof a === 'number':null);
var G__18131_18467 = (((!(G__18129_18465)))?typeof b === 'number':null);
var G__18119_18468 = self__.buf;
var G__18120_18469 = ((G__18128_18464)?a.buf:null);
var G__18121_18470 = ((G__18129_18465)?b.buf:null);
var G__18122_18471 = (G__18119_18468[(0)]);
var G__18123_18472 = (G__18119_18468[(1)]);
var G__18124_18473 = ((G__18128_18464)?(G__18120_18469[(0)]):(cljs.core.truth_(G__18130_18466)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__18125_18474 = ((G__18128_18464)?(G__18120_18469[(1)]):(cljs.core.truth_(G__18130_18466)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__18126_18475 = ((G__18129_18465)?(G__18121_18470[(0)]):(cljs.core.truth_(G__18131_18467)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__18127_18476 = ((G__18129_18465)?(G__18121_18470[(1)]):(cljs.core.truth_(G__18131_18467)?b:cljs.core.nth.call(null,b,(1),1.0)));
(self__.buf[(0)] = ((G__18122_18471 + G__18124_18473) * G__18126_18475));

(self__.buf[(1)] = ((G__18123_18472 + G__18125_18474) * G__18127_18476));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IBuffer$get_float_buffer$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.buf;
});

thi.ng.geom.vector.Vec2.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(0)]))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(1)])),"]"].join('');
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,___$1);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (_,k,nf){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,___$1);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ICrossProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ICrossProduct$cross$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18132 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18133 = v.buf;
return (((G__18132[(0)]) * (G__18133[(1)])) - ((G__18132[(1)]) * (G__18133[(0)])));
} else {
return (((G__18132[(0)]) * cljs.core.nth.call(null,v,(1),0.0)) - ((G__18132[(1)]) * cljs.core.nth.call(null,v,(0),0.0)));
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (_,n){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (2))){
return (self__.buf[n]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,n);
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (_,n,nf){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (2))){
return (self__.buf[n]);
} else {
return nf;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (_,writer,opts){
var self__ = this;
var ___$1 = this;
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,"#thi.ng/vec2 ["," ","]",opts,cljs.core.seq.call(null,___$1));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (_,n,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array(self__.buf));
(b[n] = v);

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec2((new Float32Array(self__.buf)),self__._hash,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IReflect$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IReflect$reflect$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__18134 = self__.buf;
var G__18136 = (G__18134[(0)]);
var G__18137 = (G__18134[(1)]);
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18135 = v.buf;
var G__18138 = (G__18135[(0)]);
var G__18139 = (G__18135[(1)]);
var d = (((G__18136 * G__18138) + (G__18137 * G__18139)) * 2.0);
(b[(0)] = ((G__18138 * d) - G__18136));

(b[(1)] = ((G__18139 * d) - G__18137));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
var G__18138 = cljs.core.nth.call(null,v,(0),0.0);
var G__18139 = cljs.core.nth.call(null,v,(1),0.0);
var d = (((G__18136 * G__18138) + (G__18137 * G__18139)) * 2.0);
(b[(0)] = ((G__18138 * d) - G__18136));

(b[(1)] = ((G__18139 * d) - G__18137));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),null);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (2);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IDistance$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IDistance$dist$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return Math.sqrt(thi.ng.geom.core.dist_squared.call(null,___$1,v));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IDistance$dist_squared$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18140 = self__.buf;
var G__18142 = (G__18140[(0)]);
var G__18143 = (G__18140[(1)]);
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18141 = v.buf;
var G__18144 = (G__18141[(0)]);
var G__18145 = (G__18141[(1)]);
var dx = (G__18142 - G__18144);
var dy = (G__18143 - G__18145);
return ((dx * dx) + (dy * dy));
} else {
var G__18144 = cljs.core.nth.call(null,v,(0),0.0);
var G__18145 = cljs.core.nth.call(null,v,(1),0.0);
var dx = (G__18142 - G__18144);
var dy = (G__18143 - G__18145);
return ((dx * dx) + (dy * dy));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IRotate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IRotate$rotate$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((2)));
var G__18146 = self__.buf;
var G__18147 = (G__18146[(0)]);
var G__18148 = (G__18146[(1)]);
(b[(0)] = ((G__18147 * c) - (G__18148 * s)));

(b[(1)] = ((G__18147 * s) + (G__18148 * c)));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IStack$_peek$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(1)]);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IStack$_pop$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.buf[(0)])], null),self__._meta);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInvert$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInvert$invert$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core._.call(null,___$1);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.vector.swizzle2_fns.call(null,new cljs.core.Keyword(null,"yx","yx",1696579752)).call(null,___$1);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ILimit$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ILimit$limit$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
if((thi.ng.math.core.mag_squared.call(null,___$1) > (len * len))){
return thi.ng.math.core.normalize.call(null,___$1,len);
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IScale$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IScale$scale$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13252__auto__ = (new Float32Array((2)));
var G__18149_18477 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18150_18478 = v.buf;
(dest__13252__auto__[(0)] = ((G__18149_18477[(0)]) * (G__18150_18478[(0)])));

(dest__13252__auto__[(1)] = ((G__18149_18477[(1)]) * (G__18150_18478[(1)])));
} else {
if(typeof v === 'number'){
(dest__13252__auto__[(0)] = ((G__18149_18477[(0)]) * v));

(dest__13252__auto__[(1)] = ((G__18149_18477[(1)]) * v));
} else {
(dest__13252__auto__[(0)] = ((G__18149_18477[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__13252__auto__[(1)] = ((G__18149_18477[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__13252__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var or__4131__auto__ = self__._hash;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return ___$1._hash = cljs.core.mix_collection_hash.call(null,((cljs.core.imul.call(null,(((31) + cljs.core.hash.call(null,(self__.buf[(0)]))) | (0)),(31)) + cljs.core.hash.call(null,(self__.buf[(1)]))) | (0)),(2));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDeltaEquals$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,___$1,v,thi.ng.math.core._STAR_eps_STAR_);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$3 = (function (_,v,eps){
var self__ = this;
var ___$1 = this;
if(cljs.core.sequential_QMARK_.call(null,v)){
if(((2) === cljs.core.count.call(null,v))){
var G__18151 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18152 = v.buf;
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__18151[(0)]),(G__18152[(0)]),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__18151[(1)]),(G__18152[(1)]),eps);
} else {
return null;
}
} else {
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__18151[(0)]),cljs.core.nth.call(null,v,(0),0.0),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__18151[(1)]),cljs.core.nth.call(null,v,(1),0.0),eps);
} else {
return null;
}
}
} else {
return null;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec2)){
var b_SINGLEQUOTE_ = o.buf;
return ((((self__.buf[(0)]) === (b_SINGLEQUOTE_[(0)]))) && (((self__.buf[(1)]) === (b_SINGLEQUOTE_[(1)]))));
} else {
return ((cljs.core.sequential_QMARK_.call(null,o)) && (((2) === cljs.core.count.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(0)]),cljs.core.first.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(1)]),cljs.core.nth.call(null,o,(1)))));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IVectorReduce$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$3 = (function (_,f,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
return (new thi.ng.geom.vector.Vec2(thi.ng.geom.vector.vec2_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs),null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$4 = (function (_,f,f2,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
thi.ng.geom.vector.vec2_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs);

(buf_SINGLEQUOTE_[(0)] = f2.call(null,(buf_SINGLEQUOTE_[(0)]),(0)));

(buf_SINGLEQUOTE_[(1)] = f2.call(null,(buf_SINGLEQUOTE_[(1)]),(1)));

return (new thi.ng.geom.vector.Vec2(buf_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IIntoBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IIntoBuffer$into_float_buffer$arity$4 = (function (_,dest,stride,idx){
var self__ = this;
var ___$1 = this;
dest.set(self__.buf,idx);

return (idx + stride);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDotProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDotProduct$dot$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18153 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18154 = v.buf;
return (((G__18153[(0)]) * (G__18154[(0)])) + ((G__18153[(1)]) * (G__18154[(1)])));
} else {
return (((G__18153[(0)]) * cljs.core.nth.call(null,v,(0),0.0)) + ((G__18153[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$INormal$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$INormal$normal$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
(b[(0)] = (- (self__.buf[(1)])));

(b[(1)] = (self__.buf[(0)]));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,(self__.buf[(0)]),(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
return acc;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,start,(self__.buf[(0)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
var acc__$1 = f.call(null,acc,(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$1)){
return cljs.core.deref.call(null,acc__$1);
} else {
return acc__$1;
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITranslate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITranslate$translate$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13252__auto__ = (new Float32Array((2)));
var G__18155_18479 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18156_18480 = v.buf;
(dest__13252__auto__[(0)] = ((G__18155_18479[(0)]) + (G__18156_18480[(0)])));

(dest__13252__auto__[(1)] = ((G__18155_18479[(1)]) + (G__18156_18480[(1)])));
} else {
if(typeof v === 'number'){
(dest__13252__auto__[(0)] = ((G__18155_18479[(0)]) + v));

(dest__13252__auto__[(1)] = ((G__18155_18479[(1)]) + v));
} else {
(dest__13252__auto__[(0)] = ((G__18155_18479[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__13252__auto__[(1)] = ((G__18155_18479[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__13252__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(0)]);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),null);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$heading$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(1)]),(self__.buf[(0)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$heading_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.heading.call(null,___$1);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$angle_between$arity$2 = (function (_,a){
var self__ = this;
var ___$1 = this;
var t = (thi.ng.geom.core.heading.call(null,a) - thi.ng.geom.core.heading.call(null,___$1));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$slope_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(1)]) / (self__.buf[(0)]));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__18157_18481 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18158_18482 = v.buf;
(b[(0)] = (((G__18157_18481[(0)]) + (G__18158_18482[(0)])) * 0.5));

(b[(1)] = (((G__18157_18481[(1)]) + (G__18158_18482[(1)])) * 0.5));
} else {
if(typeof v === 'number'){
(b[(0)] = (((G__18157_18481[(0)]) + v) * 0.5));

(b[(1)] = (((G__18157_18481[(1)]) + v) * 0.5));
} else {
(b[(0)] = (((G__18157_18481[(0)]) + cljs.core.nth.call(null,v,(0),0.0)) * 0.5));

(b[(1)] = (((G__18157_18481[(1)]) + cljs.core.nth.call(null,v,(1),0.0)) * 0.5));
}
}

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix$arity$3 = (function (_,v,t){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__18168_18483 = (v instanceof thi.ng.geom.vector.Vec2);
var G__18169_18484 = (t instanceof thi.ng.geom.vector.Vec2);
var G__18170_18485 = (((!(G__18168_18483)))?typeof v === 'number':null);
var G__18171_18486 = (((!(G__18169_18484)))?typeof t === 'number':null);
var G__18159_18487 = self__.buf;
var G__18160_18488 = ((G__18168_18483)?v.buf:null);
var G__18161_18489 = ((G__18169_18484)?t.buf:null);
var G__18162_18490 = (G__18159_18487[(0)]);
var G__18163_18491 = (G__18159_18487[(1)]);
var G__18164_18492 = ((G__18168_18483)?(G__18160_18488[(0)]):(cljs.core.truth_(G__18170_18485)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__18165_18493 = ((G__18168_18483)?(G__18160_18488[(1)]):(cljs.core.truth_(G__18170_18485)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__18166_18494 = ((G__18169_18484)?(G__18161_18489[(0)]):(cljs.core.truth_(G__18171_18486)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__18167_18495 = ((G__18169_18484)?(G__18161_18489[(1)]):(cljs.core.truth_(G__18171_18486)?t:cljs.core.nth.call(null,t,(1),0.0)));
(b[(0)] = (((G__18164_18492 - G__18162_18490) * G__18166_18494) + G__18162_18490));

(b[(1)] = (((G__18165_18493 - G__18163_18491) * G__18167_18495) + G__18163_18491));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix$arity$6 = (function (_,b,c,d,u,v){
var self__ = this;
var ___$1 = this;
var b_SINGLEQUOTE_ = (new Float32Array((2)));
var dv_QMARK_ = (d instanceof thi.ng.geom.vector.Vec2);
var dn_QMARK_ = typeof d === 'number';
var dv = ((dv_QMARK_)?d.buf:null);
var dx = ((dv_QMARK_)?(dv[(0)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(0),0.0)));
var dy = ((dv_QMARK_)?(dv[(1)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(1),0.0)));
var G__18181_18496 = (b instanceof thi.ng.geom.vector.Vec2);
var G__18182_18497 = (c instanceof thi.ng.geom.vector.Vec2);
var G__18183_18498 = (((!(G__18181_18496)))?typeof b === 'number':null);
var G__18184_18499 = (((!(G__18182_18497)))?typeof c === 'number':null);
var G__18172_18500 = self__.buf;
var G__18173_18501 = ((G__18181_18496)?b.buf:null);
var G__18174_18502 = ((G__18182_18497)?c.buf:null);
var G__18175_18503 = (G__18172_18500[(0)]);
var G__18176_18504 = (G__18172_18500[(1)]);
var G__18177_18505 = ((G__18181_18496)?(G__18173_18501[(0)]):(cljs.core.truth_(G__18183_18498)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18178_18506 = ((G__18181_18496)?(G__18173_18501[(1)]):(cljs.core.truth_(G__18183_18498)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__18179_18507 = ((G__18182_18497)?(G__18174_18502[(0)]):(cljs.core.truth_(G__18184_18499)?c:cljs.core.nth.call(null,c,(0),0.0)));
var G__18180_18508 = ((G__18182_18497)?(G__18174_18502[(1)]):(cljs.core.truth_(G__18184_18499)?c:cljs.core.nth.call(null,c,(1),0.0)));
var x1_18509 = (((G__18177_18505 - G__18175_18503) * u) + G__18175_18503);
var y1_18510 = (((G__18178_18506 - G__18176_18504) * u) + G__18176_18504);
(b_SINGLEQUOTE_[(0)] = ((((((dx - G__18179_18507) * u) + G__18179_18507) - x1_18509) * v) + x1_18509));

(b_SINGLEQUOTE_[(1)] = ((((((dy - G__18180_18508) * u) + G__18180_18508) - y1_18510) * v) + y1_18510));

return (new thi.ng.geom.vector.Vec2(b_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix_with$arity$4 = (function (_,v,t,f){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__18194_18511 = (v instanceof thi.ng.geom.vector.Vec2);
var G__18195_18512 = (t instanceof thi.ng.geom.vector.Vec2);
var G__18196_18513 = (((!(G__18194_18511)))?typeof v === 'number':null);
var G__18197_18514 = (((!(G__18195_18512)))?typeof t === 'number':null);
var G__18185_18515 = self__.buf;
var G__18186_18516 = ((G__18194_18511)?v.buf:null);
var G__18187_18517 = ((G__18195_18512)?t.buf:null);
var G__18188_18518 = (G__18185_18515[(0)]);
var G__18189_18519 = (G__18185_18515[(1)]);
var G__18190_18520 = ((G__18194_18511)?(G__18186_18516[(0)]):(cljs.core.truth_(G__18196_18513)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__18191_18521 = ((G__18194_18511)?(G__18186_18516[(1)]):(cljs.core.truth_(G__18196_18513)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__18192_18522 = ((G__18195_18512)?(G__18187_18517[(0)]):(cljs.core.truth_(G__18197_18514)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__18193_18523 = ((G__18195_18512)?(G__18187_18517[(1)]):(cljs.core.truth_(G__18197_18514)?t:cljs.core.nth.call(null,t,(1),0.0)));
(b[(0)] = f.call(null,G__18188_18518,G__18190_18520,G__18192_18522));

(b[(1)] = f.call(null,G__18189_18519,G__18191_18521,G__18193_18523));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$step$arity$2 = (function (_,e){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__18198_18524 = self__.buf;
if((e instanceof thi.ng.geom.vector.Vec2)){
var G__18199_18525 = e.buf;
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,(G__18199_18525[(0)]),(G__18198_18524[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,(G__18199_18525[(1)]),(G__18198_18524[(1)])));
} else {
if(typeof e === 'number'){
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,e,(G__18198_18524[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,e,(G__18198_18524[(1)])));
} else {
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(0),0.0),(G__18198_18524[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(1),0.0),(G__18198_18524[(1)])));
}
}

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$smoothstep$arity$3 = (function (_,e1,e2){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__18209_18526 = (e1 instanceof thi.ng.geom.vector.Vec2);
var G__18210_18527 = (e2 instanceof thi.ng.geom.vector.Vec2);
var G__18211_18528 = (((!(G__18209_18526)))?typeof e1 === 'number':null);
var G__18212_18529 = (((!(G__18210_18527)))?typeof e2 === 'number':null);
var G__18200_18530 = self__.buf;
var G__18201_18531 = ((G__18209_18526)?e1.buf:null);
var G__18202_18532 = ((G__18210_18527)?e2.buf:null);
var G__18203_18533 = (G__18200_18530[(0)]);
var G__18204_18534 = (G__18200_18530[(1)]);
var G__18205_18535 = ((G__18209_18526)?(G__18201_18531[(0)]):(cljs.core.truth_(G__18211_18528)?e1:cljs.core.nth.call(null,e1,(0),0.0)));
var G__18206_18536 = ((G__18209_18526)?(G__18201_18531[(1)]):(cljs.core.truth_(G__18211_18528)?e1:cljs.core.nth.call(null,e1,(1),0.0)));
var G__18207_18537 = ((G__18210_18527)?(G__18202_18532[(0)]):(cljs.core.truth_(G__18212_18529)?e2:cljs.core.nth.call(null,e2,(0),0.0)));
var G__18208_18538 = ((G__18210_18527)?(G__18202_18532[(1)]):(cljs.core.truth_(G__18212_18529)?e2:cljs.core.nth.call(null,e2,(1),0.0)));
(b[(0)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__18205_18535,G__18207_18537,G__18203_18533));

(b[(1)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__18205_18535,G__18208_18538,G__18204_18534));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
return (((k >= (0))) && ((k < (2))));
} else {
if(cljs.core.truth_(thi.ng.geom.vector.swizzle2_fns.call(null,k))){
return true;
} else {
return false;
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (_,k,v){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
if((((k === (0))) || ((k === (1))))){
var b = (new Float32Array(self__.buf));
(b[k] = v);

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
if((k === (2))){
return cljs.core.conj.call(null,___$1,v);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
} else {
if((k instanceof cljs.core.Keyword)){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"z","z",-789527183),k)){
return cljs.core.conj.call(null,___$1,v);
} else {
return (new thi.ng.geom.vector.Vec2(thi.ng.geom.vector.swizzle_assoc_STAR_.call(null,self__.buf,(new Float32Array(self__.buf)),new cljs.core.PersistentArrayMap(null, 2, ["x",(0),"y",(1)], null),k,v),null,self__._meta));
}
} else {
return null;
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$min$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13252__auto__ = (new Float32Array((2)));
var G__18213_18539 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18214_18540 = v.buf;
(dest__13252__auto__[(0)] = (function (){var a__11171__auto__ = (G__18213_18539[(0)]);
var b__11172__auto__ = (G__18214_18540[(0)]);
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13252__auto__[(1)] = (function (){var a__11171__auto__ = (G__18213_18539[(1)]);
var b__11172__auto__ = (G__18214_18540[(1)]);
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__13252__auto__[(0)] = (function (){var a__11171__auto__ = (G__18213_18539[(0)]);
var b__11172__auto__ = v;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13252__auto__[(1)] = (function (){var a__11171__auto__ = (G__18213_18539[(1)]);
var b__11172__auto__ = v;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());
} else {
(dest__13252__auto__[(0)] = (function (){var a__11171__auto__ = (G__18213_18539[(0)]);
var b__11172__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13252__auto__[(1)] = (function (){var a__11171__auto__ = (G__18213_18539[(1)]);
var b__11172__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec2(dest__13252__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$min$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__13263__auto__ = (new Float32Array((2)));
var G__18224_18541 = (v instanceof thi.ng.geom.vector.Vec2);
var G__18225_18542 = (v2 instanceof thi.ng.geom.vector.Vec2);
var G__18226_18543 = (((!(G__18224_18541)))?typeof v === 'number':null);
var G__18227_18544 = (((!(G__18225_18542)))?typeof v2 === 'number':null);
var G__18215_18545 = self__.buf;
var G__18216_18546 = ((G__18224_18541)?v.buf:null);
var G__18217_18547 = ((G__18225_18542)?v2.buf:null);
var G__18218_18548 = (G__18215_18545[(0)]);
var G__18219_18549 = (G__18215_18545[(1)]);
var G__18220_18550 = ((G__18224_18541)?(G__18216_18546[(0)]):(cljs.core.truth_(G__18226_18543)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__18221_18551 = ((G__18224_18541)?(G__18216_18546[(1)]):(cljs.core.truth_(G__18226_18543)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__18222_18552 = ((G__18225_18542)?(G__18217_18547[(0)]):(cljs.core.truth_(G__18227_18544)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18223_18553 = ((G__18225_18542)?(G__18217_18547[(1)]):(cljs.core.truth_(G__18227_18544)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(dest__13263__auto__[(0)] = (function (){var a__11171__auto__ = (function (){var a__11171__auto__ = G__18218_18548;
var b__11172__auto__ = G__18220_18550;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})();
var b__11172__auto__ = G__18222_18552;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13263__auto__[(1)] = (function (){var a__11171__auto__ = (function (){var a__11171__auto__ = G__18219_18549;
var b__11172__auto__ = G__18221_18551;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})();
var b__11172__auto__ = G__18223_18553;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

return (new thi.ng.geom.vector.Vec2(dest__13263__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$max$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13252__auto__ = (new Float32Array((2)));
var G__18228_18554 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18229_18555 = v.buf;
(dest__13252__auto__[(0)] = (function (){var a__11178__auto__ = (G__18228_18554[(0)]);
var b__11179__auto__ = (G__18229_18555[(0)]);
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13252__auto__[(1)] = (function (){var a__11178__auto__ = (G__18228_18554[(1)]);
var b__11179__auto__ = (G__18229_18555[(1)]);
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__13252__auto__[(0)] = (function (){var a__11178__auto__ = (G__18228_18554[(0)]);
var b__11179__auto__ = v;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13252__auto__[(1)] = (function (){var a__11178__auto__ = (G__18228_18554[(1)]);
var b__11179__auto__ = v;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());
} else {
(dest__13252__auto__[(0)] = (function (){var a__11178__auto__ = (G__18228_18554[(0)]);
var b__11179__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13252__auto__[(1)] = (function (){var a__11178__auto__ = (G__18228_18554[(1)]);
var b__11179__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec2(dest__13252__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$max$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__13263__auto__ = (new Float32Array((2)));
var G__18239_18556 = (v instanceof thi.ng.geom.vector.Vec2);
var G__18240_18557 = (v2 instanceof thi.ng.geom.vector.Vec2);
var G__18241_18558 = (((!(G__18239_18556)))?typeof v === 'number':null);
var G__18242_18559 = (((!(G__18240_18557)))?typeof v2 === 'number':null);
var G__18230_18560 = self__.buf;
var G__18231_18561 = ((G__18239_18556)?v.buf:null);
var G__18232_18562 = ((G__18240_18557)?v2.buf:null);
var G__18233_18563 = (G__18230_18560[(0)]);
var G__18234_18564 = (G__18230_18560[(1)]);
var G__18235_18565 = ((G__18239_18556)?(G__18231_18561[(0)]):(cljs.core.truth_(G__18241_18558)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__18236_18566 = ((G__18239_18556)?(G__18231_18561[(1)]):(cljs.core.truth_(G__18241_18558)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__18237_18567 = ((G__18240_18557)?(G__18232_18562[(0)]):(cljs.core.truth_(G__18242_18559)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18238_18568 = ((G__18240_18557)?(G__18232_18562[(1)]):(cljs.core.truth_(G__18242_18559)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(dest__13263__auto__[(0)] = (function (){var a__11178__auto__ = (function (){var a__11178__auto__ = G__18233_18563;
var b__11179__auto__ = G__18235_18565;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})();
var b__11179__auto__ = G__18237_18567;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13263__auto__[(1)] = (function (){var a__11178__auto__ = (function (){var a__11178__auto__ = G__18234_18564;
var b__11179__auto__ = G__18236_18566;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})();
var b__11179__auto__ = G__18238_18568;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

return (new thi.ng.geom.vector.Vec2(dest__13263__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec2((new Float32Array(self__.buf)),self__._hash,m));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IClear$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IClear$clear_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec2((new Float32Array((2))),null,null));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IClear$clear_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = 0.0);

(self__.buf[(1)] = 0.0);

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ICollection$_conj$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
return cljs.core.with_meta.call(null,thi.ng.geom.vector.vec3.call(null,(self__.buf[(0)]),(self__.buf[(1)]),x),self__._meta);
});

thi.ng.geom.vector.Vec2.prototype.call = (function() {
var G__18569 = null;
var G__18569__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});
var G__18569__3 = (function (self__,k,nf){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});
G__18569 = function(self__,k,nf){
switch(arguments.length){
case 2:
return G__18569__2.call(this,self__,k);
case 3:
return G__18569__3.call(this,self__,k,nf);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__18569.cljs$core$IFn$_invoke$arity$2 = G__18569__2;
G__18569.cljs$core$IFn$_invoke$arity$3 = G__18569__3;
return G__18569;
})()
;

thi.ng.geom.vector.Vec2.prototype.apply = (function (self__,args18027){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args18027)));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,nf){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IPolar$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IPolar$as_polar$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
(b[(0)] = thi.ng.math.core.mag.call(null,___$1));

(b[(1)] = thi.ng.geom.core.heading.call(null,___$1));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IPolar$as_cartesian$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__18243 = self__.buf;
var G__18244 = (G__18243[(0)]);
var G__18245 = (G__18243[(1)]);
var b = (new Float32Array((2)));
(b[(0)] = (G__18244 * Math.cos(G__18245)));

(b[(1)] = (G__18244 * Math.sin(G__18245)));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IComparable$_compare$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec2)){
var b_SINGLEQUOTE_ = o.buf;
var c = cljs.core.compare.call(null,(self__.buf[(0)]),(b_SINGLEQUOTE_[(0)]));
if(((0) === c)){
return cljs.core.compare.call(null,(self__.buf[(1)]),(b_SINGLEQUOTE_[(1)]));
} else {
return c;
}
} else {
var c = cljs.core.count.call(null,o);
if(((2) === c)){
return (- cljs.core.compare.call(null,o,___$1));
} else {
return ((2) - c);
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$normalize$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__18246 = self__.buf;
var G__18247 = (G__18246[(0)]);
var G__18248 = (G__18246[(1)]);
var l = Math.sqrt(((G__18247 * G__18247) + (G__18248 * G__18248)));
if((l > (0))){
var b = (new Float32Array((2)));
(b[(0)] = (G__18247 / l));

(b[(1)] = (G__18248 / l));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$normalize$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
var G__18249 = self__.buf;
var G__18250 = (G__18249[(0)]);
var G__18251 = (G__18249[(1)]);
var l = Math.sqrt(((G__18250 * G__18250) + (G__18251 * G__18251)));
if((l > (0))){
var l__$1 = (len / l);
var b = (new Float32Array((2)));
(b[(0)] = (G__18250 * l__$1));

(b[(1)] = (G__18251 * l__$1));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$normalized_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,1.0,thi.ng.math.core.mag_squared.call(null,___$1));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMagnitude$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMagnitude$mag$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__18252 = self__.buf;
var G__18253 = (G__18252[(0)]);
var G__18254 = (G__18252[(1)]);
return Math.sqrt(((G__18253 * G__18253) + (G__18254 * G__18254)));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMagnitude$mag_squared$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__18255 = self__.buf;
var G__18256 = (G__18255[(0)]);
var G__18257 = (G__18255[(1)]);
return ((G__18256 * G__18256) + (G__18257 * G__18257));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$msub$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__13263__auto__ = (new Float32Array((2)));
var G__18267_18570 = (a instanceof thi.ng.geom.vector.Vec2);
var G__18268_18571 = (b instanceof thi.ng.geom.vector.Vec2);
var G__18269_18572 = (((!(G__18267_18570)))?typeof a === 'number':null);
var G__18270_18573 = (((!(G__18268_18571)))?typeof b === 'number':null);
var G__18258_18574 = self__.buf;
var G__18259_18575 = ((G__18267_18570)?a.buf:null);
var G__18260_18576 = ((G__18268_18571)?b.buf:null);
var G__18261_18577 = (G__18258_18574[(0)]);
var G__18262_18578 = (G__18258_18574[(1)]);
var G__18263_18579 = ((G__18267_18570)?(G__18259_18575[(0)]):(cljs.core.truth_(G__18269_18572)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__18264_18580 = ((G__18267_18570)?(G__18259_18575[(1)]):(cljs.core.truth_(G__18269_18572)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__18265_18581 = ((G__18268_18571)?(G__18260_18576[(0)]):(cljs.core.truth_(G__18270_18573)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18266_18582 = ((G__18268_18571)?(G__18260_18576[(1)]):(cljs.core.truth_(G__18270_18573)?b:cljs.core.nth.call(null,b,(1),0.0)));
(dest__13263__auto__[(0)] = ((G__18261_18577 * G__18263_18579) - G__18265_18581));

(dest__13263__auto__[(1)] = ((G__18262_18578 * G__18264_18580) - G__18266_18582));

return (new thi.ng.geom.vector.Vec2(dest__13263__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13252__auto__ = (new Float32Array((2)));
var G__18271_18583 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18272_18584 = v.buf;
(dest__13252__auto__[(0)] = ((G__18271_18583[(0)]) * (G__18272_18584[(0)])));

(dest__13252__auto__[(1)] = ((G__18271_18583[(1)]) * (G__18272_18584[(1)])));
} else {
if(typeof v === 'number'){
(dest__13252__auto__[(0)] = ((G__18271_18583[(0)]) * v));

(dest__13252__auto__[(1)] = ((G__18271_18583[(1)]) * v));
} else {
(dest__13252__auto__[(0)] = ((G__18271_18583[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__13252__auto__[(1)] = ((G__18271_18583[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__13252__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18273 = self__.buf;
var G__18276 = (new Float32Array((2)));
var G__18277 = (G__18273[(0)]);
var G__18278 = (G__18273[(1)]);
var G__18283 = typeof v1 === 'number';
var G__18284 = typeof v2 === 'number';
if(((G__18283)?G__18284:false)){
(G__18276[(0)] = (G__18277 * v1));

(G__18276[(1)] = (G__18278 * v2));
} else {
var G__18285_18585 = (((!(G__18283)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__18286_18586 = (((!(G__18284)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__18274_18587 = (cljs.core.truth_(G__18285_18585)?v1.buf:null);
var G__18275_18588 = (cljs.core.truth_(G__18286_18586)?v2.buf:null);
var G__18279_18589 = (cljs.core.truth_(G__18285_18585)?(G__18274_18587[(0)]):((G__18283)?v1:cljs.core.nth.call(null,v1,(0),1.0)));
var G__18280_18590 = (cljs.core.truth_(G__18285_18585)?(G__18274_18587[(1)]):((G__18283)?v1:cljs.core.nth.call(null,v1,(1),1.0)));
var G__18281_18591 = (cljs.core.truth_(G__18286_18586)?(G__18275_18588[(0)]):((G__18284)?v2:cljs.core.nth.call(null,v2,(0),1.0)));
var G__18282_18592 = (cljs.core.truth_(G__18286_18586)?(G__18275_18588[(1)]):((G__18284)?v2:cljs.core.nth.call(null,v2,(1),1.0)));
(G__18276[(0)] = ((G__18277 * G__18279_18589) * G__18281_18591));

(G__18276[(1)] = ((G__18278 * G__18280_18590) * G__18282_18592));
}

return (new thi.ng.geom.vector.Vec2(G__18276,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__13222__auto__ = (new Float32Array((2)));
var G__18287_18593 = self__.buf;
(dest__13222__auto__[(0)] = (- (G__18287_18593[(0)])));

(dest__13222__auto__[(1)] = (- (G__18287_18593[(1)])));

return (new thi.ng.geom.vector.Vec2(dest__13222__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13252__auto__ = (new Float32Array((2)));
var G__18288_18594 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18289_18595 = v.buf;
(dest__13252__auto__[(0)] = ((G__18288_18594[(0)]) - (G__18289_18595[(0)])));

(dest__13252__auto__[(1)] = ((G__18288_18594[(1)]) - (G__18289_18595[(1)])));
} else {
if(typeof v === 'number'){
(dest__13252__auto__[(0)] = ((G__18288_18594[(0)]) - v));

(dest__13252__auto__[(1)] = ((G__18288_18594[(1)]) - v));
} else {
(dest__13252__auto__[(0)] = ((G__18288_18594[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(dest__13252__auto__[(1)] = ((G__18288_18594[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__13252__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18290 = self__.buf;
var G__18293 = (new Float32Array((2)));
var G__18294 = (G__18290[(0)]);
var G__18295 = (G__18290[(1)]);
var G__18300 = typeof v1 === 'number';
var G__18301 = typeof v2 === 'number';
if(((G__18300)?G__18301:false)){
(G__18293[(0)] = (G__18294 - v1));

(G__18293[(1)] = (G__18295 - v2));
} else {
var G__18302_18596 = (((!(G__18300)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__18303_18597 = (((!(G__18301)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__18291_18598 = (cljs.core.truth_(G__18302_18596)?v1.buf:null);
var G__18292_18599 = (cljs.core.truth_(G__18303_18597)?v2.buf:null);
var G__18296_18600 = (cljs.core.truth_(G__18302_18596)?(G__18291_18598[(0)]):((G__18300)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18297_18601 = (cljs.core.truth_(G__18302_18596)?(G__18291_18598[(1)]):((G__18300)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18298_18602 = (cljs.core.truth_(G__18303_18597)?(G__18292_18599[(0)]):((G__18301)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18299_18603 = (cljs.core.truth_(G__18303_18597)?(G__18292_18599[(1)]):((G__18301)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(G__18293[(0)] = ((G__18294 - G__18296_18600) - G__18298_18602));

(G__18293[(1)] = ((G__18295 - G__18297_18601) - G__18299_18603));
}

return (new thi.ng.geom.vector.Vec2(G__18293,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$madd$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__13263__auto__ = (new Float32Array((2)));
var G__18313_18604 = (a instanceof thi.ng.geom.vector.Vec2);
var G__18314_18605 = (b instanceof thi.ng.geom.vector.Vec2);
var G__18315_18606 = (((!(G__18313_18604)))?typeof a === 'number':null);
var G__18316_18607 = (((!(G__18314_18605)))?typeof b === 'number':null);
var G__18304_18608 = self__.buf;
var G__18305_18609 = ((G__18313_18604)?a.buf:null);
var G__18306_18610 = ((G__18314_18605)?b.buf:null);
var G__18307_18611 = (G__18304_18608[(0)]);
var G__18308_18612 = (G__18304_18608[(1)]);
var G__18309_18613 = ((G__18313_18604)?(G__18305_18609[(0)]):(cljs.core.truth_(G__18315_18606)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__18310_18614 = ((G__18313_18604)?(G__18305_18609[(1)]):(cljs.core.truth_(G__18315_18606)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__18311_18615 = ((G__18314_18605)?(G__18306_18610[(0)]):(cljs.core.truth_(G__18316_18607)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18312_18616 = ((G__18314_18605)?(G__18306_18610[(1)]):(cljs.core.truth_(G__18316_18607)?b:cljs.core.nth.call(null,b,(1),0.0)));
(dest__13263__auto__[(0)] = ((G__18307_18611 * G__18309_18613) + G__18311_18615));

(dest__13263__auto__[(1)] = ((G__18308_18612 * G__18310_18614) + G__18312_18616));

return (new thi.ng.geom.vector.Vec2(dest__13263__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$addm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__13263__auto__ = (new Float32Array((2)));
var G__18326_18617 = (a instanceof thi.ng.geom.vector.Vec2);
var G__18327_18618 = (b instanceof thi.ng.geom.vector.Vec2);
var G__18328_18619 = (((!(G__18326_18617)))?typeof a === 'number':null);
var G__18329_18620 = (((!(G__18327_18618)))?typeof b === 'number':null);
var G__18317_18621 = self__.buf;
var G__18318_18622 = ((G__18326_18617)?a.buf:null);
var G__18319_18623 = ((G__18327_18618)?b.buf:null);
var G__18320_18624 = (G__18317_18621[(0)]);
var G__18321_18625 = (G__18317_18621[(1)]);
var G__18322_18626 = ((G__18326_18617)?(G__18318_18622[(0)]):(cljs.core.truth_(G__18328_18619)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__18323_18627 = ((G__18326_18617)?(G__18318_18622[(1)]):(cljs.core.truth_(G__18328_18619)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__18324_18628 = ((G__18327_18618)?(G__18319_18623[(0)]):(cljs.core.truth_(G__18329_18620)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__18325_18629 = ((G__18327_18618)?(G__18319_18623[(1)]):(cljs.core.truth_(G__18329_18620)?b:cljs.core.nth.call(null,b,(1),1.0)));
(dest__13263__auto__[(0)] = ((G__18320_18624 + G__18322_18626) * G__18324_18628));

(dest__13263__auto__[(1)] = ((G__18321_18625 + G__18323_18627) * G__18325_18629));

return (new thi.ng.geom.vector.Vec2(dest__13263__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$div$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__13222__auto__ = (new Float32Array((2)));
var G__18330_18630 = self__.buf;
(dest__13222__auto__[(0)] = ((1) / (G__18330_18630[(0)])));

(dest__13222__auto__[(1)] = ((1) / (G__18330_18630[(1)])));

return (new thi.ng.geom.vector.Vec2(dest__13222__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$div$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13252__auto__ = (new Float32Array((2)));
var G__18331_18631 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18332_18632 = v.buf;
(dest__13252__auto__[(0)] = ((G__18331_18631[(0)]) / (G__18332_18632[(0)])));

(dest__13252__auto__[(1)] = ((G__18331_18631[(1)]) / (G__18332_18632[(1)])));
} else {
if(typeof v === 'number'){
(dest__13252__auto__[(0)] = ((G__18331_18631[(0)]) / v));

(dest__13252__auto__[(1)] = ((G__18331_18631[(1)]) / v));
} else {
(dest__13252__auto__[(0)] = ((G__18331_18631[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(dest__13252__auto__[(1)] = ((G__18331_18631[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__13252__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$div$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18333 = self__.buf;
var G__18336 = (new Float32Array((2)));
var G__18337 = (G__18333[(0)]);
var G__18338 = (G__18333[(1)]);
var G__18343 = typeof v1 === 'number';
var G__18344 = typeof v2 === 'number';
if(((G__18343)?G__18344:false)){
(G__18336[(0)] = (G__18337 / v1));

(G__18336[(1)] = (G__18338 / v2));
} else {
var G__18345_18633 = (((!(G__18343)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__18346_18634 = (((!(G__18344)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__18334_18635 = (cljs.core.truth_(G__18345_18633)?v1.buf:null);
var G__18335_18636 = (cljs.core.truth_(G__18346_18634)?v2.buf:null);
var G__18339_18637 = (cljs.core.truth_(G__18345_18633)?(G__18334_18635[(0)]):((G__18343)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18340_18638 = (cljs.core.truth_(G__18345_18633)?(G__18334_18635[(1)]):((G__18343)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18341_18639 = (cljs.core.truth_(G__18346_18634)?(G__18335_18636[(0)]):((G__18344)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18342_18640 = (cljs.core.truth_(G__18346_18634)?(G__18335_18636[(1)]):((G__18344)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(G__18336[(0)] = ((G__18337 / G__18339_18637) / G__18341_18639));

(G__18336[(1)] = ((G__18338 / G__18340_18638) / G__18342_18640));
}

return (new thi.ng.geom.vector.Vec2(G__18336,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13252__auto__ = (new Float32Array((2)));
var G__18347_18641 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__18348_18642 = v.buf;
(dest__13252__auto__[(0)] = ((G__18347_18641[(0)]) + (G__18348_18642[(0)])));

(dest__13252__auto__[(1)] = ((G__18347_18641[(1)]) + (G__18348_18642[(1)])));
} else {
if(typeof v === 'number'){
(dest__13252__auto__[(0)] = ((G__18347_18641[(0)]) + v));

(dest__13252__auto__[(1)] = ((G__18347_18641[(1)]) + v));
} else {
(dest__13252__auto__[(0)] = ((G__18347_18641[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__13252__auto__[(1)] = ((G__18347_18641[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__13252__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18349 = self__.buf;
var G__18352 = (new Float32Array((2)));
var G__18353 = (G__18349[(0)]);
var G__18354 = (G__18349[(1)]);
var G__18359 = typeof v1 === 'number';
var G__18360 = typeof v2 === 'number';
if(((G__18359)?G__18360:false)){
(G__18352[(0)] = (G__18353 + v1));

(G__18352[(1)] = (G__18354 + v2));
} else {
var G__18361_18643 = (((!(G__18359)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__18362_18644 = (((!(G__18360)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__18350_18645 = (cljs.core.truth_(G__18361_18643)?v1.buf:null);
var G__18351_18646 = (cljs.core.truth_(G__18362_18644)?v2.buf:null);
var G__18355_18647 = (cljs.core.truth_(G__18361_18643)?(G__18350_18645[(0)]):((G__18359)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18356_18648 = (cljs.core.truth_(G__18361_18643)?(G__18350_18645[(1)]):((G__18359)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18357_18649 = (cljs.core.truth_(G__18362_18644)?(G__18351_18646[(0)]):((G__18360)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18358_18650 = (cljs.core.truth_(G__18362_18644)?(G__18351_18646[(1)]):((G__18360)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(G__18352[(0)] = ((G__18353 + G__18355_18647) + G__18357_18649));

(G__18352[(1)] = ((G__18354 + G__18356_18648) + G__18358_18650));
}

return (new thi.ng.geom.vector.Vec2(G__18352,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$abs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__13222__auto__ = (new Float32Array((2)));
var G__18363_18651 = self__.buf;
(dest__13222__auto__[(0)] = thi.ng.math.core.abs_STAR_.call(null,(G__18363_18651[(0)])));

(dest__13222__auto__[(1)] = thi.ng.math.core.abs_STAR_.call(null,(G__18363_18651[(1)])));

return (new thi.ng.geom.vector.Vec2(dest__13222__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$subm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__13263__auto__ = (new Float32Array((2)));
var G__18373_18652 = (a instanceof thi.ng.geom.vector.Vec2);
var G__18374_18653 = (b instanceof thi.ng.geom.vector.Vec2);
var G__18375_18654 = (((!(G__18373_18652)))?typeof a === 'number':null);
var G__18376_18655 = (((!(G__18374_18653)))?typeof b === 'number':null);
var G__18364_18656 = self__.buf;
var G__18365_18657 = ((G__18373_18652)?a.buf:null);
var G__18366_18658 = ((G__18374_18653)?b.buf:null);
var G__18367_18659 = (G__18364_18656[(0)]);
var G__18368_18660 = (G__18364_18656[(1)]);
var G__18369_18661 = ((G__18373_18652)?(G__18365_18657[(0)]):(cljs.core.truth_(G__18375_18654)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__18370_18662 = ((G__18373_18652)?(G__18365_18657[(1)]):(cljs.core.truth_(G__18375_18654)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__18371_18663 = ((G__18374_18653)?(G__18366_18658[(0)]):(cljs.core.truth_(G__18376_18655)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__18372_18664 = ((G__18374_18653)?(G__18366_18658[(1)]):(cljs.core.truth_(G__18376_18655)?b:cljs.core.nth.call(null,b,(1),1.0)));
(dest__13263__auto__[(0)] = ((G__18367_18659 - G__18369_18661) * G__18371_18663));

(dest__13263__auto__[(1)] = ((G__18368_18660 - G__18370_18662) * G__18372_18664));

return (new thi.ng.geom.vector.Vec2(dest__13263__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"buf","buf",1426618187,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

thi.ng.geom.vector.Vec2.cljs$lang$type = true;

thi.ng.geom.vector.Vec2.cljs$lang$ctorStr = "thi.ng.geom.vector/Vec2";

thi.ng.geom.vector.Vec2.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"thi.ng.geom.vector/Vec2");
});

/**
 * Positional factory function for thi.ng.geom.vector/Vec2.
 */
thi.ng.geom.vector.__GT_Vec2 = (function thi$ng$geom$vector$__GT_Vec2(buf,_hash,_meta){
return (new thi.ng.geom.vector.Vec2(buf,_hash,_meta));
});


/**
* @constructor
 * @implements {thi.ng.geom.core.ITranslate}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {thi.ng.math.core.IDotProduct}
 * @implements {cljs.core.IReversible}
 * @implements {thi.ng.math.core.IMutableMathOps}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {thi.ng.math.core.ICrossProduct}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {thi.ng.math.core.IDeltaEquals}
 * @implements {thi.ng.geom.core.IPolar}
 * @implements {thi.ng.geom.core.IRotate3D}
 * @implements {thi.ng.geom.vector.Object}
 * @implements {thi.ng.geom.core.IClear}
 * @implements {thi.ng.math.core.IInvert}
 * @implements {cljs.core.ICounted}
 * @implements {thi.ng.math.core.ILimit}
 * @implements {thi.ng.dstruct.streams.IBuffer}
 * @implements {cljs.core.ISeq}
 * @implements {thi.ng.math.core.IInterpolate}
 * @implements {cljs.core.INext}
 * @implements {thi.ng.math.core.IMathOps}
 * @implements {thi.ng.geom.core.ITransform}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {thi.ng.math.core.IMinMax}
 * @implements {thi.ng.geom.core.IRotate}
 * @implements {thi.ng.math.core.INormalize}
 * @implements {thi.ng.math.core.IMagnitude}
 * @implements {thi.ng.geom.core.IScale}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {thi.ng.geom.core.IReflect}
 * @implements {thi.ng.geom.core.IHeading}
 * @implements {thi.ng.geom.core.IDistance}
 * @implements {cljs.core.IComparable}
 * @implements {thi.ng.dstruct.streams.IIntoBuffer}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {thi.ng.geom.core.IVectorReduce}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
thi.ng.geom.vector.Vec3 = (function (buf,_hash,_meta){
this.buf = buf;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2314101723;
this.cljs$lang$protocol_mask$partition1$ = 10240;
});
thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITransform$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITransform$transform$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.transform_vector.call(null,m,___$1);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = (- (self__.buf[(0)])));

(self__.buf[(1)] = (- (self__.buf[(1)])));

(self__.buf[(2)] = (- (self__.buf[(2)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18666_19117 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18667_19118 = v.buf;
(self__.buf[(0)] = ((G__18666_19117[(0)]) - (G__18667_19118[(0)])));

(self__.buf[(1)] = ((G__18666_19117[(1)]) - (G__18667_19118[(1)])));

(self__.buf[(2)] = ((G__18666_19117[(2)]) - (G__18667_19118[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__18666_19117[(0)]) - v));

(self__.buf[(1)] = ((G__18666_19117[(1)]) - v));

(self__.buf[(2)] = ((G__18666_19117[(2)]) - v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__18666_19117[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__18666_19117[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__18666_19117[(2)]) - cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18680_19119 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__18681_19120 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__18682_19121 = (((!(G__18680_19119)))?typeof v1 === 'number':null);
var G__18683_19122 = (((!(G__18681_19120)))?typeof v2 === 'number':null);
var G__18668_19123 = self__.buf;
var G__18669_19124 = ((G__18680_19119)?v1.buf:null);
var G__18670_19125 = ((G__18681_19120)?v2.buf:null);
var G__18671_19126 = (G__18668_19123[(0)]);
var G__18672_19127 = (G__18668_19123[(1)]);
var G__18673_19128 = (G__18668_19123[(2)]);
var G__18674_19129 = ((G__18680_19119)?(G__18669_19124[(0)]):(cljs.core.truth_(G__18682_19121)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18675_19130 = ((G__18680_19119)?(G__18669_19124[(1)]):(cljs.core.truth_(G__18682_19121)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18676_19131 = ((G__18680_19119)?(G__18669_19124[(2)]):(cljs.core.truth_(G__18682_19121)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__18677_19132 = ((G__18681_19120)?(G__18670_19125[(0)]):(cljs.core.truth_(G__18683_19122)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18678_19133 = ((G__18681_19120)?(G__18670_19125[(1)]):(cljs.core.truth_(G__18683_19122)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__18679_19134 = ((G__18681_19120)?(G__18670_19125[(2)]):(cljs.core.truth_(G__18683_19122)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__18671_19126 - G__18674_19129) - G__18677_19132));

(self__.buf[(1)] = ((G__18672_19127 - G__18675_19130) - G__18678_19133));

(self__.buf[(2)] = ((G__18673_19128 - G__18676_19131) - G__18679_19134));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) - x));

(self__.buf[(1)] = ((self__.buf[(1)]) - y));

(self__.buf[(2)] = ((self__.buf[(2)]) - z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18684_19135 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18685_19136 = v.buf;
(self__.buf[(0)] = ((G__18684_19135[(0)]) * (G__18685_19136[(0)])));

(self__.buf[(1)] = ((G__18684_19135[(1)]) * (G__18685_19136[(1)])));

(self__.buf[(2)] = ((G__18684_19135[(2)]) * (G__18685_19136[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__18684_19135[(0)]) * v));

(self__.buf[(1)] = ((G__18684_19135[(1)]) * v));

(self__.buf[(2)] = ((G__18684_19135[(2)]) * v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__18684_19135[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__18684_19135[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__18684_19135[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18698_19137 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__18699_19138 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__18700_19139 = (((!(G__18698_19137)))?typeof v1 === 'number':null);
var G__18701_19140 = (((!(G__18699_19138)))?typeof v2 === 'number':null);
var G__18686_19141 = self__.buf;
var G__18687_19142 = ((G__18698_19137)?v1.buf:null);
var G__18688_19143 = ((G__18699_19138)?v2.buf:null);
var G__18689_19144 = (G__18686_19141[(0)]);
var G__18690_19145 = (G__18686_19141[(1)]);
var G__18691_19146 = (G__18686_19141[(2)]);
var G__18692_19147 = ((G__18698_19137)?(G__18687_19142[(0)]):(cljs.core.truth_(G__18700_19139)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18693_19148 = ((G__18698_19137)?(G__18687_19142[(1)]):(cljs.core.truth_(G__18700_19139)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18694_19149 = ((G__18698_19137)?(G__18687_19142[(2)]):(cljs.core.truth_(G__18700_19139)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__18695_19150 = ((G__18699_19138)?(G__18688_19143[(0)]):(cljs.core.truth_(G__18701_19140)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18696_19151 = ((G__18699_19138)?(G__18688_19143[(1)]):(cljs.core.truth_(G__18701_19140)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__18697_19152 = ((G__18699_19138)?(G__18688_19143[(2)]):(cljs.core.truth_(G__18701_19140)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__18689_19144 * G__18692_19147) * G__18695_19150));

(self__.buf[(1)] = ((G__18690_19145 * G__18693_19148) * G__18696_19151));

(self__.buf[(2)] = ((G__18691_19146 * G__18694_19149) * G__18697_19152));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) * x));

(self__.buf[(1)] = ((self__.buf[(1)]) * y));

(self__.buf[(2)] = ((self__.buf[(2)]) * z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$subm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__18714_19153 = (a instanceof thi.ng.geom.vector.Vec3);
var G__18715_19154 = (b instanceof thi.ng.geom.vector.Vec3);
var G__18716_19155 = (((!(G__18714_19153)))?typeof a === 'number':null);
var G__18717_19156 = (((!(G__18715_19154)))?typeof b === 'number':null);
var G__18702_19157 = self__.buf;
var G__18703_19158 = ((G__18714_19153)?a.buf:null);
var G__18704_19159 = ((G__18715_19154)?b.buf:null);
var G__18705_19160 = (G__18702_19157[(0)]);
var G__18706_19161 = (G__18702_19157[(1)]);
var G__18707_19162 = (G__18702_19157[(2)]);
var G__18708_19163 = ((G__18714_19153)?(G__18703_19158[(0)]):(cljs.core.truth_(G__18716_19155)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__18709_19164 = ((G__18714_19153)?(G__18703_19158[(1)]):(cljs.core.truth_(G__18716_19155)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__18710_19165 = ((G__18714_19153)?(G__18703_19158[(2)]):(cljs.core.truth_(G__18716_19155)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__18711_19166 = ((G__18715_19154)?(G__18704_19159[(0)]):(cljs.core.truth_(G__18717_19156)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__18712_19167 = ((G__18715_19154)?(G__18704_19159[(1)]):(cljs.core.truth_(G__18717_19156)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__18713_19168 = ((G__18715_19154)?(G__18704_19159[(2)]):(cljs.core.truth_(G__18717_19156)?b:cljs.core.nth.call(null,b,(2),1.0)));
(self__.buf[(0)] = ((G__18705_19160 - G__18708_19163) * G__18711_19166));

(self__.buf[(1)] = ((G__18706_19161 - G__18709_19164) * G__18712_19167));

(self__.buf[(2)] = ((G__18707_19162 - G__18710_19165) * G__18713_19168));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$msub_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__18730_19169 = (a instanceof thi.ng.geom.vector.Vec3);
var G__18731_19170 = (b instanceof thi.ng.geom.vector.Vec3);
var G__18732_19171 = (((!(G__18730_19169)))?typeof a === 'number':null);
var G__18733_19172 = (((!(G__18731_19170)))?typeof b === 'number':null);
var G__18718_19173 = self__.buf;
var G__18719_19174 = ((G__18730_19169)?a.buf:null);
var G__18720_19175 = ((G__18731_19170)?b.buf:null);
var G__18721_19176 = (G__18718_19173[(0)]);
var G__18722_19177 = (G__18718_19173[(1)]);
var G__18723_19178 = (G__18718_19173[(2)]);
var G__18724_19179 = ((G__18730_19169)?(G__18719_19174[(0)]):(cljs.core.truth_(G__18732_19171)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__18725_19180 = ((G__18730_19169)?(G__18719_19174[(1)]):(cljs.core.truth_(G__18732_19171)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__18726_19181 = ((G__18730_19169)?(G__18719_19174[(2)]):(cljs.core.truth_(G__18732_19171)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__18727_19182 = ((G__18731_19170)?(G__18720_19175[(0)]):(cljs.core.truth_(G__18733_19172)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18728_19183 = ((G__18731_19170)?(G__18720_19175[(1)]):(cljs.core.truth_(G__18733_19172)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__18729_19184 = ((G__18731_19170)?(G__18720_19175[(2)]):(cljs.core.truth_(G__18733_19172)?b:cljs.core.nth.call(null,b,(2),0.0)));
(self__.buf[(0)] = ((G__18721_19176 * G__18724_19179) - G__18727_19182));

(self__.buf[(1)] = ((G__18722_19177 * G__18725_19180) - G__18728_19183));

(self__.buf[(2)] = ((G__18723_19178 * G__18726_19181) - G__18729_19184));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$abs_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(0)])));

(self__.buf[(1)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(1)])));

(self__.buf[(2)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(2)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$madd_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__18746_19185 = (a instanceof thi.ng.geom.vector.Vec3);
var G__18747_19186 = (b instanceof thi.ng.geom.vector.Vec3);
var G__18748_19187 = (((!(G__18746_19185)))?typeof a === 'number':null);
var G__18749_19188 = (((!(G__18747_19186)))?typeof b === 'number':null);
var G__18734_19189 = self__.buf;
var G__18735_19190 = ((G__18746_19185)?a.buf:null);
var G__18736_19191 = ((G__18747_19186)?b.buf:null);
var G__18737_19192 = (G__18734_19189[(0)]);
var G__18738_19193 = (G__18734_19189[(1)]);
var G__18739_19194 = (G__18734_19189[(2)]);
var G__18740_19195 = ((G__18746_19185)?(G__18735_19190[(0)]):(cljs.core.truth_(G__18748_19187)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__18741_19196 = ((G__18746_19185)?(G__18735_19190[(1)]):(cljs.core.truth_(G__18748_19187)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__18742_19197 = ((G__18746_19185)?(G__18735_19190[(2)]):(cljs.core.truth_(G__18748_19187)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__18743_19198 = ((G__18747_19186)?(G__18736_19191[(0)]):(cljs.core.truth_(G__18749_19188)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18744_19199 = ((G__18747_19186)?(G__18736_19191[(1)]):(cljs.core.truth_(G__18749_19188)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__18745_19200 = ((G__18747_19186)?(G__18736_19191[(2)]):(cljs.core.truth_(G__18749_19188)?b:cljs.core.nth.call(null,b,(2),0.0)));
(self__.buf[(0)] = ((G__18737_19192 * G__18740_19195) + G__18743_19198));

(self__.buf[(1)] = ((G__18738_19193 * G__18741_19196) + G__18744_19199));

(self__.buf[(2)] = ((G__18739_19194 * G__18742_19197) + G__18745_19200));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((1) / (self__.buf[(0)])));

(self__.buf[(1)] = ((1) / (self__.buf[(1)])));

(self__.buf[(2)] = ((1) / (self__.buf[(2)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18750_19201 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18751_19202 = v.buf;
(self__.buf[(0)] = ((G__18750_19201[(0)]) / (G__18751_19202[(0)])));

(self__.buf[(1)] = ((G__18750_19201[(1)]) / (G__18751_19202[(1)])));

(self__.buf[(2)] = ((G__18750_19201[(2)]) / (G__18751_19202[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__18750_19201[(0)]) / v));

(self__.buf[(1)] = ((G__18750_19201[(1)]) / v));

(self__.buf[(2)] = ((G__18750_19201[(2)]) / v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__18750_19201[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__18750_19201[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__18750_19201[(2)]) / cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18764_19203 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__18765_19204 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__18766_19205 = (((!(G__18764_19203)))?typeof v1 === 'number':null);
var G__18767_19206 = (((!(G__18765_19204)))?typeof v2 === 'number':null);
var G__18752_19207 = self__.buf;
var G__18753_19208 = ((G__18764_19203)?v1.buf:null);
var G__18754_19209 = ((G__18765_19204)?v2.buf:null);
var G__18755_19210 = (G__18752_19207[(0)]);
var G__18756_19211 = (G__18752_19207[(1)]);
var G__18757_19212 = (G__18752_19207[(2)]);
var G__18758_19213 = ((G__18764_19203)?(G__18753_19208[(0)]):(cljs.core.truth_(G__18766_19205)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18759_19214 = ((G__18764_19203)?(G__18753_19208[(1)]):(cljs.core.truth_(G__18766_19205)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18760_19215 = ((G__18764_19203)?(G__18753_19208[(2)]):(cljs.core.truth_(G__18766_19205)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__18761_19216 = ((G__18765_19204)?(G__18754_19209[(0)]):(cljs.core.truth_(G__18767_19206)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18762_19217 = ((G__18765_19204)?(G__18754_19209[(1)]):(cljs.core.truth_(G__18767_19206)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__18763_19218 = ((G__18765_19204)?(G__18754_19209[(2)]):(cljs.core.truth_(G__18767_19206)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__18755_19210 / G__18758_19213) / G__18761_19216));

(self__.buf[(1)] = ((G__18756_19211 / G__18759_19214) / G__18762_19217));

(self__.buf[(2)] = ((G__18757_19212 / G__18760_19215) / G__18763_19218));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) / x));

(self__.buf[(1)] = ((self__.buf[(1)]) / y));

(self__.buf[(2)] = ((self__.buf[(2)]) / z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18768_19219 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18769_19220 = v.buf;
(self__.buf[(0)] = ((G__18768_19219[(0)]) + (G__18769_19220[(0)])));

(self__.buf[(1)] = ((G__18768_19219[(1)]) + (G__18769_19220[(1)])));

(self__.buf[(2)] = ((G__18768_19219[(2)]) + (G__18769_19220[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__18768_19219[(0)]) + v));

(self__.buf[(1)] = ((G__18768_19219[(1)]) + v));

(self__.buf[(2)] = ((G__18768_19219[(2)]) + v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__18768_19219[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__18768_19219[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__18768_19219[(2)]) + cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__18782_19221 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__18783_19222 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__18784_19223 = (((!(G__18782_19221)))?typeof v1 === 'number':null);
var G__18785_19224 = (((!(G__18783_19222)))?typeof v2 === 'number':null);
var G__18770_19225 = self__.buf;
var G__18771_19226 = ((G__18782_19221)?v1.buf:null);
var G__18772_19227 = ((G__18783_19222)?v2.buf:null);
var G__18773_19228 = (G__18770_19225[(0)]);
var G__18774_19229 = (G__18770_19225[(1)]);
var G__18775_19230 = (G__18770_19225[(2)]);
var G__18776_19231 = ((G__18782_19221)?(G__18771_19226[(0)]):(cljs.core.truth_(G__18784_19223)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18777_19232 = ((G__18782_19221)?(G__18771_19226[(1)]):(cljs.core.truth_(G__18784_19223)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18778_19233 = ((G__18782_19221)?(G__18771_19226[(2)]):(cljs.core.truth_(G__18784_19223)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__18779_19234 = ((G__18783_19222)?(G__18772_19227[(0)]):(cljs.core.truth_(G__18785_19224)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18780_19235 = ((G__18783_19222)?(G__18772_19227[(1)]):(cljs.core.truth_(G__18785_19224)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__18781_19236 = ((G__18783_19222)?(G__18772_19227[(2)]):(cljs.core.truth_(G__18785_19224)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__18773_19228 + G__18776_19231) + G__18779_19234));

(self__.buf[(1)] = ((G__18774_19229 + G__18777_19232) + G__18780_19235));

(self__.buf[(2)] = ((G__18775_19230 + G__18778_19233) + G__18781_19236));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) + x));

(self__.buf[(1)] = ((self__.buf[(1)]) + y));

(self__.buf[(2)] = ((self__.buf[(2)]) + z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$addm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__18798_19237 = (a instanceof thi.ng.geom.vector.Vec3);
var G__18799_19238 = (b instanceof thi.ng.geom.vector.Vec3);
var G__18800_19239 = (((!(G__18798_19237)))?typeof a === 'number':null);
var G__18801_19240 = (((!(G__18799_19238)))?typeof b === 'number':null);
var G__18786_19241 = self__.buf;
var G__18787_19242 = ((G__18798_19237)?a.buf:null);
var G__18788_19243 = ((G__18799_19238)?b.buf:null);
var G__18789_19244 = (G__18786_19241[(0)]);
var G__18790_19245 = (G__18786_19241[(1)]);
var G__18791_19246 = (G__18786_19241[(2)]);
var G__18792_19247 = ((G__18798_19237)?(G__18787_19242[(0)]):(cljs.core.truth_(G__18800_19239)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__18793_19248 = ((G__18798_19237)?(G__18787_19242[(1)]):(cljs.core.truth_(G__18800_19239)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__18794_19249 = ((G__18798_19237)?(G__18787_19242[(2)]):(cljs.core.truth_(G__18800_19239)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__18795_19250 = ((G__18799_19238)?(G__18788_19243[(0)]):(cljs.core.truth_(G__18801_19240)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__18796_19251 = ((G__18799_19238)?(G__18788_19243[(1)]):(cljs.core.truth_(G__18801_19240)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__18797_19252 = ((G__18799_19238)?(G__18788_19243[(2)]):(cljs.core.truth_(G__18801_19240)?b:cljs.core.nth.call(null,b,(2),1.0)));
(self__.buf[(0)] = ((G__18789_19244 + G__18792_19247) * G__18795_19250));

(self__.buf[(1)] = ((G__18790_19245 + G__18793_19248) * G__18796_19251));

(self__.buf[(2)] = ((G__18791_19246 + G__18794_19249) * G__18797_19252));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IBuffer$get_float_buffer$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.buf;
});

thi.ng.geom.vector.Vec3.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(0)]))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(1)]))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(2)])),"]"].join('');
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,___$1);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (_,k,nf){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,___$1);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ICrossProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ICrossProduct$cross$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__18802_19253 = self__.buf;
var G__18804_19254 = (G__18802_19253[(0)]);
var G__18805_19255 = (G__18802_19253[(1)]);
var G__18806_19256 = (G__18802_19253[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18803_19257 = v.buf;
var G__18807_19258 = (G__18803_19257[(0)]);
var G__18808_19259 = (G__18803_19257[(1)]);
var G__18809_19260 = (G__18803_19257[(2)]);
(b[(0)] = ((G__18805_19255 * G__18809_19260) - (G__18808_19259 * G__18806_19256)));

(b[(1)] = ((G__18806_19256 * G__18807_19258) - (G__18809_19260 * G__18804_19254)));

(b[(2)] = ((G__18804_19254 * G__18808_19259) - (G__18807_19258 * G__18805_19255)));
} else {
var G__18807_19261 = cljs.core.nth.call(null,v,(0),0.0);
var G__18808_19262 = cljs.core.nth.call(null,v,(1),0.0);
var G__18809_19263 = cljs.core.nth.call(null,v,(2),0.0);
(b[(0)] = ((G__18805_19255 * G__18809_19263) - (G__18808_19262 * G__18806_19256)));

(b[(1)] = ((G__18806_19256 * G__18807_19261) - (G__18809_19263 * G__18804_19254)));

(b[(2)] = ((G__18804_19254 * G__18808_19262) - (G__18807_19261 * G__18805_19255)));
}

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (_,n){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (3))){
return (self__.buf[n]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,n);
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (_,n,nf){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (3))){
return (self__.buf[n]);
} else {
return nf;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (_,writer,opts){
var self__ = this;
var ___$1 = this;
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,"#thi.ng/vec3 ["," ","]",opts,cljs.core.seq.call(null,___$1));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (_,n,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array(self__.buf));
(b[n] = v);

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec3((new Float32Array(self__.buf)),self__._hash,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IReflect$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IReflect$reflect$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__18810 = self__.buf;
var G__18812 = (G__18810[(0)]);
var G__18813 = (G__18810[(1)]);
var G__18814 = (G__18810[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18811 = v.buf;
var G__18815 = (G__18811[(0)]);
var G__18816 = (G__18811[(1)]);
var G__18817 = (G__18811[(2)]);
var d = ((((G__18812 * G__18815) + (G__18813 * G__18816)) + (G__18814 * G__18817)) * 2.0);
(b[(0)] = ((G__18815 * d) - G__18812));

(b[(1)] = ((G__18816 * d) - G__18813));

(b[(2)] = ((G__18817 * d) - G__18814));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
var G__18815 = cljs.core.nth.call(null,v,(0),0.0);
var G__18816 = cljs.core.nth.call(null,v,(1),0.0);
var G__18817 = cljs.core.nth.call(null,v,(2),0.0);
var d = ((((G__18812 * G__18815) + (G__18813 * G__18816)) + (G__18814 * G__18817)) * 2.0);
(b[(0)] = ((G__18815 * d) - G__18812));

(b[(1)] = ((G__18816 * d) - G__18813));

(b[(2)] = ((G__18817 * d) - G__18814));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),cljs.core.cons.call(null,(self__.buf[(2)]),null));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (3);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IDistance$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IDistance$dist$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return Math.sqrt(thi.ng.geom.core.dist_squared.call(null,___$1,v));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IDistance$dist_squared$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18818 = self__.buf;
var G__18820 = (G__18818[(0)]);
var G__18821 = (G__18818[(1)]);
var G__18822 = (G__18818[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18819 = v.buf;
var G__18823 = (G__18819[(0)]);
var G__18824 = (G__18819[(1)]);
var G__18825 = (G__18819[(2)]);
var dx = (G__18820 - G__18823);
var dy = (G__18821 - G__18824);
var dz = (G__18822 - G__18825);
return (((dx * dx) + (dy * dy)) + (dz * dz));
} else {
var G__18823 = cljs.core.nth.call(null,v,(0),0.0);
var G__18824 = cljs.core.nth.call(null,v,(1),0.0);
var G__18825 = cljs.core.nth.call(null,v,(2),0.0);
var dx = (G__18820 - G__18823);
var dy = (G__18821 - G__18824);
var dz = (G__18822 - G__18825);
return (((dx * dx) + (dy * dy)) + (dz * dz));
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate$rotate$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.rotate_z.call(null,___$1,theta);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IStack$_peek$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(2)]);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IStack$_pop$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
(b[(0)] = (self__.buf[(0)]));

(b[(1)] = (self__.buf[(1)]));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInvert$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInvert$invert$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core._.call(null,___$1);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.vector.swizzle3_fns.call(null,new cljs.core.Keyword(null,"zyx","zyx",1752527951)).call(null,___$1);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ILimit$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ILimit$limit$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
if((thi.ng.math.core.mag_squared.call(null,___$1) > (len * len))){
return thi.ng.math.core.normalize.call(null,___$1,len);
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IScale$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IScale$scale$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13357__auto__ = (new Float32Array((3)));
var G__18826_19264 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18827_19265 = v.buf;
(dest__13357__auto__[(0)] = ((G__18826_19264[(0)]) * (G__18827_19265[(0)])));

(dest__13357__auto__[(1)] = ((G__18826_19264[(1)]) * (G__18827_19265[(1)])));

(dest__13357__auto__[(2)] = ((G__18826_19264[(2)]) * (G__18827_19265[(2)])));
} else {
if(typeof v === 'number'){
(dest__13357__auto__[(0)] = ((G__18826_19264[(0)]) * v));

(dest__13357__auto__[(1)] = ((G__18826_19264[(1)]) * v));

(dest__13357__auto__[(2)] = ((G__18826_19264[(2)]) * v));
} else {
(dest__13357__auto__[(0)] = ((G__18826_19264[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__13357__auto__[(1)] = ((G__18826_19264[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

(dest__13357__auto__[(2)] = ((G__18826_19264[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__13357__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var or__4131__auto__ = self__._hash;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return ___$1._hash = cljs.core.mix_collection_hash.call(null,((cljs.core.imul.call(null,((cljs.core.imul.call(null,(((31) + cljs.core.hash.call(null,(self__.buf[(0)]))) | (0)),(31)) + cljs.core.hash.call(null,(self__.buf[(1)]))) | (0)),(31)) + cljs.core.hash.call(null,(self__.buf[(2)]))) | (0)),(3));
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDeltaEquals$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,___$1,v,thi.ng.math.core._STAR_eps_STAR_);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$3 = (function (_,v,eps){
var self__ = this;
var ___$1 = this;
if(cljs.core.sequential_QMARK_.call(null,v)){
if(((3) === cljs.core.count.call(null,v))){
var G__18828 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18829 = v.buf;
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__18828[(0)]),(G__18829[(0)]),eps))){
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__18828[(1)]),(G__18829[(1)]),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__18828[(2)]),(G__18829[(2)]),eps);
} else {
return null;
}
} else {
return null;
}
} else {
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__18828[(0)]),cljs.core.nth.call(null,v,(0),0.0),eps))){
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__18828[(1)]),cljs.core.nth.call(null,v,(1),0.0),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__18828[(2)]),cljs.core.nth.call(null,v,(2),0.0),eps);
} else {
return null;
}
} else {
return null;
}
}
} else {
return null;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec3)){
var b_SINGLEQUOTE_ = o.buf;
return ((((self__.buf[(0)]) === (b_SINGLEQUOTE_[(0)]))) && (((self__.buf[(1)]) === (b_SINGLEQUOTE_[(1)]))) && (((self__.buf[(2)]) === (b_SINGLEQUOTE_[(2)]))));
} else {
return ((cljs.core.sequential_QMARK_.call(null,o)) && (((3) === cljs.core.count.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(0)]),cljs.core.first.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(1)]),cljs.core.nth.call(null,o,(1)))) && (cljs.core._EQ_.call(null,(self__.buf[(2)]),cljs.core.nth.call(null,o,(2)))));
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IVectorReduce$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$3 = (function (_,f,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
return (new thi.ng.geom.vector.Vec3(thi.ng.geom.vector.vec3_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs),null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$4 = (function (_,f,f2,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
thi.ng.geom.vector.vec3_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs);

(buf_SINGLEQUOTE_[(0)] = f2.call(null,(buf_SINGLEQUOTE_[(0)]),(0)));

(buf_SINGLEQUOTE_[(1)] = f2.call(null,(buf_SINGLEQUOTE_[(1)]),(1)));

(buf_SINGLEQUOTE_[(2)] = f2.call(null,(buf_SINGLEQUOTE_[(2)]),(2)));

return (new thi.ng.geom.vector.Vec3(buf_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IIntoBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IIntoBuffer$into_float_buffer$arity$4 = (function (_,dest,stride,idx){
var self__ = this;
var ___$1 = this;
dest.set(self__.buf,idx);

return (idx + stride);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDotProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDotProduct$dot$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__18830 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18831 = v.buf;
return ((((G__18830[(0)]) * (G__18831[(0)])) + ((G__18830[(1)]) * (G__18831[(1)]))) + ((G__18830[(2)]) * (G__18831[(2)])));
} else {
return ((((G__18830[(0)]) * cljs.core.nth.call(null,v,(0),0.0)) + ((G__18830[(1)]) * cljs.core.nth.call(null,v,(1),0.0))) + ((G__18830[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,(self__.buf[(0)]),(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
var acc__$1 = f.call(null,acc,(self__.buf[(2)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$1)){
return cljs.core.deref.call(null,acc__$1);
} else {
return acc__$1;
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,start,(self__.buf[(0)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
var acc__$1 = f.call(null,acc,(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$1)){
return cljs.core.deref.call(null,acc__$1);
} else {
var acc__$2 = f.call(null,acc__$1,(self__.buf[(2)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$2)){
return cljs.core.deref.call(null,acc__$2);
} else {
return acc__$2;
}
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITranslate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITranslate$translate$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13357__auto__ = (new Float32Array((3)));
var G__18832_19266 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18833_19267 = v.buf;
(dest__13357__auto__[(0)] = ((G__18832_19266[(0)]) + (G__18833_19267[(0)])));

(dest__13357__auto__[(1)] = ((G__18832_19266[(1)]) + (G__18833_19267[(1)])));

(dest__13357__auto__[(2)] = ((G__18832_19266[(2)]) + (G__18833_19267[(2)])));
} else {
if(typeof v === 'number'){
(dest__13357__auto__[(0)] = ((G__18832_19266[(0)]) + v));

(dest__13357__auto__[(1)] = ((G__18832_19266[(1)]) + v));

(dest__13357__auto__[(2)] = ((G__18832_19266[(2)]) + v));
} else {
(dest__13357__auto__[(0)] = ((G__18832_19266[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__13357__auto__[(1)] = ((G__18832_19266[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

(dest__13357__auto__[(2)] = ((G__18832_19266[(2)]) + cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__13357__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(0)]);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),cljs.core.cons.call(null,(self__.buf[(2)]),null));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.heading_xy.call(null,___$1);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(1)]),(self__.buf[(0)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading_xz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(2)]),(self__.buf[(0)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading_yz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(2)]),(self__.buf[(1)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$angle_between$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var v__$1 = (((v instanceof thi.ng.geom.vector.Vec3))?v:thi.ng.geom.vector.vec3.call(null,v));
return Math.acos(thi.ng.math.core.dot.call(null,thi.ng.math.core.normalize.call(null,___$1),thi.ng.math.core.normalize.call(null,v__$1)));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$slope_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(1)]) / (self__.buf[(0)]));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$slope_xz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(2)]) / (self__.buf[(0)]));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$slope_yz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(2)]) / (self__.buf[(1)]));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__18834_19268 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18835_19269 = v.buf;
(b[(0)] = (((G__18834_19268[(0)]) + (G__18835_19269[(0)])) * 0.5));

(b[(1)] = (((G__18834_19268[(1)]) + (G__18835_19269[(1)])) * 0.5));

(b[(2)] = (((G__18834_19268[(2)]) + (G__18835_19269[(2)])) * 0.5));
} else {
if(typeof v === 'number'){
(b[(0)] = (((G__18834_19268[(0)]) + v) * 0.5));

(b[(1)] = (((G__18834_19268[(1)]) + v) * 0.5));

(b[(2)] = (((G__18834_19268[(2)]) + v) * 0.5));
} else {
(b[(0)] = (((G__18834_19268[(0)]) + cljs.core.nth.call(null,v,(0),0.0)) * 0.5));

(b[(1)] = (((G__18834_19268[(1)]) + cljs.core.nth.call(null,v,(1),0.0)) * 0.5));

(b[(2)] = (((G__18834_19268[(2)]) + cljs.core.nth.call(null,v,(2),0.0)) * 0.5));
}
}

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix$arity$3 = (function (_,v,t){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__18848_19270 = (v instanceof thi.ng.geom.vector.Vec3);
var G__18849_19271 = (t instanceof thi.ng.geom.vector.Vec3);
var G__18850_19272 = (((!(G__18848_19270)))?typeof v === 'number':null);
var G__18851_19273 = (((!(G__18849_19271)))?typeof t === 'number':null);
var G__18836_19274 = self__.buf;
var G__18837_19275 = ((G__18848_19270)?v.buf:null);
var G__18838_19276 = ((G__18849_19271)?t.buf:null);
var G__18839_19277 = (G__18836_19274[(0)]);
var G__18840_19278 = (G__18836_19274[(1)]);
var G__18841_19279 = (G__18836_19274[(2)]);
var G__18842_19280 = ((G__18848_19270)?(G__18837_19275[(0)]):(cljs.core.truth_(G__18850_19272)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__18843_19281 = ((G__18848_19270)?(G__18837_19275[(1)]):(cljs.core.truth_(G__18850_19272)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__18844_19282 = ((G__18848_19270)?(G__18837_19275[(2)]):(cljs.core.truth_(G__18850_19272)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__18845_19283 = ((G__18849_19271)?(G__18838_19276[(0)]):(cljs.core.truth_(G__18851_19273)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__18846_19284 = ((G__18849_19271)?(G__18838_19276[(1)]):(cljs.core.truth_(G__18851_19273)?t:cljs.core.nth.call(null,t,(1),0.0)));
var G__18847_19285 = ((G__18849_19271)?(G__18838_19276[(2)]):(cljs.core.truth_(G__18851_19273)?t:cljs.core.nth.call(null,t,(2),0.0)));
(b[(0)] = (((G__18842_19280 - G__18839_19277) * G__18845_19283) + G__18839_19277));

(b[(1)] = (((G__18843_19281 - G__18840_19278) * G__18846_19284) + G__18840_19278));

(b[(2)] = (((G__18844_19282 - G__18841_19279) * G__18847_19285) + G__18841_19279));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix$arity$6 = (function (_,b,c,d,u,v){
var self__ = this;
var ___$1 = this;
var b_SINGLEQUOTE_ = (new Float32Array((3)));
var dv_QMARK_ = (d instanceof thi.ng.geom.vector.Vec3);
var dn_QMARK_ = typeof d === 'number';
var dv = ((dv_QMARK_)?d.buf:null);
var dx = ((dv_QMARK_)?(dv[(0)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(0),0.0)));
var dy = ((dv_QMARK_)?(dv[(1)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(1),0.0)));
var dz = ((dv_QMARK_)?(dv[(2)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(2),0.0)));
var G__18864_19286 = (b instanceof thi.ng.geom.vector.Vec3);
var G__18865_19287 = (c instanceof thi.ng.geom.vector.Vec3);
var G__18866_19288 = (((!(G__18864_19286)))?typeof b === 'number':null);
var G__18867_19289 = (((!(G__18865_19287)))?typeof c === 'number':null);
var G__18852_19290 = self__.buf;
var G__18853_19291 = ((G__18864_19286)?b.buf:null);
var G__18854_19292 = ((G__18865_19287)?c.buf:null);
var G__18855_19293 = (G__18852_19290[(0)]);
var G__18856_19294 = (G__18852_19290[(1)]);
var G__18857_19295 = (G__18852_19290[(2)]);
var G__18858_19296 = ((G__18864_19286)?(G__18853_19291[(0)]):(cljs.core.truth_(G__18866_19288)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18859_19297 = ((G__18864_19286)?(G__18853_19291[(1)]):(cljs.core.truth_(G__18866_19288)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__18860_19298 = ((G__18864_19286)?(G__18853_19291[(2)]):(cljs.core.truth_(G__18866_19288)?b:cljs.core.nth.call(null,b,(2),0.0)));
var G__18861_19299 = ((G__18865_19287)?(G__18854_19292[(0)]):(cljs.core.truth_(G__18867_19289)?c:cljs.core.nth.call(null,c,(0),0.0)));
var G__18862_19300 = ((G__18865_19287)?(G__18854_19292[(1)]):(cljs.core.truth_(G__18867_19289)?c:cljs.core.nth.call(null,c,(1),0.0)));
var G__18863_19301 = ((G__18865_19287)?(G__18854_19292[(2)]):(cljs.core.truth_(G__18867_19289)?c:cljs.core.nth.call(null,c,(2),0.0)));
var x1_19302 = (((G__18858_19296 - G__18855_19293) * u) + G__18855_19293);
var y1_19303 = (((G__18859_19297 - G__18856_19294) * u) + G__18856_19294);
var z1_19304 = (((G__18860_19298 - G__18857_19295) * u) + G__18857_19295);
(b_SINGLEQUOTE_[(0)] = ((((((dx - G__18861_19299) * u) + G__18861_19299) - x1_19302) * v) + x1_19302));

(b_SINGLEQUOTE_[(1)] = ((((((dy - G__18862_19300) * u) + G__18862_19300) - y1_19303) * v) + y1_19303));

(b_SINGLEQUOTE_[(2)] = ((((((dz - G__18863_19301) * u) + G__18863_19301) - z1_19304) * v) + z1_19304));

return (new thi.ng.geom.vector.Vec3(b_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix_with$arity$4 = (function (_,v,t,f){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__18880_19305 = (v instanceof thi.ng.geom.vector.Vec3);
var G__18881_19306 = (t instanceof thi.ng.geom.vector.Vec3);
var G__18882_19307 = (((!(G__18880_19305)))?typeof v === 'number':null);
var G__18883_19308 = (((!(G__18881_19306)))?typeof t === 'number':null);
var G__18868_19309 = self__.buf;
var G__18869_19310 = ((G__18880_19305)?v.buf:null);
var G__18870_19311 = ((G__18881_19306)?t.buf:null);
var G__18871_19312 = (G__18868_19309[(0)]);
var G__18872_19313 = (G__18868_19309[(1)]);
var G__18873_19314 = (G__18868_19309[(2)]);
var G__18874_19315 = ((G__18880_19305)?(G__18869_19310[(0)]):(cljs.core.truth_(G__18882_19307)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__18875_19316 = ((G__18880_19305)?(G__18869_19310[(1)]):(cljs.core.truth_(G__18882_19307)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__18876_19317 = ((G__18880_19305)?(G__18869_19310[(2)]):(cljs.core.truth_(G__18882_19307)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__18877_19318 = ((G__18881_19306)?(G__18870_19311[(0)]):(cljs.core.truth_(G__18883_19308)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__18878_19319 = ((G__18881_19306)?(G__18870_19311[(1)]):(cljs.core.truth_(G__18883_19308)?t:cljs.core.nth.call(null,t,(1),0.0)));
var G__18879_19320 = ((G__18881_19306)?(G__18870_19311[(2)]):(cljs.core.truth_(G__18883_19308)?t:cljs.core.nth.call(null,t,(2),0.0)));
(b[(0)] = f.call(null,G__18871_19312,G__18874_19315,G__18877_19318));

(b[(1)] = f.call(null,G__18872_19313,G__18875_19316,G__18878_19319));

(b[(2)] = f.call(null,G__18873_19314,G__18876_19317,G__18879_19320));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$step$arity$2 = (function (_,e){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__18884_19321 = self__.buf;
if((e instanceof thi.ng.geom.vector.Vec3)){
var G__18885_19322 = e.buf;
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,(G__18885_19322[(0)]),(G__18884_19321[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,(G__18885_19322[(1)]),(G__18884_19321[(1)])));

(b[(2)] = thi.ng.math.core.step_STAR_.call(null,(G__18885_19322[(2)]),(G__18884_19321[(2)])));
} else {
if(typeof e === 'number'){
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,e,(G__18884_19321[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,e,(G__18884_19321[(1)])));

(b[(2)] = thi.ng.math.core.step_STAR_.call(null,e,(G__18884_19321[(2)])));
} else {
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(0),0.0),(G__18884_19321[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(1),0.0),(G__18884_19321[(1)])));

(b[(2)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(2),0.0),(G__18884_19321[(2)])));
}
}

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$smoothstep$arity$3 = (function (_,e1,e2){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__18898_19323 = (e1 instanceof thi.ng.geom.vector.Vec3);
var G__18899_19324 = (e2 instanceof thi.ng.geom.vector.Vec3);
var G__18900_19325 = (((!(G__18898_19323)))?typeof e1 === 'number':null);
var G__18901_19326 = (((!(G__18899_19324)))?typeof e2 === 'number':null);
var G__18886_19327 = self__.buf;
var G__18887_19328 = ((G__18898_19323)?e1.buf:null);
var G__18888_19329 = ((G__18899_19324)?e2.buf:null);
var G__18889_19330 = (G__18886_19327[(0)]);
var G__18890_19331 = (G__18886_19327[(1)]);
var G__18891_19332 = (G__18886_19327[(2)]);
var G__18892_19333 = ((G__18898_19323)?(G__18887_19328[(0)]):(cljs.core.truth_(G__18900_19325)?e1:cljs.core.nth.call(null,e1,(0),0.0)));
var G__18893_19334 = ((G__18898_19323)?(G__18887_19328[(1)]):(cljs.core.truth_(G__18900_19325)?e1:cljs.core.nth.call(null,e1,(1),0.0)));
var G__18894_19335 = ((G__18898_19323)?(G__18887_19328[(2)]):(cljs.core.truth_(G__18900_19325)?e1:cljs.core.nth.call(null,e1,(2),0.0)));
var G__18895_19336 = ((G__18899_19324)?(G__18888_19329[(0)]):(cljs.core.truth_(G__18901_19326)?e2:cljs.core.nth.call(null,e2,(0),0.0)));
var G__18896_19337 = ((G__18899_19324)?(G__18888_19329[(1)]):(cljs.core.truth_(G__18901_19326)?e2:cljs.core.nth.call(null,e2,(1),0.0)));
var G__18897_19338 = ((G__18899_19324)?(G__18888_19329[(2)]):(cljs.core.truth_(G__18901_19326)?e2:cljs.core.nth.call(null,e2,(2),0.0)));
(b[(0)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__18892_19333,G__18895_19336,G__18889_19330));

(b[(1)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__18893_19334,G__18896_19337,G__18890_19331));

(b[(2)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__18894_19335,G__18897_19338,G__18891_19332));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
return (((k >= (0))) && ((k <= (2))));
} else {
if(cljs.core.truth_(thi.ng.geom.vector.swizzle3_fns.call(null,k))){
return true;
} else {
return false;
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (_,k,v){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
if((((k >= (0))) && ((k <= (2))))){
var b = (new Float32Array(self__.buf));
(b[k] = v);

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
if((k === (3))){
return cljs.core.conj.call(null,___$1,v);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
} else {
if((k instanceof cljs.core.Keyword)){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"w","w",354169001),k)){
return cljs.core.conj.call(null,___$1,v);
} else {
return (new thi.ng.geom.vector.Vec3(thi.ng.geom.vector.swizzle_assoc_STAR_.call(null,self__.buf,(new Float32Array(self__.buf)),new cljs.core.PersistentArrayMap(null, 3, ["x",(0),"y",(1),"z",(2)], null),k,v),null,self__._meta));
}
} else {
return null;
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$min$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13357__auto__ = (new Float32Array((3)));
var G__18902_19339 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18903_19340 = v.buf;
(dest__13357__auto__[(0)] = (function (){var a__11171__auto__ = (G__18902_19339[(0)]);
var b__11172__auto__ = (G__18903_19340[(0)]);
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13357__auto__[(1)] = (function (){var a__11171__auto__ = (G__18902_19339[(1)]);
var b__11172__auto__ = (G__18903_19340[(1)]);
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13357__auto__[(2)] = (function (){var a__11171__auto__ = (G__18902_19339[(2)]);
var b__11172__auto__ = (G__18903_19340[(2)]);
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__13357__auto__[(0)] = (function (){var a__11171__auto__ = (G__18902_19339[(0)]);
var b__11172__auto__ = v;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13357__auto__[(1)] = (function (){var a__11171__auto__ = (G__18902_19339[(1)]);
var b__11172__auto__ = v;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13357__auto__[(2)] = (function (){var a__11171__auto__ = (G__18902_19339[(2)]);
var b__11172__auto__ = v;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());
} else {
(dest__13357__auto__[(0)] = (function (){var a__11171__auto__ = (G__18902_19339[(0)]);
var b__11172__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13357__auto__[(1)] = (function (){var a__11171__auto__ = (G__18902_19339[(1)]);
var b__11172__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13357__auto__[(2)] = (function (){var a__11171__auto__ = (G__18902_19339[(2)]);
var b__11172__auto__ = cljs.core.nth.call(null,v,(2),0.0);
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec3(dest__13357__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$min$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__13368__auto__ = (new Float32Array((3)));
var G__18916_19341 = (v instanceof thi.ng.geom.vector.Vec3);
var G__18917_19342 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__18918_19343 = (((!(G__18916_19341)))?typeof v === 'number':null);
var G__18919_19344 = (((!(G__18917_19342)))?typeof v2 === 'number':null);
var G__18904_19345 = self__.buf;
var G__18905_19346 = ((G__18916_19341)?v.buf:null);
var G__18906_19347 = ((G__18917_19342)?v2.buf:null);
var G__18907_19348 = (G__18904_19345[(0)]);
var G__18908_19349 = (G__18904_19345[(1)]);
var G__18909_19350 = (G__18904_19345[(2)]);
var G__18910_19351 = ((G__18916_19341)?(G__18905_19346[(0)]):(cljs.core.truth_(G__18918_19343)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__18911_19352 = ((G__18916_19341)?(G__18905_19346[(1)]):(cljs.core.truth_(G__18918_19343)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__18912_19353 = ((G__18916_19341)?(G__18905_19346[(2)]):(cljs.core.truth_(G__18918_19343)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__18913_19354 = ((G__18917_19342)?(G__18906_19347[(0)]):(cljs.core.truth_(G__18919_19344)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18914_19355 = ((G__18917_19342)?(G__18906_19347[(1)]):(cljs.core.truth_(G__18919_19344)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__18915_19356 = ((G__18917_19342)?(G__18906_19347[(2)]):(cljs.core.truth_(G__18919_19344)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__13368__auto__[(0)] = (function (){var a__11171__auto__ = (function (){var a__11171__auto__ = G__18907_19348;
var b__11172__auto__ = G__18910_19351;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})();
var b__11172__auto__ = G__18913_19354;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13368__auto__[(1)] = (function (){var a__11171__auto__ = (function (){var a__11171__auto__ = G__18908_19349;
var b__11172__auto__ = G__18911_19352;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})();
var b__11172__auto__ = G__18914_19355;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

(dest__13368__auto__[(2)] = (function (){var a__11171__auto__ = (function (){var a__11171__auto__ = G__18909_19350;
var b__11172__auto__ = G__18912_19353;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})();
var b__11172__auto__ = G__18915_19356;
if((a__11171__auto__ <= b__11172__auto__)){
return a__11171__auto__;
} else {
return b__11172__auto__;
}
})());

return (new thi.ng.geom.vector.Vec3(dest__13368__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$max$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13357__auto__ = (new Float32Array((3)));
var G__18920_19357 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18921_19358 = v.buf;
(dest__13357__auto__[(0)] = (function (){var a__11178__auto__ = (G__18920_19357[(0)]);
var b__11179__auto__ = (G__18921_19358[(0)]);
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13357__auto__[(1)] = (function (){var a__11178__auto__ = (G__18920_19357[(1)]);
var b__11179__auto__ = (G__18921_19358[(1)]);
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13357__auto__[(2)] = (function (){var a__11178__auto__ = (G__18920_19357[(2)]);
var b__11179__auto__ = (G__18921_19358[(2)]);
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__13357__auto__[(0)] = (function (){var a__11178__auto__ = (G__18920_19357[(0)]);
var b__11179__auto__ = v;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13357__auto__[(1)] = (function (){var a__11178__auto__ = (G__18920_19357[(1)]);
var b__11179__auto__ = v;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13357__auto__[(2)] = (function (){var a__11178__auto__ = (G__18920_19357[(2)]);
var b__11179__auto__ = v;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());
} else {
(dest__13357__auto__[(0)] = (function (){var a__11178__auto__ = (G__18920_19357[(0)]);
var b__11179__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13357__auto__[(1)] = (function (){var a__11178__auto__ = (G__18920_19357[(1)]);
var b__11179__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13357__auto__[(2)] = (function (){var a__11178__auto__ = (G__18920_19357[(2)]);
var b__11179__auto__ = cljs.core.nth.call(null,v,(2),0.0);
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec3(dest__13357__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$max$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__13368__auto__ = (new Float32Array((3)));
var G__18934_19359 = (v instanceof thi.ng.geom.vector.Vec3);
var G__18935_19360 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__18936_19361 = (((!(G__18934_19359)))?typeof v === 'number':null);
var G__18937_19362 = (((!(G__18935_19360)))?typeof v2 === 'number':null);
var G__18922_19363 = self__.buf;
var G__18923_19364 = ((G__18934_19359)?v.buf:null);
var G__18924_19365 = ((G__18935_19360)?v2.buf:null);
var G__18925_19366 = (G__18922_19363[(0)]);
var G__18926_19367 = (G__18922_19363[(1)]);
var G__18927_19368 = (G__18922_19363[(2)]);
var G__18928_19369 = ((G__18934_19359)?(G__18923_19364[(0)]):(cljs.core.truth_(G__18936_19361)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__18929_19370 = ((G__18934_19359)?(G__18923_19364[(1)]):(cljs.core.truth_(G__18936_19361)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__18930_19371 = ((G__18934_19359)?(G__18923_19364[(2)]):(cljs.core.truth_(G__18936_19361)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__18931_19372 = ((G__18935_19360)?(G__18924_19365[(0)]):(cljs.core.truth_(G__18937_19362)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18932_19373 = ((G__18935_19360)?(G__18924_19365[(1)]):(cljs.core.truth_(G__18937_19362)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__18933_19374 = ((G__18935_19360)?(G__18924_19365[(2)]):(cljs.core.truth_(G__18937_19362)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__13368__auto__[(0)] = (function (){var a__11178__auto__ = (function (){var a__11178__auto__ = G__18925_19366;
var b__11179__auto__ = G__18928_19369;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})();
var b__11179__auto__ = G__18931_19372;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13368__auto__[(1)] = (function (){var a__11178__auto__ = (function (){var a__11178__auto__ = G__18926_19367;
var b__11179__auto__ = G__18929_19370;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})();
var b__11179__auto__ = G__18932_19373;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

(dest__13368__auto__[(2)] = (function (){var a__11178__auto__ = (function (){var a__11178__auto__ = G__18927_19368;
var b__11179__auto__ = G__18930_19371;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})();
var b__11179__auto__ = G__18933_19374;
if((a__11178__auto__ >= b__11179__auto__)){
return a__11178__auto__;
} else {
return b__11179__auto__;
}
})());

return (new thi.ng.geom.vector.Vec3(dest__13368__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_x$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((3)));
var G__18938 = self__.buf;
var G__18939 = (G__18938[(0)]);
var G__18940 = (G__18938[(1)]);
var G__18941 = (G__18938[(2)]);
(b[(0)] = G__18939);

(b[(1)] = ((G__18940 * c) - (G__18941 * s)));

(b[(2)] = ((G__18940 * s) + (G__18941 * c)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_y$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((3)));
var G__18942 = self__.buf;
var G__18943 = (G__18942[(0)]);
var G__18944 = (G__18942[(1)]);
var G__18945 = (G__18942[(2)]);
(b[(0)] = ((G__18943 * c) + (G__18945 * s)));

(b[(1)] = G__18944);

(b[(2)] = ((G__18945 * c) - (G__18943 * s)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_z$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((3)));
var G__18946 = self__.buf;
var G__18947 = (G__18946[(0)]);
var G__18948 = (G__18946[(1)]);
var G__18949 = (G__18946[(2)]);
(b[(0)] = ((G__18947 * c) - (G__18948 * s)));

(b[(1)] = ((G__18947 * s) + (G__18948 * c)));

(b[(2)] = G__18949);

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_around_axis$arity$3 = (function (_,v,theta){
var self__ = this;
var ___$1 = this;
var G__18950 = self__.buf;
var G__18952 = (G__18950[(0)]);
var G__18953 = (G__18950[(1)]);
var G__18954 = (G__18950[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18951 = v.buf;
var G__18955 = (G__18951[(0)]);
var G__18956 = (G__18951[(1)]);
var G__18957 = (G__18951[(2)]);
var ux_SINGLEQUOTE_ = (G__18955 * G__18952);
var uy_SINGLEQUOTE_ = (G__18955 * G__18953);
var uz_SINGLEQUOTE_ = (G__18955 * G__18954);
var vx_SINGLEQUOTE_ = (G__18956 * G__18952);
var vy_SINGLEQUOTE_ = (G__18956 * G__18953);
var vz_SINGLEQUOTE_ = (G__18956 * G__18954);
var wx_SINGLEQUOTE_ = (G__18957 * G__18952);
var wy_SINGLEQUOTE_ = (G__18957 * G__18953);
var wz_SINGLEQUOTE_ = (G__18957 * G__18954);
var vx2 = (G__18955 * G__18955);
var vy2 = (G__18956 * G__18956);
var vz2 = (G__18957 * G__18957);
var s = Math.sin(theta);
var c = Math.cos(theta);
var uvw = ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) + wz_SINGLEQUOTE_);
var b = (new Float32Array((3)));
(b[(0)] = (((uvw * G__18955) + ((((vy2 + vz2) * G__18952) - ((vy_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__18955)) * c)) + ((vz_SINGLEQUOTE_ - wy_SINGLEQUOTE_) * s)));

(b[(1)] = (((uvw * G__18956) + ((((vx2 + vz2) * G__18953) - ((ux_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__18956)) * c)) + ((wx_SINGLEQUOTE_ - uz_SINGLEQUOTE_) * s)));

(b[(2)] = (((uvw * G__18957) + ((((vx2 + vy2) * G__18954) - ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) * G__18957)) * c)) + ((uy_SINGLEQUOTE_ - vx_SINGLEQUOTE_) * s)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
var G__18955 = cljs.core.nth.call(null,v,(0),0.0);
var G__18956 = cljs.core.nth.call(null,v,(1),0.0);
var G__18957 = cljs.core.nth.call(null,v,(2),0.0);
var ux_SINGLEQUOTE_ = (G__18955 * G__18952);
var uy_SINGLEQUOTE_ = (G__18955 * G__18953);
var uz_SINGLEQUOTE_ = (G__18955 * G__18954);
var vx_SINGLEQUOTE_ = (G__18956 * G__18952);
var vy_SINGLEQUOTE_ = (G__18956 * G__18953);
var vz_SINGLEQUOTE_ = (G__18956 * G__18954);
var wx_SINGLEQUOTE_ = (G__18957 * G__18952);
var wy_SINGLEQUOTE_ = (G__18957 * G__18953);
var wz_SINGLEQUOTE_ = (G__18957 * G__18954);
var vx2 = (G__18955 * G__18955);
var vy2 = (G__18956 * G__18956);
var vz2 = (G__18957 * G__18957);
var s = Math.sin(theta);
var c = Math.cos(theta);
var uvw = ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) + wz_SINGLEQUOTE_);
var b = (new Float32Array((3)));
(b[(0)] = (((uvw * G__18955) + ((((vy2 + vz2) * G__18952) - ((vy_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__18955)) * c)) + ((vz_SINGLEQUOTE_ - wy_SINGLEQUOTE_) * s)));

(b[(1)] = (((uvw * G__18956) + ((((vx2 + vz2) * G__18953) - ((ux_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__18956)) * c)) + ((wx_SINGLEQUOTE_ - uz_SINGLEQUOTE_) * s)));

(b[(2)] = (((uvw * G__18957) + ((((vx2 + vy2) * G__18954) - ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) * G__18957)) * c)) + ((uy_SINGLEQUOTE_ - vx_SINGLEQUOTE_) * s)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec3((new Float32Array(self__.buf)),self__._hash,m));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IClear$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IClear$clear_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec3((new Float32Array((3))),null,null));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IClear$clear_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = 0.0);

(self__.buf[(1)] = 0.0);

(self__.buf[(2)] = 0.0);

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ICollection$_conj$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.buf[(0)]),(self__.buf[(1)]),(self__.buf[(2)]),x], null),self__._meta);
});

thi.ng.geom.vector.Vec3.prototype.call = (function() {
var G__19375 = null;
var G__19375__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});
var G__19375__3 = (function (self__,k,nf){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});
G__19375 = function(self__,k,nf){
switch(arguments.length){
case 2:
return G__19375__2.call(this,self__,k);
case 3:
return G__19375__3.call(this,self__,k,nf);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__19375.cljs$core$IFn$_invoke$arity$2 = G__19375__2;
G__19375.cljs$core$IFn$_invoke$arity$3 = G__19375__3;
return G__19375;
})()
;

thi.ng.geom.vector.Vec3.prototype.apply = (function (self__,args18665){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args18665)));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,nf){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IPolar$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IPolar$as_polar$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var r = thi.ng.math.core.mag.call(null,___$1);
var b = (new Float32Array((3)));
(b[(0)] = r);

(b[(1)] = Math.asin(((self__.buf[(2)]) / r)));

(b[(2)] = Math.atan2((self__.buf[(1)]),(self__.buf[(0)])));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IPolar$as_cartesian$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = self__.buf;
var x = (b[(0)]);
var y = (b[(1)]);
var z = (b[(2)]);
var rcos = (x * Math.cos(y));
var b_SINGLEQUOTE_ = (new Float32Array((3)));
(b_SINGLEQUOTE_[(0)] = (rcos * Math.cos(z)));

(b_SINGLEQUOTE_[(1)] = (rcos * Math.sin(z)));

(b_SINGLEQUOTE_[(2)] = (x * Math.sin(y)));

return (new thi.ng.geom.vector.Vec3(b_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IComparable$_compare$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec3)){
var b_SINGLEQUOTE_ = o.buf;
var c = cljs.core.compare.call(null,(self__.buf[(0)]),(b_SINGLEQUOTE_[(0)]));
if(((0) === c)){
var c__$1 = cljs.core.compare.call(null,(self__.buf[(1)]),(b_SINGLEQUOTE_[(1)]));
if(((0) === c__$1)){
return cljs.core.compare.call(null,(self__.buf[(2)]),(b_SINGLEQUOTE_[(2)]));
} else {
return c__$1;
}
} else {
return c;
}
} else {
var c = cljs.core.count.call(null,o);
if(((3) === c)){
return (- cljs.core.compare.call(null,o,___$1));
} else {
return ((3) - c);
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$normalize$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__18958 = self__.buf;
var G__18959 = (G__18958[(0)]);
var G__18960 = (G__18958[(1)]);
var G__18961 = (G__18958[(2)]);
var l = Math.sqrt((((G__18959 * G__18959) + (G__18960 * G__18960)) + (G__18961 * G__18961)));
if((l > (0))){
var b = (new Float32Array((3)));
(b[(0)] = (G__18959 / l));

(b[(1)] = (G__18960 / l));

(b[(2)] = (G__18961 / l));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$normalize$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
var G__18962 = self__.buf;
var G__18963 = (G__18962[(0)]);
var G__18964 = (G__18962[(1)]);
var G__18965 = (G__18962[(2)]);
var l = Math.sqrt((((G__18963 * G__18963) + (G__18964 * G__18964)) + (G__18965 * G__18965)));
if((l > (0))){
var l__$1 = (len / l);
var b = (new Float32Array((3)));
(b[(0)] = (G__18963 * l__$1));

(b[(1)] = (G__18964 * l__$1));

(b[(2)] = (G__18965 * l__$1));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$normalized_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,1.0,thi.ng.math.core.mag_squared.call(null,___$1));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMagnitude$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMagnitude$mag$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__18966 = self__.buf;
var G__18967 = (G__18966[(0)]);
var G__18968 = (G__18966[(1)]);
var G__18969 = (G__18966[(2)]);
return Math.sqrt((((G__18967 * G__18967) + (G__18968 * G__18968)) + (G__18969 * G__18969)));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMagnitude$mag_squared$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__18970 = self__.buf;
var G__18971 = (G__18970[(0)]);
var G__18972 = (G__18970[(1)]);
var G__18973 = (G__18970[(2)]);
return (((G__18971 * G__18971) + (G__18972 * G__18972)) + (G__18973 * G__18973));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$msub$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__13368__auto__ = (new Float32Array((3)));
var G__18986_19376 = (a instanceof thi.ng.geom.vector.Vec3);
var G__18987_19377 = (b instanceof thi.ng.geom.vector.Vec3);
var G__18988_19378 = (((!(G__18986_19376)))?typeof a === 'number':null);
var G__18989_19379 = (((!(G__18987_19377)))?typeof b === 'number':null);
var G__18974_19380 = self__.buf;
var G__18975_19381 = ((G__18986_19376)?a.buf:null);
var G__18976_19382 = ((G__18987_19377)?b.buf:null);
var G__18977_19383 = (G__18974_19380[(0)]);
var G__18978_19384 = (G__18974_19380[(1)]);
var G__18979_19385 = (G__18974_19380[(2)]);
var G__18980_19386 = ((G__18986_19376)?(G__18975_19381[(0)]):(cljs.core.truth_(G__18988_19378)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__18981_19387 = ((G__18986_19376)?(G__18975_19381[(1)]):(cljs.core.truth_(G__18988_19378)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__18982_19388 = ((G__18986_19376)?(G__18975_19381[(2)]):(cljs.core.truth_(G__18988_19378)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__18983_19389 = ((G__18987_19377)?(G__18976_19382[(0)]):(cljs.core.truth_(G__18989_19379)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18984_19390 = ((G__18987_19377)?(G__18976_19382[(1)]):(cljs.core.truth_(G__18989_19379)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__18985_19391 = ((G__18987_19377)?(G__18976_19382[(2)]):(cljs.core.truth_(G__18989_19379)?b:cljs.core.nth.call(null,b,(2),0.0)));
(dest__13368__auto__[(0)] = ((G__18977_19383 * G__18980_19386) - G__18983_19389));

(dest__13368__auto__[(1)] = ((G__18978_19384 * G__18981_19387) - G__18984_19390));

(dest__13368__auto__[(2)] = ((G__18979_19385 * G__18982_19388) - G__18985_19391));

return (new thi.ng.geom.vector.Vec3(dest__13368__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13357__auto__ = (new Float32Array((3)));
var G__18990_19392 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18991_19393 = v.buf;
(dest__13357__auto__[(0)] = ((G__18990_19392[(0)]) * (G__18991_19393[(0)])));

(dest__13357__auto__[(1)] = ((G__18990_19392[(1)]) * (G__18991_19393[(1)])));

(dest__13357__auto__[(2)] = ((G__18990_19392[(2)]) * (G__18991_19393[(2)])));
} else {
if(typeof v === 'number'){
(dest__13357__auto__[(0)] = ((G__18990_19392[(0)]) * v));

(dest__13357__auto__[(1)] = ((G__18990_19392[(1)]) * v));

(dest__13357__auto__[(2)] = ((G__18990_19392[(2)]) * v));
} else {
(dest__13357__auto__[(0)] = ((G__18990_19392[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__13357__auto__[(1)] = ((G__18990_19392[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

(dest__13357__auto__[(2)] = ((G__18990_19392[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__13357__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__13368__auto__ = (new Float32Array((3)));
var G__19004_19394 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__19005_19395 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__19006_19396 = (((!(G__19004_19394)))?typeof v1 === 'number':null);
var G__19007_19397 = (((!(G__19005_19395)))?typeof v2 === 'number':null);
var G__18992_19398 = self__.buf;
var G__18993_19399 = ((G__19004_19394)?v1.buf:null);
var G__18994_19400 = ((G__19005_19395)?v2.buf:null);
var G__18995_19401 = (G__18992_19398[(0)]);
var G__18996_19402 = (G__18992_19398[(1)]);
var G__18997_19403 = (G__18992_19398[(2)]);
var G__18998_19404 = ((G__19004_19394)?(G__18993_19399[(0)]):(cljs.core.truth_(G__19006_19396)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18999_19405 = ((G__19004_19394)?(G__18993_19399[(1)]):(cljs.core.truth_(G__19006_19396)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19000_19406 = ((G__19004_19394)?(G__18993_19399[(2)]):(cljs.core.truth_(G__19006_19396)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__19001_19407 = ((G__19005_19395)?(G__18994_19400[(0)]):(cljs.core.truth_(G__19007_19397)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19002_19408 = ((G__19005_19395)?(G__18994_19400[(1)]):(cljs.core.truth_(G__19007_19397)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__19003_19409 = ((G__19005_19395)?(G__18994_19400[(2)]):(cljs.core.truth_(G__19007_19397)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__13368__auto__[(0)] = ((G__18995_19401 * G__18998_19404) * G__19001_19407));

(dest__13368__auto__[(1)] = ((G__18996_19402 * G__18999_19405) * G__19002_19408));

(dest__13368__auto__[(2)] = ((G__18997_19403 * G__19000_19406) * G__19003_19409));

return (new thi.ng.geom.vector.Vec3(dest__13368__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__19008 = self__.buf;
var dest__13346__auto__ = (new Float32Array((3)));
(dest__13346__auto__[(0)] = ((G__19008[(0)]) * x));

(dest__13346__auto__[(1)] = ((G__19008[(1)]) * y));

(dest__13346__auto__[(2)] = ((G__19008[(2)]) * z));

return (new thi.ng.geom.vector.Vec3(dest__13346__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__13340__auto__ = (new Float32Array((3)));
var G__19009_19410 = self__.buf;
(dest__13340__auto__[(0)] = (- (G__19009_19410[(0)])));

(dest__13340__auto__[(1)] = (- (G__19009_19410[(1)])));

(dest__13340__auto__[(2)] = (- (G__19009_19410[(2)])));

return (new thi.ng.geom.vector.Vec3(dest__13340__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13357__auto__ = (new Float32Array((3)));
var G__19010_19411 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__19011_19412 = v.buf;
(dest__13357__auto__[(0)] = ((G__19010_19411[(0)]) - (G__19011_19412[(0)])));

(dest__13357__auto__[(1)] = ((G__19010_19411[(1)]) - (G__19011_19412[(1)])));

(dest__13357__auto__[(2)] = ((G__19010_19411[(2)]) - (G__19011_19412[(2)])));
} else {
if(typeof v === 'number'){
(dest__13357__auto__[(0)] = ((G__19010_19411[(0)]) - v));

(dest__13357__auto__[(1)] = ((G__19010_19411[(1)]) - v));

(dest__13357__auto__[(2)] = ((G__19010_19411[(2)]) - v));
} else {
(dest__13357__auto__[(0)] = ((G__19010_19411[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(dest__13357__auto__[(1)] = ((G__19010_19411[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));

(dest__13357__auto__[(2)] = ((G__19010_19411[(2)]) - cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__13357__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__13368__auto__ = (new Float32Array((3)));
var G__19024_19413 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__19025_19414 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__19026_19415 = (((!(G__19024_19413)))?typeof v1 === 'number':null);
var G__19027_19416 = (((!(G__19025_19414)))?typeof v2 === 'number':null);
var G__19012_19417 = self__.buf;
var G__19013_19418 = ((G__19024_19413)?v1.buf:null);
var G__19014_19419 = ((G__19025_19414)?v2.buf:null);
var G__19015_19420 = (G__19012_19417[(0)]);
var G__19016_19421 = (G__19012_19417[(1)]);
var G__19017_19422 = (G__19012_19417[(2)]);
var G__19018_19423 = ((G__19024_19413)?(G__19013_19418[(0)]):(cljs.core.truth_(G__19026_19415)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19019_19424 = ((G__19024_19413)?(G__19013_19418[(1)]):(cljs.core.truth_(G__19026_19415)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19020_19425 = ((G__19024_19413)?(G__19013_19418[(2)]):(cljs.core.truth_(G__19026_19415)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__19021_19426 = ((G__19025_19414)?(G__19014_19419[(0)]):(cljs.core.truth_(G__19027_19416)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19022_19427 = ((G__19025_19414)?(G__19014_19419[(1)]):(cljs.core.truth_(G__19027_19416)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__19023_19428 = ((G__19025_19414)?(G__19014_19419[(2)]):(cljs.core.truth_(G__19027_19416)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__13368__auto__[(0)] = ((G__19015_19420 - G__19018_19423) - G__19021_19426));

(dest__13368__auto__[(1)] = ((G__19016_19421 - G__19019_19424) - G__19022_19427));

(dest__13368__auto__[(2)] = ((G__19017_19422 - G__19020_19425) - G__19023_19428));

return (new thi.ng.geom.vector.Vec3(dest__13368__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__19028 = self__.buf;
var dest__13346__auto__ = (new Float32Array((3)));
(dest__13346__auto__[(0)] = ((G__19028[(0)]) - x));

(dest__13346__auto__[(1)] = ((G__19028[(1)]) - y));

(dest__13346__auto__[(2)] = ((G__19028[(2)]) - z));

return (new thi.ng.geom.vector.Vec3(dest__13346__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$madd$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__13368__auto__ = (new Float32Array((3)));
var G__19041_19429 = (a instanceof thi.ng.geom.vector.Vec3);
var G__19042_19430 = (b instanceof thi.ng.geom.vector.Vec3);
var G__19043_19431 = (((!(G__19041_19429)))?typeof a === 'number':null);
var G__19044_19432 = (((!(G__19042_19430)))?typeof b === 'number':null);
var G__19029_19433 = self__.buf;
var G__19030_19434 = ((G__19041_19429)?a.buf:null);
var G__19031_19435 = ((G__19042_19430)?b.buf:null);
var G__19032_19436 = (G__19029_19433[(0)]);
var G__19033_19437 = (G__19029_19433[(1)]);
var G__19034_19438 = (G__19029_19433[(2)]);
var G__19035_19439 = ((G__19041_19429)?(G__19030_19434[(0)]):(cljs.core.truth_(G__19043_19431)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__19036_19440 = ((G__19041_19429)?(G__19030_19434[(1)]):(cljs.core.truth_(G__19043_19431)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__19037_19441 = ((G__19041_19429)?(G__19030_19434[(2)]):(cljs.core.truth_(G__19043_19431)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__19038_19442 = ((G__19042_19430)?(G__19031_19435[(0)]):(cljs.core.truth_(G__19044_19432)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__19039_19443 = ((G__19042_19430)?(G__19031_19435[(1)]):(cljs.core.truth_(G__19044_19432)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__19040_19444 = ((G__19042_19430)?(G__19031_19435[(2)]):(cljs.core.truth_(G__19044_19432)?b:cljs.core.nth.call(null,b,(2),0.0)));
(dest__13368__auto__[(0)] = ((G__19032_19436 * G__19035_19439) + G__19038_19442));

(dest__13368__auto__[(1)] = ((G__19033_19437 * G__19036_19440) + G__19039_19443));

(dest__13368__auto__[(2)] = ((G__19034_19438 * G__19037_19441) + G__19040_19444));

return (new thi.ng.geom.vector.Vec3(dest__13368__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$addm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__13368__auto__ = (new Float32Array((3)));
var G__19057_19445 = (a instanceof thi.ng.geom.vector.Vec3);
var G__19058_19446 = (b instanceof thi.ng.geom.vector.Vec3);
var G__19059_19447 = (((!(G__19057_19445)))?typeof a === 'number':null);
var G__19060_19448 = (((!(G__19058_19446)))?typeof b === 'number':null);
var G__19045_19449 = self__.buf;
var G__19046_19450 = ((G__19057_19445)?a.buf:null);
var G__19047_19451 = ((G__19058_19446)?b.buf:null);
var G__19048_19452 = (G__19045_19449[(0)]);
var G__19049_19453 = (G__19045_19449[(1)]);
var G__19050_19454 = (G__19045_19449[(2)]);
var G__19051_19455 = ((G__19057_19445)?(G__19046_19450[(0)]):(cljs.core.truth_(G__19059_19447)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__19052_19456 = ((G__19057_19445)?(G__19046_19450[(1)]):(cljs.core.truth_(G__19059_19447)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__19053_19457 = ((G__19057_19445)?(G__19046_19450[(2)]):(cljs.core.truth_(G__19059_19447)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__19054_19458 = ((G__19058_19446)?(G__19047_19451[(0)]):(cljs.core.truth_(G__19060_19448)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__19055_19459 = ((G__19058_19446)?(G__19047_19451[(1)]):(cljs.core.truth_(G__19060_19448)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__19056_19460 = ((G__19058_19446)?(G__19047_19451[(2)]):(cljs.core.truth_(G__19060_19448)?b:cljs.core.nth.call(null,b,(2),1.0)));
(dest__13368__auto__[(0)] = ((G__19048_19452 + G__19051_19455) * G__19054_19458));

(dest__13368__auto__[(1)] = ((G__19049_19453 + G__19052_19456) * G__19055_19459));

(dest__13368__auto__[(2)] = ((G__19050_19454 + G__19053_19457) * G__19056_19460));

return (new thi.ng.geom.vector.Vec3(dest__13368__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__13340__auto__ = (new Float32Array((3)));
var G__19061_19461 = self__.buf;
(dest__13340__auto__[(0)] = ((1) / (G__19061_19461[(0)])));

(dest__13340__auto__[(1)] = ((1) / (G__19061_19461[(1)])));

(dest__13340__auto__[(2)] = ((1) / (G__19061_19461[(2)])));

return (new thi.ng.geom.vector.Vec3(dest__13340__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13357__auto__ = (new Float32Array((3)));
var G__19062_19462 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__19063_19463 = v.buf;
(dest__13357__auto__[(0)] = ((G__19062_19462[(0)]) / (G__19063_19463[(0)])));

(dest__13357__auto__[(1)] = ((G__19062_19462[(1)]) / (G__19063_19463[(1)])));

(dest__13357__auto__[(2)] = ((G__19062_19462[(2)]) / (G__19063_19463[(2)])));
} else {
if(typeof v === 'number'){
(dest__13357__auto__[(0)] = ((G__19062_19462[(0)]) / v));

(dest__13357__auto__[(1)] = ((G__19062_19462[(1)]) / v));

(dest__13357__auto__[(2)] = ((G__19062_19462[(2)]) / v));
} else {
(dest__13357__auto__[(0)] = ((G__19062_19462[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(dest__13357__auto__[(1)] = ((G__19062_19462[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));

(dest__13357__auto__[(2)] = ((G__19062_19462[(2)]) / cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__13357__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__13368__auto__ = (new Float32Array((3)));
var G__19076_19464 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__19077_19465 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__19078_19466 = (((!(G__19076_19464)))?typeof v1 === 'number':null);
var G__19079_19467 = (((!(G__19077_19465)))?typeof v2 === 'number':null);
var G__19064_19468 = self__.buf;
var G__19065_19469 = ((G__19076_19464)?v1.buf:null);
var G__19066_19470 = ((G__19077_19465)?v2.buf:null);
var G__19067_19471 = (G__19064_19468[(0)]);
var G__19068_19472 = (G__19064_19468[(1)]);
var G__19069_19473 = (G__19064_19468[(2)]);
var G__19070_19474 = ((G__19076_19464)?(G__19065_19469[(0)]):(cljs.core.truth_(G__19078_19466)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19071_19475 = ((G__19076_19464)?(G__19065_19469[(1)]):(cljs.core.truth_(G__19078_19466)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19072_19476 = ((G__19076_19464)?(G__19065_19469[(2)]):(cljs.core.truth_(G__19078_19466)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__19073_19477 = ((G__19077_19465)?(G__19066_19470[(0)]):(cljs.core.truth_(G__19079_19467)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19074_19478 = ((G__19077_19465)?(G__19066_19470[(1)]):(cljs.core.truth_(G__19079_19467)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__19075_19479 = ((G__19077_19465)?(G__19066_19470[(2)]):(cljs.core.truth_(G__19079_19467)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__13368__auto__[(0)] = ((G__19067_19471 / G__19070_19474) / G__19073_19477));

(dest__13368__auto__[(1)] = ((G__19068_19472 / G__19071_19475) / G__19074_19478));

(dest__13368__auto__[(2)] = ((G__19069_19473 / G__19072_19476) / G__19075_19479));

return (new thi.ng.geom.vector.Vec3(dest__13368__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__19080 = self__.buf;
var dest__13346__auto__ = (new Float32Array((3)));
(dest__13346__auto__[(0)] = ((G__19080[(0)]) / x));

(dest__13346__auto__[(1)] = ((G__19080[(1)]) / y));

(dest__13346__auto__[(2)] = ((G__19080[(2)]) / z));

return (new thi.ng.geom.vector.Vec3(dest__13346__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__13357__auto__ = (new Float32Array((3)));
var G__19081_19480 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__19082_19481 = v.buf;
(dest__13357__auto__[(0)] = ((G__19081_19480[(0)]) + (G__19082_19481[(0)])));

(dest__13357__auto__[(1)] = ((G__19081_19480[(1)]) + (G__19082_19481[(1)])));

(dest__13357__auto__[(2)] = ((G__19081_19480[(2)]) + (G__19082_19481[(2)])));
} else {
if(typeof v === 'number'){
(dest__13357__auto__[(0)] = ((G__19081_19480[(0)]) + v));

(dest__13357__auto__[(1)] = ((G__19081_19480[(1)]) + v));

(dest__13357__auto__[(2)] = ((G__19081_19480[(2)]) + v));
} else {
(dest__13357__auto__[(0)] = ((G__19081_19480[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__13357__auto__[(1)] = ((G__19081_19480[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

(dest__13357__auto__[(2)] = ((G__19081_19480[(2)]) + cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__13357__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__13368__auto__ = (new Float32Array((3)));
var G__19095_19482 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__19096_19483 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__19097_19484 = (((!(G__19095_19482)))?typeof v1 === 'number':null);
var G__19098_19485 = (((!(G__19096_19483)))?typeof v2 === 'number':null);
var G__19083_19486 = self__.buf;
var G__19084_19487 = ((G__19095_19482)?v1.buf:null);
var G__19085_19488 = ((G__19096_19483)?v2.buf:null);
var G__19086_19489 = (G__19083_19486[(0)]);
var G__19087_19490 = (G__19083_19486[(1)]);
var G__19088_19491 = (G__19083_19486[(2)]);
var G__19089_19492 = ((G__19095_19482)?(G__19084_19487[(0)]):(cljs.core.truth_(G__19097_19484)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__19090_19493 = ((G__19095_19482)?(G__19084_19487[(1)]):(cljs.core.truth_(G__19097_19484)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__19091_19494 = ((G__19095_19482)?(G__19084_19487[(2)]):(cljs.core.truth_(G__19097_19484)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__19092_19495 = ((G__19096_19483)?(G__19085_19488[(0)]):(cljs.core.truth_(G__19098_19485)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__19093_19496 = ((G__19096_19483)?(G__19085_19488[(1)]):(cljs.core.truth_(G__19098_19485)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__19094_19497 = ((G__19096_19483)?(G__19085_19488[(2)]):(cljs.core.truth_(G__19098_19485)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__13368__auto__[(0)] = ((G__19086_19489 + G__19089_19492) + G__19092_19495));

(dest__13368__auto__[(1)] = ((G__19087_19490 + G__19090_19493) + G__19093_19496));

(dest__13368__auto__[(2)] = ((G__19088_19491 + G__19091_19494) + G__19094_19497));

return (new thi.ng.geom.vector.Vec3(dest__13368__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__19099 = self__.buf;
var dest__13346__auto__ = (new Float32Array((3)));
(dest__13346__auto__[(0)] = ((G__19099[(0)]) + x));

(dest__13346__auto__[(1)] = ((G__19099[(1)]) + y));

(dest__13346__auto__[(2)] = ((G__19099[(2)]) + z));

return (new thi.ng.geom.vector.Vec3(dest__13346__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$abs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__13340__auto__ = (new Float32Array((3)));
var G__19100_19498 = self__.buf;
(dest__13340__auto__[(0)] = thi.ng.math.core.abs_STAR_.call(null,(G__19100_19498[(0)])));

(dest__13340__auto__[(1)] = thi.ng.math.core.abs_STAR_.call(null,(G__19100_19498[(1)])));

(dest__13340__auto__[(2)] = thi.ng.math.core.abs_STAR_.call(null,(G__19100_19498[(2)])));

return (new thi.ng.geom.vector.Vec3(dest__13340__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$subm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__13368__auto__ = (new Float32Array((3)));
var G__19113_19499 = (a instanceof thi.ng.geom.vector.Vec3);
var G__19114_19500 = (b instanceof thi.ng.geom.vector.Vec3);
var G__19115_19501 = (((!(G__19113_19499)))?typeof a === 'number':null);
var G__19116_19502 = (((!(G__19114_19500)))?typeof b === 'number':null);
var G__19101_19503 = self__.buf;
var G__19102_19504 = ((G__19113_19499)?a.buf:null);
var G__19103_19505 = ((G__19114_19500)?b.buf:null);
var G__19104_19506 = (G__19101_19503[(0)]);
var G__19105_19507 = (G__19101_19503[(1)]);
var G__19106_19508 = (G__19101_19503[(2)]);
var G__19107_19509 = ((G__19113_19499)?(G__19102_19504[(0)]):(cljs.core.truth_(G__19115_19501)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__19108_19510 = ((G__19113_19499)?(G__19102_19504[(1)]):(cljs.core.truth_(G__19115_19501)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__19109_19511 = ((G__19113_19499)?(G__19102_19504[(2)]):(cljs.core.truth_(G__19115_19501)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__19110_19512 = ((G__19114_19500)?(G__19103_19505[(0)]):(cljs.core.truth_(G__19116_19502)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__19111_19513 = ((G__19114_19500)?(G__19103_19505[(1)]):(cljs.core.truth_(G__19116_19502)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__19112_19514 = ((G__19114_19500)?(G__19103_19505[(2)]):(cljs.core.truth_(G__19116_19502)?b:cljs.core.nth.call(null,b,(2),1.0)));
(dest__13368__auto__[(0)] = ((G__19104_19506 - G__19107_19509) * G__19110_19512));

(dest__13368__auto__[(1)] = ((G__19105_19507 - G__19108_19510) * G__19111_19513));

(dest__13368__auto__[(2)] = ((G__19106_19508 - G__19109_19511) * G__19112_19514));

return (new thi.ng.geom.vector.Vec3(dest__13368__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"buf","buf",1426618187,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

thi.ng.geom.vector.Vec3.cljs$lang$type = true;

thi.ng.geom.vector.Vec3.cljs$lang$ctorStr = "thi.ng.geom.vector/Vec3";

thi.ng.geom.vector.Vec3.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"thi.ng.geom.vector/Vec3");
});

/**
 * Positional factory function for thi.ng.geom.vector/Vec3.
 */
thi.ng.geom.vector.__GT_Vec3 = (function thi$ng$geom$vector$__GT_Vec3(buf,_hash,_meta){
return (new thi.ng.geom.vector.Vec3(buf,_hash,_meta));
});

thi.ng.geom.vector.x = (function thi$ng$geom$vector$x(G__19517){
var G__19515 = (((G__19517 instanceof thi.ng.geom.vector.Vec2))?G__19517.buf:G__19517.buf);
return (G__19515[(0)]);
});
thi.ng.geom.vector.xx = (function thi$ng$geom$vector$xx(G__19520){
var G__19518 = (((G__19520 instanceof thi.ng.geom.vector.Vec2))?G__19520.buf:G__19520.buf);
var G__19519 = (new Float32Array(2));
(G__19519[(0)] = (G__19518[(0)]));

(G__19519[(1)] = (G__19518[(0)]));

return (new thi.ng.geom.vector.Vec2(G__19519,null,cljs.core.meta.call(null,G__19520)));
});
thi.ng.geom.vector.xxx = (function thi$ng$geom$vector$xxx(G__19523){
var G__19521 = (((G__19523 instanceof thi.ng.geom.vector.Vec2))?G__19523.buf:G__19523.buf);
var G__19522 = (new Float32Array(3));
(G__19522[(0)] = (G__19521[(0)]));

(G__19522[(1)] = (G__19521[(0)]));

(G__19522[(2)] = (G__19521[(0)]));

return (new thi.ng.geom.vector.Vec3(G__19522,null,cljs.core.meta.call(null,G__19523)));
});
thi.ng.geom.vector.xxy = (function thi$ng$geom$vector$xxy(G__19526){
var G__19524 = (((G__19526 instanceof thi.ng.geom.vector.Vec2))?G__19526.buf:G__19526.buf);
var G__19525 = (new Float32Array(3));
(G__19525[(0)] = (G__19524[(0)]));

(G__19525[(1)] = (G__19524[(0)]));

(G__19525[(2)] = (G__19524[(1)]));

return (new thi.ng.geom.vector.Vec3(G__19525,null,cljs.core.meta.call(null,G__19526)));
});
thi.ng.geom.vector.xxz = (function thi$ng$geom$vector$xxz(G__19529){
var G__19527 = (((G__19529 instanceof thi.ng.geom.vector.Vec2))?G__19529.buf:G__19529.buf);
var G__19528 = (new Float32Array(3));
(G__19528[(0)] = (G__19527[(0)]));

(G__19528[(1)] = (G__19527[(0)]));

(G__19528[(2)] = (G__19527[(2)]));

return (new thi.ng.geom.vector.Vec3(G__19528,null,cljs.core.meta.call(null,G__19529)));
});
thi.ng.geom.vector.xy = (function thi$ng$geom$vector$xy(G__19532){
var G__19530 = (((G__19532 instanceof thi.ng.geom.vector.Vec2))?G__19532.buf:G__19532.buf);
var G__19531 = (new Float32Array(2));
(G__19531[(0)] = (G__19530[(0)]));

(G__19531[(1)] = (G__19530[(1)]));

return (new thi.ng.geom.vector.Vec2(G__19531,null,cljs.core.meta.call(null,G__19532)));
});
thi.ng.geom.vector.xyx = (function thi$ng$geom$vector$xyx(G__19535){
var G__19533 = (((G__19535 instanceof thi.ng.geom.vector.Vec2))?G__19535.buf:G__19535.buf);
var G__19534 = (new Float32Array(3));
(G__19534[(0)] = (G__19533[(0)]));

(G__19534[(1)] = (G__19533[(1)]));

(G__19534[(2)] = (G__19533[(0)]));

return (new thi.ng.geom.vector.Vec3(G__19534,null,cljs.core.meta.call(null,G__19535)));
});
thi.ng.geom.vector.xyy = (function thi$ng$geom$vector$xyy(G__19538){
var G__19536 = (((G__19538 instanceof thi.ng.geom.vector.Vec2))?G__19538.buf:G__19538.buf);
var G__19537 = (new Float32Array(3));
(G__19537[(0)] = (G__19536[(0)]));

(G__19537[(1)] = (G__19536[(1)]));

(G__19537[(2)] = (G__19536[(1)]));

return (new thi.ng.geom.vector.Vec3(G__19537,null,cljs.core.meta.call(null,G__19538)));
});
thi.ng.geom.vector.xyz = (function thi$ng$geom$vector$xyz(G__19541){
var G__19539 = (((G__19541 instanceof thi.ng.geom.vector.Vec2))?G__19541.buf:G__19541.buf);
var G__19540 = (new Float32Array(3));
(G__19540[(0)] = (G__19539[(0)]));

(G__19540[(1)] = (G__19539[(1)]));

(G__19540[(2)] = (G__19539[(2)]));

return (new thi.ng.geom.vector.Vec3(G__19540,null,cljs.core.meta.call(null,G__19541)));
});
thi.ng.geom.vector.xz = (function thi$ng$geom$vector$xz(G__19544){
var G__19542 = (((G__19544 instanceof thi.ng.geom.vector.Vec2))?G__19544.buf:G__19544.buf);
var G__19543 = (new Float32Array(2));
(G__19543[(0)] = (G__19542[(0)]));

(G__19543[(1)] = (G__19542[(2)]));

return (new thi.ng.geom.vector.Vec2(G__19543,null,cljs.core.meta.call(null,G__19544)));
});
thi.ng.geom.vector.xzx = (function thi$ng$geom$vector$xzx(G__19547){
var G__19545 = (((G__19547 instanceof thi.ng.geom.vector.Vec2))?G__19547.buf:G__19547.buf);
var G__19546 = (new Float32Array(3));
(G__19546[(0)] = (G__19545[(0)]));

(G__19546[(1)] = (G__19545[(2)]));

(G__19546[(2)] = (G__19545[(0)]));

return (new thi.ng.geom.vector.Vec3(G__19546,null,cljs.core.meta.call(null,G__19547)));
});
thi.ng.geom.vector.xzy = (function thi$ng$geom$vector$xzy(G__19550){
var G__19548 = (((G__19550 instanceof thi.ng.geom.vector.Vec2))?G__19550.buf:G__19550.buf);
var G__19549 = (new Float32Array(3));
(G__19549[(0)] = (G__19548[(0)]));

(G__19549[(1)] = (G__19548[(2)]));

(G__19549[(2)] = (G__19548[(1)]));

return (new thi.ng.geom.vector.Vec3(G__19549,null,cljs.core.meta.call(null,G__19550)));
});
thi.ng.geom.vector.xzz = (function thi$ng$geom$vector$xzz(G__19553){
var G__19551 = (((G__19553 instanceof thi.ng.geom.vector.Vec2))?G__19553.buf:G__19553.buf);
var G__19552 = (new Float32Array(3));
(G__19552[(0)] = (G__19551[(0)]));

(G__19552[(1)] = (G__19551[(2)]));

(G__19552[(2)] = (G__19551[(2)]));

return (new thi.ng.geom.vector.Vec3(G__19552,null,cljs.core.meta.call(null,G__19553)));
});
thi.ng.geom.vector.y = (function thi$ng$geom$vector$y(G__19556){
var G__19554 = (((G__19556 instanceof thi.ng.geom.vector.Vec2))?G__19556.buf:G__19556.buf);
return (G__19554[(1)]);
});
thi.ng.geom.vector.yx = (function thi$ng$geom$vector$yx(G__19559){
var G__19557 = (((G__19559 instanceof thi.ng.geom.vector.Vec2))?G__19559.buf:G__19559.buf);
var G__19558 = (new Float32Array(2));
(G__19558[(0)] = (G__19557[(1)]));

(G__19558[(1)] = (G__19557[(0)]));

return (new thi.ng.geom.vector.Vec2(G__19558,null,cljs.core.meta.call(null,G__19559)));
});
thi.ng.geom.vector.yxx = (function thi$ng$geom$vector$yxx(G__19562){
var G__19560 = (((G__19562 instanceof thi.ng.geom.vector.Vec2))?G__19562.buf:G__19562.buf);
var G__19561 = (new Float32Array(3));
(G__19561[(0)] = (G__19560[(1)]));

(G__19561[(1)] = (G__19560[(0)]));

(G__19561[(2)] = (G__19560[(0)]));

return (new thi.ng.geom.vector.Vec3(G__19561,null,cljs.core.meta.call(null,G__19562)));
});
thi.ng.geom.vector.yxy = (function thi$ng$geom$vector$yxy(G__19565){
var G__19563 = (((G__19565 instanceof thi.ng.geom.vector.Vec2))?G__19565.buf:G__19565.buf);
var G__19564 = (new Float32Array(3));
(G__19564[(0)] = (G__19563[(1)]));

(G__19564[(1)] = (G__19563[(0)]));

(G__19564[(2)] = (G__19563[(1)]));

return (new thi.ng.geom.vector.Vec3(G__19564,null,cljs.core.meta.call(null,G__19565)));
});
thi.ng.geom.vector.yxz = (function thi$ng$geom$vector$yxz(G__19568){
var G__19566 = (((G__19568 instanceof thi.ng.geom.vector.Vec2))?G__19568.buf:G__19568.buf);
var G__19567 = (new Float32Array(3));
(G__19567[(0)] = (G__19566[(1)]));

(G__19567[(1)] = (G__19566[(0)]));

(G__19567[(2)] = (G__19566[(2)]));

return (new thi.ng.geom.vector.Vec3(G__19567,null,cljs.core.meta.call(null,G__19568)));
});
thi.ng.geom.vector.yy = (function thi$ng$geom$vector$yy(G__19571){
var G__19569 = (((G__19571 instanceof thi.ng.geom.vector.Vec2))?G__19571.buf:G__19571.buf);
var G__19570 = (new Float32Array(2));
(G__19570[(0)] = (G__19569[(1)]));

(G__19570[(1)] = (G__19569[(1)]));

return (new thi.ng.geom.vector.Vec2(G__19570,null,cljs.core.meta.call(null,G__19571)));
});
thi.ng.geom.vector.yyx = (function thi$ng$geom$vector$yyx(G__19574){
var G__19572 = (((G__19574 instanceof thi.ng.geom.vector.Vec2))?G__19574.buf:G__19574.buf);
var G__19573 = (new Float32Array(3));
(G__19573[(0)] = (G__19572[(1)]));

(G__19573[(1)] = (G__19572[(1)]));

(G__19573[(2)] = (G__19572[(0)]));

return (new thi.ng.geom.vector.Vec3(G__19573,null,cljs.core.meta.call(null,G__19574)));
});
thi.ng.geom.vector.yyy = (function thi$ng$geom$vector$yyy(G__19577){
var G__19575 = (((G__19577 instanceof thi.ng.geom.vector.Vec2))?G__19577.buf:G__19577.buf);
var G__19576 = (new Float32Array(3));
(G__19576[(0)] = (G__19575[(1)]));

(G__19576[(1)] = (G__19575[(1)]));

(G__19576[(2)] = (G__19575[(1)]));

return (new thi.ng.geom.vector.Vec3(G__19576,null,cljs.core.meta.call(null,G__19577)));
});
thi.ng.geom.vector.yyz = (function thi$ng$geom$vector$yyz(G__19580){
var G__19578 = (((G__19580 instanceof thi.ng.geom.vector.Vec2))?G__19580.buf:G__19580.buf);
var G__19579 = (new Float32Array(3));
(G__19579[(0)] = (G__19578[(1)]));

(G__19579[(1)] = (G__19578[(1)]));

(G__19579[(2)] = (G__19578[(2)]));

return (new thi.ng.geom.vector.Vec3(G__19579,null,cljs.core.meta.call(null,G__19580)));
});
thi.ng.geom.vector.yz = (function thi$ng$geom$vector$yz(G__19583){
var G__19581 = (((G__19583 instanceof thi.ng.geom.vector.Vec2))?G__19583.buf:G__19583.buf);
var G__19582 = (new Float32Array(2));
(G__19582[(0)] = (G__19581[(1)]));

(G__19582[(1)] = (G__19581[(2)]));

return (new thi.ng.geom.vector.Vec2(G__19582,null,cljs.core.meta.call(null,G__19583)));
});
thi.ng.geom.vector.yzx = (function thi$ng$geom$vector$yzx(G__19586){
var G__19584 = (((G__19586 instanceof thi.ng.geom.vector.Vec2))?G__19586.buf:G__19586.buf);
var G__19585 = (new Float32Array(3));
(G__19585[(0)] = (G__19584[(1)]));

(G__19585[(1)] = (G__19584[(2)]));

(G__19585[(2)] = (G__19584[(0)]));

return (new thi.ng.geom.vector.Vec3(G__19585,null,cljs.core.meta.call(null,G__19586)));
});
thi.ng.geom.vector.yzy = (function thi$ng$geom$vector$yzy(G__19589){
var G__19587 = (((G__19589 instanceof thi.ng.geom.vector.Vec2))?G__19589.buf:G__19589.buf);
var G__19588 = (new Float32Array(3));
(G__19588[(0)] = (G__19587[(1)]));

(G__19588[(1)] = (G__19587[(2)]));

(G__19588[(2)] = (G__19587[(1)]));

return (new thi.ng.geom.vector.Vec3(G__19588,null,cljs.core.meta.call(null,G__19589)));
});
thi.ng.geom.vector.yzz = (function thi$ng$geom$vector$yzz(G__19592){
var G__19590 = (((G__19592 instanceof thi.ng.geom.vector.Vec2))?G__19592.buf:G__19592.buf);
var G__19591 = (new Float32Array(3));
(G__19591[(0)] = (G__19590[(1)]));

(G__19591[(1)] = (G__19590[(2)]));

(G__19591[(2)] = (G__19590[(2)]));

return (new thi.ng.geom.vector.Vec3(G__19591,null,cljs.core.meta.call(null,G__19592)));
});
thi.ng.geom.vector.z = (function thi$ng$geom$vector$z(G__19595){
var G__19593 = (((G__19595 instanceof thi.ng.geom.vector.Vec2))?G__19595.buf:G__19595.buf);
return (G__19593[(2)]);
});
thi.ng.geom.vector.zx = (function thi$ng$geom$vector$zx(G__19598){
var G__19596 = (((G__19598 instanceof thi.ng.geom.vector.Vec2))?G__19598.buf:G__19598.buf);
var G__19597 = (new Float32Array(2));
(G__19597[(0)] = (G__19596[(2)]));

(G__19597[(1)] = (G__19596[(0)]));

return (new thi.ng.geom.vector.Vec2(G__19597,null,cljs.core.meta.call(null,G__19598)));
});
thi.ng.geom.vector.zxx = (function thi$ng$geom$vector$zxx(G__19601){
var G__19599 = (((G__19601 instanceof thi.ng.geom.vector.Vec2))?G__19601.buf:G__19601.buf);
var G__19600 = (new Float32Array(3));
(G__19600[(0)] = (G__19599[(2)]));

(G__19600[(1)] = (G__19599[(0)]));

(G__19600[(2)] = (G__19599[(0)]));

return (new thi.ng.geom.vector.Vec3(G__19600,null,cljs.core.meta.call(null,G__19601)));
});
thi.ng.geom.vector.zxy = (function thi$ng$geom$vector$zxy(G__19604){
var G__19602 = (((G__19604 instanceof thi.ng.geom.vector.Vec2))?G__19604.buf:G__19604.buf);
var G__19603 = (new Float32Array(3));
(G__19603[(0)] = (G__19602[(2)]));

(G__19603[(1)] = (G__19602[(0)]));

(G__19603[(2)] = (G__19602[(1)]));

return (new thi.ng.geom.vector.Vec3(G__19603,null,cljs.core.meta.call(null,G__19604)));
});
thi.ng.geom.vector.zxz = (function thi$ng$geom$vector$zxz(G__19607){
var G__19605 = (((G__19607 instanceof thi.ng.geom.vector.Vec2))?G__19607.buf:G__19607.buf);
var G__19606 = (new Float32Array(3));
(G__19606[(0)] = (G__19605[(2)]));

(G__19606[(1)] = (G__19605[(0)]));

(G__19606[(2)] = (G__19605[(2)]));

return (new thi.ng.geom.vector.Vec3(G__19606,null,cljs.core.meta.call(null,G__19607)));
});
thi.ng.geom.vector.zy = (function thi$ng$geom$vector$zy(G__19610){
var G__19608 = (((G__19610 instanceof thi.ng.geom.vector.Vec2))?G__19610.buf:G__19610.buf);
var G__19609 = (new Float32Array(2));
(G__19609[(0)] = (G__19608[(2)]));

(G__19609[(1)] = (G__19608[(1)]));

return (new thi.ng.geom.vector.Vec2(G__19609,null,cljs.core.meta.call(null,G__19610)));
});
thi.ng.geom.vector.zyx = (function thi$ng$geom$vector$zyx(G__19613){
var G__19611 = (((G__19613 instanceof thi.ng.geom.vector.Vec2))?G__19613.buf:G__19613.buf);
var G__19612 = (new Float32Array(3));
(G__19612[(0)] = (G__19611[(2)]));

(G__19612[(1)] = (G__19611[(1)]));

(G__19612[(2)] = (G__19611[(0)]));

return (new thi.ng.geom.vector.Vec3(G__19612,null,cljs.core.meta.call(null,G__19613)));
});
thi.ng.geom.vector.zyy = (function thi$ng$geom$vector$zyy(G__19616){
var G__19614 = (((G__19616 instanceof thi.ng.geom.vector.Vec2))?G__19616.buf:G__19616.buf);
var G__19615 = (new Float32Array(3));
(G__19615[(0)] = (G__19614[(2)]));

(G__19615[(1)] = (G__19614[(1)]));

(G__19615[(2)] = (G__19614[(1)]));

return (new thi.ng.geom.vector.Vec3(G__19615,null,cljs.core.meta.call(null,G__19616)));
});
thi.ng.geom.vector.zyz = (function thi$ng$geom$vector$zyz(G__19619){
var G__19617 = (((G__19619 instanceof thi.ng.geom.vector.Vec2))?G__19619.buf:G__19619.buf);
var G__19618 = (new Float32Array(3));
(G__19618[(0)] = (G__19617[(2)]));

(G__19618[(1)] = (G__19617[(1)]));

(G__19618[(2)] = (G__19617[(2)]));

return (new thi.ng.geom.vector.Vec3(G__19618,null,cljs.core.meta.call(null,G__19619)));
});
thi.ng.geom.vector.zz = (function thi$ng$geom$vector$zz(G__19622){
var G__19620 = (((G__19622 instanceof thi.ng.geom.vector.Vec2))?G__19622.buf:G__19622.buf);
var G__19621 = (new Float32Array(2));
(G__19621[(0)] = (G__19620[(2)]));

(G__19621[(1)] = (G__19620[(2)]));

return (new thi.ng.geom.vector.Vec2(G__19621,null,cljs.core.meta.call(null,G__19622)));
});
thi.ng.geom.vector.zzx = (function thi$ng$geom$vector$zzx(G__19625){
var G__19623 = (((G__19625 instanceof thi.ng.geom.vector.Vec2))?G__19625.buf:G__19625.buf);
var G__19624 = (new Float32Array(3));
(G__19624[(0)] = (G__19623[(2)]));

(G__19624[(1)] = (G__19623[(2)]));

(G__19624[(2)] = (G__19623[(0)]));

return (new thi.ng.geom.vector.Vec3(G__19624,null,cljs.core.meta.call(null,G__19625)));
});
thi.ng.geom.vector.zzy = (function thi$ng$geom$vector$zzy(G__19628){
var G__19626 = (((G__19628 instanceof thi.ng.geom.vector.Vec2))?G__19628.buf:G__19628.buf);
var G__19627 = (new Float32Array(3));
(G__19627[(0)] = (G__19626[(2)]));

(G__19627[(1)] = (G__19626[(2)]));

(G__19627[(2)] = (G__19626[(1)]));

return (new thi.ng.geom.vector.Vec3(G__19627,null,cljs.core.meta.call(null,G__19628)));
});
thi.ng.geom.vector.zzz = (function thi$ng$geom$vector$zzz(G__19631){
var G__19629 = (((G__19631 instanceof thi.ng.geom.vector.Vec2))?G__19631.buf:G__19631.buf);
var G__19630 = (new Float32Array(3));
(G__19630[(0)] = (G__19629[(2)]));

(G__19630[(1)] = (G__19629[(2)]));

(G__19630[(2)] = (G__19629[(2)]));

return (new thi.ng.geom.vector.Vec3(G__19630,null,cljs.core.meta.call(null,G__19631)));
});
thi.ng.geom.vector.swizzle2_fns = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"x","x",2099068185),thi.ng.geom.vector.x,new cljs.core.Keyword(null,"xx","xx",-1542203733),thi.ng.geom.vector.xx,new cljs.core.Keyword(null,"xy","xy",-696978232),thi.ng.geom.vector.xy,new cljs.core.Keyword(null,"y","y",-1757859776),thi.ng.geom.vector.y,new cljs.core.Keyword(null,"yx","yx",1696579752),thi.ng.geom.vector.yx,new cljs.core.Keyword(null,"yy","yy",-1432012814),thi.ng.geom.vector.yy], null);
thi.ng.geom.vector.swizzle3_fns = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"xzx","xzx",-1000197983),new cljs.core.Keyword(null,"xyz","xyz",-1605570015),new cljs.core.Keyword(null,"zzy","zzy",-874287326),new cljs.core.Keyword(null,"yx","yx",1696579752),new cljs.core.Keyword(null,"xy","xy",-696978232),new cljs.core.Keyword(null,"yyz","yyz",1133968296),new cljs.core.Keyword(null,"zxy","zxy",-1258840183),new cljs.core.Keyword(null,"xzy","xzy",1043177385),new cljs.core.Keyword(null,"zxz","zxz",1026042602),new cljs.core.Keyword(null,"zx","zx",-933582998),new cljs.core.Keyword(null,"xx","xx",-1542203733),new cljs.core.Keyword(null,"xxx","xxx",-1019301908),new cljs.core.Keyword(null,"zy","zy",-1975963090),new cljs.core.Keyword(null,"zzx","zzx",20750383),new cljs.core.Keyword(null,"zyx","zyx",1752527951),new cljs.core.Keyword(null,"yzx","yzx",-1496223025),new cljs.core.Keyword(null,"z","z",-789527183),new cljs.core.Keyword(null,"yyx","yyx",-1318218191),new cljs.core.Keyword(null,"xz","xz",426487154),new cljs.core.Keyword(null,"zyz","zyz",-1838068142),new cljs.core.Keyword(null,"yy","yy",-1432012814),new cljs.core.Keyword(null,"xxz","xxz",129827699),new cljs.core.Keyword(null,"yzy","yzy",-179510251),new cljs.core.Keyword(null,"yz","yz",679015029),new cljs.core.Keyword(null,"yxx","yxx",-332290091),new cljs.core.Keyword(null,"xyy","xyy",996073014),new cljs.core.Keyword(null,"xxy","xxy",-650102026),new cljs.core.Keyword(null,"zz","zz",122901783),new cljs.core.Keyword(null,"zzz","zzz",-77420552),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"xzz","xzz",-643126693),new cljs.core.Keyword(null,"yxz","yxz",1786796508),new cljs.core.Keyword(null,"zxx","zxx",-61980804),new cljs.core.Keyword(null,"yzz","yzz",-1034441732),new cljs.core.Keyword(null,"xyx","xyx",1899467293),new cljs.core.Keyword(null,"yxy","yxy",1369901661),new cljs.core.Keyword(null,"yyy","yyy",780595422),new cljs.core.Keyword(null,"zyy","zyy",1946268991)],[thi.ng.geom.vector.y,thi.ng.geom.vector.xzx,thi.ng.geom.vector.xyz,thi.ng.geom.vector.zzy,thi.ng.geom.vector.yx,thi.ng.geom.vector.xy,thi.ng.geom.vector.yyz,thi.ng.geom.vector.zxy,thi.ng.geom.vector.xzy,thi.ng.geom.vector.zxz,thi.ng.geom.vector.zx,thi.ng.geom.vector.xx,thi.ng.geom.vector.xxx,thi.ng.geom.vector.zy,thi.ng.geom.vector.zzx,thi.ng.geom.vector.zyx,thi.ng.geom.vector.yzx,thi.ng.geom.vector.z,thi.ng.geom.vector.yyx,thi.ng.geom.vector.xz,thi.ng.geom.vector.zyz,thi.ng.geom.vector.yy,thi.ng.geom.vector.xxz,thi.ng.geom.vector.yzy,thi.ng.geom.vector.yz,thi.ng.geom.vector.yxx,thi.ng.geom.vector.xyy,thi.ng.geom.vector.xxy,thi.ng.geom.vector.zz,thi.ng.geom.vector.zzz,thi.ng.geom.vector.x,thi.ng.geom.vector.xzz,thi.ng.geom.vector.yxz,thi.ng.geom.vector.zxx,thi.ng.geom.vector.yzz,thi.ng.geom.vector.xyx,thi.ng.geom.vector.yxy,thi.ng.geom.vector.yyy,thi.ng.geom.vector.zyy]);
thi.ng.geom.vector.swizzle_assoc_STAR_ = (function thi$ng$geom$vector$swizzle_assoc_STAR_(src,dest,keymap,k,v){
var n = cljs.core.name.call(null,k);
var c = cljs.core.count.call(null,n);
var temp__5802__auto__ = (function (){var and__4120__auto__ = ((1) === c);
if(and__4120__auto__){
return keymap.call(null,cljs.core.first.call(null,n));
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var idx = temp__5802__auto__;
(dest[(idx | (0))] = v);

return dest;
} else {
if((((c <= cljs.core.count.call(null,keymap))) && ((((c === cljs.core.count.call(null,v))) && ((cljs.core.count.call(null,v) === cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,n)))))))){
var i = (0);
var n__$1 = n;
while(true){
if(cljs.core.truth_(n__$1)){
var temp__5802__auto____$1 = keymap.call(null,cljs.core.first.call(null,n__$1));
if(cljs.core.truth_(temp__5802__auto____$1)){
var idx = temp__5802__auto____$1;
(dest[(idx | (0))] = v.call(null,i));

var G__19632 = (i + (1));
var G__19633 = cljs.core.next.call(null,n__$1);
i = G__19632;
n__$1 = G__19633;
continue;
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
return dest;
}
break;
}
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});
thi.ng.geom.vector.vec2_reduce_STAR_ = (function thi$ng$geom$vector$vec2_reduce_STAR_(op,acc,xs){
return cljs.core.transduce.call(null,cljs.core.map.call(null,(function (x){
return x.buf;
})),(function() {
var G__19634 = null;
var G__19634__1 = (function (a){
return a;
});
var G__19634__2 = (function (a,b){
(a[(0)] = op.call(null,(a[(0)]),(b[(0)])));

(a[(1)] = op.call(null,(a[(1)]),(b[(1)])));

return a;
});
G__19634 = function(a,b){
switch(arguments.length){
case 1:
return G__19634__1.call(this,a);
case 2:
return G__19634__2.call(this,a,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19634.cljs$core$IFn$_invoke$arity$1 = G__19634__1;
G__19634.cljs$core$IFn$_invoke$arity$2 = G__19634__2;
return G__19634;
})()
,acc,xs);
});
thi.ng.geom.vector.vec3_reduce_STAR_ = (function thi$ng$geom$vector$vec3_reduce_STAR_(op,acc,xs){
return cljs.core.transduce.call(null,cljs.core.map.call(null,(function (x){
return x.buf;
})),(function() {
var G__19635 = null;
var G__19635__1 = (function (a){
return a;
});
var G__19635__2 = (function (a,b){
(a[(0)] = op.call(null,(a[(0)]),(b[(0)])));

(a[(1)] = op.call(null,(a[(1)]),(b[(1)])));

(a[(2)] = op.call(null,(a[(2)]),(b[(2)])));

return a;
});
G__19635 = function(a,b){
switch(arguments.length){
case 1:
return G__19635__1.call(this,a);
case 2:
return G__19635__2.call(this,a,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19635.cljs$core$IFn$_invoke$arity$1 = G__19635__1;
G__19635.cljs$core$IFn$_invoke$arity$2 = G__19635__2;
return G__19635;
})()
,acc,xs);
});
thi.ng.geom.vector.V2 = (new thi.ng.geom.vector.Vec2((new Float32Array((2))),null,null));
thi.ng.geom.vector.V3 = (new thi.ng.geom.vector.Vec3((new Float32Array((3))),null,null));
thi.ng.geom.vector.vec2 = (function thi$ng$geom$vector$vec2(var_args){
var G__19637 = arguments.length;
switch (G__19637) {
case 0:
return thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.geom.vector.V2;
});

thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$1 = (function (v){
if((v instanceof thi.ng.geom.vector.Vec2)){
return v;
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec2.call(null,v,v);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0));
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),(0)),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),(0)));
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec2",v);

}
}
}
}
});

thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var b = (new Float32Array((2)));
(b[(0)] = x);

(b[(1)] = y);

return (new thi.ng.geom.vector.Vec2(b,null,null));
});

thi.ng.geom.vector.vec2.cljs$lang$maxFixedArity = 2;

thi.ng.geom.vector.vec3 = (function thi$ng$geom$vector$vec3(var_args){
var G__19640 = arguments.length;
switch (G__19640) {
case 0:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.geom.vector.V3;
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$1 = (function (v){
if((v instanceof thi.ng.geom.vector.Vec3)){
return v;
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec3.call(null,v,v,v);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),cljs.core.nth.call(null,v,(2),0.0));
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"z","z",-789527183),0.0));
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec3",v);

}
}
}
}
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$2 = (function (v,z){
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),z);
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),z);
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec3.call(null,v,z,(0));
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec3",v);

}
}
}
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$3 = (function (x,y,z){
var b = (new Float32Array((3)));
(b[(0)] = x);

(b[(1)] = y);

(b[(2)] = z);

return (new thi.ng.geom.vector.Vec3(b,null,null));
});

thi.ng.geom.vector.vec3.cljs$lang$maxFixedArity = 3;

thi.ng.geom.vector.vec2_with_meta = (function thi$ng$geom$vector$vec2_with_meta(var_args){
var G__19643 = arguments.length;
switch (G__19643) {
case 2:
return thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$2 = (function (v,meta){
if((v instanceof thi.ng.geom.vector.Vec2)){
return cljs.core.with_meta.call(null,v,meta);
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec2_with_meta.call(null,v,v,meta);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2_with_meta.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),meta);
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2_with_meta.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),meta);
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec2",v);

}
}
}
}
});

thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$3 = (function (x,y,meta){
var b = (new Float32Array((2)));
(b[(0)] = x);

(b[(1)] = y);

return (new thi.ng.geom.vector.Vec2(b,null,meta));
});

thi.ng.geom.vector.vec2_with_meta.cljs$lang$maxFixedArity = 3;

thi.ng.geom.vector.vec3_with_meta = (function thi$ng$geom$vector$vec3_with_meta(var_args){
var G__19646 = arguments.length;
switch (G__19646) {
case 2:
return thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$2 = (function (v,meta){
if((v instanceof thi.ng.geom.vector.Vec3)){
return cljs.core.with_meta.call(null,v,meta);
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec3_with_meta.call(null,v,v,v,meta);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3_with_meta.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),cljs.core.nth.call(null,v,(2),0.0),meta);
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3_with_meta.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"z","z",-789527183),0.0),meta);
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec3",v);

}
}
}
}
});

thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$4 = (function (x,y,z,meta){
var b = (new Float32Array((3)));
(b[(0)] = x);

(b[(1)] = y);

(b[(2)] = z);

return (new thi.ng.geom.vector.Vec3(b,null,meta));
});

thi.ng.geom.vector.vec3_with_meta.cljs$lang$maxFixedArity = 4;

thi.ng.geom.vector.vec2_QMARK_ = (function thi$ng$geom$vector$vec2_QMARK_(x){
return (x instanceof thi.ng.geom.vector.Vec2);
});
thi.ng.geom.vector.vec3_QMARK_ = (function thi$ng$geom$vector$vec3_QMARK_(x){
return (x instanceof thi.ng.geom.vector.Vec3);
});
thi.ng.geom.vector.V2X = thi.ng.geom.vector.vec2.call(null,(1),(0));
thi.ng.geom.vector.V2Y = thi.ng.geom.vector.vec2.call(null,(0),(1));
thi.ng.geom.vector.V3X = thi.ng.geom.vector.vec3.call(null,(1),(0),(0));
thi.ng.geom.vector.V3Y = thi.ng.geom.vector.vec3.call(null,(0),(1),(0));
thi.ng.geom.vector.V3Z = thi.ng.geom.vector.vec3.call(null,(0),(0),(1));
thi.ng.geom.vector.V2INF_ = thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.INF_);
thi.ng.geom.vector.V2INF_PLUS_ = thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.INF_PLUS_);
thi.ng.geom.vector.V3INF_ = thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.INF_);
thi.ng.geom.vector.V3INF_PLUS_ = thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.INF_PLUS_);
thi.ng.geom.vector.randvec2 = (function thi$ng$geom$vector$randvec2(var_args){
var G__19649 = arguments.length;
switch (G__19649) {
case 0:
return thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)));
});

thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$1 = (function (n){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)),n);
});

thi.ng.geom.vector.randvec2.cljs$lang$maxFixedArity = 1;

thi.ng.geom.vector.randvec3 = (function thi$ng$geom$vector$randvec3(var_args){
var G__19652 = arguments.length;
switch (G__19652) {
case 0:
return thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)));
});

thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$1 = (function (n){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)),n);
});

thi.ng.geom.vector.randvec3.cljs$lang$maxFixedArity = 1;


//# sourceMappingURL=vector.js.map
