/*
 * Decompiled with CFR 0.152.
 */
package clojure.core.matrix.impl.wrappers;

import clojure.core.matrix.protocols.PDimensionInfo;
import clojure.core.matrix.protocols.PImplementation;
import clojure.core.matrix.protocols.PIndexedAccess;
import clojure.core.matrix.protocols.PIndexedSetting;
import clojure.core.matrix.protocols.PIndexedSettingMutable;
import clojure.core.matrix.protocols.PMatrixSlices;
import clojure.core.matrix.protocols.PSliceSeq;
import clojure.core.matrix.protocols.PSubVector;
import clojure.core.matrix.protocols.PZeroDimensionAccess;
import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.IType;
import clojure.lang.Indexed;
import clojure.lang.Keyword;
import clojure.lang.Numbers;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Seqable;
import clojure.lang.Symbol;
import clojure.lang.Util;
import clojure.lang.Var;

public final class NDWrapper
implements Indexed,
PIndexedSettingMutable,
PZeroDimensionAccess,
Seqable,
PImplementation,
PIndexedAccess,
PSubVector,
PDimensionInfo,
PIndexedSetting,
IType {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"str");
    public static final Var const__1 = RT.var((String)"clojure.core.matrix.protocols", (String)"persistent-vector-coerce");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"aget");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"int");
    public static final Object const__4 = 0L;
    public static final Var const__5 = RT.var((String)"clojure.core.matrix.protocols", (String)"get-major-slice");
    public static final Var const__6 = RT.var((String)"clojure.core", (String)"integer?");
    public static final Var const__7 = RT.var((String)"clojure.core", (String)"<=");
    public static final Var const__8 = RT.var((String)"clojure.core", (String)"<");
    public static final Var const__9 = RT.var((String)"clojure.core.matrix.protocols", (String)"get-nd");
    public static final Var const__10 = RT.var((String)"clojure.core.matrix.protocols", (String)"set-nd");
    public static final Var const__11 = RT.var((String)"clojure.core.matrix.protocols", (String)"get-major-slice-seq");
    public static final Var const__12 = RT.var((String)"clojure.core", (String)"alength");
    public static final Var const__13 = RT.var((String)"clojure.core", (String)"==");
    public static final Object const__14 = 1L;
    public static final Var const__15 = RT.var((String)"clojure.core.matrix.utils", (String)"copy-long-array");
    public static final Var const__16 = RT.var((String)"clojure.core", (String)">=");
    public static final Var const__17 = RT.var((String)"clojure.core", (String)"aset");
    public static final Var const__18 = RT.var((String)"clojure.core.matrix.protocols", (String)"set-nd!");
    public static final Var const__19 = RT.var((String)"clojure.core", (String)"long");
    public static final Var const__20 = RT.var((String)"clojure.core", (String)"nth");
    public static final Var const__21 = RT.var((String)"clojure.core", (String)"unchecked-inc");
    public static final Var const__22 = RT.var((String)"clojure.core", (String)"not=");
    public static final Var const__23 = RT.var((String)"clojure.core", (String)"+");
    public static final Var const__24 = RT.var((String)"clojure.core", (String)"long-array");
    public static final Var const__25 = RT.var((String)"clojure.core", (String)">");
    public static final Var const__26 = RT.var((String)"clojure.core.matrix.utils", (String)"long-array-of");
    public static final Var const__27 = RT.var((String)"clojure.core.matrix.utils", (String)"object-array-of");
    public static final Var const__28 = RT.var((String)"clojure.core.matrix.protocols", (String)"is-mutable?");
    public static final Keyword const__29 = RT.keyword(null, (String)"nd-wrapper");
    public static final Keyword const__30 = RT.keyword(null, (String)"doc");
    public static final AFn const__31 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "Wraps an N-dimensional subset or broadcast of an array"});
    public static final Var const__32 = RT.var((String)"clojure.core.matrix.protocols", (String)"new-vector");
    public static final Var const__33 = RT.var((String)"clojure.core.matrix.protocols", (String)"new-matrix");
    public static final Var const__34 = RT.var((String)"clojure.core.matrix.protocols", (String)"new-matrix-nd");
    public static final Var const__35 = RT.var((String)"clojure.core.matrix.protocols", (String)"construct-matrix");
    public final Object array;
    public final Object shape;
    public final Object dim_map;
    public final Object index_maps;
    public final Object source_position;
    private static Class __cached_class__0;
    private static Class __cached_class__1;
    private static Class __cached_class__2;
    private static Class __cached_class__3;
    private static Class __cached_class__4;
    private static Class __cached_class__5;
    private static Class __cached_class__6;
    private static Class __cached_class__7;
    private static Class __cached_class__8;
    private static Class __cached_class__9;
    private static Class __cached_class__10;
    private static Class __cached_class__11;
    private static Class __cached_class__12;
    private static Class __cached_class__13;
    private static Class __cached_class__14;
    private static Class __cached_class__15;

    public NDWrapper(Object object, Object object2, Object object3, Object object4, Object object5) {
        this.array = object;
        this.shape = object2;
        this.dim_map = object3;
        this.index_maps = object4;
        this.source_position = object5;
    }

    public static IPersistentVector getBasis() {
        return RT.vector((Object[])new Object[]{Symbol.intern(null, (String)"array"), ((IObj)Symbol.intern(null, (String)"shape")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"longs")})), ((IObj)Symbol.intern(null, (String)"dim-map")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"longs")})), ((IObj)Symbol.intern(null, (String)"index-maps")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"objects")})), ((IObj)Symbol.intern(null, (String)"source-position")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"longs")}))});
    }

    public Object supports_dimensionality_QMARK_(Object dims) {
        return Boolean.TRUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object construct_matrix(Object data) {
        Object object;
        PersistentVector persistentVector = PersistentVector.EMPTY;
        if (Util.classOf((Object)persistentVector) != __cached_class__15) {
            if (persistentVector instanceof PImplementation) {
                Object object2 = data;
                data = null;
                object = persistentVector.construct_matrix(object2);
                return object;
            }
            persistentVector = persistentVector;
            __cached_class__15 = Util.classOf((Object)persistentVector);
        }
        Object object3 = data;
        data = null;
        object = const__35.getRawRoot().invoke((Object)persistentVector, object3);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object new_matrix_nd(Object dims) {
        Object object;
        PersistentVector persistentVector = PersistentVector.EMPTY;
        if (Util.classOf((Object)persistentVector) != __cached_class__14) {
            if (persistentVector instanceof PImplementation) {
                Object object2 = dims;
                dims = null;
                object = persistentVector.new_matrix_nd(object2);
                return object;
            }
            persistentVector = persistentVector;
            __cached_class__14 = Util.classOf((Object)persistentVector);
        }
        Object object3 = dims;
        dims = null;
        object = const__34.getRawRoot().invoke((Object)persistentVector, object3);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object new_matrix(Object rows2, Object columns2) {
        Object object;
        PersistentVector persistentVector = PersistentVector.EMPTY;
        if (Util.classOf((Object)persistentVector) != __cached_class__13) {
            if (persistentVector instanceof PImplementation) {
                Object object2 = rows2;
                rows2 = null;
                Object object3 = columns2;
                columns2 = null;
                object = persistentVector.new_matrix(object2, object3);
                return object;
            }
            persistentVector = persistentVector;
            __cached_class__13 = Util.classOf((Object)persistentVector);
        }
        Object object4 = rows2;
        rows2 = null;
        Object object5 = columns2;
        columns2 = null;
        object = const__33.getRawRoot().invoke((Object)persistentVector, object4, object5);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object new_vector(Object length2) {
        Object object;
        PersistentVector persistentVector = PersistentVector.EMPTY;
        if (Util.classOf((Object)persistentVector) != __cached_class__12) {
            if (persistentVector instanceof PImplementation) {
                Object object2 = length2;
                length2 = null;
                object = persistentVector.new_vector(object2);
                return object;
            }
            persistentVector = persistentVector;
            __cached_class__12 = Util.classOf((Object)persistentVector);
        }
        Object object3 = length2;
        length2 = null;
        object = const__32.getRawRoot().invoke((Object)persistentVector, object3);
        return object;
    }

    public Object meta_info() {
        return const__31;
    }

    public Object implementation_key() {
        return const__29;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object is_mutable_QMARK_() {
        Object object;
        Object object2 = this.array;
        if (Util.classOf((Object)object2) != __cached_class__11) {
            if (object2 instanceof PIndexedSetting) {
                object = object2.is_mutable_QMARK_();
                return object;
            }
            object2 = object2;
            __cached_class__11 = Util.classOf((Object)object2);
        }
        object = const__28.getRawRoot().invoke(object2);
        return object;
    }

    public Object set_nd(Object indexes, Object v) {
        throw (Throwable)new RuntimeException((String)((IFn)const__0.getRawRoot()).invoke((Object)"TODO: not yet implemented"));
    }

    public Object set_2d(Object x, Object y, Object v) {
        throw (Throwable)new RuntimeException((String)((IFn)const__0.getRawRoot()).invoke((Object)"TODO: not yet implemented"));
    }

    public Object set_1d(Object x, Object v) {
        throw (Throwable)new RuntimeException((String)((IFn)const__0.getRawRoot()).invoke((Object)"TODO: not yet implemented"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object get_nd(Object indexes) {
        Object object;
        Object ix = ((IFn)const__15.getRawRoot()).invoke(this.source_position);
        long n__4379__auto__4532 = ((long[])this.shape).length;
        for (long i = 0L; i < n__4379__auto__4532; ++i) {
            long i4529 = i;
            long tdim__4519__auto__4531 = ((long[])this.dim_map)[(int)i4529];
            if (tdim__4519__auto__4531 < 0L) continue;
            RT.aset((long[])((long[])ix), (int)((int)tdim__4519__auto__4531), (long)((long[])RT.aget((Object[])((Object[])this.index_maps), (int)((int)i4529)))[RT.uncheckedIntCast((Object)RT.nth((Object)indexes, (int)RT.uncheckedIntCast((long)i)))]);
        }
        Object object2 = this.array;
        if (Util.classOf((Object)object2) != __cached_class__10) {
            if (object2 instanceof PIndexedAccess) {
                Object object3 = ix;
                ix = null;
                object = object2.get_nd(object3);
                return object;
            }
            object2 = object2;
            __cached_class__10 = Util.classOf((Object)object2);
        }
        Object object4 = ix;
        ix = null;
        object = const__9.getRawRoot().invoke(object2, object4);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object get_2d(Object row, Object column) {
        Object object;
        Object object2;
        Object ix = ((IFn)const__15.getRawRoot()).invoke(this.source_position);
        long i4527 = 0L;
        long tdim__4519__auto__4533 = ((long[])this.dim_map)[(int)i4527];
        if (tdim__4519__auto__4533 >= 0L) {
            Object object3 = row;
            row = null;
            RT.aset((long[])((long[])ix), (int)((int)tdim__4519__auto__4533), (long)((long[])RT.aget((Object[])((Object[])this.index_maps), (int)((int)i4527)))[RT.uncheckedIntCast((Object)object3)]);
        }
        long i4528 = 1L;
        long tdim__4519__auto__4534 = ((long[])this.dim_map)[(int)i4528];
        if (tdim__4519__auto__4534 >= 0L) {
            Object object4 = column;
            column = null;
            RT.aset((long[])((long[])ix), (int)((int)tdim__4519__auto__4534), (long)((long[])RT.aget((Object[])((Object[])this.index_maps), (int)((int)i4528)))[RT.uncheckedIntCast((Object)object4)]);
        }
        if (Util.classOf((Object)(object2 = this.array)) != __cached_class__9) {
            if (object2 instanceof PIndexedAccess) {
                Object object5 = ix;
                ix = null;
                object = object2.get_nd(object5);
                return object;
            }
            object2 = object2;
            __cached_class__9 = Util.classOf((Object)object2);
        }
        Object object6 = ix;
        ix = null;
        object = const__9.getRawRoot().invoke(object2, object6);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object get_1d(Object row) {
        Object object;
        Object object2;
        Object ix = ((IFn)const__15.getRawRoot()).invoke(this.source_position);
        Object im = RT.aget((Object[])((Object[])this.index_maps), (int)((int)0L));
        long i4526 = 0L;
        long tdim__4519__auto__4535 = ((long[])this.dim_map)[(int)i4526];
        if (tdim__4519__auto__4535 >= 0L) {
            Object object3 = row;
            row = null;
            RT.aset((long[])((long[])ix), (int)((int)tdim__4519__auto__4535), (long)((long[])RT.aget((Object[])((Object[])this.index_maps), (int)((int)i4526)))[RT.uncheckedIntCast((Object)object3)]);
        }
        if (Util.classOf((Object)(object2 = this.array)) != __cached_class__8) {
            if (object2 instanceof PIndexedAccess) {
                Object object4 = ix;
                ix = null;
                object = object2.get_nd(object4);
                return object;
            }
            object2 = object2;
            __cached_class__8 = Util.classOf((Object)object2);
        }
        Object object5 = ix;
        ix = null;
        object = const__9.getRawRoot().invoke(object2, object5);
        return object;
    }

    public Object subvector(Object start, Object length2) {
        Object object = ((IFn)const__22.getRawRoot()).invoke(const__14, (Object)RT.alength((long[])((long[])this.shape)));
        if (object != null && object != Boolean.FALSE) {
            throw (Throwable)new RuntimeException((String)((IFn)const__0.getRawRoot()).invoke((Object)"Can't take subvector: wrong dimensionality = ", (Object)RT.alength((long[])((long[])this.shape))));
        }
        long vlen = ((long[])this.shape)[(int)0L];
        Object object2 = start;
        start = null;
        long start2 = RT.longCast((Object)object2);
        Object object3 = length2;
        length2 = null;
        long length3 = RT.longCast((Object)object3);
        long end = start2 + length3;
        Object old_index_map = RT.aget((Object[])((Object[])this.index_maps), (int)((int)0L));
        long[] new_index_map = Numbers.long_array((Object)Numbers.num((long)length3));
        if (start2 < 0L) {
            throw (Throwable)new RuntimeException((String)((IFn)const__0.getRawRoot()).invoke((Object)"Start index out of bounds: ", (Object)Numbers.num((long)start2)));
        }
        if (end > vlen) {
            throw (Throwable)new RuntimeException((String)((IFn)const__0.getRawRoot()).invoke((Object)"End index out of bounds: ", (Object)Numbers.num((long)end)));
        }
        long n__4379__auto__4536 = length3;
        for (long i = 0L; i < n__4379__auto__4536; ++i) {
            RT.aset((long[])new_index_map, (int)((int)i), (long)((long[])old_index_map)[(int)(start2 + i)]);
        }
        long[] lArray = new_index_map;
        new_index_map = null;
        return new NDWrapper(this.array, ((IFn)const__26.getRawRoot()).invoke((Object)Numbers.num((long)length3)), this.dim_map, ((IFn)const__27.getRawRoot()).invoke((Object)lArray), this.source_position);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object set_nd_BANG_(Object indexes, Object v) {
        Object object;
        Object ix = ((IFn)const__15.getRawRoot()).invoke(this.source_position);
        long n__4379__auto__4538 = ((long[])this.shape).length;
        for (long i = 0L; i < n__4379__auto__4538; ++i) {
            long i4525 = i;
            long tdim__4519__auto__4537 = ((long[])this.dim_map)[(int)i4525];
            if (tdim__4519__auto__4537 < 0L) continue;
            RT.aset((long[])((long[])ix), (int)((int)tdim__4519__auto__4537), (long)((long[])RT.aget((Object[])((Object[])this.index_maps), (int)((int)i4525)))[RT.uncheckedIntCast((Object)RT.nth((Object)indexes, (int)RT.uncheckedIntCast((long)i)))]);
        }
        Object object2 = this.array;
        if (Util.classOf((Object)object2) != __cached_class__7) {
            if (object2 instanceof PIndexedSettingMutable) {
                Object object3 = ix;
                ix = null;
                Object object4 = v;
                v = null;
                object = object2.set_nd_BANG_(object3, object4);
                return object;
            }
            object2 = object2;
            __cached_class__7 = Util.classOf((Object)object2);
        }
        Object object5 = ix;
        ix = null;
        Object object6 = v;
        v = null;
        object = const__18.getRawRoot().invoke(object2, object5, object6);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object set_2d_BANG_(Object row, Object column, Object v) {
        Object object;
        Object object2;
        Object ix = ((IFn)const__15.getRawRoot()).invoke(this.source_position);
        long i4523 = 0L;
        long tdim__4519__auto__4539 = ((long[])this.dim_map)[(int)i4523];
        if (tdim__4519__auto__4539 >= 0L) {
            Object object3 = row;
            row = null;
            RT.aset((long[])((long[])ix), (int)((int)tdim__4519__auto__4539), (long)((long[])RT.aget((Object[])((Object[])this.index_maps), (int)((int)i4523)))[RT.uncheckedIntCast((Object)object3)]);
        }
        long i4524 = 1L;
        long tdim__4519__auto__4540 = ((long[])this.dim_map)[(int)i4524];
        if (tdim__4519__auto__4540 >= 0L) {
            Object object4 = column;
            column = null;
            RT.aset((long[])((long[])ix), (int)((int)tdim__4519__auto__4540), (long)((long[])RT.aget((Object[])((Object[])this.index_maps), (int)((int)i4524)))[RT.uncheckedIntCast((Object)object4)]);
        }
        if (Util.classOf((Object)(object2 = this.array)) != __cached_class__6) {
            if (object2 instanceof PIndexedSettingMutable) {
                Object object5 = ix;
                ix = null;
                Object object6 = v;
                v = null;
                object = object2.set_nd_BANG_(object5, object6);
                return object;
            }
            object2 = object2;
            __cached_class__6 = Util.classOf((Object)object2);
        }
        Object object7 = ix;
        ix = null;
        Object object8 = v;
        v = null;
        object = const__18.getRawRoot().invoke(object2, object7, object8);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object set_1d_BANG_(Object row, Object v) {
        Object object;
        Object object2;
        Object ix = ((IFn)const__15.getRawRoot()).invoke(this.source_position);
        Object im = RT.aget((Object[])((Object[])this.index_maps), (int)((int)0L));
        long i4522 = 0L;
        long tdim__4519__auto__4541 = ((long[])this.dim_map)[(int)i4522];
        if (tdim__4519__auto__4541 >= 0L) {
            Object object3 = row;
            row = null;
            RT.aset((long[])((long[])ix), (int)((int)tdim__4519__auto__4541), (long)((long[])RT.aget((Object[])((Object[])this.index_maps), (int)((int)i4522)))[RT.uncheckedIntCast((Object)object3)]);
        }
        if (Util.classOf((Object)(object2 = this.array)) != __cached_class__5) {
            if (object2 instanceof PIndexedSettingMutable) {
                Object object4 = ix;
                ix = null;
                Object object5 = v;
                v = null;
                object = object2.set_nd_BANG_(object4, object5);
                return object;
            }
            object2 = object2;
            __cached_class__5 = Util.classOf((Object)object2);
        }
        Object object6 = ix;
        ix = null;
        Object object7 = v;
        v = null;
        object = const__18.getRawRoot().invoke(object2, object6, object7);
        return object;
    }

    public Object dimension_count(Object dimension_number) {
        Object object = dimension_number;
        dimension_number = null;
        return Numbers.num((long)RT.aget((long[])((long[])this.shape), (int)RT.uncheckedIntCast((Object)object)));
    }

    public Object is_vector_QMARK_() {
        return Numbers.equiv((long)1L, (long)((long[])this.shape).length) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object is_scalar_QMARK_() {
        return Boolean.FALSE;
    }

    public Object get_shape() {
        return this.shape;
    }

    public Object dimensionality() {
        return RT.alength((long[])((long[])this.shape));
    }

    /*
     * Enabled aggressive block sorting
     */
    public ISeq seq() {
        Object object;
        NDWrapper nDWrapper = this;
        if (Util.classOf((Object)nDWrapper) != __cached_class__4) {
            if (nDWrapper instanceof PSliceSeq) {
                object = nDWrapper.get_major_slice_seq();
                return (ISeq)object;
            }
            nDWrapper = nDWrapper;
            __cached_class__4 = Util.classOf((Object)nDWrapper);
        }
        object = const__11.getRawRoot().invoke((Object)nDWrapper);
        return (ISeq)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object set_0d_BANG_(Object value) {
        Object object;
        Object object2 = this.array;
        if (Util.classOf((Object)object2) != __cached_class__3) {
            if (object2 instanceof PIndexedSetting) {
                Object object3 = value;
                value = null;
                object = object2.set_nd(this.source_position, object3);
                return object;
            }
            object2 = object2;
            __cached_class__3 = Util.classOf((Object)object2);
        }
        Object object4 = value;
        value = null;
        object = const__10.getRawRoot().invoke(object2, this.source_position, object4);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object get_0d() {
        Object object;
        Object object2 = this.array;
        if (Util.classOf((Object)object2) != __cached_class__2) {
            if (object2 instanceof PIndexedAccess) {
                object = object2.get_nd(this.source_position);
                return object;
            }
            object2 = object2;
            __cached_class__2 = Util.classOf((Object)object2);
        }
        object = const__9.getRawRoot().invoke(object2, this.source_position);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object nth(int i, Object not_found) {
        Object object;
        Object object2;
        Object and__3973__auto__4543;
        Object object3 = and__3973__auto__4543 = ((IFn)const__6.getRawRoot()).invoke((Object)i);
        if (object3 != null && object3 != Boolean.FALSE) {
            boolean and__3973__auto__4542 = Numbers.lte((long)0L, (long)i);
            object2 = and__3973__auto__4542 ? (Numbers.lt((long)i, (long)((long[])this.shape)[(int)0L]) ? Boolean.TRUE : Boolean.FALSE) : (and__3973__auto__4542 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            object2 = and__3973__auto__4543;
            Object var3_3 = null;
        }
        if (object2 != null && object2 != Boolean.FALSE) {
            NDWrapper nDWrapper = this;
            if (Util.classOf((Object)nDWrapper) != __cached_class__1) {
                if (nDWrapper instanceof PMatrixSlices) {
                    object = nDWrapper.get_major_slice(i);
                    return object;
                }
                nDWrapper = nDWrapper;
                __cached_class__1 = Util.classOf((Object)nDWrapper);
            }
            object = const__5.getRawRoot().invoke((Object)nDWrapper, (Object)i);
            return object;
        }
        object = not_found;
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object nth(int i) {
        Object object;
        NDWrapper nDWrapper = this;
        if (Util.classOf((Object)nDWrapper) != __cached_class__0) {
            if (nDWrapper instanceof PMatrixSlices) {
                object = nDWrapper.get_major_slice(i);
                return object;
            }
            nDWrapper = nDWrapper;
            __cached_class__0 = Util.classOf((Object)nDWrapper);
        }
        object = const__5.getRawRoot().invoke((Object)nDWrapper, (Object)i);
        return object;
    }

    public int count() {
        return RT.intCast((long)((long[])this.shape)[(int)0L]);
    }

    public String toString() {
        return (String)((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)this));
    }
}

