(ns leiningen.new.shadow-cljs
  (:require [leiningen.new.templates :refer [renderer year date project-name ->files sanitize-ns name-to-path multi-segment]]
            [leiningen.core.main :as main])
  (:import [java.nio.file Files Paths]
           [java.nio.file.attribute FileAttribute]))

(defn path
  [root p]
  (Paths/get root (into-array String [p])))

(defn sym-link
  [root source target]
  (Files/createSymbolicLink (path root target) (path "." source) (into-array FileAttribute [])))

(defn shadow-cljs
  [name]
  (let [render (renderer "shadow_cljs")
        main-ns (multi-segment (sanitize-ns name))
        data {:raw-name name
              :name (project-name name)
              :namespace main-ns
              :nested-dirs (name-to-path main-ns)
              :year (year)
              :date (date)}]
    (main/info "Generating a shadow-cljs project called" name)
    (->files data
             ["README.md" (render "README.md" data)]
             [".gitignore" (render "gitignore" data)]
             ["shadow-cljs.edn" (render "shadow-cljs.edn" data)]
             ["package.json" (render "package.json")]
             ["src/main/cljs/{{nested-dirs}}.cljs" (render "core.cljs" data)]
             ["resources/public/index.html" (render "index.html")]
             ["buildw" (render "buildw") :executable true]
             ["src/docker/build/Dockerfile" (render "Dockerfile")]
             ["docker-compose.yml" (render "docker-compose.yml")])
    (let [buildw "buildw"]
      (sym-link name buildw "npmw")
      (sym-link name buildw "shadow-cljsw"))))
