(ns net.ozias.echohandler.echohandler
  (:require [net.ozias.swarmhandler.handler :refer (Handler)]
            [taoensso.timbre :as timbre :refer (debug info)]))

(defn- myname []
  "echo")

(defn- separator [count string]
  (apply str (take 80 (repeat string))))

(defrecord EchoHandler []
  Handler
  (handlercommands [_] ["echo <text>"])
  (handlername [_] (myname))
  (handlerhelp [_] [(separator 80 "=")
                    "Echo Handler Help"
                    (separator 80 "=")
                    "echo <text>: Echo the given text back to the console."])
  (parse [_ [options args :as cl]]
    (if (:debug options)
      (println (myname) ":" cl))
    (let [command (:command options)]
      (if-let [matched (re-matches #"^echo (.*)" command)]
        (info (apply str (interpose " " (rest matched))))))
    cl))
