(ns net.ozias.swarm.libswarm
  (:require [environ.core :refer :all]
            [me.raynes.conch :refer (let-programs)]
            [net.ozias.swarm.version :as ver]
            [taoensso.timbre :refer (debug info)]))

(defn version []
  (str (or (env :name) "swarm") " (git version: " ver/version ")"))

(defn separator [length char]
  (apply str (repeat length char)))

(defn- out [line _]
  (info line))

(defn run-cmd [cmdv & {:keys [basedir]}]
  (let [process-map {:out out :err out :seq true :verbose true}
        process-map (if-not (nil? basedir) (assoc process-map :dir basedir) process-map)]
    (debug process-map)
    (debug cmdv)
    (let-programs [cmd (first cmdv)]
                  (apply cmd (conj (subvec cmdv 1) process-map)))))
