(ns net.project-fifo.libsnarl.group
  (:use 
   [net.project-fifo.libsnarl.connection :only 
    [list-to-str str-to-bin erlangify-tuple-list clojurefy-tuple-list erlangify-value]])
  (:require
   [net.project-fifo.libsnarl.connection :as connection]))

(defn- send [server & args]
  (second (connection/send server (vec (concat [:group] args)))))

(defn list [server]
  (second (send server :list)))

(defn get [server group]
  (second (send server :get (str-to-bin group))))

(defn add [server group]
  (second (send server :add (str-to-bin group))))

(defn delete [server group]
  (second (send server :delete (str-to-bin group))))

(defn grant [server group permission]
  (second (send server :grant (str-to-bin group) (map erlangify-value permission))))

(defn revoke [server group permission]
  (second (send server :revoke (str-to-bin group) (map erlangify-value permission))))