(ns net.project-fifo.libsniffle.dataset
  (:use 
   [net.project-fifo.libsniffle.connection :only 
    [list-to-str str-to-bin erlangify-tuple-list clojurefy-tuple-list erlangify-value]])
  (:require
   [net.project-fifo.libsniffle.connection :as connection]))

(defn- send [server & args]
  (second (connection/send server (vec (concat [:dataset] args)))))

(defn create [server dataset]
  (second (send server :create 
                (str-to-bin dataset))))

(defn delete [server dataset]
  (second (send server :delete 
                (str-to-bin dataset))))

(defn set 
  ([server dataset attrs]
     (let [r (send server :attribute :set (str-to-bin dataset) (erlangify-tuple-list attrs))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r))))
  ([server dataset attr value]
     (let [r (send server :attribute :set (str-to-bin dataset) (str-to-bin attr) (erlangify-value value))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r)))))

(defn get 
  ([server dataset]
     (let [r (send server :attribute :get (str-to-bin dataset))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r))))
  ([server dataset attr]
     (let [r (send server :attribute :get (str-to-bin dataset) (str-to-bin attr))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r)))))

(defn list 
  ([server]
     (let [[_ [_ r]] (send server :list)]
       (map list-to-str r)))
  ([server user]
     (let [[_ [_ r]] (send server :list user)]
       (map list-to-str r))))