(ns net.project-fifo.libsniffle.hypervisor
  (:use 
   [net.project-fifo.libsniffle.connection :only 
    [list-to-str str-to-bin erlangify-tuple-list clojurefy-tuple-list erlangify-value]])
  (:require
   [net.project-fifo.libsniffle.connection :as connection]))

(defn- send [server & args]
  (second (connection/send server (vec (concat [:hypervisor] args)))))


(defn register [server uuid host port]
  (second (send server :register 
                (str-to-bin uuid)
                (str-to-bin host)
                port)))

(defn set 
  ([server hypervisor attrs]
     (let [r (send server :resource :set (str-to-bin hypervisor) (erlangify-tuple-list attrs))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r))))
  ([server hypervisor attr value]
     (let [r (send server :resource :set (str-to-bin hypervisor) (str-to-bin attr) (erlangify-value value))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r)))))

(defn get 
  ([server hypervisor]
     (let [r (send server :resource :get (str-to-bin hypervisor))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r))))
  ([server hypervisor attr]
     (let [r (send server :resource :get (str-to-bin hypervisor) (str-to-bin attr))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r)))))

(defn list 
  ([server]
     (let [[_ [_ r]] (send server :list)]
       (map list-to-str r)))
  ([server user]
     (let [[_ [_ r]] (send server :list user)]
       (map list-to-str r))))