(ns net.project-fifo.libsniffle.package
  (:use 
   [net.project-fifo.libsniffle.connection :only 
    [list-to-str str-to-bin erlangify-tuple-list clojurefy-tuple-list erlangify-value]])
  (:require
   [net.project-fifo.libsniffle.connection :as connection]))

(defn- send [server & args]
  (second (connection/send server (vec (concat [:package] args)))))

(defn create [server package]
  (second (send server :create 
                (str-to-bin package))))

(defn delete [server package]
  (second (send server :delete 
                (str-to-bin package))))

(defn set 
  ([server package attrs]
     (let [r (send server :attribute :set (str-to-bin package) (erlangify-tuple-list attrs))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r))))
  ([server package attr value]
     (let [r (send server :attribute :set (str-to-bin package) (str-to-bin attr) (erlangify-value value))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r)))))

(defn get 
  ([server package]
     (let [r (send server :attribute :get (str-to-bin package))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r))))
  ([server package attr]
     (let [r (send server :attribute :get (str-to-bin package) (str-to-bin attr))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r)))))

(defn list 
  ([server]
     (let [[_ [_ r]] (send server :list)]
       (map list-to-str r)))
  ([server user]
     (let [[_ [_ r]] (send server :list user)]
       (map list-to-str r))))