(ns net.project-fifo.libsniffle.vm
  (:use 
   [net.project-fifo.libsniffle.connection :only 
    [list-to-str str-to-bin erlangify-tuple-list clojurefy-tuple-list erlangify-value]])
  (:require
   [net.project-fifo.libsniffle.connection :as connection]))

(defn- send [server & args]
  (second (connection/send server (vec (concat [:vm] args)))))

(defn create [server package dataset spec]
  (second (send server :create 
                (str-to-bin package)
                (str-to-bin dataset)
                (erlangify-tuple-list spec))))

(defn register [server uuid hypervisor]
  (second (send server :register 
                (str-to-bin uuid)
                (str-to-bin hypervisor))))

(defn set 
  ([server vm attrs]
     (let [r (send server :attribute :set (str-to-bin vm) (erlangify-tuple-list attrs))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r))))
  ([server vm attr value]
     (let [r (send server :attribute :set (str-to-bin vm) (str-to-bin attr) (erlangify-value value))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r)))))

(defn get 
  ([server vm]
     (let [r (send server :attribute :get (str-to-bin vm))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r))))
  ([server vm attr]
     (let [r (send server :attribute :get (str-to-bin vm) (str-to-bin attr))]
       (if (= r :not_found)
         r
         (clojurefy-tuple-list r)))))

(defn list 
  ([server]
     (let [[_ [_ r]] (send server :list)]
       (map list-to-str r)))
  ([server user]
     (let [[_ [_ r]] (send server :list user)]
       (map list-to-str r))))