/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo;

import gnu.cajo.Grail;
import gnu.cajo.invoke.Invoke;
import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.ItemServer;
import gnu.cajo.utils.Multicast;
import gnu.cajo.utils.extra.TransparentItemProxy;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;

public final class Cajo
implements Grail {
    private final Multicast multicast;
    private final Vector items = new Vector();
    private final Registrar registrar = new Registrar(this.items);

    protected void finalize() throws Throwable {
        Remote.shutdown();
        super.finalize();
    }

    public Cajo(int port, String serverHost, String clientHost) throws UnknownHostException, IOException {
        Remote.config(serverHost, port, clientHost, port);
        this.multicast = new Multicast("224.0.23.162", port);
        this.multicast.listen(this.registrar);
        this.multicast.announce(this.registrar, 255);
        ItemServer.bind(this.registrar, "registrar");
    }

    public void export(Object object) throws IOException {
        this.items.add(new Remote(new Searchable(object)));
        this.multicast.announce(this.registrar, 255);
    }

    public Object[] lookup(Class methodSetInterface) throws Exception {
        if (!methodSetInterface.isInterface()) {
            throw new IllegalArgumentException("class must be an interface");
        }
        Method[] methods = methodSetInterface.getMethods();
        Class[] returns = new Class[methods.length];
        String[] names = new String[methods.length];
        Class[][] args = new Class[methods.length][];
        for (int i = 0; i < methods.length; ++i) {
            returns[i] = methods[i].getReturnType();
            names[i] = methods[i].getName();
            args[i] = methods[i].getParameterTypes();
        }
        Object[] params = new Object[]{returns, names, args};
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] elements = this.items.toArray();
        for (int i = 0; i < elements.length; ++i) {
            try {
                Object match = Remote.invoke(elements[i], null, params);
                if (!Boolean.TRUE.equals(match)) continue;
                list.add(elements[i]);
                continue;
            }
            catch (Exception x) {
                this.items.removeElement(elements[i]);
            }
        }
        return list.toArray();
    }

    public Object proxy(Object reference, Class methodSetInterface) {
        return TransparentItemProxy.getItem(new Purger(reference, this.items), new Class[]{methodSetInterface});
    }

    public static Object proxy(Object object) {
        HashSet interfaces = new HashSet();
        for (Class<?> c = object.getClass(); c != null; c = c.getSuperclass()) {
            interfaces.addAll(Arrays.asList(c.getInterfaces()));
        }
        return TransparentItemProxy.getItem(object, interfaces.toArray(new Class[0]));
    }

    public void register(String hostname, int port) throws Exception {
        Object reg = Remote.getItem("//" + hostname + ':' + port + "/registrar");
        if (this.items.size() > 0) {
            Remote.invoke(reg, "register", this.items);
        }
        this.registrar.register((Vector)Remote.invoke(reg, "request", null));
    }

    public static void main(String[] args) throws Exception {
        InputStream is = Cajo.class.getResourceAsStream("/readme.txt");
        byte[] text = new byte[is.available()];
        is.read(text);
        is.close();
        System.out.println(new String(text));
    }

    public static final class Purger
    implements Invoke {
        private static final long serialVersionUID = 1L;
        private final Object object;
        private transient Vector items;

        private Purger(Object object, Vector items) {
            this.object = object;
            this.items = items;
        }

        public Object invoke(String method, Object args) throws Exception {
            try {
                return Remote.invoke(this.object, method, args);
            }
            catch (RemoteException x) {
                if (this.items != null) {
                    this.items.remove(this.object);
                }
                throw x;
            }
        }
    }

    public static final class Searchable
    implements Invoke {
        private static final long serialVersionUID = 1L;
        private final Object object;

        private Searchable(Object object) {
            this.object = object;
        }

        public Object invoke(String method, Object args) throws Exception {
            if (method == null) {
                int i;
                Class[] ireturns = (Class[])((Object[])args)[0];
                String[] inames = (String[])((Object[])args)[1];
                Class[][] iargs = (Class[][])((Object[])args)[2];
                Method[] methods = this.object.getClass().getMethods();
                String[] mnames = new String[methods.length];
                Class[] mreturns = new Class[methods.length];
                for (i = 0; i < methods.length; ++i) {
                    mreturns[i] = methods[i].getReturnType();
                    mnames[i] = methods[i].getName();
                }
                block1: for (i = 0; i < inames.length; ++i) {
                    for (int j = 0; j < mnames.length; ++j) {
                        if (!mnames[j].equals(inames[i]) || !ireturns[i].equals(Void.TYPE) && !Remote.autobox(ireturns[i]).isAssignableFrom(Remote.autobox(mreturns[j]))) continue;
                        Class<?>[] margs = methods[j].getParameterTypes();
                        if (margs.length != iargs[i].length) break;
                        for (int k = 0; k < margs.length && Remote.autobox(margs[k]).isAssignableFrom(iargs[i][k]); ++k) {
                        }
                        continue block1;
                    }
                    return null;
                }
                return Boolean.TRUE;
            }
            return Remote.invoke(this.object, method, args);
        }
    }

    public static final class Registrar {
        private final Vector items;

        private Registrar(Vector items) {
            this.items = items;
        }

        public Object multicast(Multicast multicast) throws Exception {
            if (this.items.size() > 0) {
                multicast.item.invoke("register", this.items);
            }
            this.register((Vector)multicast.item.invoke("request", null));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(Vector elements) {
            if (elements != null && elements.size() > 0) {
                Vector vector = this.items;
                synchronized (vector) {
                    for (int i = 0; i < elements.size(); ++i) {
                        if (this.items.contains(elements.elementAt(i))) continue;
                        this.items.add(elements.elementAt(i));
                    }
                }
            }
        }

        public Vector request() {
            return this.items;
        }
    }
}

