/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.invoke;

import gnu.cajo.invoke.NoSecurityManager;
import gnu.cajo.invoke.Remote;
import gnu.cajo.invoke.RemoteInvoke;
import java.awt.Component;
import java.awt.event.WindowListener;
import java.rmi.MarshalledObject;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public final class JClient
extends JApplet {
    private static final long serialVersionUID = 1L;
    private static Object proxy;

    public String getAppletInfo() {
        return "cajo Proxy JApplet, Copyright \u00a9 2006 John Catherino";
    }

    public String[][] getParameterInfo() {
        return new String[][]{{"proxyName", "String", "Server's proxy's registry name"}, {"proxyPort", "Integer", "Server's proxy's port number"}, {"clientHost", "String", "Client's external host name"}, {"clientPort", "Integer", "Client's external port number"}, {"localPort", "Integer", "Client's internal port number"}};
    }

    public void init() {
        try {
            int lPort;
            String proxyName = this.getParameter("proxyName");
            String proxyPort = this.getParameter("proxyPort");
            String clientHost = this.getParameter("clientHost");
            String clientPort = this.getParameter("clientPort");
            String localPort = this.getParameter("localPort");
            int pPort = proxyPort != null ? Integer.parseInt(proxyPort) : 1099;
            int cPort = clientPort != null ? Integer.parseInt(clientPort) : 0;
            int n = lPort = localPort != null ? Integer.parseInt(localPort) : 0;
            if (proxyName == null) {
                proxyName = "main";
            }
            Remote.config("0.0.0.0", lPort, clientHost, cPort);
            proxy = LocateRegistry.getRegistry(this.getCodeBase().getHost(), pPort);
            proxy = ((Registry)proxy).lookup(proxyName);
            proxy = Remote.invoke(proxy, "getProxy", null);
            if (proxy instanceof MarshalledObject) {
                proxy = ((MarshalledObject)proxy).get();
            }
            if (!(proxy instanceof RemoteInvoke)) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            proxy = Remote.invoke(proxy, "init", new Remote(proxy));
                            if (proxy instanceof Component) {
                                JClient.this.getContentPane().add((Component)proxy);
                                JClient.this.validate();
                            }
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void start() {
        try {
            Remote.invoke(proxy, "start", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            Remote.invoke(proxy, "stop", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        try {
            Remote.invoke(proxy, "destroy", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(final String[] args) throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new NoSecurityManager());
        }
        if (args.length > 0) {
            int clientPort = args.length > 1 ? Integer.parseInt(args[1]) : 0;
            String clientHost = args.length > 2 ? args[2] : null;
            int localPort = args.length > 3 ? Integer.parseInt(args[3]) : 0;
            String localHost = args.length > 4 ? args[4] : "0.0.0.0";
            Remote.config(localHost, localPort, clientHost, clientPort);
            proxy = Remote.getItem(args[0]);
            proxy = Remote.invoke(proxy, "getProxy", null);
            if (proxy instanceof MarshalledObject) {
                proxy = ((MarshalledObject)proxy).get();
            }
            if (!(proxy instanceof RemoteInvoke)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        block5: {
                            try {
                                proxy = Remote.invoke(proxy, "init", new Remote(proxy));
                                if (!(proxy instanceof Component)) break block5;
                                String title = "cajo Proxy Viewer";
                                try {
                                    title = System.getProperty("gnu.cajo.invoke.JClient.title");
                                }
                                catch (Exception x) {
                                    // empty catch block
                                }
                                JFrame frame = new JFrame(title + " - " + args[0]);
                                if (proxy instanceof WindowListener) {
                                    frame.addWindowListener((WindowListener)proxy);
                                }
                                frame.setDefaultCloseOperation(3);
                                frame.getContentPane().add((Component)proxy);
                                frame.pack();
                                frame.setVisible(true);
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                        }
                    }
                });
            }
        } else {
            System.err.println("No source URL provided");
        }
    }
}

