/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.utils;

import gnu.cajo.invoke.Remote;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class CodebaseServer
extends Thread {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private static final byte[] bye = "HTTP/1.0 404 Not Found\r\nContent-type: text/html\r\nServer: cajo/CodebaseServer\r\nConnection: close\r\n\r\n<html><head><title>404: URL Not Found</title></head><body><h1>404 - Not Found</h1>The requested resource is not available from this server.<br><br><hr><i>gnu.cajo.utils.CodebaseServer - The cajo project: <a href=https://cajo.dev.java.net>https://cajo.dev.java.net</a>.</i></body></html>".getBytes();
    private static final byte[] apl = ("HTTP/1.0 200 OK\r\nContent-type: text/html\r\nServer: cajo/CodebaseServer\r\nLast-Modified: " + formatter.format(new Date()) + "\r\n" + "Connection: close\r\n\r\n").getBytes();
    private static final byte[] jws = ("HTTP/1.0 200 OK\r\nContent-type: application/x-java-jnlp-file\r\nServer: cajo/CodebaseServer\r\nLast-Modified: " + formatter.format(new Date()) + "\r\n" + "Connection: close\r\n\r\n").getBytes();
    private static final byte[] jarHdr = "HTTP/1.0 200 OK\r\nContent-type: application/x-java-archive\r\nServer: cajo/CodebaseServer\r\n".getBytes();
    private static final byte[] classHdr = "HTTP/1.0 200 OK\r\nContent-type: application/x-java-vm\r\nServer: cajo/CodebaseServer\r\n".getBytes();
    private static final byte[] imgHdr = "HTTP/1.0 200 OK\r\nContent-type: image/jpeg\r\nServer: cajo/CodebaseServer\r\n".getBytes();
    private static final byte[] end = "PLUGINSPAGE=\"http://java.sun.com/j2se/1.5.0/download.html\">\r\n</EMBED></COMMENT></OBJECT></CENTER></BODY></HTML>".getBytes();
    private static final byte[] out = "  </application-desc>\r\n</jnlp>".getBytes();
    private final byte[] top;
    private final byte[] mid;
    private final byte[] tip;
    private final byte[] xml;
    private final ServerSocket ss;
    private PrintStream log;
    public final int serverPort;
    public static int port;

    public CodebaseServer(String[] jars, int port, String client, String title, String vendor, String icon, String splash) throws IOException {
        int i;
        String temp = client.replace('.', '/') + ".class";
        StringBuffer base = new StringBuffer();
        if (title == null) {
            title = "cajo Proxy Viewer";
        }
        if (jars != null) {
            base.append(jars[0]);
            for (i = 1; i < jars.length; ++i) {
                base.append(", ");
                base.append(jars[i]);
            }
        } else {
            base.append("client.jar");
        }
        this.top = ("<HTML><HEAD><TITLE>" + title + "</TITLE>\r\n" + "<META NAME=\"description\" content=\"Graphical cajo proxy client\">\r\n" + "<META NAME=\"copyright\" content=\"Copyright (c) 1999 John Catherino\">\r\n" + "<META NAME=\"author\" content=\"John Catherino\">\r\n" + "<META NAME=\"generator\" content=\"CodebaseServer\">\r\n" + "</HEAD><BODY leftmargin=\"0\" topmargin=\"0\" marginheight=\"0\" marginwidth=\"0\" rightmargin=\"0\">\r\n" + "<CENTER><OBJECT classid=\"clsid:8AD9C840-044E-11D1-B3E9-00805F499D93\"\r\n" + "WIDTH=\"100%\" HEIGHT=\"100%\"\r\n" + "CODEBASE=\"http://java.sun.com/products/plugin/autodl/jinstall-1_5_0-windows-i586.cab#Version=1,5,0,0\">\r\n" + "<PARAM NAME=\"draggable\" VALUE=\"true\">\r\n" + "<PARAM NAME=\"archive\" VALUE=\"" + base.toString() + "\">\r\n" + "<PARAM NAME=\"type\" VALUE=\"application/x-java-applet;version=1.5\">\r\n" + "<PARAM NAME=\"code\" VALUE=\"" + temp + "\">\r\n").getBytes();
        this.mid = ("<COMMENT><EMBED type=\"application/x-java-applet;version=1.5\"\r\nARCHIVE=\"" + base.toString() + "\"\r\n" + "CODE=\"" + temp + "\"\r\n" + "WIDTH=\"100%\" HEIGHT=\"100%\"\r\n" + "DRAGGABLE=\"true\"\r\n").getBytes();
        this.ss = Remote.getDefaultServerHost() == null ? new ServerSocket(port) : new ServerSocket(port, 50, InetAddress.getByName(Remote.getDefaultServerHost()));
        CodebaseServer.port = this.serverPort = port == 0 ? this.ss.getLocalPort() : port;
        this.tip = ("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<jnlp spec=\"1.5+\"\r\n  codebase=\"http://" + (Remote.getDefaultClientHost() != null ? Remote.getDefaultClientHost() : InetAddress.getLocalHost().getHostAddress()) + ':' + this.serverPort + "\"\r\n").getBytes();
        base = new StringBuffer("  <information>\r\n    <title>" + title + "</title>\r\n" + "    <vendor>" + (vendor != null ? vendor : "The cajo project") + "</vendor>\r\n" + "    <description>Graphical cajo proxy client</description>\r\n" + "    <homepage href=\"https://cajo.dev.java.net\"/>\r\n" + (icon == null ? "" : "    <icon href=\"" + icon + "\"/>\r\n") + (splash == null ? "" : "    <icon href=\"" + splash + "\" kind=\"splash\"/>\r\n") + "    <shortcut><desktop/></shortcut>\r\n" + "  </information>\r\n" + "  <resources>\r\n" + "    <j2se version=\"1.5+\"/>\r\n");
        if (jars != null) {
            base.append("    <jar href=\"" + jars[0] + "\" main=\"true\"/>\r\n");
            for (i = 1; i < jars.length; ++i) {
                base.append("    <jar href=\"" + jars[i] + "\" download=\"lazy\"/>\r\n");
            }
        } else {
            base.append("    <jar href=\"client.jar\" main=\"true\"/>\r\n");
        }
        base.append("  </resources>\r\n");
        base.append("  <application-desc main-class=\"");
        base.append(client);
        base.append("\">\r\n");
        this.xml = base.toString().getBytes();
        String loc = "http://" + (Remote.getDefaultClientHost() != null ? Remote.getDefaultClientHost() : InetAddress.getLocalHost().getHostAddress()) + ':' + CodebaseServer.port + '/';
        base = new StringBuffer();
        if (jars != null) {
            for (int i2 = 0; i2 < jars.length; ++i2) {
                base.append(loc);
                base.append(jars[i2]);
                if (i2 >= jars.length - 1) continue;
                base.append(' ');
            }
        } else {
            base.append(loc);
        }
        if (System.getProperty("java.rmi.server.codebase") != null) {
            base.append(' ');
            base.append(System.getProperty("java.rmi.server.codebase"));
        }
        System.setProperty("java.rmi.server.codebase", base.toString());
        this.setDaemon(true);
        this.start();
    }

    public CodebaseServer(String base, int port, String client) throws IOException {
        String[] stringArray;
        if (base != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "client.jar";
            stringArray = stringArray2;
            stringArray2[1] = base;
        } else {
            stringArray = null;
        }
        this(stringArray, port, client, null, null, null, null);
    }

    public CodebaseServer(String base, int port) throws IOException {
        this(base, port, "gnu.cajo.invoke.Client");
    }

    public void setLog(OutputStream log) {
        if (log != null) {
            this.log = log instanceof PrintStream ? (PrintStream)log : new PrintStream(log);
        }
    }

    public void run() {
        try {
            byte[] msg = new byte[4096];
            while (!this.isInterrupted()) {
                Socket s = this.ss.accept();
                try {
                    BufferedOutputStream os;
                    InputStream is;
                    block27: {
                        is = s.getInputStream();
                        os = new BufferedOutputStream(s.getOutputStream(), 32768);
                        int ix = is.read(msg);
                        String itemName = null;
                        block13: for (int i = 0; i < ix; ++i) {
                            if (msg[i] != 47) continue;
                            for (int j = i + 1; j < msg.length; ++j) {
                                if (msg[j] != 32) continue;
                                itemName = new String(msg, i, j - i);
                                break block13;
                            }
                        }
                        String clientHost = s.getInetAddress().getHostAddress();
                        if (this.log != null) {
                            this.log.println("Client " + clientHost + " request: " + itemName);
                        }
                        if (itemName == null) {
                            ((OutputStream)os).write(bye);
                        } else if (itemName.indexOf(46) == -1 && itemName.indexOf(47, 1) == -1) {
                            try {
                                int ia;
                                int n = itemName.indexOf(58) != -1 ? itemName.indexOf(58) : (itemName.indexOf(45) != -1 ? itemName.indexOf(45) : (ia = itemName.indexOf(33) != -1 ? itemName.indexOf(33) : itemName.length()));
                                int ib = itemName.indexOf(45) != -1 ? itemName.indexOf(45) : (itemName.indexOf(33) != -1 ? itemName.indexOf(33) : itemName.length());
                                int ic = itemName.indexOf(33) != -1 ? itemName.indexOf(33) : itemName.length();
                                String clientPort = ia > 1 ? itemName.substring(1, ia) : "0";
                                String localPort = ib > ia ? itemName.substring(ia + 1, ib) : "0";
                                String proxyName = ic > ib ? itemName.substring(ib + 1, ic) : "main";
                                Integer.parseInt(clientPort);
                                Integer.parseInt(localPort);
                                int proxyPort = Remote.getDefaultClientPort();
                                if (itemName.indexOf(33) == -1) {
                                    byte[] iex = ("<PARAM NAME=\"clientHost\" VALUE=\"" + clientHost + "\">\r\n" + "<PARAM NAME=\"clientPort\" VALUE=\"" + clientPort + "\">\r\n" + "<PARAM NAME=\"localPort\"  VALUE=\"" + localPort + "\">\r\n" + "<PARAM NAME=\"proxyPort\"  VALUE=\"" + proxyPort + "\">\r\n" + "<PARAM NAME=\"proxyName\"  VALUE=\"" + proxyName + "\">\r\n").getBytes();
                                    byte[] nav = ("clientHost=\"" + clientHost + "\"\r\n" + "clientPort=\"" + clientPort + "\"\r\n" + "localPort=\"" + localPort + "\"\r\n" + "proxyPort=\"" + proxyPort + "\"\r\n" + "proxyName=\"" + proxyName + "\"\r\n").getBytes();
                                    ((OutputStream)os).write(apl);
                                    ((OutputStream)os).write(this.top);
                                    ((OutputStream)os).write(iex);
                                    ((OutputStream)os).write(this.mid);
                                    ((OutputStream)os).write(nav);
                                    ((OutputStream)os).write(end);
                                    break block27;
                                }
                                byte[] obj = ("  href=\"" + clientPort + ':' + localPort + '-' + proxyName + "!\">\r\n").getBytes();
                                byte[] arg = ("    <argument>//" + Remote.getDefaultClientHost() + ':' + proxyPort + '/' + proxyName + "</argument>\r\n" + "    <argument>" + clientPort + "</argument>\r\n" + "    <argument>" + clientHost + "</argument>\r\n" + "    <argument>" + localPort + "</argument>\r\n").getBytes();
                                ((OutputStream)os).write(jws);
                                ((OutputStream)os).write(this.tip);
                                ((OutputStream)os).write(obj);
                                ((OutputStream)os).write(this.xml);
                                ((OutputStream)os).write(arg);
                                ((OutputStream)os).write(out);
                            }
                            catch (Exception x) {
                                ((OutputStream)os).write(bye);
                            }
                        } else if (!itemName.endsWith("service.jar")) {
                            if (itemName.equals("/favicon.ico") || itemName.endsWith(".jar") || itemName.endsWith(".class") || itemName.endsWith(".gif") || itemName.endsWith(".jpg") || itemName.endsWith(".jpeg")) {
                                try {
                                    InputStream ris = this.getClass().getResourceAsStream(itemName);
                                    if (ris == null) {
                                        ris = new FileInputStream('.' + itemName);
                                    }
                                    ((OutputStream)os).write(itemName.endsWith(".jar") ? jarHdr : (itemName.endsWith(".class") ? classHdr : imgHdr));
                                    ((OutputStream)os).write(formatter.format(new Date(new File('.' + itemName).lastModified())).getBytes());
                                    ((OutputStream)os).write("\r\nConnection: close\r\n\r\n".getBytes());
                                    int i = ris.read(msg);
                                    while (i != -1) {
                                        ((OutputStream)os).write(msg, 0, i);
                                        i = ris.read(msg);
                                    }
                                    ris.close();
                                }
                                catch (Exception x) {
                                    ((OutputStream)os).write(bye);
                                }
                            } else {
                                ((OutputStream)os).write(bye);
                            }
                        } else {
                            ((OutputStream)os).write(bye);
                        }
                    }
                    ((OutputStream)os).flush();
                    ((OutputStream)os).close();
                    is.close();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                try {
                    s.close();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        try {
            this.ss.close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        CodebaseServer c = args.length == 0 ? new CodebaseServer(null, 0) : new CodebaseServer(null, Integer.parseInt(args[0]));
        System.out.println("Codebase service on port " + c.serverPort);
    }
}

