/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.utils.extra;

import gnu.cajo.invoke.Invoke;
import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.ItemServer;
import gnu.cajo.utils.MonitorItem;
import gnu.cajo.utils.Multicast;
import java.rmi.RemoteException;
import java.util.LinkedList;

public class Queue
implements Invoke {
    private static final long serialVersionUID = 1L;
    protected final Object topic;
    protected LinkedList invocations = new LinkedList();
    protected LinkedList consumers = new LinkedList();
    protected transient Thread thread;

    public Queue(Object topic) {
        this.topic = topic;
    }

    public Object topic() {
        return this.topic;
    }

    public synchronized void enqueue(Object consumer) {
        this.consumers.add(consumer);
    }

    public synchronized void dequeue(Object consumer) {
        this.consumers.remove(consumer);
    }

    public synchronized void pause() {
        if (this.thread != null && !this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
    }

    public synchronized void resume() {
        if (this.thread != null && this.thread.isInterrupted()) {
            this.thread = null;
        }
    }

    public synchronized Object invoke(String method, Object args) {
        if (method.equals("enqueue") && args != null) {
            this.enqueue(args);
            return null;
        }
        if (method.equals("dequeue") && args != null) {
            this.dequeue(args);
            return null;
        }
        if (method.equals("topic") && args == null) {
            return this.topic();
        }
        if (this.thread == null) {
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        do {
                            Object[] consumers;
                            Object args;
                            String method;
                            Queue queue = Queue.this;
                            synchronized (queue) {
                                while (Queue.this.invocations.size() == 0) {
                                    Queue.this.wait();
                                }
                                method = (String)Queue.this.invocations.removeFirst();
                                args = Queue.this.invocations.removeFirst();
                                if (Queue.this.consumers.isEmpty()) {
                                    continue;
                                }
                                consumers = Queue.this.consumers.toArray();
                            }
                            for (int i = 0; i < consumers.length; ++i) {
                                try {
                                    Remote.invoke(consumers[i], method, args);
                                    continue;
                                }
                                catch (RemoteException x) {
                                    Queue.this.dequeue(consumers[i]);
                                    continue;
                                }
                                catch (Exception x) {
                                    continue;
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                            }
                        } while (!Queue.this.thread.isInterrupted());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            this.thread.start();
        }
        this.invocations.add(method);
        this.invocations.add(args);
        this.notify();
        return null;
    }

    public static void main(String[] args) throws Exception {
        String topic = args.length > 0 ? args[0] : "void";
        int port = args.length > 1 ? Integer.parseInt(args[1]) : 1198;
        Remote.config(null, port, null, port);
        Remote queue = new Remote(new MonitorItem(new Queue(topic)));
        System.out.println("Queue started\n");
        ItemServer.bind(queue, topic);
        new Multicast("224.0.23.162", 1198).announce(queue, 32);
    }
}

