/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ghost4j.converter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.ghost4j.Ghostscript;
import net.sf.ghost4j.GhostscriptException;
import net.sf.ghost4j.converter.AbstractRemoteConverter;
import net.sf.ghost4j.converter.ConverterException;
import net.sf.ghost4j.document.Document;
import net.sf.ghost4j.document.DocumentException;
import net.sf.ghost4j.document.PSDocument;
import net.sf.ghost4j.util.DiskStore;
import org.apache.commons.io.IOUtils;

public class PDFConverter
extends AbstractRemoteConverter {
    public static final int OPTION_AUTOROTATEPAGES_NONE = 0;
    public static final int OPTION_AUTOROTATEPAGES_ALL = 1;
    public static final int OPTION_AUTOROTATEPAGES_PAGEBYPAGE = 2;
    public static final int OPTION_PROCESSCOLORMODEL_RGB = 0;
    public static final int OPTION_PROCESSCOLORMODEL_GRAY = 1;
    public static final int OPTION_PROCESSCOLORMODEL_CMYK = 2;
    public static final int OPTION_PDFSETTINGS_DEFAULT = 0;
    public static final int OPTION_PDFSETTINGS_SCREEN = 1;
    public static final int OPTION_PDFSETTINGS_EBOOK = 2;
    public static final int OPTION_PDFSETTINGS_PRINTER = 3;
    public static final int OPTION_PDFSETTINGS_PREPRESS = 4;
    private int autoRotatePages;
    private int processColorModel;
    private int PDFSettings;
    private String compatibilityLevel = "1.4";
    private boolean PDFX = false;
    private String paperSize = "letter";

    public PDFConverter() {
        this.supportedDocumentClasses = new Class[1];
        this.supportedDocumentClasses[0] = PSDocument.class;
    }

    public static void main(String[] args) throws ConverterException {
        PDFConverter.startRemoteConverter(new PDFConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Document document, OutputStream outputStream) throws IOException, ConverterException, DocumentException {
        if (outputStream == null) {
            return;
        }
        this.assertDocumentSupported(document);
        Ghostscript gs = Ghostscript.getInstance();
        DiskStore diskStore = DiskStore.getInstance();
        String diskStoreKey = outputStream.toString() + String.valueOf(System.currentTimeMillis() + String.valueOf((int)(Math.random() * 1000.0)));
        String[] gsArgs = new String[15];
        gsArgs[0] = "-ps2pdf";
        gsArgs[1] = "-dNOPAUSE";
        gsArgs[2] = "-dBATCH";
        gsArgs[3] = "-dSAFER";
        switch (this.autoRotatePages) {
            case 0: {
                gsArgs[4] = "-dAutoRotatePages=/None";
                break;
            }
            case 1: {
                gsArgs[4] = "-dAutoRotatePages=/All";
                break;
            }
            default: {
                gsArgs[4] = "-dAutoRotatePages=/PageByPage";
            }
        }
        switch (this.processColorModel) {
            case 2: {
                gsArgs[5] = "-dProcessColorModel=/DeviceCMYK";
                break;
            }
            case 1: {
                gsArgs[5] = "-dProcessColorModel=/DeviceGray";
                break;
            }
            default: {
                gsArgs[5] = "-dProcessColorModel=/DeviceRGB";
            }
        }
        switch (this.PDFSettings) {
            case 2: {
                gsArgs[6] = "-dPDFSETTINGS=/ebook";
                break;
            }
            case 1: {
                gsArgs[6] = "-dPDFSETTINGS=/screen";
                break;
            }
            case 3: {
                gsArgs[6] = "-dPDFSETTINGS=/printer";
                break;
            }
            case 4: {
                gsArgs[6] = "-dPDFSETTINGS=/prepress";
                break;
            }
            default: {
                gsArgs[6] = "-dPDFSETTINGS=/default";
            }
        }
        gsArgs[7] = "-dCompatibilityLevel=" + this.compatibilityLevel;
        gsArgs[8] = "-dPDFX=" + this.PDFX;
        gsArgs[9] = "-sPAPERSIZE=" + this.paperSize;
        gsArgs[10] = "-sDEVICE=pdfwrite";
        gsArgs[11] = "-sOutputFile=" + diskStore.addFile(diskStoreKey).getAbsolutePath();
        gsArgs[12] = "-q";
        gsArgs[13] = "-f";
        gsArgs[14] = "-";
        ByteArrayInputStream is = new ByteArrayInputStream(document.getContent());
        try {
            try {
                Ghostscript ghostscript = gs;
                synchronized (ghostscript) {
                    gs.setStdIn(is);
                    gs.initialize(gsArgs);
                }
                File outputFile = diskStore.getFile(diskStoreKey);
                if (outputFile == null) {
                    throw new ConverterException("Cannot retrieve file with key " + diskStoreKey + " from disk store");
                }
                FileInputStream fis = new FileInputStream(outputFile);
                byte[] content = new byte[(int)outputFile.length()];
                fis.read(content);
                fis.close();
                outputStream.write(content);
            }
            catch (GhostscriptException e) {
                throw new ConverterException(e);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            IOUtils.closeQuietly((InputStream)is);
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException e) {
                throw new ConverterException(e);
            }
            diskStore.removeFile(diskStoreKey);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        try {}
        catch (GhostscriptException e) {
            throw new ConverterException(e);
        }
        Ghostscript.deleteInstance();
        diskStore.removeFile(diskStoreKey);
    }

    public int getAutoRotatePages() {
        return this.autoRotatePages;
    }

    public void setAutoRotatePages(int autoRotatePages) {
        this.autoRotatePages = autoRotatePages;
    }

    public int getProcessColorModel() {
        return this.processColorModel;
    }

    public void setProcessColorModel(int processColorModel) {
        this.processColorModel = processColorModel;
    }

    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public void setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    public int getPDFSettings() {
        return this.PDFSettings;
    }

    public void setPDFSettings(int PDFSettings) {
        this.PDFSettings = PDFSettings;
    }

    public boolean isPDFX() {
        return this.PDFX;
    }

    public void setPDFX(boolean PDFX) {
        this.PDFX = PDFX;
    }

    public String getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(String paperSize) {
        this.paperSize = paperSize;
    }
}

