/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ghost4j.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.ghost4j.Ghostscript;
import net.sf.ghost4j.GhostscriptException;
import net.sf.ghost4j.converter.AbstractRemoteConverter;
import net.sf.ghost4j.converter.ConverterException;
import net.sf.ghost4j.document.Document;
import net.sf.ghost4j.document.DocumentException;
import net.sf.ghost4j.document.PDFDocument;
import net.sf.ghost4j.document.PSDocument;
import net.sf.ghost4j.util.DiskStore;

public class PSConverter
extends AbstractRemoteConverter {
    private int languageLevel = 3;
    private String paperSize = "letter";

    public PSConverter() {
        this.supportedDocumentClasses = new Class[2];
        this.supportedDocumentClasses[0] = PSDocument.class;
        this.supportedDocumentClasses[1] = PDFDocument.class;
    }

    public static void main(String[] args) throws ConverterException {
        PSConverter.startRemoteConverter(new PSConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Document document, OutputStream outputStream) throws IOException, ConverterException, DocumentException {
        if (outputStream == null) {
            return;
        }
        this.assertDocumentSupported(document);
        Ghostscript gs = Ghostscript.getInstance();
        DiskStore diskStore = DiskStore.getInstance();
        String outputDiskStoreKey = outputStream.toString() + String.valueOf(System.currentTimeMillis() + String.valueOf((int)(Math.random() * 1000.0)));
        String inputDiskStoreKey = outputStream.toString() + String.valueOf(System.currentTimeMillis() + String.valueOf((int)(Math.random() * 1000.0)));
        document.write(diskStore.addFile(inputDiskStoreKey));
        String[] gsArgs = new String[]{"-psconv", "-dNOPAUSE", "-dBATCH", "-dSAFER", "-dLanguageLevel=" + this.languageLevel, "-sPAPERSIZE=" + this.paperSize, "-sDEVICE=pswrite", "-sOutputFile=" + diskStore.addFile(outputDiskStoreKey).getAbsolutePath(), "-q", "-f", diskStore.getFile(inputDiskStoreKey).getAbsolutePath()};
        try {
            try {
                Ghostscript ghostscript = gs;
                synchronized (ghostscript) {
                    gs.initialize(gsArgs);
                    gs.exit();
                }
                File outputFile = diskStore.getFile(outputDiskStoreKey);
                if (outputFile == null) {
                    throw new ConverterException("Cannot retrieve file with key " + outputDiskStoreKey + " from disk store");
                }
                FileInputStream fis = new FileInputStream(outputFile);
                byte[] content = new byte[(int)outputFile.length()];
                fis.read(content);
                fis.close();
                outputStream.write(content);
            }
            catch (GhostscriptException e) {
                throw new ConverterException(e);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException e) {
                throw new ConverterException(e);
            }
            diskStore.removeFile(outputDiskStoreKey);
            diskStore.removeFile(inputDiskStoreKey);
            throw throwable;
        }
        try {}
        catch (GhostscriptException e) {
            throw new ConverterException(e);
        }
        Ghostscript.deleteInstance();
        diskStore.removeFile(outputDiskStoreKey);
        diskStore.removeFile(inputDiskStoreKey);
    }

    public int getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(int languageLevel) {
        this.languageLevel = languageLevel;
    }

    public String getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(String paperSize) {
        this.paperSize = paperSize;
    }
}

