/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ghost4j.document;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import net.sf.ghost4j.document.Document;
import net.sf.ghost4j.document.DocumentException;
import org.apache.commons.io.IOUtils;

public abstract class AbstractDocument
implements Document,
Serializable {
    private static final long serialVersionUID = -7160779330993730486L;
    public static final int READ_BUFFER_SIZE = 1024;
    protected byte[] content;

    public abstract int getPageCount() throws DocumentException;

    public void load(File file) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        this.load(fis);
        IOUtils.closeQuietly((InputStream)fis);
    }

    public void load(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int readCount = 0;
        while ((readCount = inputStream.read(buffer)) > 0) {
            baos.write(buffer, 0, readCount);
        }
        this.content = baos.toByteArray();
        IOUtils.closeQuietly((OutputStream)baos);
    }

    public void write(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        this.write(fos);
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.content);
    }

    public int getSize() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length;
    }

    public byte[] getContent() {
        return this.content;
    }
}

