/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ghost4j.document;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.ghost4j.document.AbstractDocument;
import net.sf.ghost4j.document.DocumentException;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.DSCParser;
import org.apache.xmlgraphics.ps.dsc.events.DSCAtend;
import org.apache.xmlgraphics.ps.dsc.events.DSCComment;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPages;

public class PSDocument
extends AbstractDocument {
    private static final long serialVersionUID = 7225098893496658222L;

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
        ByteArrayInputStream bais = null;
        try {
            try {
                bais = new ByteArrayInputStream(this.content);
                DSCParser parser = new DSCParser((InputStream)bais);
                if (parser.nextDSCComment("EndComments") == null) {
                    throw new IOException("PostScript document is not valid");
                }
                Object var5_5 = null;
            }
            catch (DSCException e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            IOUtils.closeQuietly((InputStream)bais);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
    }

    public int getPageCount() throws DocumentException {
        int pageCount = 0;
        if (this.content == null) {
            return pageCount;
        }
        ByteArrayInputStream bais = null;
        try {
            try {
                bais = new ByteArrayInputStream(this.content);
                DSCParser parser = new DSCParser((InputStream)bais);
                DSCComment tP = parser.nextDSCComment("Pages");
                while (tP instanceof DSCAtend) {
                    tP = parser.nextDSCComment("Pages");
                }
                DSCCommentPages pages = (DSCCommentPages)tP;
                pageCount = pages.getPageCount();
            }
            catch (Exception e) {
                throw new DocumentException(e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            IOUtils.closeQuietly((InputStream)bais);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
        return pageCount;
    }

    public String getType() {
        return "PostScript";
    }
}

