/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.CASValue;
import net.spy.memcached.CachedData;
import net.spy.memcached.MembaseClientIF;
import net.spy.memcached.MembaseConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.GetlOperation;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.vbucket.Reconfigurable;
import net.spy.memcached.vbucket.config.Bucket;

public class MembaseClient
extends MemcachedClient
implements MembaseClientIF,
Reconfigurable {
    protected volatile boolean reconfiguring = false;

    public MembaseClient(List<URI> baseList, String bucketName, String pwd) throws IOException {
        this(new MembaseConnectionFactory(baseList, bucketName, bucketName, pwd));
    }

    public MembaseClient(List<URI> baseList, String bucketName, String usr, String pwd) throws IOException {
        this(new MembaseConnectionFactory(baseList, bucketName, usr, pwd));
    }

    public MembaseClient(MembaseConnectionFactory cf) throws IOException {
        this(cf, true);
    }

    protected MembaseClient(MembaseConnectionFactory cf, boolean subscribe) throws IOException {
        super(cf, AddrUtil.getAddresses(cf.getVBucketConfig().getServers()));
        if (subscribe) {
            cf.getConfigurationProvider().subscribe(cf.getBucket(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(Bucket bucket) {
        this.reconfiguring = true;
        try {
            this.mconn.reconfigure(bucket);
        }
        catch (IllegalArgumentException ex) {
            this.getLogger().warn((Object)"Failed to reconfigure client, staying with previous configuration.", ex);
        }
        finally {
            this.reconfiguring = false;
        }
    }

    public <T> OperationFuture<CASValue<T>> asyncGetAndLock(final String key, int exp, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture<CASValue<T>> rv = new OperationFuture<CASValue<T>>(key, latch, this.operationTimeout);
        GetlOperation op = this.opFact.getl(key, exp, new GetlOperation.Callback(){
            private CASValue<T> val = null;

            @Override
            public void receivedStatus(OperationStatus status) {
                if (!status.isSuccess()) {
                    this.val = new CASValue<Object>(-1L, null);
                }
                rv.set(this.val, status);
            }

            @Override
            public void gotData(String k, int flags, long cas, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                assert (cas > 0L) : "CAS was less than zero:  " + cas;
                this.val = new CASValue(cas, tc.decode(new CachedData(flags, data, tc.getMaxSize())));
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    public OperationFuture<CASValue<Object>> asyncGetAndLock(String key, int exp) {
        return this.asyncGetAndLock(key, exp, this.transcoder);
    }

    @Override
    public <T> CASValue<T> getAndLock(String key, int exp, Transcoder<T> tc) {
        try {
            return (CASValue)((OperationFuture)this.asyncGetAndLock(key, exp, (Transcoder)tc)).get(this.operationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for value", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception waiting for value", e);
        }
        catch (TimeoutException e) {
            throw new OperationTimeoutException("Timeout waiting for value", e);
        }
    }

    @Override
    public CASValue<Object> getAndLock(String key, int exp) {
        return this.getAndLock(key, exp, this.transcoder);
    }

    @Override
    public int getNumVBuckets() {
        return ((MembaseConnectionFactory)this.connFactory).getVBucketConfig().getVbucketsCount();
    }

    @Override
    public boolean shutdown(long timeout, TimeUnit unit) {
        boolean shutdownResult = super.shutdown(timeout, unit);
        MembaseConnectionFactory cf = (MembaseConnectionFactory)this.connFactory;
        if (cf.getConfigurationProvider() != null) {
            cf.getConfigurationProvider().shutdown();
        }
        return shutdownResult;
    }
}

