/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.couch;

import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.protocol.couch.Stale;
import net.spy.memcached.util.StringUtils;

public class Query {
    private static final String DESCENDING = "descending";
    private static final String ENDKEY = "endkey";
    private static final String ENDKEYDOCID = "endkey_docid";
    private static final String GROUP = "group";
    private static final String GROUPLEVEL = "group_level";
    private static final String INCLUSIVEEND = "inclusive_end";
    private static final String KEY = "key";
    private static final String LIMIT = "limit";
    private static final String REDUCE = "reduce";
    private static final String SKIP = "skip";
    private static final String STALE = "stale";
    private static final String STARTKEY = "startkey";
    private static final String STARTKEYDOCID = "startkey_docid";
    private static final String UPDATESEQ = "update_seq";
    private boolean includedocs = false;
    private Map<String, Object> args = new HashMap<String, Object>();

    public boolean willReduce() {
        return this.args.containsKey(REDUCE) ? (Boolean)this.args.get(REDUCE) : false;
    }

    public boolean willIncludeDocs() {
        return this.includedocs;
    }

    public Query setDescending(boolean descending) {
        this.args.put(DESCENDING, descending);
        return this;
    }

    public Query setEndkeyDocID(String endkeydocid) {
        this.args.put(ENDKEYDOCID, endkeydocid);
        return this;
    }

    public Query setGroup(boolean group) {
        this.args.put(GROUP, group);
        return this;
    }

    public Query setGroup(boolean group, int grouplevel) {
        this.args.put(GROUP, new Boolean(group));
        this.args.put(GROUPLEVEL, grouplevel);
        return this;
    }

    public Query setIncludeDocs(boolean include) {
        this.includedocs = include;
        return this;
    }

    public Query setInclusiveEnd(boolean inclusiveend) {
        this.args.put(INCLUSIVEEND, inclusiveend);
        return this;
    }

    public Query setKey(String key) {
        this.args.put(KEY, key);
        return this;
    }

    public Query setLimit(int limit) {
        this.args.put(LIMIT, limit);
        return this;
    }

    public Query setRange(String startkey, String endkey) {
        this.args.put(ENDKEY, endkey);
        this.args.put(STARTKEY, startkey);
        return this;
    }

    public Query setRangeStart(String startkey) {
        this.args.put(STARTKEY, startkey);
        return this;
    }

    public Query setReduce(boolean reduce) {
        this.args.put(REDUCE, new Boolean(reduce));
        return this;
    }

    public Query setRangeEnd(String endkey) {
        this.args.put(ENDKEY, endkey);
        return this;
    }

    public Query setSkip(int docstoskip) {
        this.args.put(SKIP, docstoskip);
        return this;
    }

    public Query setStale(Stale stale) {
        if (stale == Stale.OK) {
            this.args.put(STALE, (Object)stale);
        } else if (stale == Stale.UPDATE_AFTER) {
            this.args.put(STALE, (Object)stale);
        }
        return this;
    }

    public Query setStartkeyDocID(String startkeydocid) {
        this.args.put(STARTKEYDOCID, startkeydocid);
        return this;
    }

    public Query setUpdateSeq(boolean updateseq) {
        this.args.put(UPDATESEQ, Boolean.toString(updateseq));
        return this;
    }

    public Query copy() {
        Query query = new Query();
        if (this.args.containsKey(DESCENDING)) {
            query.setDescending((Boolean)this.args.get(DESCENDING));
        }
        if (this.args.containsKey(ENDKEY)) {
            query.setRangeEnd((String)this.args.get(ENDKEY));
        }
        if (this.args.containsKey(ENDKEYDOCID)) {
            query.setEndkeyDocID((String)this.args.get(ENDKEYDOCID));
        }
        if (this.args.containsKey(GROUP)) {
            query.setGroup((Boolean)this.args.get(GROUP));
        }
        if (this.args.containsKey(GROUPLEVEL)) {
            query.setGroup((Boolean)this.args.get(GROUP), (Integer)this.args.get(GROUPLEVEL));
        }
        if (this.args.containsKey(INCLUSIVEEND)) {
            query.setInclusiveEnd((Boolean)this.args.get(INCLUSIVEEND));
        }
        if (this.args.containsKey(KEY)) {
            query.setEndkeyDocID((String)this.args.get(KEY));
        }
        if (this.args.containsKey(LIMIT)) {
            query.setLimit((Integer)this.args.get(LIMIT));
        }
        if (this.args.containsKey(REDUCE)) {
            query.setReduce((Boolean)this.args.get(REDUCE));
        }
        if (this.args.containsKey(SKIP)) {
            query.setSkip((Integer)this.args.get(SKIP));
        }
        if (this.args.containsKey(STALE)) {
            query.setStale((Stale)((Object)this.args.get(STALE)));
        }
        if (this.args.containsKey(STARTKEY)) {
            query.setRangeStart((String)this.args.get(STARTKEY));
        }
        if (this.args.containsKey(STARTKEYDOCID)) {
            query.setStartkeyDocID((String)this.args.get(STARTKEYDOCID));
        }
        if (this.args.containsKey(UPDATESEQ)) {
            query.setUpdateSeq((Boolean)this.args.get(UPDATESEQ));
        }
        this.setIncludeDocs(this.willIncludeDocs());
        return query;
    }

    public String toString() {
        boolean first = true;
        StringBuffer result = new StringBuffer();
        for (Map.Entry<String, Object> arg : this.args.entrySet()) {
            if (first) {
                result.append("?");
                first = false;
            } else {
                result.append("&");
            }
            result.append(this.getArg(arg.getKey(), arg.getValue()));
        }
        return result.toString();
    }

    private String getArg(String key, Object value) {
        if (key.equals(STARTKEYDOCID)) {
            return key + "=" + value;
        }
        if (value instanceof Stale) {
            return key + "=" + ((Stale)((Object)value)).toString();
        }
        if (StringUtils.isJsonObject(value.toString())) {
            return key + "=" + value.toString();
        }
        return key + "=\"" + value + "\"";
    }
}

