/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.couch;

import java.text.ParseException;
import java.util.Iterator;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationException;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.couch.HttpOperationImpl;
import net.spy.memcached.protocol.couch.View;
import net.spy.memcached.protocol.couch.ViewFetcherOperation;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ViewFetcherOperationImpl
extends HttpOperationImpl
implements ViewFetcherOperation {
    private final String bucketName;
    private final String designDocName;
    private final String viewName;

    public ViewFetcherOperationImpl(HttpRequest r, String bucketName, String designDocName, String viewName, ViewFetcherOperation.ViewFetcherCallback viewCallback) {
        super(r, viewCallback);
        this.bucketName = bucketName;
        this.designDocName = designDocName;
        this.viewName = viewName;
    }

    @Override
    public void handleResponse(HttpResponse response) {
        String json = this.getEntityString(response);
        try {
            View view = this.parseDesignDocumentForView(this.bucketName, this.designDocName, this.viewName, json);
            int errorcode = response.getStatusLine().getStatusCode();
            if (errorcode == 200) {
                ((ViewFetcherOperation.ViewFetcherCallback)this.callback).gotData(view);
                this.callback.receivedStatus(new OperationStatus(true, "OK"));
            } else {
                this.callback.receivedStatus(new OperationStatus(false, Integer.toString(errorcode)));
            }
        }
        catch (ParseException e) {
            this.exception = new OperationException(OperationErrorType.GENERAL, "Error parsing JSON");
        }
        this.callback.complete();
    }

    private View parseDesignDocumentForView(String dn, String ddn, String viewname, String json) throws ParseException {
        View view;
        block5: {
            view = null;
            if (json != null) {
                try {
                    JSONObject base = new JSONObject(json);
                    if (base.has("error")) {
                        return null;
                    }
                    if (!base.has("views")) break block5;
                    JSONObject views = base.getJSONObject("views");
                    Iterator itr = views.keys();
                    while (itr.hasNext()) {
                        String curView = (String)itr.next();
                        if (!curView.equals(viewname)) continue;
                        boolean map = views.getJSONObject(curView).has("map");
                        boolean reduce = views.getJSONObject(curView).has("reduce");
                        view = new View(dn, ddn, viewname, map, reduce);
                        break;
                    }
                }
                catch (JSONException e) {
                    throw new ParseException("Cannot read json: " + json, 0);
                }
            }
        }
        return view;
    }
}

