/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.vbucket;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.spy.memcached.vbucket.BucketMonitor;
import net.spy.memcached.vbucket.ConnectionException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

@ChannelPipelineCoverage(value="one")
public class BucketUpdateResponseHandler
extends SimpleChannelUpstreamHandler {
    private volatile boolean readingChunks;
    private String lastResponse;
    private ChannelFuture receivedFuture;
    private CountDownLatch latch;
    private StringBuilder partialResponse;
    private BucketMonitor monitor;
    private static final Logger LOGGER = Logger.getLogger(BucketUpdateResponseHandler.class.getName());

    public void messageReceived(ChannelHandlerContext context, MessageEvent event) {
        ChannelFuture channelFuture = event.getFuture();
        this.setReceivedFuture(channelFuture);
        if (this.partialResponse == null) {
            this.partialResponse = new StringBuilder();
        }
        if (this.readingChunks) {
            HttpChunk chunk = (HttpChunk)event.getMessage();
            if (chunk.isLast()) {
                this.readingChunks = false;
            } else {
                String curChunk = chunk.getContent().toString("UTF-8");
                if (curChunk.matches("\n\n\n\n")) {
                    this.setLastResponse(this.partialResponse.toString());
                    this.partialResponse = null;
                    this.getLatch().countDown();
                    if (this.monitor != null) {
                        this.monitor.invalidate();
                    }
                } else {
                    this.finerLog(curChunk);
                    this.finerLog("Chunk length is: " + curChunk.length());
                    this.partialResponse.append(curChunk);
                    channelFuture.setSuccess();
                }
            }
        } else {
            HttpResponse response = (HttpResponse)event.getMessage();
            this.logResponse(response);
        }
    }

    private void logResponse(HttpResponse response) {
        this.finerLog("STATUS: " + response.getStatus());
        this.finerLog("VERSION: " + response.getProtocolVersion());
        if (!response.getHeaderNames().isEmpty()) {
            for (String name : response.getHeaderNames()) {
                for (String value : response.getHeaders(name)) {
                    this.finerLog("HEADER: " + name + " = " + value);
                }
            }
            this.finerLog(System.getProperty("line.separator"));
        }
        if (response.getStatus().getCode() == 200 && response.isChunked()) {
            this.readingChunks = true;
            this.finerLog("CHUNKED CONTENT {");
        } else {
            ChannelBuffer content = response.getContent();
            if (content.readable()) {
                this.finerLog("CONTENT {");
                this.finerLog(content.toString("UTF-8"));
                this.finerLog("} END OF CONTENT");
            }
        }
    }

    protected String getLastResponse() {
        ChannelFuture channelFuture = this.getReceivedFuture();
        if (channelFuture.awaitUninterruptibly(30L, TimeUnit.SECONDS)) {
            return this.lastResponse;
        }
        throw new ConnectionException("Cannot contact any server in the pool");
    }

    private void setLastResponse(String newLastResponse) {
        this.lastResponse = newLastResponse;
    }

    private ChannelFuture getReceivedFuture() {
        try {
            this.getLatch().await();
        }
        catch (InterruptedException ex) {
            this.finerLog("Getting received future has been interrupted.");
        }
        return this.receivedFuture;
    }

    private void setReceivedFuture(ChannelFuture newReceivedFuture) {
        this.receivedFuture = newReceivedFuture;
    }

    private CountDownLatch getLatch() {
        if (this.latch == null) {
            this.latch = new CountDownLatch(1);
        }
        return this.latch;
    }

    private void finerLog(String message) {
        LOGGER.log(Level.FINER, message);
    }

    public void handleUpstream(ChannelHandlerContext context, ChannelEvent event) throws Exception {
        if (event instanceof ChannelStateEvent) {
            LOGGER.log(Level.FINEST, "Channel state changed: " + event + "\n\n");
        }
        super.handleUpstream(context, event);
    }

    protected void setBucketMonitor(BucketMonitor newMonitor) {
        this.monitor = newMonitor;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        LOGGER.log(Level.INFO, "Exception occurred: ");
        if (this.monitor != null) {
            this.monitor.invalidate();
        }
    }
}

