(ns net.thegeez.w3a.user
  (:require [io.pedestal.log :refer [info]]
            [com.stuartsierra.component :as component]
            [clojure.tools.namespace.repl :refer (refresh)]
            [clojure.java.io :as io]
            [clojure.string :as str]
            [clojure.pprint :refer (pprint)]
            [clojure.repl :refer :all]
            [clojure.test :as test]))

(def system nil)

(def init-system nil) ;; to be altered by user

(defn start []
  (alter-var-root #'system component/start)
  :started)

(defn init []
  (assert init-system "Need to bind init-system with your system")
  (alter-var-root #'system
                  (fn [_] (init-system))))

(defn stop []
  (alter-var-root #'system
    (fn [s] (when s (component/stop s) nil))))

(defn go []
  (if system
    "System not nil, use (reset) ?"
    (do (init)
        (start))))

(defn reset []
  (stop)
  (refresh :after 'net.thegeez.w3a.user/go))

;; lein trampoline run -m user/run
(defn run []
  (go)
  (.addShutdownHook (Runtime/getRuntime)
                    (Thread. (fn []
                               (stop)))))
