(ns net.vemv.util
  (:require
   [clojure.java.io :as io]))

(def ^:private system-clipboard (. (java.awt.Toolkit/getDefaultToolkit) getSystemClipboard))

(defn
  ^{:examples '[(with-out-str (clipboard (doc distinct)))
                (clipboard (clipboard "foo!"))]}
  "Gets/sets the system's clipboard string respectively, depending on whether an argument is given."
  clipboard
  ([]
     (let [contents (. system-clipboard getContents nil)]
       (cond
        (nil? contents) nil
        (not (. contents isDataFlavorSupported java.awt.datatransfer.DataFlavor/stringFlavor)) nil
        true (. contents getTransferData java.awt.datatransfer.DataFlavor/stringFlavor))))
  ([string]
     (let [selection (java.awt.datatransfer.StringSelection. string)]
       (.setContents system-clipboard selection selection)
       string)))

(defn date
  "Returns an #inst from corresponding to the call time, a string or to three integers respectively."
  ([]
     (java.util.Date.))
  ([yyyymmdd]
     (-> (java.text.SimpleDateFormat. "yyyy/MM/dd") (.parse yyyymmdd)))
  ([yyyy mm dd]
     (doto (java.util.Calendar/getInstance)
       (.set java.util.Calendar/YEAR yyyy)
       (.set java.util.Calendar/MONTH mm)
       (.set java.util.Calendar/DAY_OF_MONTH dd))))

(defn sysout
  "printlns its arguments to `System.out`.

Useful for printing values between different editors/terminals - 
e.g. from Emacs to gnome-terminal."
  [& args]
  (binding [*out* (io/writer System/out)]
    (apply println args)))