/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt.x11;

import com.sun.javafx.newt.Window;
import com.sun.javafx.newt.x11.X11Display;
import com.sun.javafx.newt.x11.X11Screen;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.x11.X11GraphicsConfiguration;

public class X11Window
extends Window {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private int nfs_width;
    private int nfs_height;
    private int nfs_x;
    private int nfs_y;
    private long windowHandleClose;
    private long displayHandleClose;
    private long parentWindowHandle;

    protected void createNative(long l, Capabilities capabilities) {
        X11Screen x11Screen = (X11Screen)this.getScreen();
        X11Display x11Display = (X11Display)x11Screen.getDisplay();
        this.config = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)x11Display.getGraphicsDevice()).chooseGraphicsConfiguration(capabilities, null, x11Screen.getGraphicsScreen());
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        X11GraphicsConfiguration x11GraphicsConfiguration = (X11GraphicsConfiguration)this.config;
        long l2 = x11GraphicsConfiguration.getVisualID();
        long l3 = this.CreateWindow(l, x11Display.getHandle(), x11Screen.getIndex(), l2, x11Display.getJavaObjectAtom(), x11Display.getWindowDeleteAtom(), this.x, this.y, this.width, this.height);
        if (l3 == 0L || l3 != this.windowHandle) {
            throw new NativeWindowException("Error creating window: " + l3);
        }
        this.parentWindowHandle = l;
        this.windowHandleClose = this.windowHandle;
        this.displayHandleClose = x11Display.getHandle();
    }

    protected void closeNative() {
        if (0L != this.displayHandleClose && 0L != this.windowHandleClose) {
            X11Display x11Display = (X11Display)this.getScreen().getDisplay();
            this.CloseWindow(this.displayHandleClose, this.windowHandleClose, x11Display.getJavaObjectAtom());
            this.windowHandleClose = 0L;
            this.displayHandleClose = 0L;
        }
    }

    protected void windowDestroyed() {
        this.windowHandleClose = 0L;
        this.displayHandleClose = 0L;
        super.windowDestroyed();
    }

    public void setVisible(boolean bl) {
        if (0L != this.windowHandle && this.visible != bl) {
            this.visible = bl;
            this.setVisible0(this.getDisplayHandle(), this.windowHandle, bl);
            this.clearEventMask();
        }
    }

    public void requestFocus() {
        super.requestFocus();
    }

    public void setSize(int n, int n2) {
        if (0L == this.windowHandle) {
            return;
        }
        if (!this.visible) {
            this.width = n;
            this.height = n2;
        }
        if (!this.fullscreen) {
            this.nfs_width = n;
            this.nfs_height = n2;
        }
        this.setSize0(this.parentWindowHandle, this.getDisplayHandle(), this.getScreenIndex(), this.windowHandle, this.x, this.y, n, n2, this.undecorated || this.fullscreen ? -1 : 1, false);
    }

    public void setPosition(int n, int n2) {
        if (0L == this.windowHandle) {
            return;
        }
        if (!this.visible) {
            this.x = n;
            this.y = n2;
        }
        if (!this.fullscreen) {
            this.nfs_x = n;
            this.nfs_y = n2;
        }
        this.setPosition0(this.getDisplayHandle(), this.windowHandle, n, n2);
    }

    public boolean setFullscreen(boolean bl) {
        if (0L != this.windowHandle && this.fullscreen != bl) {
            int n;
            int n2;
            int n3;
            int n4;
            this.fullscreen = bl;
            if (bl) {
                n4 = 0;
                n3 = 0;
                n2 = this.screen.getWidth();
                n = this.screen.getHeight();
            } else {
                n4 = this.nfs_x;
                n3 = this.nfs_y;
                n2 = this.nfs_width;
                n = this.nfs_height;
            }
            if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
                System.err.println("X11Window fs: " + bl + " " + n4 + "/" + n3 + " " + n2 + "x" + n);
            }
            this.setSize0(this.parentWindowHandle, this.getDisplayHandle(), this.getScreenIndex(), this.windowHandle, n4, n3, n2, n, this.undecorated || bl ? -1 : 1, false);
        }
        return bl;
    }

    protected static native boolean initIDs();

    private native long CreateWindow(long var1, long var3, int var5, long var6, long var8, long var10, int var12, int var13, int var14, int var15);

    private native void CloseWindow(long var1, long var3, long var5);

    private native void setVisible0(long var1, long var3, boolean var5);

    private native void setSize0(long var1, long var3, int var5, long var6, int var8, int var9, int var10, int var11, int var12, boolean var13);

    private native void setPosition0(long var1, long var3, int var5, int var6);

    private void windowChanged(int n, int n2, int n3, int n4) {
        if (this.width != n3 || this.height != n4) {
            this.width = n3;
            this.height = n4;
            if (!this.fullscreen) {
                this.nfs_width = this.width;
                this.nfs_height = this.height;
            }
            this.sendWindowEvent(100);
        }
        if (this.x != n || this.y != n2) {
            this.x = n;
            this.y = n2;
            if (!this.fullscreen) {
                this.nfs_x = this.x;
                this.nfs_y = this.y;
            }
            this.sendWindowEvent(101);
        }
    }

    private void windowCreated(long l) {
        this.windowHandle = l;
    }

    static {
        X11Display.initSingleton();
    }
}

