/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt.macosx;

import com.sun.javafx.newt.Insets;
import com.sun.javafx.newt.Window;
import com.sun.javafx.newt.macosx.MacDisplay;
import com.sun.javafx.newt.util.MainThread;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ToolkitLock;

public class MacWindow
extends Window {
    private static final int NSBorderlessWindowMask = 0;
    private static final int NSTitledWindowMask = 1;
    private static final int NSClosableWindowMask = 2;
    private static final int NSMiniaturizableWindowMask = 4;
    private static final int NSResizableWindowMask = 8;
    private static final int NSBackingStoreRetained = 0;
    private static final int NSBackingStoreNonretained = 1;
    private static final int NSBackingStoreBuffered = 2;
    private static final int NSUpArrowFunctionKey = 63232;
    private static final int NSDownArrowFunctionKey = 63233;
    private static final int NSLeftArrowFunctionKey = 63234;
    private static final int NSRightArrowFunctionKey = 63235;
    private static final int NSF1FunctionKey = 63236;
    private static final int NSF2FunctionKey = 63237;
    private static final int NSF3FunctionKey = 63238;
    private static final int NSF4FunctionKey = 63239;
    private static final int NSF5FunctionKey = 63240;
    private static final int NSF6FunctionKey = 63241;
    private static final int NSF7FunctionKey = 63242;
    private static final int NSF8FunctionKey = 63243;
    private static final int NSF9FunctionKey = 63244;
    private static final int NSF10FunctionKey = 63245;
    private static final int NSF11FunctionKey = 63246;
    private static final int NSF12FunctionKey = 63247;
    private static final int NSF13FunctionKey = 63248;
    private static final int NSF14FunctionKey = 63249;
    private static final int NSF15FunctionKey = 63250;
    private static final int NSF16FunctionKey = 63251;
    private static final int NSF17FunctionKey = 63252;
    private static final int NSF18FunctionKey = 63253;
    private static final int NSF19FunctionKey = 63254;
    private static final int NSF20FunctionKey = 63255;
    private static final int NSF21FunctionKey = 63256;
    private static final int NSF22FunctionKey = 63257;
    private static final int NSF23FunctionKey = 63258;
    private static final int NSF24FunctionKey = 63259;
    private static final int NSF25FunctionKey = 63260;
    private static final int NSF26FunctionKey = 63261;
    private static final int NSF27FunctionKey = 63262;
    private static final int NSF28FunctionKey = 63263;
    private static final int NSF29FunctionKey = 63264;
    private static final int NSF30FunctionKey = 63265;
    private static final int NSF31FunctionKey = 63266;
    private static final int NSF32FunctionKey = 63267;
    private static final int NSF33FunctionKey = 63268;
    private static final int NSF34FunctionKey = 63269;
    private static final int NSF35FunctionKey = 63270;
    private static final int NSInsertFunctionKey = 63271;
    private static final int NSDeleteFunctionKey = 63272;
    private static final int NSHomeFunctionKey = 63273;
    private static final int NSBeginFunctionKey = 63274;
    private static final int NSEndFunctionKey = 63275;
    private static final int NSPageUpFunctionKey = 63276;
    private static final int NSPageDownFunctionKey = 63277;
    private static final int NSPrintScreenFunctionKey = 63278;
    private static final int NSScrollLockFunctionKey = 63279;
    private static final int NSPauseFunctionKey = 63280;
    private static final int NSSysReqFunctionKey = 63281;
    private static final int NSBreakFunctionKey = 63282;
    private static final int NSResetFunctionKey = 63283;
    private static final int NSStopFunctionKey = 63284;
    private static final int NSMenuFunctionKey = 63285;
    private static final int NSUserFunctionKey = 63286;
    private static final int NSSystemFunctionKey = 63287;
    private static final int NSPrintFunctionKey = 63288;
    private static final int NSClearLineFunctionKey = 63289;
    private static final int NSClearDisplayFunctionKey = 63290;
    private static final int NSInsertLineFunctionKey = 63291;
    private static final int NSDeleteLineFunctionKey = 63292;
    private static final int NSInsertCharFunctionKey = 63293;
    private static final int NSDeleteCharFunctionKey = 63294;
    private static final int NSPrevFunctionKey = 63295;
    private static final int NSNextFunctionKey = 63296;
    private static final int NSSelectFunctionKey = 63297;
    private static final int NSExecuteFunctionKey = 63298;
    private static final int NSUndoFunctionKey = 63299;
    private static final int NSRedoFunctionKey = 63300;
    private static final int NSFindFunctionKey = 63301;
    private static final int NSHelpFunctionKey = 63302;
    private static final int NSModeSwitchFunctionKey = 63303;
    private volatile long surfaceHandle;
    private long parentWindowHandle;
    private int nfs_width;
    private int nfs_height;
    private int nfs_x;
    private int nfs_y;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private CloseAction closeAction = new CloseAction();
    private EnsureWindowCreatedAction ensureWindowCreatedAction = new EnsureWindowCreatedAction();
    private ToolkitLock nsViewLock = new ToolkitLock(){
        private Thread owner;
        private int recursionCount;

        public synchronized void lock() {
            Thread thread = Thread.currentThread();
            if (this.owner == thread) {
                ++this.recursionCount;
                return;
            }
            while (this.owner != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            this.owner = thread;
        }

        public synchronized void unlock() {
            if (this.owner != Thread.currentThread()) {
                throw new RuntimeException("Not owner");
            }
            if (this.recursionCount > 0) {
                --this.recursionCount;
                return;
            }
            this.owner = null;
            this.notifyAll();
        }
    };
    private VisibleAction visibleAction = new VisibleAction();
    private TitleAction titleAction = new TitleAction();
    private FocusAction focusAction = new FocusAction();
    private SizeAction sizeAction = new SizeAction();
    private PositionAction positionAction = new PositionAction();
    private FullscreenAction fullscreenAction = new FullscreenAction();

    protected void createNative(long l, Capabilities capabilities) {
        this.parentWindowHandle = l;
        this.config = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)this.getScreen().getDisplay().getGraphicsDevice()).chooseGraphicsConfiguration(capabilities, null, this.getScreen().getGraphicsScreen());
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + (Object)((Object)this));
        }
    }

    protected void closeNative() {
        MainThread.invoke((boolean)true, (Runnable)this.closeAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWindowHandle() {
        this.nsViewLock.lock();
        try {
            long l = this.windowHandle;
            return l;
        }
        finally {
            this.nsViewLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSurfaceHandle() {
        this.nsViewLock.lock();
        try {
            long l = this.surfaceHandle;
            return l;
        }
        finally {
            this.nsViewLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Insets getInsets() {
        MainThread.invoke((boolean)true, (Runnable)this.ensureWindowCreatedAction);
        this.nsViewLock.lock();
        try {
            Insets insets = (Insets)this.insets.clone();
            return insets;
        }
        finally {
            this.nsViewLock.unlock();
        }
    }

    public synchronized int lockSurface() throws NativeWindowException {
        this.nsViewLock.lock();
        return super.lockSurface();
    }

    public void unlockSurface() {
        super.unlockSurface();
        this.nsViewLock.unlock();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        MainThread.invoke((boolean)true, (Runnable)this.visibleAction);
    }

    public void setTitle(String string) {
        super.setTitle(string);
        MainThread.invoke((boolean)true, (Runnable)this.titleAction);
    }

    public void requestFocus() {
        super.requestFocus();
        MainThread.invoke((boolean)true, (Runnable)this.focusAction);
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        if (!this.fullscreen) {
            this.nfs_width = n;
            this.nfs_height = n2;
        }
        MainThread.invoke((boolean)true, (Runnable)this.sizeAction);
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        if (!this.fullscreen) {
            this.nfs_x = n;
            this.nfs_y = n2;
        }
        MainThread.invoke((boolean)true, (Runnable)this.positionAction);
    }

    public boolean setFullscreen(boolean bl) {
        if (this.fullscreen != bl) {
            this.fullscreen = bl;
            if (bl) {
                this.x = 0;
                this.y = 0;
                this.width = this.screen.getWidth();
                this.height = this.screen.getHeight();
            } else {
                this.x = this.nfs_x;
                this.y = this.nfs_y;
                this.width = this.nfs_width;
                this.height = this.nfs_height;
            }
            MainThread.invoke((boolean)true, (Runnable)this.fullscreenAction);
        }
        return bl;
    }

    private void sizeChanged(int n, int n2) {
        if (DEBUG_IMPLEMENTATION) {
            System.out.println(Thread.currentThread().getName() + " Size changed to " + n + ", " + n2);
        }
        this.width = n;
        this.height = n2;
        if (!this.fullscreen) {
            this.nfs_width = this.width;
            this.nfs_height = this.height;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.out.println("  Posted WINDOW_RESIZED event");
        }
        this.sendWindowEvent(100);
    }

    private void insetsChanged(int n, int n2, int n3, int n4) {
        if (DEBUG_IMPLEMENTATION) {
            System.out.println(Thread.currentThread().getName() + " Insets changed to " + n + ", " + n2 + ", " + n3 + ", " + n4);
        }
        if (n != -1 && n2 != -1 && n3 != -1 && n4 != -1) {
            this.insets.left = n;
            this.insets.top = n2;
            this.insets.right = n3;
            this.insets.bottom = n4;
        }
    }

    private void positionChanged(int n, int n2) {
        if (DEBUG_IMPLEMENTATION) {
            System.out.println(Thread.currentThread().getName() + " Position changed to " + n + ", " + n2);
        }
        this.x = n;
        this.y = n2;
        if (!this.fullscreen) {
            this.nfs_x = this.x;
            this.nfs_y = this.y;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.out.println("  Posted WINDOW_MOVED event");
        }
        this.sendWindowEvent(101);
    }

    private void focusChanged(boolean bl) {
        if (bl) {
            this.sendWindowEvent(103);
        } else {
            this.sendWindowEvent(104);
        }
    }

    private char convertKeyChar(char c) {
        if (c == '\r') {
            return '\n';
        }
        if (c >= '\uf700' && c <= '\uf747') {
            switch (c) {
                case '\uf700': {
                    return '&';
                }
                case '\uf701': {
                    return '(';
                }
                case '\uf702': {
                    return '%';
                }
                case '\uf703': {
                    return '\'';
                }
                case '\uf704': {
                    return 'p';
                }
                case '\uf705': {
                    return 'q';
                }
                case '\uf706': {
                    return 'r';
                }
                case '\uf707': {
                    return 's';
                }
                case '\uf708': {
                    return 't';
                }
                case '\uf709': {
                    return 'u';
                }
                case '\uf70a': {
                    return 'v';
                }
                case '\uf70b': {
                    return 'w';
                }
                case '\uf70c': {
                    return 'x';
                }
                case '\uf70d': {
                    return 'y';
                }
                case '\uf70e': {
                    return 'z';
                }
                case '\uf70f': {
                    return '{';
                }
                case '\uf710': {
                    return '\uf000';
                }
                case '\uf711': {
                    return '\uf001';
                }
                case '\uf712': {
                    return '\uf002';
                }
                case '\uf713': {
                    return '\uf003';
                }
                case '\uf714': {
                    return '\uf004';
                }
                case '\uf715': {
                    return '\uf005';
                }
                case '\uf716': {
                    return '\uf006';
                }
                case '\uf717': {
                    return '\uf007';
                }
                case '\uf718': {
                    return '\uf008';
                }
                case '\uf719': {
                    return '\uf009';
                }
                case '\uf71a': {
                    return '\uf00a';
                }
                case '\uf71b': {
                    return '\uf00b';
                }
                case '\uf727': {
                    return '\u009b';
                }
                case '\uf728': {
                    return '\u007f';
                }
                case '\uf729': {
                    return '$';
                }
                case '\uf72a': {
                    return '\uff58';
                }
                case '\uf72b': {
                    return '#';
                }
                case '\uf72c': {
                    return '!';
                }
                case '\uf72d': {
                    return '\"';
                }
                case '\uf72e': {
                    return '\u009a';
                }
                case '\uf72f': {
                    return '\u0091';
                }
                case '\uf730': {
                    return '\u0013';
                }
                case '\uf734': {
                    return '\uffc8';
                }
            }
        }
        if (c >= 'a' && c <= 'z') {
            return Character.toUpperCase(c);
        }
        return c;
    }

    protected void sendKeyEvent(int n, int n2, int n3, char c) {
        char c2 = this.convertKeyChar(c);
        if (DEBUG_IMPLEMENTATION) {
            System.out.println("MacWindow.sendKeyEvent " + Thread.currentThread().getName());
        }
        super.sendKeyEvent(n, n2, (int)c2, c);
    }

    private void createWindow(long l, boolean bl) {
        if (0L != this.windowHandle && !bl) {
            return;
        }
        if (0L != this.windowHandle) {
            this.surfaceHandle = this.changeContentView(l, this.windowHandle, 0L);
            if (bl && 0L == this.surfaceHandle) {
                throw new NativeWindowException("Internal Error - recreate, window but no view");
            }
            this.close0(this.windowHandle);
            this.windowHandle = 0L;
        } else {
            this.surfaceHandle = 0L;
        }
        this.windowHandle = this.createWindow0(l, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.fullscreen, this.isUndecorated() ? 0 : 15, 2, this.getScreen().getIndex(), this.surfaceHandle);
        if (this.windowHandle == 0L) {
            throw new NativeWindowException("Could create native window " + Thread.currentThread().getName() + " " + (Object)((Object)this));
        }
        this.surfaceHandle = this.contentView(this.windowHandle);
        this.setTitle0(this.windowHandle, this.getTitle());
        this.sendWindowEvent(101);
        this.sendWindowEvent(100);
        this.sendWindowEvent(103);
    }

    protected static native boolean initIDs();

    private native long createWindow0(long var1, int var3, int var4, int var5, int var6, boolean var7, int var8, int var9, int var10, long var11);

    private native void makeKeyAndOrderFront(long var1);

    private native void makeKey(long var1);

    private native void orderOut(long var1);

    private native void close0(long var1);

    private native void setTitle0(long var1, String var3);

    private native long contentView(long var1);

    private native long changeContentView(long var1, long var3, long var5);

    private native void setContentSize(long var1, int var3, int var4);

    private native void setFrameTopLeftPoint(long var1, long var3, int var5, int var6);

    static {
        MacDisplay.initSingleton();
    }

    class CloseAction
    implements Runnable {
        CloseAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MacWindow.this.nsViewLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.out.println("MacWindow.CloseAction " + Thread.currentThread().getName());
                }
                if (MacWindow.this.windowHandle != 0L) {
                    MacWindow.this.close0(MacWindow.this.windowHandle);
                    MacWindow.this.windowHandle = 0L;
                }
            }
            finally {
                MacWindow.this.nsViewLock.unlock();
            }
        }
    }

    class EnsureWindowCreatedAction
    implements Runnable {
        EnsureWindowCreatedAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MacWindow.this.nsViewLock.lock();
            try {
                MacWindow.this.createWindow(MacWindow.this.parentWindowHandle, false);
            }
            finally {
                MacWindow.this.nsViewLock.unlock();
            }
        }
    }

    class FocusAction
    implements Runnable {
        FocusAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MacWindow.this.nsViewLock.lock();
            try {
                if (MacWindow.this.windowHandle != 0L) {
                    MacWindow.this.makeKey(MacWindow.this.windowHandle);
                }
            }
            finally {
                MacWindow.this.nsViewLock.unlock();
            }
        }
    }

    class FullscreenAction
    implements Runnable {
        FullscreenAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MacWindow.this.nsViewLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION || Window.DEBUG_WINDOW_EVENT) {
                    System.err.println("MacWindow fs: " + MacWindow.this.fullscreen + " " + MacWindow.this.x + "/" + MacWindow.this.y + " " + MacWindow.this.width + "x" + MacWindow.this.height);
                }
                MacWindow.this.createWindow(MacWindow.this.parentWindowHandle, true);
                if (MacWindow.this.windowHandle != 0L) {
                    MacWindow.this.makeKeyAndOrderFront(MacWindow.this.windowHandle);
                }
            }
            finally {
                MacWindow.this.nsViewLock.unlock();
            }
        }
    }

    class PositionAction
    implements Runnable {
        PositionAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MacWindow.this.nsViewLock.lock();
            try {
                if (MacWindow.this.windowHandle != 0L) {
                    MacWindow.this.setFrameTopLeftPoint(MacWindow.this.parentWindowHandle, MacWindow.this.windowHandle, MacWindow.this.x, MacWindow.this.y);
                }
            }
            finally {
                MacWindow.this.nsViewLock.unlock();
            }
        }
    }

    class SizeAction
    implements Runnable {
        SizeAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MacWindow.this.nsViewLock.lock();
            try {
                if (MacWindow.this.windowHandle != 0L) {
                    MacWindow.this.setContentSize(MacWindow.this.windowHandle, MacWindow.this.width, MacWindow.this.height);
                }
            }
            finally {
                MacWindow.this.nsViewLock.unlock();
            }
        }
    }

    class TitleAction
    implements Runnable {
        TitleAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MacWindow.this.nsViewLock.lock();
            try {
                if (MacWindow.this.windowHandle != 0L) {
                    MacWindow.this.setTitle0(MacWindow.this.windowHandle, MacWindow.this.title);
                }
            }
            finally {
                MacWindow.this.nsViewLock.unlock();
            }
        }
    }

    class VisibleAction
    implements Runnable {
        VisibleAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MacWindow.this.nsViewLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.out.println("MacWindow.VisibleAction " + MacWindow.this.visible + " " + Thread.currentThread().getName());
                }
                if (MacWindow.this.visible) {
                    MacWindow.this.createWindow(MacWindow.this.parentWindowHandle, false);
                    if (MacWindow.this.windowHandle != 0L) {
                        MacWindow.this.makeKeyAndOrderFront(MacWindow.this.windowHandle);
                    }
                } else if (MacWindow.this.windowHandle != 0L) {
                    MacWindow.this.orderOut(MacWindow.this.windowHandle);
                }
            }
            finally {
                MacWindow.this.nsViewLock.unlock();
            }
        }
    }
}

