// Compiled by ClojureScript 1.9.562 {}
goog.provide('cats.context');
goog.require('cljs.core');
goog.require('cats.protocols');
cats.context._STAR_context_STAR_ = null;
cats.context.throw_illegal_argument = (function cats$context$throw_illegal_argument(text){
throw cljs.core.ex_info.call(null,text,cljs.core.PersistentArrayMap.EMPTY);
});
/**
 * Return `true` if the provided value satisfies
 *   the Context protocol.
 */
cats.context.context_QMARK_ = (function cats$context$context_QMARK_(v){
if(!((v == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === v.cats$protocols$Context$))){
return true;
} else {
if((!v.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cats.protocols.Context,v);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cats.protocols.Context,v);
}
});
/**
 * Given an optional value infer its context. If context is already set, it
 *   is returned as is without any inference operation.
 */
cats.context.infer = (function cats$context$infer(var_args){
var args22190 = [];
var len__8628__auto___22194 = arguments.length;
var i__8629__auto___22195 = (0);
while(true){
if((i__8629__auto___22195 < len__8628__auto___22194)){
args22190.push((arguments[i__8629__auto___22195]));

var G__22196 = (i__8629__auto___22195 + (1));
i__8629__auto___22195 = G__22196;
continue;
} else {
}
break;
}

var G__22192 = args22190.length;
switch (G__22192) {
case 0:
return cats.context.infer.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cats.context.infer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args22190.length)].join('')));

}
});

cats.context.infer.cljs$core$IFn$_invoke$arity$0 = (function (){
if((cats.context._STAR_context_STAR_ == null)){
cats.context.throw_illegal_argument.call(null,"No context is set.");
} else {
}

return cats.context._STAR_context_STAR_;
});

cats.context.infer.cljs$core$IFn$_invoke$arity$1 = (function (v){
if(!((cats.context._STAR_context_STAR_ == null))){
return cats.context._STAR_context_STAR_;
} else {
if(((!((v == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === v.cats$protocols$Contextual$)))?true:(((!v.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,cats.protocols.Contextual,v):false)):cljs.core.native_satisfies_QMARK_.call(null,cats.protocols.Contextual,v))){
return cats.protocols._get_context.call(null,v);
} else {
return cats.context.throw_illegal_argument.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("No context is set and it can not be automatically "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("resolved from provided value")].join(''));

}
}
});

cats.context.infer.cljs$lang$maxFixedArity = 1;

/**
 * Deprecated alias to `infer`.
 */
cats.context.get_current = (function cats$context$get_current(var_args){
var args__8635__auto__ = [];
var len__8628__auto___22199 = arguments.length;
var i__8629__auto___22200 = (0);
while(true){
if((i__8629__auto___22200 < len__8628__auto___22199)){
args__8635__auto__.push((arguments[i__8629__auto___22200]));

var G__22201 = (i__8629__auto___22200 + (1));
i__8629__auto___22200 = G__22201;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((0) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((0)),(0),null)):null);
return cats.context.get_current.cljs$core$IFn$_invoke$arity$variadic(argseq__8636__auto__);
});

cats.context.get_current.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cats.context.infer,args);
});

cats.context.get_current.cljs$lang$maxFixedArity = (0);

cats.context.get_current.cljs$lang$applyTo = (function (seq22198){
return cats.context.get_current.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22198));
});


//# sourceMappingURL=context.js.map