// Compiled by ClojureScript 1.9.562 {}
goog.provide('cljs.core.async.impl.channels');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.buffers');
cljs.core.async.impl.channels.box = (function cljs$core$async$impl$channels$box(val){
if(typeof cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711 = (function (val,meta8712){
this.val = val;
this.meta8712 = meta8712;
this.cljs$lang$protocol_mask$partition0$ = 425984;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8713,meta8712__$1){
var self__ = this;
var _8713__$1 = this;
return (new cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711(self__.val,meta8712__$1));
});

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8713){
var self__ = this;
var _8713__$1 = this;
return self__.meta8712;
});

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.val;
});

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta8712","meta8712",-110275481,null)], null);
});

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711.cljs$lang$type = true;

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711.cljs$lang$ctorStr = "cljs.core.async.impl.channels/t_cljs$core$async$impl$channels8711";

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711.cljs$lang$ctorPrWriter = (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async.impl.channels/t_cljs$core$async$impl$channels8711");
});

cljs.core.async.impl.channels.__GT_t_cljs$core$async$impl$channels8711 = (function cljs$core$async$impl$channels$box_$___GT_t_cljs$core$async$impl$channels8711(val__$1,meta8712){
return (new cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711(val__$1,meta8712));
});

}

return (new cljs.core.async.impl.channels.t_cljs$core$async$impl$channels8711(val,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.async.impl.channels.PutBox = (function (handler,val){
this.handler = handler;
this.val = val;
})

cljs.core.async.impl.channels.PutBox.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"handler","handler",1444934915,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
});

cljs.core.async.impl.channels.PutBox.cljs$lang$type = true;

cljs.core.async.impl.channels.PutBox.cljs$lang$ctorStr = "cljs.core.async.impl.channels/PutBox";

cljs.core.async.impl.channels.PutBox.cljs$lang$ctorPrWriter = (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async.impl.channels/PutBox");
});

cljs.core.async.impl.channels.__GT_PutBox = (function cljs$core$async$impl$channels$__GT_PutBox(handler,val){
return (new cljs.core.async.impl.channels.PutBox(handler,val));
});

cljs.core.async.impl.channels.put_active_QMARK_ = (function cljs$core$async$impl$channels$put_active_QMARK_(box){
return cljs.core.async.impl.protocols.active_QMARK_.call(null,box.handler);
});
cljs.core.async.impl.channels.MAX_DIRTY = (64);

/**
 * @interface
 */
cljs.core.async.impl.channels.MMC = function(){};

cljs.core.async.impl.channels.abort = (function cljs$core$async$impl$channels$abort(this$){
if((!((this$ == null))) && (!((this$.cljs$core$async$impl$channels$MMC$abort$arity$1 == null)))){
return this$.cljs$core$async$impl$channels$MMC$abort$arity$1(this$);
} else {
var x__8125__auto__ = (((this$ == null))?null:this$);
var m__8126__auto__ = (cljs.core.async.impl.channels.abort[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,this$);
} else {
var m__8126__auto____$1 = (cljs.core.async.impl.channels.abort["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"MMC.abort",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.async.impl.channels.MMC}
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
*/
cljs.core.async.impl.channels.ManyToManyChannel = (function (takes,dirty_takes,puts,dirty_puts,buf,closed,add_BANG_){
this.takes = takes;
this.dirty_takes = dirty_takes;
this.puts = puts;
this.dirty_puts = dirty_puts;
this.buf = buf;
this.closed = closed;
this.add_BANG_ = add_BANG_;
})
cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$channels$MMC$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$channels$MMC$abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
while(true){
var putter_8725 = self__.puts.pop();
if((putter_8725 == null)){
} else {
var put_handler_8726 = putter_8725.handler;
var val_8727 = putter_8725.val;
if(cljs.core.async.impl.protocols.active_QMARK_.call(null,put_handler_8726)){
var put_cb_8728 = cljs.core.async.impl.protocols.commit.call(null,put_handler_8726);
cljs.core.async.impl.dispatch.run.call(null,((function (put_cb_8728,put_handler_8726,val_8727,putter_8725,this$__$1){
return (function (){
return put_cb_8728.call(null,true);
});})(put_cb_8728,put_handler_8726,val_8727,putter_8725,this$__$1))
);
} else {
continue;
}
}
break;
}

self__.puts.cleanup(cljs.core.constantly.call(null,false));

return cljs.core.async.impl.protocols.close_BANG_.call(null,this$__$1);
});

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (this$,val,handler){
var self__ = this;
var this$__$1 = this;
if(!((val == null))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Can't put nil in on a channel"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(not (nil? val))")].join('')));
}

var closed__$1 = self__.closed;
if((closed__$1) || (!(cljs.core.async.impl.protocols.active_QMARK_.call(null,handler)))){
return cljs.core.async.impl.channels.box.call(null,!(closed__$1));
} else {
if(cljs.core.truth_((function (){var and__7395__auto__ = self__.buf;
if(cljs.core.truth_(and__7395__auto__)){
return cljs.core.not.call(null,cljs.core.async.impl.protocols.full_QMARK_.call(null,self__.buf));
} else {
return and__7395__auto__;
}
})())){
cljs.core.async.impl.protocols.commit.call(null,handler);

var done_QMARK_ = cljs.core.reduced_QMARK_.call(null,self__.add_BANG_.call(null,self__.buf,val));
var take_cbs = (function (){var takers = cljs.core.PersistentVector.EMPTY;
while(true){
if(((self__.takes.length > (0))) && ((cljs.core.count.call(null,self__.buf) > (0)))){
var taker = self__.takes.pop();
if(cljs.core.async.impl.protocols.active_QMARK_.call(null,taker)){
var ret = cljs.core.async.impl.protocols.commit.call(null,taker);
var val__$1 = cljs.core.async.impl.protocols.remove_BANG_.call(null,self__.buf);
var G__8729 = cljs.core.conj.call(null,takers,((function (takers,ret,val__$1,taker,done_QMARK_,closed__$1,this$__$1){
return (function (){
return ret.call(null,val__$1);
});})(takers,ret,val__$1,taker,done_QMARK_,closed__$1,this$__$1))
);
takers = G__8729;
continue;
} else {
var G__8730 = takers;
takers = G__8730;
continue;
}
} else {
return takers;
}
break;
}
})();
if(done_QMARK_){
cljs.core.async.impl.channels.abort.call(null,this$__$1);
} else {
}

if(cljs.core.seq.call(null,take_cbs)){
var seq__8714_8731 = cljs.core.seq.call(null,take_cbs);
var chunk__8715_8732 = null;
var count__8716_8733 = (0);
var i__8717_8734 = (0);
while(true){
if((i__8717_8734 < count__8716_8733)){
var f_8735 = cljs.core._nth.call(null,chunk__8715_8732,i__8717_8734);
cljs.core.async.impl.dispatch.run.call(null,f_8735);

var G__8736 = seq__8714_8731;
var G__8737 = chunk__8715_8732;
var G__8738 = count__8716_8733;
var G__8739 = (i__8717_8734 + (1));
seq__8714_8731 = G__8736;
chunk__8715_8732 = G__8737;
count__8716_8733 = G__8738;
i__8717_8734 = G__8739;
continue;
} else {
var temp__5278__auto___8740 = cljs.core.seq.call(null,seq__8714_8731);
if(temp__5278__auto___8740){
var seq__8714_8741__$1 = temp__5278__auto___8740;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8714_8741__$1)){
var c__8318__auto___8742 = cljs.core.chunk_first.call(null,seq__8714_8741__$1);
var G__8743 = cljs.core.chunk_rest.call(null,seq__8714_8741__$1);
var G__8744 = c__8318__auto___8742;
var G__8745 = cljs.core.count.call(null,c__8318__auto___8742);
var G__8746 = (0);
seq__8714_8731 = G__8743;
chunk__8715_8732 = G__8744;
count__8716_8733 = G__8745;
i__8717_8734 = G__8746;
continue;
} else {
var f_8747 = cljs.core.first.call(null,seq__8714_8741__$1);
cljs.core.async.impl.dispatch.run.call(null,f_8747);

var G__8748 = cljs.core.next.call(null,seq__8714_8741__$1);
var G__8749 = null;
var G__8750 = (0);
var G__8751 = (0);
seq__8714_8731 = G__8748;
chunk__8715_8732 = G__8749;
count__8716_8733 = G__8750;
i__8717_8734 = G__8751;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.core.async.impl.channels.box.call(null,true);
} else {
var taker = (function (){while(true){
var taker = self__.takes.pop();
if(cljs.core.truth_(taker)){
if(cljs.core.truth_(cljs.core.async.impl.protocols.active_QMARK_.call(null,taker))){
return taker;
} else {
continue;
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(taker)){
var take_cb = cljs.core.async.impl.protocols.commit.call(null,taker);
cljs.core.async.impl.protocols.commit.call(null,handler);

cljs.core.async.impl.dispatch.run.call(null,((function (take_cb,taker,closed__$1,this$__$1){
return (function (){
return take_cb.call(null,val);
});})(take_cb,taker,closed__$1,this$__$1))
);

return cljs.core.async.impl.channels.box.call(null,true);
} else {
if((self__.dirty_puts > cljs.core.async.impl.channels.MAX_DIRTY)){
self__.dirty_puts = (0);

self__.puts.cleanup(cljs.core.async.impl.channels.put_active_QMARK_);
} else {
self__.dirty_puts = (self__.dirty_puts + (1));
}

if(cljs.core.truth_(cljs.core.async.impl.protocols.blockable_QMARK_.call(null,handler))){
if((self__.puts.length < cljs.core.async.impl.protocols.MAX_QUEUE_SIZE)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No more than "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.async.impl.protocols.MAX_QUEUE_SIZE),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" pending puts are allowed on a single channel."),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" Consider using a windowed buffer.")].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(< (.-length puts) impl/MAX-QUEUE-SIZE)")].join('')));
}

self__.puts.unbounded_unshift((new cljs.core.async.impl.channels.PutBox(handler,val)));
} else {
}

return null;
}
}
}
});

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (this$,handler){
var self__ = this;
var this$__$1 = this;
if(!(cljs.core.async.impl.protocols.active_QMARK_.call(null,handler))){
return null;
} else {
if((!((self__.buf == null))) && ((cljs.core.count.call(null,self__.buf) > (0)))){
var temp__5276__auto__ = cljs.core.async.impl.protocols.commit.call(null,handler);
if(cljs.core.truth_(temp__5276__auto__)){
var take_cb = temp__5276__auto__;
var val = cljs.core.async.impl.protocols.remove_BANG_.call(null,self__.buf);
var vec__8718 = (((self__.puts.length > (0)))?(function (){var cbs = cljs.core.PersistentVector.EMPTY;
while(true){
var putter = self__.puts.pop();
var put_handler = putter.handler;
var val__$1 = putter.val;
var cb = (function (){var and__7395__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,put_handler);
if(and__7395__auto__){
return cljs.core.async.impl.protocols.commit.call(null,put_handler);
} else {
return and__7395__auto__;
}
})();
var cbs__$1 = (cljs.core.truth_(cb)?cljs.core.conj.call(null,cbs,cb):cbs);
var done_QMARK_ = (cljs.core.truth_(cb)?cljs.core.reduced_QMARK_.call(null,self__.add_BANG_.call(null,self__.buf,val__$1)):null);
if((cljs.core.not.call(null,done_QMARK_)) && (cljs.core.not.call(null,cljs.core.async.impl.protocols.full_QMARK_.call(null,self__.buf))) && ((self__.puts.length > (0)))){
var G__8752 = cbs__$1;
cbs = G__8752;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [done_QMARK_,cbs__$1], null);
}
break;
}
})():null);
var done_QMARK_ = cljs.core.nth.call(null,vec__8718,(0),null);
var cbs = cljs.core.nth.call(null,vec__8718,(1),null);
if(cljs.core.truth_(done_QMARK_)){
cljs.core.async.impl.channels.abort.call(null,this$__$1);
} else {
}

var seq__8721_8753 = cljs.core.seq.call(null,cbs);
var chunk__8722_8754 = null;
var count__8723_8755 = (0);
var i__8724_8756 = (0);
while(true){
if((i__8724_8756 < count__8723_8755)){
var cb_8757 = cljs.core._nth.call(null,chunk__8722_8754,i__8724_8756);
cljs.core.async.impl.dispatch.run.call(null,((function (seq__8721_8753,chunk__8722_8754,count__8723_8755,i__8724_8756,cb_8757,val,vec__8718,done_QMARK_,cbs,take_cb,temp__5276__auto__,this$__$1){
return (function (){
return cb_8757.call(null,true);
});})(seq__8721_8753,chunk__8722_8754,count__8723_8755,i__8724_8756,cb_8757,val,vec__8718,done_QMARK_,cbs,take_cb,temp__5276__auto__,this$__$1))
);

var G__8758 = seq__8721_8753;
var G__8759 = chunk__8722_8754;
var G__8760 = count__8723_8755;
var G__8761 = (i__8724_8756 + (1));
seq__8721_8753 = G__8758;
chunk__8722_8754 = G__8759;
count__8723_8755 = G__8760;
i__8724_8756 = G__8761;
continue;
} else {
var temp__5278__auto___8762 = cljs.core.seq.call(null,seq__8721_8753);
if(temp__5278__auto___8762){
var seq__8721_8763__$1 = temp__5278__auto___8762;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8721_8763__$1)){
var c__8318__auto___8764 = cljs.core.chunk_first.call(null,seq__8721_8763__$1);
var G__8765 = cljs.core.chunk_rest.call(null,seq__8721_8763__$1);
var G__8766 = c__8318__auto___8764;
var G__8767 = cljs.core.count.call(null,c__8318__auto___8764);
var G__8768 = (0);
seq__8721_8753 = G__8765;
chunk__8722_8754 = G__8766;
count__8723_8755 = G__8767;
i__8724_8756 = G__8768;
continue;
} else {
var cb_8769 = cljs.core.first.call(null,seq__8721_8763__$1);
cljs.core.async.impl.dispatch.run.call(null,((function (seq__8721_8753,chunk__8722_8754,count__8723_8755,i__8724_8756,cb_8769,seq__8721_8763__$1,temp__5278__auto___8762,val,vec__8718,done_QMARK_,cbs,take_cb,temp__5276__auto__,this$__$1){
return (function (){
return cb_8769.call(null,true);
});})(seq__8721_8753,chunk__8722_8754,count__8723_8755,i__8724_8756,cb_8769,seq__8721_8763__$1,temp__5278__auto___8762,val,vec__8718,done_QMARK_,cbs,take_cb,temp__5276__auto__,this$__$1))
);

var G__8770 = cljs.core.next.call(null,seq__8721_8763__$1);
var G__8771 = null;
var G__8772 = (0);
var G__8773 = (0);
seq__8721_8753 = G__8770;
chunk__8722_8754 = G__8771;
count__8723_8755 = G__8772;
i__8724_8756 = G__8773;
continue;
}
} else {
}
}
break;
}

return cljs.core.async.impl.channels.box.call(null,val);
} else {
return null;
}
} else {
var putter = (function (){while(true){
var putter = self__.puts.pop();
if(cljs.core.truth_(putter)){
if(cljs.core.async.impl.protocols.active_QMARK_.call(null,putter.handler)){
return putter;
} else {
continue;
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(putter)){
var put_cb = cljs.core.async.impl.protocols.commit.call(null,putter.handler);
cljs.core.async.impl.protocols.commit.call(null,handler);

cljs.core.async.impl.dispatch.run.call(null,((function (put_cb,putter,this$__$1){
return (function (){
return put_cb.call(null,true);
});})(put_cb,putter,this$__$1))
);

return cljs.core.async.impl.channels.box.call(null,putter.val);
} else {
if(cljs.core.truth_(self__.closed)){
if(cljs.core.truth_(self__.buf)){
self__.add_BANG_.call(null,self__.buf);
} else {
}

if(cljs.core.truth_((function (){var and__7395__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,handler);
if(cljs.core.truth_(and__7395__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,handler);
} else {
return and__7395__auto__;
}
})())){
var has_val = (function (){var and__7395__auto__ = self__.buf;
if(cljs.core.truth_(and__7395__auto__)){
return (cljs.core.count.call(null,self__.buf) > (0));
} else {
return and__7395__auto__;
}
})();
var val = (cljs.core.truth_(has_val)?cljs.core.async.impl.protocols.remove_BANG_.call(null,self__.buf):null);
return cljs.core.async.impl.channels.box.call(null,val);
} else {
return null;
}
} else {
if((self__.dirty_takes > cljs.core.async.impl.channels.MAX_DIRTY)){
self__.dirty_takes = (0);

self__.takes.cleanup(cljs.core.async.impl.protocols.active_QMARK_);
} else {
self__.dirty_takes = (self__.dirty_takes + (1));
}

if(cljs.core.truth_(cljs.core.async.impl.protocols.blockable_QMARK_.call(null,handler))){
if((self__.takes.length < cljs.core.async.impl.protocols.MAX_QUEUE_SIZE)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No more than "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.async.impl.protocols.MAX_QUEUE_SIZE),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" pending takes are allowed on a single channel.")].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(< (.-length takes) impl/MAX-QUEUE-SIZE)")].join('')));
}

self__.takes.unbounded_unshift(handler);
} else {
}

return null;
}
}
}
}
});

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.closed;
});

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(self__.closed){
return null;
} else {
self__.closed = true;

if(cljs.core.truth_((function (){var and__7395__auto__ = self__.buf;
if(cljs.core.truth_(and__7395__auto__)){
return (self__.puts.length === (0));
} else {
return and__7395__auto__;
}
})())){
self__.add_BANG_.call(null,self__.buf);
} else {
}

while(true){
var taker_8774 = self__.takes.pop();
if((taker_8774 == null)){
} else {
if(cljs.core.async.impl.protocols.active_QMARK_.call(null,taker_8774)){
var take_cb_8775 = cljs.core.async.impl.protocols.commit.call(null,taker_8774);
var val_8776 = (cljs.core.truth_((function (){var and__7395__auto__ = self__.buf;
if(cljs.core.truth_(and__7395__auto__)){
return (cljs.core.count.call(null,self__.buf) > (0));
} else {
return and__7395__auto__;
}
})())?cljs.core.async.impl.protocols.remove_BANG_.call(null,self__.buf):null);
cljs.core.async.impl.dispatch.run.call(null,((function (take_cb_8775,val_8776,taker_8774,this$__$1){
return (function (){
return take_cb_8775.call(null,val_8776);
});})(take_cb_8775,val_8776,taker_8774,this$__$1))
);
} else {
}

continue;
}
break;
}

if(cljs.core.truth_(self__.buf)){
cljs.core.async.impl.protocols.close_buf_BANG_.call(null,self__.buf);
} else {
}

return null;
}
});

cljs.core.async.impl.channels.ManyToManyChannel.getBasis = (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"takes","takes",298247964,null),cljs.core.with_meta(new cljs.core.Symbol(null,"dirty-takes","dirty-takes",575642138,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"puts","puts",-1883877054,null),cljs.core.with_meta(new cljs.core.Symbol(null,"dirty-puts","dirty-puts",57041148,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"closed","closed",720856168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"add!","add!",2046056845,null)], null);
});

cljs.core.async.impl.channels.ManyToManyChannel.cljs$lang$type = true;

cljs.core.async.impl.channels.ManyToManyChannel.cljs$lang$ctorStr = "cljs.core.async.impl.channels/ManyToManyChannel";

cljs.core.async.impl.channels.ManyToManyChannel.cljs$lang$ctorPrWriter = (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async.impl.channels/ManyToManyChannel");
});

cljs.core.async.impl.channels.__GT_ManyToManyChannel = (function cljs$core$async$impl$channels$__GT_ManyToManyChannel(takes,dirty_takes,puts,dirty_puts,buf,closed,add_BANG_){
return (new cljs.core.async.impl.channels.ManyToManyChannel(takes,dirty_takes,puts,dirty_puts,buf,closed,add_BANG_));
});

cljs.core.async.impl.channels.ex_handler = (function cljs$core$async$impl$channels$ex_handler(ex){
console.log(ex);

return null;
});
cljs.core.async.impl.channels.handle = (function cljs$core$async$impl$channels$handle(buf,exh,t){
var else$ = (function (){var or__7407__auto__ = exh;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return cljs.core.async.impl.channels.ex_handler;
}
})().call(null,t);
if((else$ == null)){
return buf;
} else {
return cljs.core.async.impl.protocols.add_BANG_.call(null,buf,else$);
}
});
cljs.core.async.impl.channels.chan = (function cljs$core$async$impl$channels$chan(var_args){
var args8777 = [];
var len__8628__auto___8782 = arguments.length;
var i__8629__auto___8783 = (0);
while(true){
if((i__8629__auto___8783 < len__8628__auto___8782)){
args8777.push((arguments[i__8629__auto___8783]));

var G__8784 = (i__8629__auto___8783 + (1));
i__8629__auto___8783 = G__8784;
continue;
} else {
}
break;
}

var G__8779 = args8777.length;
switch (G__8779) {
case 1:
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args8777.length)].join('')));

}
});

cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf){
return cljs.core.async.impl.channels.chan.call(null,buf,null);
});

cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf,xform){
return cljs.core.async.impl.channels.chan.call(null,buf,xform,null);
});

cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf,xform,exh){
return (new cljs.core.async.impl.channels.ManyToManyChannel(cljs.core.async.impl.buffers.ring_buffer.call(null,(32)),(0),cljs.core.async.impl.buffers.ring_buffer.call(null,(32)),(0),buf,false,(function (){var add_BANG_ = (cljs.core.truth_(xform)?xform.call(null,cljs.core.async.impl.protocols.add_BANG_):cljs.core.async.impl.protocols.add_BANG_);
return ((function (add_BANG_){
return (function() {
var G__8786 = null;
var G__8786__1 = (function (buf__$1){
try{return add_BANG_.call(null,buf__$1);
}catch (e8780){var t = e8780;
return cljs.core.async.impl.channels.handle.call(null,buf__$1,exh,t);
}});
var G__8786__2 = (function (buf__$1,val){
try{return add_BANG_.call(null,buf__$1,val);
}catch (e8781){var t = e8781;
return cljs.core.async.impl.channels.handle.call(null,buf__$1,exh,t);
}});
G__8786 = function(buf__$1,val){
switch(arguments.length){
case 1:
return G__8786__1.call(this,buf__$1);
case 2:
return G__8786__2.call(this,buf__$1,val);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__8786.cljs$core$IFn$_invoke$arity$1 = G__8786__1;
G__8786.cljs$core$IFn$_invoke$arity$2 = G__8786__2;
return G__8786;
})()
;})(add_BANG_))
})()));
});

cljs.core.async.impl.channels.chan.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=channels.js.map