// Compiled by ClojureScript 1.9.562 {}
goog.provide('cljstache.core');
goog.require('cljs.core');
goog.require('clojure.string');
cljstache.core.re_quote_replacement = cljs.core.identity;
/**
 * Apply f to each element of coll, concatenate all results into a
 *   String.
 */
cljstache.core.map_str = (function cljstache$core$map_str(f,coll){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,f,coll));
});
cljstache.core.re_matcher = (function cljstache$core$re_matcher(pattern,s){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.re_pattern.call(null,pattern),s], null);
});
cljstache.core.re_find = (function cljstache$core$re_find(var_args){
var args17964 = [];
var len__8628__auto___17971 = arguments.length;
var i__8629__auto___17972 = (0);
while(true){
if((i__8629__auto___17972 < len__8628__auto___17971)){
args17964.push((arguments[i__8629__auto___17972]));

var G__17973 = (i__8629__auto___17972 + (1));
i__8629__auto___17972 = G__17973;
continue;
} else {
}
break;
}

var G__17966 = args17964.length;
switch (G__17966) {
case 2:
return cljstache.core.re_find.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return cljstache.core.re_find.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17964.length)].join('')));

}
});

cljstache.core.re_find.cljs$core$IFn$_invoke$arity$2 = (function (re,s){
return cljs.core.re_find.call(null,re,s);
});

cljstache.core.re_find.cljs$core$IFn$_invoke$arity$1 = (function (p__17967){
var vec__17968 = p__17967;
var re = cljs.core.nth.call(null,vec__17968,(0),null);
var s = cljs.core.nth.call(null,vec__17968,(1),null);
return cljstache.core.re_find.call(null,re,s);
});

cljstache.core.re_find.cljs$lang$maxFixedArity = 2;

cljstache.core.re_groups = (function cljstache$core$re_groups(p__17975){
var vec__17979 = p__17975;
var re = cljs.core.nth.call(null,vec__17979,(0),null);
var s = cljs.core.nth.call(null,vec__17979,(1),null);
return re.exec(s);
});
cljstache.core.matcher_find = (function cljstache$core$matcher_find(var_args){
var args17982 = [];
var len__8628__auto___17989 = arguments.length;
var i__8629__auto___17990 = (0);
while(true){
if((i__8629__auto___17990 < len__8628__auto___17989)){
args17982.push((arguments[i__8629__auto___17990]));

var G__17991 = (i__8629__auto___17990 + (1));
i__8629__auto___17990 = G__17991;
continue;
} else {
}
break;
}

var G__17984 = args17982.length;
switch (G__17984) {
case 1:
return cljstache.core.matcher_find.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljstache.core.matcher_find.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17982.length)].join('')));

}
});

cljstache.core.matcher_find.cljs$core$IFn$_invoke$arity$1 = (function (m){
return cljstache.core.matcher_find.call(null,m,(0));
});

cljstache.core.matcher_find.cljs$core$IFn$_invoke$arity$2 = (function (p__17985,offset){
var vec__17986 = p__17985;
var m = cljs.core.nth.call(null,vec__17986,(0),null);
var s = cljs.core.nth.call(null,vec__17986,(1),null);
var temp__5278__auto__ = m.exec(cljs.core.subs.call(null,s,offset));
if(cljs.core.truth_(temp__5278__auto__)){
var match = temp__5278__auto__;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"match-start","match-start",48220753),(match.index + offset),new cljs.core.Keyword(null,"match-end","match-end",-1347942185),((match.index + cljs.core.count.call(null,cljs.core.first.call(null,match))) + offset)], null);
} else {
return null;
}
});

cljstache.core.matcher_find.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljstache.core.Section = (function (name,body,start,end,inverted,__meta,__extmap,__hash){
this.name = name;
this.body = body;
this.start = start;
this.end = end;
this.inverted = inverted;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljstache.core.Section.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

cljstache.core.Section.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k17994,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__17996 = k17994;
var G__17996__$1 = (((G__17996 instanceof cljs.core.Keyword))?G__17996.fqn:null);
switch (G__17996__$1) {
case "name":
return self__.name;

break;
case "body":
return self__.body;

break;
case "start":
return self__.start;

break;
case "end":
return self__.end;

break;
case "inverted":
return self__.inverted;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k17994,else__8085__auto__);

}
});

cljstache.core.Section.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#cljstache.core.Section{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"body","body",-2049205669),self__.body],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"start","start",-355208981),self__.start],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"end","end",-268185958),self__.end],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"inverted","inverted",-310592290),self__.inverted],null))], null),self__.__extmap));
});

cljstache.core.Section.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljstache.core.Section.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__17993){
var self__ = this;
var G__17993__$1 = this;
return (new cljs.core.RecordIter((0),G__17993__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"start","start",-355208981),new cljs.core.Keyword(null,"end","end",-268185958),new cljs.core.Keyword(null,"inverted","inverted",-310592290)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

cljstache.core.Section.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

cljstache.core.Section.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new cljstache.core.Section(self__.name,self__.body,self__.start,self__.end,self__.inverted,self__.__meta,self__.__extmap,self__.__hash));
});

cljstache.core.Section.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
});

cljstache.core.Section.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

cljstache.core.Section.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljstache.core.Section.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"start","start",-355208981),null,new cljs.core.Keyword(null,"end","end",-268185958),null,new cljs.core.Keyword(null,"body","body",-2049205669),null,new cljs.core.Keyword(null,"inverted","inverted",-310592290),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new cljstache.core.Section(self__.name,self__.body,self__.start,self__.end,self__.inverted,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

cljstache.core.Section.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__17993){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__17997 = cljs.core.keyword_identical_QMARK_;
var expr__17998 = k__8090__auto__;
if(cljs.core.truth_(pred__17997.call(null,new cljs.core.Keyword(null,"name","name",1843675177),expr__17998))){
return (new cljstache.core.Section(G__17993,self__.body,self__.start,self__.end,self__.inverted,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17997.call(null,new cljs.core.Keyword(null,"body","body",-2049205669),expr__17998))){
return (new cljstache.core.Section(self__.name,G__17993,self__.start,self__.end,self__.inverted,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17997.call(null,new cljs.core.Keyword(null,"start","start",-355208981),expr__17998))){
return (new cljstache.core.Section(self__.name,self__.body,G__17993,self__.end,self__.inverted,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17997.call(null,new cljs.core.Keyword(null,"end","end",-268185958),expr__17998))){
return (new cljstache.core.Section(self__.name,self__.body,self__.start,G__17993,self__.inverted,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17997.call(null,new cljs.core.Keyword(null,"inverted","inverted",-310592290),expr__17998))){
return (new cljstache.core.Section(self__.name,self__.body,self__.start,self__.end,G__17993,self__.__meta,self__.__extmap,null));
} else {
return (new cljstache.core.Section(self__.name,self__.body,self__.start,self__.end,self__.inverted,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__17993),null));
}
}
}
}
}
});

cljstache.core.Section.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"body","body",-2049205669),self__.body],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"start","start",-355208981),self__.start],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"end","end",-268185958),self__.end],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"inverted","inverted",-310592290),self__.inverted],null))], null),self__.__extmap));
});

cljstache.core.Section.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__17993){
var self__ = this;
var this__8081__auto____$1 = this;
return (new cljstache.core.Section(self__.name,self__.body,self__.start,self__.end,self__.inverted,G__17993,self__.__extmap,self__.__hash));
});

cljstache.core.Section.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

cljstache.core.Section.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"body","body",-408674142,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null)], null);
});

cljstache.core.Section.cljs$lang$type = true;

cljstache.core.Section.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"cljstache.core/Section");
});

cljstache.core.Section.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"cljstache.core/Section");
});

cljstache.core.__GT_Section = (function cljstache$core$__GT_Section(name,body,start,end,inverted){
return (new cljstache.core.Section(name,body,start,end,inverted,null,null,null));
});

cljstache.core.map__GT_Section = (function cljstache$core$map__GT_Section(G__17995){
return (new cljstache.core.Section(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(G__17995),new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(G__17995),new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(G__17995),new cljs.core.Keyword(null,"end","end",-268185958).cljs$core$IFn$_invoke$arity$1(G__17995),new cljs.core.Keyword(null,"inverted","inverted",-310592290).cljs$core$IFn$_invoke$arity$1(G__17995),null,cljs.core.dissoc.call(null,G__17995,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"start","start",-355208981),new cljs.core.Keyword(null,"end","end",-268185958),new cljs.core.Keyword(null,"inverted","inverted",-310592290)),null));
});

/**
 * Replace all instances of pattern in str
 */
cljstache.core.str_replace = (function cljstache$core$str_replace(s,from,to){
return clojure.string.replace.call(null,s,cljs.core.re_pattern.call(null,from),to);
});
/**
 * Applies all replacements from the replacement list to the string.
 * Replacements are a sequence of two element sequences where the first element
 * is the pattern to match and the second is the replacement.
 * An optional third boolean argument can be set to true if the replacement
 * should not be quoted.
 */
cljstache.core.replace_all = (function cljstache$core$replace_all(string,replacements){
return cljs.core.reduce.call(null,(function (string__$1,p__18005){
var vec__18006 = p__18005;
var from = cljs.core.nth.call(null,vec__18006,(0),null);
var to = cljs.core.nth.call(null,vec__18006,(1),null);
var dont_quote = cljs.core.nth.call(null,vec__18006,(2),null);
return cljstache.core.str_replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(string__$1)].join(''),from,(cljs.core.truth_(dont_quote)?to:cljstache.core.re_quote_replacement.call(null,to)));
}),string,replacements);
});
/**
 * Replaces angle brackets with the respective HTML entities.
 */
cljstache.core.escape_html = (function cljstache$core$escape_html(string){
return cljstache.core.replace_all.call(null,string,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["&","&amp;"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"","&quot;"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","&lt;"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [">","&gt;"], null)], null));
});
/**
 * Indent all lines of the partial by indent.
 */
cljstache.core.indent_partial = (function cljstache$core$indent_partial(partial,indent){
return cljstache.core.replace_all.call(null,partial,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(\r\n|[\r\n])(.+)",[cljs.core.str.cljs$core$IFn$_invoke$arity$1("$1"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(indent),cljs.core.str.cljs$core$IFn$_invoke$arity$1("$2")].join(''),true], null)], null));
});
cljstache.core.regex_chars = new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\\","{","}","[","]","(",")",".","?","^","+","-","|"], null);
/**
 * Escapes characters that have special meaning in regular expressions.
 */
cljstache.core.escape_regex = (function cljstache$core$escape_regex(regex){
return cljstache.core.replace_all.call(null,regex,cljs.core.map.call(null,(function (p1__18009_SHARP_){
return cljs.core.repeat.call(null,(2),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__18009_SHARP_)].join(''));
}),cljstache.core.regex_chars));
});
/**
 * Unescapes characters that have special meaning in regular expressions.
 */
cljstache.core.unescape_regex = (function cljstache$core$unescape_regex(regex){
return cljstache.core.replace_all.call(null,regex,cljs.core.map.call(null,(function (char$){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\\\\\"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(char$)].join(''),char$,true], null);
}),cljstache.core.regex_chars));
});
cljstache.core.__GT_stringbuilder = (function cljstache$core$__GT_stringbuilder(var_args){
var args18010 = [];
var len__8628__auto___18013 = arguments.length;
var i__8629__auto___18014 = (0);
while(true){
if((i__8629__auto___18014 < len__8628__auto___18013)){
args18010.push((arguments[i__8629__auto___18014]));

var G__18015 = (i__8629__auto___18014 + (1));
i__8629__auto___18014 = G__18015;
continue;
} else {
}
break;
}

var G__18012 = args18010.length;
switch (G__18012) {
case 0:
return cljstache.core.__GT_stringbuilder.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljstache.core.__GT_stringbuilder.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args18010.length)].join('')));

}
});

cljstache.core.__GT_stringbuilder.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljstache.core.__GT_stringbuilder.call(null,"");
});

cljstache.core.__GT_stringbuilder.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.atom.call(null,s);
});

cljstache.core.__GT_stringbuilder.cljs$lang$maxFixedArity = 1;

/**
 * Perform mutation on stringbuilder object
 */
cljstache.core.sb_BANG_ = (function cljstache$core$sb_BANG_(s,f){
cljs.core.swap_BANG_.call(null,s,f);

return s;
});
cljstache.core.sb__GT_str = (function cljstache$core$sb__GT_str(s){
return cljs.core.deref.call(null,s);
});
cljstache.core.sb_replace = (function cljstache$core$sb_replace(s,start,end,s_SINGLEQUOTE_){
return cljstache.core.sb_BANG_.call(null,s,(function (p1__18017_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.call(null,p1__18017_SHARP_,(0),start)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s_SINGLEQUOTE_),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.call(null,p1__18017_SHARP_,end))].join('');
}));
});
cljstache.core.sb_delete = (function cljstache$core$sb_delete(s,start,end){
return cljstache.core.sb_BANG_.call(null,s,(function (p1__18018_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.call(null,p1__18018_SHARP_,(0),start)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.call(null,p1__18018_SHARP_,end))].join('');
}));
});
cljstache.core.sb_append = (function cljstache$core$sb_append(s,s_SINGLEQUOTE_){
return cljstache.core.sb_BANG_.call(null,s,(function (p1__18019_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__18019_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s_SINGLEQUOTE_)].join('');
}));
});
cljstache.core.sb_insert = (function cljstache$core$sb_insert(s,index,s_SINGLEQUOTE_){
return cljstache.core.sb_replace.call(null,s,index,index,s_SINGLEQUOTE_);
});
cljstache.core.delim_matcher = (function cljstache$core$delim_matcher(open,close,s){
return cljstache.core.re_matcher.call(null,cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("("),cljs.core.str.cljs$core$IFn$_invoke$arity$1(open),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".*?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(close),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.not_EQ_.call(null,"\\{\\{",open))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1("|\\{\\{.*?\\}\\}")].join(''):null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(")")].join('')),s);
});
cljstache.core.find_custom_delimiters = (function cljstache$core$find_custom_delimiters(open,close,s){
return cljstache.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(open),cljs.core.str.cljs$core$IFn$_invoke$arity$1("=\\s*(.*?) (.*?)\\s*="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(close)].join('')),s);
});
/**
 * Replaces custom set delimiters with mustaches.
 */
cljstache.core.process_set_delimiters = (function cljstache$core$process_set_delimiters(template,data){
var builder = cljstache.core.__GT_stringbuilder.call(null,template);
var data__$1 = cljs.core.atom.call(null,data);
var open_delim = cljs.core.atom.call(null,cljstache.core.escape_regex.call(null,"{{"));
var close_delim = cljs.core.atom.call(null,cljstache.core.escape_regex.call(null,"}}"));
var set_delims = ((function (builder,data__$1,open_delim,close_delim){
return (function (open,close){
var seq__18033 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [open_delim,open], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [close_delim,close], null)], null));
var chunk__18034 = null;
var count__18035 = (0);
var i__18036 = (0);
while(true){
if((i__18036 < count__18035)){
var vec__18037 = cljs.core._nth.call(null,chunk__18034,i__18036);
var var$ = cljs.core.nth.call(null,vec__18037,(0),null);
var delim = cljs.core.nth.call(null,vec__18037,(1),null);
cljs.core.swap_BANG_.call(null,var$,cljs.core.constantly.call(null,cljstache.core.escape_regex.call(null,delim)));

var G__18045 = seq__18033;
var G__18046 = chunk__18034;
var G__18047 = count__18035;
var G__18048 = (i__18036 + (1));
seq__18033 = G__18045;
chunk__18034 = G__18046;
count__18035 = G__18047;
i__18036 = G__18048;
continue;
} else {
var temp__5278__auto__ = cljs.core.seq.call(null,seq__18033);
if(temp__5278__auto__){
var seq__18033__$1 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__18033__$1)){
var c__8318__auto__ = cljs.core.chunk_first.call(null,seq__18033__$1);
var G__18049 = cljs.core.chunk_rest.call(null,seq__18033__$1);
var G__18050 = c__8318__auto__;
var G__18051 = cljs.core.count.call(null,c__8318__auto__);
var G__18052 = (0);
seq__18033 = G__18049;
chunk__18034 = G__18050;
count__18035 = G__18051;
i__18036 = G__18052;
continue;
} else {
var vec__18040 = cljs.core.first.call(null,seq__18033__$1);
var var$ = cljs.core.nth.call(null,vec__18040,(0),null);
var delim = cljs.core.nth.call(null,vec__18040,(1),null);
cljs.core.swap_BANG_.call(null,var$,cljs.core.constantly.call(null,cljstache.core.escape_regex.call(null,delim)));

var G__18053 = cljs.core.next.call(null,seq__18033__$1);
var G__18054 = null;
var G__18055 = (0);
var G__18056 = (0);
seq__18033 = G__18053;
chunk__18034 = G__18054;
count__18035 = G__18055;
i__18036 = G__18056;
continue;
}
} else {
return null;
}
}
break;
}
});})(builder,data__$1,open_delim,close_delim))
;
var offset_18057 = (0);
while(true){
var custom_delim_QMARK__18058 = cljs.core.not_EQ_.call(null,"\\{\\{",cljs.core.deref.call(null,open_delim));
var s_18059 = cljstache.core.sb__GT_str.call(null,builder);
var matcher_18060 = cljstache.core.delim_matcher.call(null,cljs.core.deref.call(null,open_delim),cljs.core.deref.call(null,close_delim),s_18059);
var temp__5278__auto___18061 = cljstache.core.matcher_find.call(null,matcher_18060,offset_18057);
if(cljs.core.truth_(temp__5278__auto___18061)){
var match_result_18062 = temp__5278__auto___18061;
var map__18043_18063 = match_result_18062;
var map__18043_18064__$1 = ((((!((map__18043_18063 == null)))?((((map__18043_18063.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18043_18063.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18043_18063):map__18043_18063);
var match_start_18065 = cljs.core.get.call(null,map__18043_18064__$1,new cljs.core.Keyword(null,"match-start","match-start",48220753));
var match_end_18066 = cljs.core.get.call(null,map__18043_18064__$1,new cljs.core.Keyword(null,"match-end","match-end",-1347942185));
var match_18067 = cljs.core.subs.call(null,s_18059,match_start_18065,match_end_18066);
if((custom_delim_QMARK__18058) && (cljs.core._EQ_.call(null,"{{",cljs.core.subs.call(null,match_18067,(0),(2))))){
var temp__5278__auto___18068__$1 = cljstache.core.re_find.call(null,/\{\{(.*?)\}\}/,match_18067);
if(cljs.core.truth_(temp__5278__auto___18068__$1)){
var tag_18069 = temp__5278__auto___18068__$1;
cljstache.core.sb_replace.call(null,builder,match_start_18065,match_end_18066,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\{\\{"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,tag_18069)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\}\\}")].join(''));

var G__18070 = (match_end_18066 | (0));
offset_18057 = G__18070;
continue;
} else {
}
} else {
var temp__5276__auto___18071 = cljstache.core.find_custom_delimiters.call(null,cljs.core.deref.call(null,open_delim),cljs.core.deref.call(null,close_delim),match_18067);
if(cljs.core.truth_(temp__5276__auto___18071)){
var delim_change_18072 = temp__5276__auto___18071;
cljs.core.apply.call(null,set_delims,cljs.core.rest.call(null,delim_change_18072));

cljstache.core.sb_delete.call(null,builder,match_start_18065,match_end_18066);

var G__18073 = (match_start_18065 | (0));
offset_18057 = G__18073;
continue;
} else {
var temp__5278__auto___18074__$1 = cljstache.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,open_delim)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(.*?)"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,close_delim))].join('')),match_18067);
if(cljs.core.truth_(temp__5278__auto___18074__$1)){
var tag_18075 = temp__5278__auto___18074__$1;
var section_start_18076 = cljstache.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("^"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,open_delim)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\s*#\\s*(.*?)\\s*"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,close_delim))].join('')),cljs.core.first.call(null,tag_18075));
var key_18077 = (cljs.core.truth_(section_start_18076)?cljs.core.keyword.call(null,cljs.core.second.call(null,section_start_18076)):null);
var value_18078 = (cljs.core.truth_(key_18077)?key_18077.call(null,cljs.core.deref.call(null,data__$1)):null);
if(cljs.core.truth_((function (){var and__7395__auto__ = value_18078;
if(cljs.core.truth_(and__7395__auto__)){
return (cljs.core.fn_QMARK_.call(null,value_18078)) && (!((cljs.core._EQ_.call(null,cljs.core.deref.call(null,open_delim),"\\{\\{")) && (cljs.core._EQ_.call(null,cljs.core.deref.call(null,close_delim),"\\}\\}"))));
} else {
return and__7395__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,data__$1,((function (offset_18057,section_start_18076,key_18077,value_18078,tag_18075,temp__5278__auto___18074__$1,temp__5276__auto___18071,map__18043_18063,map__18043_18064__$1,match_start_18065,match_end_18066,match_18067,match_result_18062,temp__5278__auto___18061,custom_delim_QMARK__18058,s_18059,matcher_18060,builder,data__$1,open_delim,close_delim,set_delims){
return (function (p1__18020_SHARP_){
return cljs.core.update_in.call(null,p1__18020_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_18077], null),((function (offset_18057,section_start_18076,key_18077,value_18078,tag_18075,temp__5278__auto___18074__$1,temp__5276__auto___18071,map__18043_18063,map__18043_18064__$1,match_start_18065,match_end_18066,match_18067,match_result_18062,temp__5278__auto___18061,custom_delim_QMARK__18058,s_18059,matcher_18060,builder,data__$1,open_delim,close_delim,set_delims){
return (function (old){
return ((function (offset_18057,section_start_18076,key_18077,value_18078,tag_18075,temp__5278__auto___18074__$1,temp__5276__auto___18071,map__18043_18063,map__18043_18064__$1,match_start_18065,match_end_18066,match_18067,match_result_18062,temp__5278__auto___18061,custom_delim_QMARK__18058,s_18059,matcher_18060,builder,data__$1,open_delim,close_delim,set_delims){
return (function (data__$2){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("{{="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljstache.core.unescape_regex.call(null,cljs.core.deref.call(null,open_delim))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljstache.core.unescape_regex.call(null,cljs.core.deref.call(null,close_delim))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("=}}"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(old.call(null,data__$2))].join('');
});
;})(offset_18057,section_start_18076,key_18077,value_18078,tag_18075,temp__5278__auto___18074__$1,temp__5276__auto___18071,map__18043_18063,map__18043_18064__$1,match_start_18065,match_end_18066,match_18067,match_result_18062,temp__5278__auto___18061,custom_delim_QMARK__18058,s_18059,matcher_18060,builder,data__$1,open_delim,close_delim,set_delims))
});})(offset_18057,section_start_18076,key_18077,value_18078,tag_18075,temp__5278__auto___18074__$1,temp__5276__auto___18071,map__18043_18063,map__18043_18064__$1,match_start_18065,match_end_18066,match_18067,match_result_18062,temp__5278__auto___18061,custom_delim_QMARK__18058,s_18059,matcher_18060,builder,data__$1,open_delim,close_delim,set_delims))
);
});})(offset_18057,section_start_18076,key_18077,value_18078,tag_18075,temp__5278__auto___18074__$1,temp__5276__auto___18071,map__18043_18063,map__18043_18064__$1,match_start_18065,match_end_18066,match_18067,match_result_18062,temp__5278__auto___18061,custom_delim_QMARK__18058,s_18059,matcher_18060,builder,data__$1,open_delim,close_delim,set_delims))
);
} else {
}

cljstache.core.sb_replace.call(null,builder,match_start_18065,match_end_18066,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("{{"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,tag_18075)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("}}")].join(''));

var G__18079 = (match_end_18066 | (0));
offset_18057 = G__18079;
continue;
} else {
}
}
}
} else {
}
break;
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljstache.core.sb__GT_str.call(null,builder),cljs.core.deref.call(null,data__$1)], null);
});
/**
 * Creates pairs of partial replacements.
 */
cljstache.core.create_partial_replacements = (function cljstache$core$create_partial_replacements(template,partials){
return cljs.core.apply.call(null,cljs.core.concat,(function (){var iter__8269__auto__ = (function cljstache$core$create_partial_replacements_$_iter__18084(s__18085){
return (new cljs.core.LazySeq(null,(function (){
var s__18085__$1 = s__18085;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__18085__$1);
if(temp__5278__auto__){
var s__18085__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18085__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__18085__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__18087 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__18086 = (0);
while(true){
if((i__18086 < size__8268__auto__)){
var k = cljs.core._nth.call(null,c__8267__auto__,i__18086);
cljs.core.chunk_append.call(null,b__18087,(function (){var regex = cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("(\r\n|[\r\n]|^)([ \\t]*)\\{\\{>\\s*"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,k)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\s*\\}\\}")].join(''));
var indent = cljs.core.nth.call(null,cljs.core.first.call(null,cljs.core.re_seq.call(null,cljs.core.re_pattern.call(null,regex),template)),(2));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\{\\{>\\s*"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,k)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\s*\\}\\}")].join(''),cljs.core.first.call(null,cljstache.core.process_set_delimiters.call(null,cljstache.core.indent_partial.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k.call(null,partials))].join(''),indent),cljs.core.PersistentArrayMap.EMPTY))], null)], null);
})());

var G__18088 = (i__18086 + (1));
i__18086 = G__18088;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18087),cljstache$core$create_partial_replacements_$_iter__18084.call(null,cljs.core.chunk_rest.call(null,s__18085__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18087),null);
}
} else {
var k = cljs.core.first.call(null,s__18085__$2);
return cljs.core.cons.call(null,(function (){var regex = cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("(\r\n|[\r\n]|^)([ \\t]*)\\{\\{>\\s*"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,k)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\s*\\}\\}")].join(''));
var indent = cljs.core.nth.call(null,cljs.core.first.call(null,cljs.core.re_seq.call(null,cljs.core.re_pattern.call(null,regex),template)),(2));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\{\\{>\\s*"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,k)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\s*\\}\\}")].join(''),cljs.core.first.call(null,cljstache.core.process_set_delimiters.call(null,cljstache.core.indent_partial.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k.call(null,partials))].join(''),indent),cljs.core.PersistentArrayMap.EMPTY))], null)], null);
})(),cljstache$core$create_partial_replacements_$_iter__18084.call(null,cljs.core.rest.call(null,s__18085__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,cljs.core.keys.call(null,partials));
})());
});
/**
 * Include partials within the template.
 */
cljstache.core.include_partials = (function cljstache$core$include_partials(template,partials){
return cljstache.core.replace_all.call(null,template,cljstache.core.create_partial_replacements.call(null,template,partials));
});
/**
 * Removes comments from the template.
 */
cljstache.core.remove_comments = (function cljstache$core$remove_comments(template){
var comment_regex = "\\{\\{\\![^\\}]*\\}\\}";
return cljstache.core.replace_all.call(null,template,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1("(^|[\n\r])[ \t]*"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(comment_regex),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(\r\n|[\r\n]|$)")].join(''),"$1",true], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comment_regex,""], null)], null));
});
/**
 * Return the next index of the supplied regex.
 */
cljstache.core.next_index = (function cljstache$core$next_index(var_args){
var args18089 = [];
var len__8628__auto___18092 = arguments.length;
var i__8629__auto___18093 = (0);
while(true){
if((i__8629__auto___18093 < len__8628__auto___18092)){
args18089.push((arguments[i__8629__auto___18093]));

var G__18094 = (i__8629__auto___18093 + (1));
i__8629__auto___18093 = G__18094;
continue;
} else {
}
break;
}

var G__18091 = args18089.length;
switch (G__18091) {
case 2:
return cljstache.core.next_index.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljstache.core.next_index.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args18089.length)].join('')));

}
});

cljstache.core.next_index.cljs$core$IFn$_invoke$arity$2 = (function (section,regex){
return cljstache.core.next_index.call(null,section,regex,(0));
});

cljstache.core.next_index.cljs$core$IFn$_invoke$arity$3 = (function (section,regex,index){
if(cljs.core._EQ_.call(null,index,(-1))){
return (-1);
} else {
var s = cljs.core.subs.call(null,section,index);
var matcher = (new RegExp([cljs.core.str.cljs$core$IFn$_invoke$arity$1(regex)].join('').source,"g"));
var temp__5276__auto__ = regex.exec(s);
if(cljs.core.truth_(temp__5276__auto__)){
var m = temp__5276__auto__;
return (index + m.index);
} else {
return (-1);
}
}
});

cljstache.core.next_index.cljs$lang$maxFixedArity = 3;

/**
 * Find the next section start tag, starting to search at index.
 */
cljstache.core.find_section_start_tag = (function cljstache$core$find_section_start_tag(template,index){
return cljstache.core.next_index.call(null,template,/\{\{[#\^]/,index);
});
/**
 * Find the matching end tag for a section at the specified level,
 * starting to search at index.
 */
cljstache.core.find_section_end_tag = (function cljstache$core$find_section_end_tag(template,index,level){
var next_start = cljstache.core.find_section_start_tag.call(null,template,index);
var next_end = template.indexOf("{{/",index);
if(cljs.core._EQ_.call(null,next_end,(-1))){
return (-1);
} else {
if((cljs.core.not_EQ_.call(null,next_start,(-1))) && ((next_start < next_end))){
return cljstache.core.find_section_end_tag.call(null,template,(next_start + (3)),(level + (1)));
} else {
if(cljs.core._EQ_.call(null,level,(1))){
return next_end;
} else {
return cljstache.core.find_section_end_tag.call(null,template,(next_end + (3)),(level - (1)));
}
}
}
});
/**
 * Extracts the outer section from the template.
 */
cljstache.core.extract_section = (function cljstache$core$extract_section(template){
var start = cljstache.core.find_section_start_tag.call(null,template,(0));
if(cljs.core.not_EQ_.call(null,start,(-1))){
var inverted = cljs.core._EQ_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(template.charAt((start + (2))))].join(''),"^");
var end_tag = cljstache.core.find_section_end_tag.call(null,template,(start + (3)),(1));
if(cljs.core.not_EQ_.call(null,end_tag,(-1))){
var end = (template.indexOf("}}",end_tag) + (2));
var section = cljs.core.subs.call(null,template,start,end);
var body_start = (section.indexOf("}}") + (2));
var body_end = section.lastIndexOf("{{");
var body = (((cljs.core._EQ_.call(null,body_start,(-1))) || (cljs.core._EQ_.call(null,body_end,(-1))) || ((body_end < body_start)))?"":cljs.core.subs.call(null,section,body_start,body_end));
var section_name = cljs.core.subs.call(null,section,(3),section.indexOf("}}")).trim();
return (new cljstache.core.Section(section_name,body,start,end,inverted,null,null,null));
} else {
return null;
}
} else {
return null;
}
});
/**
 * Replaces each occurrence of the regex with the return value of the callback.
 */
cljstache.core.replace_all_callback = (function cljstache$core$replace_all_callback(string,regex,callback){
return clojure.string.replace.call(null,string,regex,callback);
});
/**
 * Replaces variables in the template with their values from the data.
 */
cljstache.core.replace_variables = (function cljstache$core$replace_variables(template,data,partials){
var regex = /\{\{(\{|\&|\>|)\s*(.*?)\s*\}{2,3}/;
return cljstache.core.replace_all_callback.call(null,template,regex,((function (regex){
return (function (p1__18096_SHARP_){
var var_name = cljs.core.nth.call(null,p1__18096_SHARP_,(2));
var var_k = cljs.core.keyword.call(null,var_name);
var var_type = cljs.core.second.call(null,p1__18096_SHARP_);
var var_value = var_k.call(null,data);
var var_value__$1 = ((cljs.core.fn_QMARK_.call(null,var_value))?cljstache.core.render_template.call(null,var_value.call(null),cljs.core.dissoc.call(null,data,var_name),partials):var_value);
var var_value__$2 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_value__$1)].join('');
if(cljs.core._EQ_.call(null,var_type,"")){
return cljstache.core.escape_html.call(null,var_value__$2);
} else {
if(cljs.core._EQ_.call(null,var_type,">")){
return cljstache.core.render_template.call(null,var_k.call(null,partials),data,partials);
} else {
return var_value__$2;

}
}
});})(regex))
);
});
/**
 * Remove newlines after standalone (i.e. on their own line) delimiter tags.
 */
cljstache.core.join_standalone_delimiter_tags = (function cljstache$core$join_standalone_delimiter_tags(template){
return cljstache.core.replace_all.call(null,template,(function (){var eol_start = "(\r\n|[\r\n]|^)";
var eol_end = "(\r\n|[\r\n]|$)";
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(eol_start),cljs.core.str.cljs$core$IFn$_invoke$arity$1("[ \t]*(\\{\\{=[^\\}]*\\}\\})"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(eol_end)].join(''),"$1$2",true], null)], null);
})());
});
/**
 * Extract the data for the supplied path.
 */
cljstache.core.path_data = (function cljstache$core$path_data(elements,data){
return cljs.core.get_in.call(null,data,cljs.core.map.call(null,cljs.core.keyword,elements));
});
/**
 * Convert a tag with a dotted name to nested sections, using the
 *   supplied delimiters to access the value.
 */
cljstache.core.convert_path = (function cljstache$core$convert_path(tag,open_delim,close_delim,data){
var tag_type = cljs.core.last.call(null,open_delim);
var section_tag = cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([tag_type]),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#","^","/"], null));
var section_end_tag = cljs.core._EQ_.call(null,tag_type,"/");
var builder = cljstache.core.__GT_stringbuilder.call(null);
var tail_builder = (cljs.core.truth_(section_tag)?null:cljstache.core.__GT_stringbuilder.call(null));
var elements = clojure.string.split.call(null,tag,/\./);
var element_to_invert = ((cljs.core._EQ_.call(null,tag_type,"^"))?(function (){var path = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,elements)], null);
var remaining_elements = cljs.core.rest.call(null,elements);
while(true){
if(cljs.core.empty_QMARK_.call(null,remaining_elements)){
return null;
} else {
if((cljstache.core.path_data.call(null,path,data) == null)){
return cljs.core.last.call(null,path);
} else {
var G__18105 = cljs.core.conj.call(null,path,cljs.core.first.call(null,remaining_elements));
var G__18106 = cljs.core.next.call(null,remaining_elements);
path = G__18105;
remaining_elements = G__18106;
continue;
}
}
break;
}
})():null);
if((cljs.core.not.call(null,section_tag)) && ((cljstache.core.path_data.call(null,elements,data) == null))){
return "";
} else {
var elements__$1 = ((section_end_tag)?cljs.core.reverse.call(null,elements):elements);
var seq__18101_18107 = cljs.core.seq.call(null,cljs.core.butlast.call(null,elements__$1));
var chunk__18102_18108 = null;
var count__18103_18109 = (0);
var i__18104_18110 = (0);
while(true){
if((i__18104_18110 < count__18103_18109)){
var element_18111 = cljs.core._nth.call(null,chunk__18102_18108,i__18104_18110);
cljstache.core.sb_append.call(null,builder,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("{{"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((section_end_tag)?"/":((cljs.core._EQ_.call(null,element_18111,element_to_invert))?"^":"#"))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(element_18111),cljs.core.str.cljs$core$IFn$_invoke$arity$1("}}")].join(''));

if(!((tail_builder == null))){
cljstache.core.sb_insert.call(null,tail_builder,(0),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("{{/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(element_18111),cljs.core.str.cljs$core$IFn$_invoke$arity$1("}}")].join(''));
} else {
}

var G__18112 = seq__18101_18107;
var G__18113 = chunk__18102_18108;
var G__18114 = count__18103_18109;
var G__18115 = (i__18104_18110 + (1));
seq__18101_18107 = G__18112;
chunk__18102_18108 = G__18113;
count__18103_18109 = G__18114;
i__18104_18110 = G__18115;
continue;
} else {
var temp__5278__auto___18116 = cljs.core.seq.call(null,seq__18101_18107);
if(temp__5278__auto___18116){
var seq__18101_18117__$1 = temp__5278__auto___18116;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__18101_18117__$1)){
var c__8318__auto___18118 = cljs.core.chunk_first.call(null,seq__18101_18117__$1);
var G__18119 = cljs.core.chunk_rest.call(null,seq__18101_18117__$1);
var G__18120 = c__8318__auto___18118;
var G__18121 = cljs.core.count.call(null,c__8318__auto___18118);
var G__18122 = (0);
seq__18101_18107 = G__18119;
chunk__18102_18108 = G__18120;
count__18103_18109 = G__18121;
i__18104_18110 = G__18122;
continue;
} else {
var element_18123 = cljs.core.first.call(null,seq__18101_18117__$1);
cljstache.core.sb_append.call(null,builder,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("{{"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((section_end_tag)?"/":((cljs.core._EQ_.call(null,element_18123,element_to_invert))?"^":"#"))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(element_18123),cljs.core.str.cljs$core$IFn$_invoke$arity$1("}}")].join(''));

if(!((tail_builder == null))){
cljstache.core.sb_insert.call(null,tail_builder,(0),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("{{/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(element_18123),cljs.core.str.cljs$core$IFn$_invoke$arity$1("}}")].join(''));
} else {
}

var G__18124 = cljs.core.next.call(null,seq__18101_18117__$1);
var G__18125 = null;
var G__18126 = (0);
var G__18127 = (0);
seq__18101_18107 = G__18124;
chunk__18102_18108 = G__18125;
count__18103_18109 = G__18126;
i__18104_18110 = G__18127;
continue;
}
} else {
}
}
break;
}

cljstache.core.sb_append.call(null,builder,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(open_delim),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,elements__$1)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(close_delim)].join(''));

return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljstache.core.sb__GT_str.call(null,builder)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((!((tail_builder == null)))?cljstache.core.sb__GT_str.call(null,tail_builder):null))].join('');
}
});
/**
 * Converts tags with dotted tag names to nested sections.
 */
cljstache.core.convert_paths = (function cljstache$core$convert_paths(template,data){
var s = template;
while(true){
var matcher = cljstache.core.re_matcher.call(null,/(\{\{[\{&#\^\/]?)([^\}]+\.[^\}]+)(\}{2,3})/,s);
var temp__5276__auto__ = cljstache.core.matcher_find.call(null,matcher);
if(cljs.core.truth_(temp__5276__auto__)){
var match_result = temp__5276__auto__;
var map__18130 = match_result;
var map__18130__$1 = ((((!((map__18130 == null)))?((((map__18130.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18130.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18130):map__18130);
var match_start = cljs.core.get.call(null,map__18130__$1,new cljs.core.Keyword(null,"match-start","match-start",48220753));
var match_end = cljs.core.get.call(null,map__18130__$1,new cljs.core.Keyword(null,"match-end","match-end",-1347942185));
var groups = cljstache.core.re_groups.call(null,matcher);
var converted = cljstache.core.convert_path.call(null,clojure.string.trim.call(null,cljs.core.nth.call(null,groups,(2))),cljs.core.nth.call(null,groups,(1)),cljs.core.nth.call(null,groups,(3)),data);
var G__18132 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.call(null,s,(0),match_start)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(converted),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.call(null,s,match_end))].join('');
s = G__18132;
continue;
} else {
return s;
}
break;
}
});
/**
 * Remove newlines after standalone (i.e. on their own line) section/partials
 * tags.
 */
cljstache.core.join_standalone_tags = (function cljstache$core$join_standalone_tags(template){
return cljstache.core.replace_all.call(null,template,(function (){var eol_start = "(\r\n|[\r\n]|^)";
var eol_end = "(\r\n|[\r\n]|$)";
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(eol_start),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\{\\{[#\\^][^\\}]*\\}\\}(\r\n|[\r\n])\\{\\{/[^\\}]*\\}\\}"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(eol_end)].join(''),"$1",true], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(eol_start),cljs.core.str.cljs$core$IFn$_invoke$arity$1("[ \t]*(\\{\\{[#\\^/][^\\}]*\\}\\})"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(eol_end)].join(''),"$1$2",true], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(eol_start),cljs.core.str.cljs$core$IFn$_invoke$arity$1("([ \t]*\\{\\{>\\s*[^\\}]*\\s*\\}\\})"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(eol_end)].join(''),"$1$2",true], null)], null);
})());
});
/**
 * Preprocesses template and data (e.g. removing comments).
 */
cljstache.core.preprocess = (function cljstache$core$preprocess(template,data,partials){
var template__$1 = cljstache.core.join_standalone_delimiter_tags.call(null,template);
var vec__18136 = cljstache.core.process_set_delimiters.call(null,template__$1,data);
var template__$2 = cljs.core.nth.call(null,vec__18136,(0),null);
var data__$1 = cljs.core.nth.call(null,vec__18136,(1),null);
var template__$3 = cljstache.core.join_standalone_tags.call(null,template__$2);
var template__$4 = cljstache.core.remove_comments.call(null,template__$3);
var template__$5 = cljstache.core.include_partials.call(null,template__$4,partials);
var template__$6 = cljstache.core.convert_paths.call(null,template__$5,data__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [template__$6,data__$1], null);
});
cljstache.core.render_section = (function cljstache$core$render_section(section,data,partials){
var section_data = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(section)).call(null,data);
if(cljs.core.truth_(new cljs.core.Keyword(null,"inverted","inverted",-310592290).cljs$core$IFn$_invoke$arity$1(section))){
if(((cljs.core.seqable_QMARK_.call(null,section_data)) && (cljs.core.empty_QMARK_.call(null,section_data))) || (cljs.core.not.call(null,section_data))){
return new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(section);
} else {
return null;
}
} else {
if(cljs.core.truth_(section_data)){
if(cljs.core.fn_QMARK_.call(null,section_data)){
var result = section_data.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(section));
if(cljs.core.fn_QMARK_.call(null,result)){
return result.call(null,((function (result,section_data){
return (function (p1__18139_SHARP_){
return cljstache.core.render_template.call(null,p1__18139_SHARP_,data,partials);
});})(result,section_data))
);
} else {
return result;
}
} else {
var section_data__$1 = ((typeof section_data === 'string')?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY], null):((cljs.core.sequential_QMARK_.call(null,section_data))?section_data:((cljs.core.map_QMARK_.call(null,section_data))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [section_data], null):((cljs.core.seqable_QMARK_.call(null,section_data))?cljs.core.seq.call(null,section_data):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY], null)
))));
var section_data__$2 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,section_data__$1)))?section_data__$1:cljs.core.map.call(null,((function (section_data__$1,section_data){
return (function (e){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.keyword.call(null,"."),e]);
});})(section_data__$1,section_data))
,section_data__$1));
var section_data__$3 = cljs.core.map.call(null,((function (section_data__$1,section_data__$2,section_data){
return (function (p1__18140_SHARP_){
return cljs.core.conj.call(null,data,p1__18140_SHARP_);
});})(section_data__$1,section_data__$2,section_data))
,section_data__$2);
return cljstache.core.map_str.call(null,((function (section_data__$1,section_data__$2,section_data__$3,section_data){
return (function (m){
return cljstache.core.render_template.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(section),m,partials);
});})(section_data__$1,section_data__$2,section_data__$3,section_data))
,section_data__$3);
}
} else {
return null;
}
}
});
/**
 * Renders the template with the data and partials.
 */
cljstache.core.render_template = (function cljstache$core$render_template(template,data,partials){
while(true){
var vec__18144 = cljstache.core.preprocess.call(null,template,data,partials);
var template__$1 = cljs.core.nth.call(null,vec__18144,(0),null);
var data__$1 = cljs.core.nth.call(null,vec__18144,(1),null);
var section = cljstache.core.extract_section.call(null,template__$1);
if((section == null)){
return cljstache.core.replace_variables.call(null,template__$1,data__$1,partials);
} else {
var before = cljs.core.subs.call(null,template__$1,(0),new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(section));
var after = cljs.core.subs.call(null,template__$1,new cljs.core.Keyword(null,"end","end",-268185958).cljs$core$IFn$_invoke$arity$1(section));
var G__18147 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(before),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljstache.core.render_section.call(null,section,data__$1,partials)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(after)].join('');
var G__18148 = data__$1;
var G__18149 = partials;
template = G__18147;
data = G__18148;
partials = G__18149;
continue;
}
break;
}
});
/**
 * Returns set of all tags in template
 */
cljstache.core.tags = (function cljstache$core$tags(template){
var vec__18153 = cljstache.core.preprocess.call(null,template,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
var template__$1 = cljs.core.nth.call(null,vec__18153,(0),null);
var data = cljs.core.nth.call(null,vec__18153,(1),null);
var matches = cljs.core.re_seq.call(null,/\{\{(\{|\&|\>|)\s*(.*?)\s*\}{2,3}/,template__$1);
var tags = cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.keyword,cljs.core.last),matches);
return cljs.core.set.call(null,tags);
});
/**
 * Renders the template with the data and, if supplied, partials.
 */
cljstache.core.render = (function cljstache$core$render(var_args){
var args18156 = [];
var len__8628__auto___18159 = arguments.length;
var i__8629__auto___18160 = (0);
while(true){
if((i__8629__auto___18160 < len__8628__auto___18159)){
args18156.push((arguments[i__8629__auto___18160]));

var G__18161 = (i__8629__auto___18160 + (1));
i__8629__auto___18160 = G__18161;
continue;
} else {
}
break;
}

var G__18158 = args18156.length;
switch (G__18158) {
case 1:
return cljstache.core.render.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljstache.core.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljstache.core.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args18156.length)].join('')));

}
});

cljstache.core.render.cljs$core$IFn$_invoke$arity$1 = (function (template){
return cljstache.core.render.call(null,template,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
});

cljstache.core.render.cljs$core$IFn$_invoke$arity$2 = (function (template,data){
return cljstache.core.render.call(null,template,data,cljs.core.PersistentArrayMap.EMPTY);
});

cljstache.core.render.cljs$core$IFn$_invoke$arity$3 = (function (template,data,partials){
return cljstache.core.replace_all.call(null,cljstache.core.render_template.call(null,template,data,partials),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\\\\\\{\\\\\\{","{{"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\\\\\\}\\\\\\}","}}"], null)], null));
});

cljstache.core.render.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=core.js.map