// Compiled by ClojureScript 1.9.562 {}
goog.provide('kvlt.middleware.util');
goog.require('cljs.core');
goog.require('kvlt.platform.util');
goog.require('cats.labs.promise');
goog.require('clojure.string');
goog.require('cats.core');
goog.require('taoensso.timbre');
goog.require('goog.crypt.base64');
kvlt.middleware.util.__GT_content_type = (function kvlt$middleware$util$__GT_content_type(var_args){
var args40760 = [];
var len__8628__auto___40764 = arguments.length;
var i__8629__auto___40765 = (0);
while(true){
if((i__8629__auto___40765 < len__8628__auto___40764)){
args40760.push((arguments[i__8629__auto___40765]));

var G__40766 = (i__8629__auto___40765 + (1));
i__8629__auto___40765 = G__40766;
continue;
} else {
}
break;
}

var G__40762 = args40760.length;
switch (G__40762) {
case 1:
return kvlt.middleware.util.__GT_content_type.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return kvlt.middleware.util.__GT_content_type.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args40760.length)].join('')));

}
});

kvlt.middleware.util.__GT_content_type.cljs$core$IFn$_invoke$arity$1 = (function (t){
if((t instanceof cljs.core.Keyword)){
var major = (function (){var or__7407__auto__ = cljs.core.namespace.call(null,t);
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return new cljs.core.Keyword(null,"application","application",551185447);
}
})();
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,major)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,t))].join('');
} else {
return t;
}
});

kvlt.middleware.util.__GT_content_type.cljs$core$IFn$_invoke$arity$2 = (function (t,charset){
var G__40763 = kvlt.middleware.util.__GT_content_type.call(null,t);
if(cljs.core.truth_(charset)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__40763),cljs.core.str.cljs$core$IFn$_invoke$arity$1("; charset="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(charset)].join('');
} else {
return G__40763;
}
});

kvlt.middleware.util.__GT_content_type.cljs$lang$maxFixedArity = 2;

kvlt.middleware.util.spec__GT_fn = (function kvlt$middleware$util$spec__GT_fn(spec){
if((spec == null)){
return cljs.core.identity;
} else {
if(cljs.core.coll_QMARK_.call(null,spec)){
var vec__40772 = spec;
var k = cljs.core.nth.call(null,vec__40772,(0),null);
var f = cljs.core.nth.call(null,vec__40772,(1),null);
return ((function (vec__40772,k,f){
return (function (p1__40768_SHARP_){
return cljs.core.update.call(null,p1__40768_SHARP_,k,f);
});
;})(vec__40772,k,f))
} else {
return spec;

}
}
});
kvlt.middleware.util.clean_req = (function kvlt$middleware$util$clean_req(r){
return cljs.core.dissoc.call(null,r,new cljs.core.Keyword("kvlt.middleware","request","kvlt.middleware/request",-1063165256),new cljs.core.Keyword("kvlt.middleware","response","kvlt.middleware/response",963961299),new cljs.core.Keyword("kvlt","trace","kvlt/trace",-1086193122));
});
kvlt.middleware.util.wrap_before = (function kvlt$middleware$util$wrap_before(f){
var map__40781 = cljs.core.meta.call(null,f);
var map__40781__$1 = ((((!((map__40781 == null)))?((((map__40781.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40781.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40781):map__40781);
var has = cljs.core.get.call(null,map__40781__$1,new cljs.core.Keyword(null,"has","has",1466247447));
var removing = cljs.core.get.call(null,map__40781__$1,new cljs.core.Keyword(null,"removing","removing",1104822312));
var f__$1 = (cljs.core.truth_(has)?((function (map__40781,map__40781__$1,has,removing){
return (function (p__40783){
var map__40784 = p__40783;
var map__40784__$1 = ((((!((map__40784 == null)))?((((map__40784.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40784.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40784):map__40784);
var req = map__40784__$1;
var v = cljs.core.get.call(null,map__40784__$1,has);
var G__40786 = req;
if(cljs.core.truth_(v)){
return f.call(null,G__40786);
} else {
return G__40786;
}
});})(map__40781,map__40781__$1,has,removing))
:f);
if(cljs.core.truth_(removing)){
return ((function (map__40781,map__40781__$1,has,removing,f__$1){
return (function (req){
return cljs.core.dissoc.call(null,f__$1.call(null,req),removing);
});
;})(map__40781,map__40781__$1,has,removing,f__$1))
} else {
return f__$1;
}
});
kvlt.middleware.util.__GT_mw = (function kvlt$middleware$util$__GT_mw(var_args){
var args__8635__auto__ = [];
var len__8628__auto___40800 = arguments.length;
var i__8629__auto___40801 = (0);
while(true){
if((i__8629__auto___40801 < len__8628__auto___40800)){
args__8635__auto__.push((arguments[i__8629__auto___40801]));

var G__40802 = (i__8629__auto___40801 + (1));
i__8629__auto___40801 = G__40802;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((2) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((2)),(0),null)):null);
return kvlt.middleware.util.__GT_mw.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8636__auto__);
});

kvlt.middleware.util.__GT_mw.cljs$core$IFn$_invoke$arity$variadic = (function (helpful_name,before,p__40791){
var vec__40792 = p__40791;
var after = cljs.core.nth.call(null,vec__40792,(0),null);
var after__$1 = kvlt.middleware.util.spec__GT_fn.call(null,after);
var before__$1 = kvlt.middleware.util.wrap_before.call(null,kvlt.middleware.util.spec__GT_fn.call(null,before));
return ((function (after__$1,before__$1,vec__40792,after){
return (function (issue_BANG_){
return ((function (after__$1,before__$1,vec__40792,after){
return (function (p__40795){
var map__40796 = p__40795;
var map__40796__$1 = ((((!((map__40796 == null)))?((((map__40796.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40796.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40796):map__40796);
var req = map__40796__$1;
var trace = cljs.core.get.call(null,map__40796__$1,new cljs.core.Keyword("kvlt","trace","kvlt/trace",-1086193122));
var req__$1 = before__$1.call(null,req);
var req__$2 = (function (){var G__40798 = req__$1;
if(cljs.core.truth_(trace)){
return cljs.core.update.call(null,G__40798,new cljs.core.Keyword("kvlt.middleware","request","kvlt.middleware/request",-1063165256),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [helpful_name,kvlt.middleware.util.clean_req.call(null,req__$1)], null));
} else {
return G__40798;
}
})();
return cats.core._GT__GT__EQ_.call(null,issue_BANG_.call(null,req__$2),cljs.core.comp.call(null,cats.core.return$,after__$1),cljs.core.comp.call(null,cats.core.return$,((function (req__$1,req__$2,map__40796,map__40796__$1,req,trace,after__$1,before__$1,vec__40792,after){
return (function (p1__40787_SHARP_){
var G__40799 = p1__40787_SHARP_;
if(cljs.core.truth_(trace)){
return cljs.core.update.call(null,G__40799,new cljs.core.Keyword("kvlt.middleware","response","kvlt.middleware/response",963961299),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [helpful_name,kvlt.middleware.util.clean_req.call(null,req__$2)], null));
} else {
return G__40799;
}
});})(req__$1,req__$2,map__40796,map__40796__$1,req,trace,after__$1,before__$1,vec__40792,after))
));
});
;})(after__$1,before__$1,vec__40792,after))
});
;})(after__$1,before__$1,vec__40792,after))
});

kvlt.middleware.util.__GT_mw.cljs$lang$maxFixedArity = (2);

kvlt.middleware.util.__GT_mw.cljs$lang$applyTo = (function (seq40788){
var G__40789 = cljs.core.first.call(null,seq40788);
var seq40788__$1 = cljs.core.next.call(null,seq40788);
var G__40790 = cljs.core.first.call(null,seq40788__$1);
var seq40788__$2 = cljs.core.next.call(null,seq40788__$1);
return kvlt.middleware.util.__GT_mw.cljs$core$IFn$_invoke$arity$variadic(G__40789,G__40790,seq40788__$2);
});

kvlt.middleware.util.url_decode = (function kvlt$middleware$util$url_decode(var_args){
var args__8635__auto__ = [];
var len__8628__auto___40809 = arguments.length;
var i__8629__auto___40810 = (0);
while(true){
if((i__8629__auto___40810 < len__8628__auto___40809)){
args__8635__auto__.push((arguments[i__8629__auto___40810]));

var G__40811 = (i__8629__auto___40810 + (1));
i__8629__auto___40810 = G__40811;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((1) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((1)),(0),null)):null);
return kvlt.middleware.util.url_decode.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8636__auto__);
});

kvlt.middleware.util.url_decode.cljs$core$IFn$_invoke$arity$variadic = (function (encoded,p__40805){
var vec__40806 = p__40805;
var encoding = cljs.core.nth.call(null,vec__40806,(0),null);
var encoding__$1 = (function (){var or__7407__auto__ = encoding;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return "UTF-8";
}
})();
if(cljs.core.not_EQ_.call(null,"UTF-8",encoding__$1)){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"kvlt.middleware.util","/private/var/folders/dr/5_hp4d_96gq7r51vm086dskm0000gp/T/form-init6526149480784285614.clj",82,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (encoding__$1,vec__40806,encoding){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["url-decode ignoring encoding",encoding__$1], null);
});})(encoding__$1,vec__40806,encoding))
,null)),null,1976371253);
} else {
}

return decodeURIComponent(encoded);
});

kvlt.middleware.util.url_decode.cljs$lang$maxFixedArity = (1);

kvlt.middleware.util.url_decode.cljs$lang$applyTo = (function (seq40803){
var G__40804 = cljs.core.first.call(null,seq40803);
var seq40803__$1 = cljs.core.next.call(null,seq40803);
return kvlt.middleware.util.url_decode.cljs$core$IFn$_invoke$arity$variadic(G__40804,seq40803__$1);
});

kvlt.middleware.util.url_encode = (function kvlt$middleware$util$url_encode(var_args){
var args__8635__auto__ = [];
var len__8628__auto___40818 = arguments.length;
var i__8629__auto___40819 = (0);
while(true){
if((i__8629__auto___40819 < len__8628__auto___40818)){
args__8635__auto__.push((arguments[i__8629__auto___40819]));

var G__40820 = (i__8629__auto___40819 + (1));
i__8629__auto___40819 = G__40820;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((1) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((1)),(0),null)):null);
return kvlt.middleware.util.url_encode.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8636__auto__);
});

kvlt.middleware.util.url_encode.cljs$core$IFn$_invoke$arity$variadic = (function (unencoded,p__40814){
var vec__40815 = p__40814;
var encoding = cljs.core.nth.call(null,vec__40815,(0),null);
var encoding__$1 = (function (){var or__7407__auto__ = encoding;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return "UTF-8";
}
})();
if(cljs.core.not_EQ_.call(null,"UTF-8",encoding__$1)){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"kvlt.middleware.util","/private/var/folders/dr/5_hp4d_96gq7r51vm086dskm0000gp/T/form-init6526149480784285614.clj",92,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (encoding__$1,vec__40815,encoding){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["url-encode ignoring encoding",encoding__$1], null);
});})(encoding__$1,vec__40815,encoding))
,null)),null,1176989860);
} else {
}

return encodeURIComponent(unencoded);
});

kvlt.middleware.util.url_encode.cljs$lang$maxFixedArity = (1);

kvlt.middleware.util.url_encode.cljs$lang$applyTo = (function (seq40812){
var G__40813 = cljs.core.first.call(null,seq40812);
var seq40812__$1 = cljs.core.next.call(null,seq40812);
return kvlt.middleware.util.url_encode.cljs$core$IFn$_invoke$arity$variadic(G__40813,seq40812__$1);
});

/**
 * Takes a raw url path or query and url-encodes any illegal characters.
 *   Minimizes ambiguity by encoding space to %20.
 */
kvlt.middleware.util.url_encode_illegal_characters = (function kvlt$middleware$util$url_encode_illegal_characters(path_or_query){
if(cljs.core.truth_(path_or_query)){
return clojure.string.replace.call(null,clojure.string.replace.call(null,path_or_query," ","%20"),/[^a-zA-Z0-9\.\-\_\~\!\$\&\'\(\)\*\+\,\;\=\:\@\\/\%\?]/,kvlt.middleware.util.url_encode);
} else {
return null;
}
});
/**
 * Parse `s` as an RFC 2616 media type.
 */
kvlt.middleware.util.parse_content_type = (function kvlt$middleware$util$parse_content_type(s){
var temp__5276__auto__ = cljs.core.re_matches.call(null,/\s*(([^\/]+)\/([^ ;]+))\s*(\s*;.*)?/,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''));
if(cljs.core.truth_(temp__5276__auto__)){
var m = temp__5276__auto__;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"content-type","content-type",-508222634),cljs.core.keyword.call(null,cljs.core.nth.call(null,m,(1))),new cljs.core.Keyword(null,"content-type-params","content-type-params",-199252295),cljs.core.apply.call(null,cljs.core.hash_map,cljs.core.mapcat.call(null,((function (m,temp__5276__auto__){
return (function (p__40826){
var vec__40827 = p__40826;
var k = cljs.core.nth.call(null,vec__40827,(0),null);
var v = cljs.core.nth.call(null,vec__40827,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,clojure.string.lower_case.call(null,k)),clojure.string.trim.call(null,v)], null);
});})(m,temp__5276__auto__))
,cljs.core.map.call(null,((function (m,temp__5276__auto__){
return (function (p1__40821_SHARP_){
return clojure.string.split.call(null,p1__40821_SHARP_,/=/);
});})(m,temp__5276__auto__))
,cljs.core.remove.call(null,clojure.string.blank_QMARK_,cljs.core.identity.call(null,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,m,(4)))].join(''),/\s*;\s*/))))))], null);
} else {
return null;
}
});
var pattern_40839 = /charset\s*=\s*([^\s]+)/i;
kvlt.middleware.util.charset = ((function (pattern_40839){
return (function kvlt$middleware$util$charset(var_args){
var args__8635__auto__ = [];
var len__8628__auto___40840 = arguments.length;
var i__8629__auto___40841 = (0);
while(true){
if((i__8629__auto___40841 < len__8628__auto___40840)){
args__8635__auto__.push((arguments[i__8629__auto___40841]));

var G__40842 = (i__8629__auto___40841 + (1));
i__8629__auto___40841 = G__40842;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((1) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((1)),(0),null)):null);
return kvlt.middleware.util.charset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8636__auto__);
});})(pattern_40839))
;

kvlt.middleware.util.charset.cljs$core$IFn$_invoke$arity$variadic = ((function (pattern_40839){
return (function (content_type,p__40832){
var vec__40833 = p__40832;
var map__40836 = cljs.core.nth.call(null,vec__40833,(0),null);
var map__40836__$1 = ((((!((map__40836 == null)))?((((map__40836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40836.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40836):map__40836);
var fallback = cljs.core.get.call(null,map__40836__$1,new cljs.core.Keyword(null,"fallback","fallback",761637929));
var charset = (function (){var G__40838 = content_type;
var G__40838__$1 = (((G__40838 == null))?null:cljs.core.name.call(null,G__40838));
var G__40838__$2 = (((G__40838__$1 == null))?null:cljs.core.re_find.call(null,pattern_40839,G__40838__$1));
if((G__40838__$2 == null)){
return null;
} else {
return cljs.core.second.call(null,G__40838__$2);
}
})();
var or__7407__auto__ = charset;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
var or__7407__auto____$1 = fallback;
if(cljs.core.truth_(or__7407__auto____$1)){
return or__7407__auto____$1;
} else {
return "UTF-8";
}
}
});})(pattern_40839))
;

kvlt.middleware.util.charset.cljs$lang$maxFixedArity = (1);

kvlt.middleware.util.charset.cljs$lang$applyTo = ((function (pattern_40839){
return (function (seq40830){
var G__40831 = cljs.core.first.call(null,seq40830);
var seq40830__$1 = cljs.core.next.call(null,seq40830);
return kvlt.middleware.util.charset.cljs$core$IFn$_invoke$arity$variadic(G__40831,seq40830__$1);
});})(pattern_40839))
;

kvlt.middleware.util.string__GT_base64 = (function kvlt$middleware$util$string__GT_base64(x){
return goog.crypt.base64.encodeString(x);
});
kvlt.middleware.util.basic_auth = (function kvlt$middleware$util$basic_auth(v){
var vec__40846 = ((cljs.core.map_QMARK_.call(null,v))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v.call(null,new cljs.core.Keyword(null,"username","username",1605666410)),v.call(null,new cljs.core.Keyword(null,"password","password",417022471))], null):v);
var user = cljs.core.nth.call(null,vec__40846,(0),null);
var pass = cljs.core.nth.call(null,vec__40846,(1),null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Basic "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(kvlt.middleware.util.string__GT_base64.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(user),cljs.core.str.cljs$core$IFn$_invoke$arity$1(":"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(pass)].join('')))].join('');
});
kvlt.middleware.util.parse_url = (function kvlt$middleware$util$parse_url(url){
var url__$1 = (new goog.Uri(url));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,url__$1.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),url__$1.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),(function (){var temp__5278__auto__ = url__$1.getPort();
if(cljs.core.truth_(temp__5278__auto__)){
var port = temp__5278__auto__;
if((port > (0))){
return port;
} else {
return null;
}
} else {
return null;
}
})(),new cljs.core.Keyword(null,"uri","uri",-774711847),(function (){var G__40852 = url__$1;
var G__40852__$1 = (((G__40852 == null))?null:G__40852.getPath());
if((G__40852__$1 == null)){
return null;
} else {
return kvlt.middleware.util.url_encode_illegal_characters.call(null,G__40852__$1);
}
})(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),(function (){var G__40853 = url__$1;
var G__40853__$1 = (((G__40853 == null))?null:G__40853.getQuery());
var G__40853__$2 = (((G__40853__$1 == null))?null:cljs.core.not_empty.call(null,G__40853__$1));
if((G__40853__$2 == null)){
return null;
} else {
return kvlt.middleware.util.url_encode_illegal_characters.call(null,G__40853__$2);
}
})(),new cljs.core.Keyword(null,"user-info","user-info",-1061909920),(function (){var G__40854 = url__$1;
var G__40854__$1 = (((G__40854 == null))?null:G__40854.getUserInfo());
var G__40854__$2 = (((G__40854__$1 == null))?null:cljs.core.not_empty.call(null,G__40854__$1));
if((G__40854__$2 == null)){
return null;
} else {
return kvlt.middleware.util.url_decode.call(null,G__40854__$2);
}
})()], null);
});

//# sourceMappingURL=util.js.map