// Compiled by ClojureScript 1.9.562 {}
goog.provide('nicheware.platform.utilities.common.graphics');
goog.require('cljs.core');
goog.require('nicheware.platform.utilities.common.core');
goog.require('nicheware.platform.utilities.common.math');
/**
 * Computes the aspect ratio of the dimensions (represented as a map).
 * 
 *   - dimensions: Dimension to calculate aspect ratio for. ```{:width :height}```
 *   - returns: aspect ratio, as a float.
 */
nicheware.platform.utilities.common.graphics.aspect_ratio = (function nicheware$platform$utilities$common$graphics$aspect_ratio(p__9025){
var map__9028 = p__9025;
var map__9028__$1 = ((((!((map__9028 == null)))?((((map__9028.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9028.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9028):map__9028);
var dimensions = map__9028__$1;
var width = cljs.core.get.call(null,map__9028__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.call(null,map__9028__$1,new cljs.core.Keyword(null,"height","height",1025178622));
return nicheware.platform.utilities.common.math.div.call(null,width,height);
});
/**
 * Does a fit to height calculation of the dimensions-to-fit, within the containing-dimension.
 * 
 *   - containing-dimensions and dimensions-to-fit are both ```{:width :height}```
 *   - returns: a map ```{:width :height :x :y :scale}```
 * 
 * where:
 * 
 *   - width and height will retain the aspect ratio of dimensions-to-fit,
 *   - height will equal the height of containing-dimensions
 *   - x will be translation to position centrally, and y is 0
 *   - scale will be the scale factor to apply to width and height of dimensions-to-fit
 *  to get the new returned width and height.
 * 
 * 
 *   eg:
 * ```clojure
 * (fit-to-height {:width 100 :height 100} {:width 10 :height 20})
 * =>
 * {:width 50.0, :height 100, :x 25.0, :y 0, :scale 5.0}
 * ```
 */
nicheware.platform.utilities.common.graphics.fit_to_height = (function nicheware$platform$utilities$common$graphics$fit_to_height(p__9030,p__9031){
var map__9036 = p__9030;
var map__9036__$1 = ((((!((map__9036 == null)))?((((map__9036.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9036.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9036):map__9036);
var containing_dimensions = map__9036__$1;
var width = cljs.core.get.call(null,map__9036__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.call(null,map__9036__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var map__9037 = p__9031;
var map__9037__$1 = ((((!((map__9037 == null)))?((((map__9037.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9037.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9037):map__9037);
var dimensions_to_fit = map__9037__$1;
var fit_width = cljs.core.get.call(null,map__9037__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var fit_height = cljs.core.get.call(null,map__9037__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var scale = nicheware.platform.utilities.common.math.div.call(null,height,fit_height);
var new_width = nicheware.platform.utilities.common.math.mult.call(null,fit_width,scale);
var x = nicheware.platform.utilities.common.math.div.call(null,(width - new_width),(2));
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"width","width",-384071477),nicheware.platform.utilities.common.math.mult.call(null,fit_width,scale),new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"x","x",2099068185),x,new cljs.core.Keyword(null,"y","y",-1757859776),(0),new cljs.core.Keyword(null,"scale","scale",-230427353),scale], null);
});
/**
 * Does a fit to width calculation of the dimensions-to-fit, within the containing-dimension.
 * 
 *   - containing-dimensions: outer dimensions setting maximum width and height,  ```{:width :height}```
 *   - dimensions-to-fit: dimension defining the aspect ratio of the final dimension to fit inside containing-dimensions. ```{:width :height}```
 *   - returns: a map ```{:width :height :x :y :scale}```
 * 
 * where:
 * 
 *   - width and height will retain the aspect ratio of dimensions-to-fit,
 *   - width will equal the width of containing-dimensions
 *   - x will be 0 as we fill the entire area
 *   - y will ensure it is centered in the new area.
 *   - scale will be the scale factor to apply to width and height of dimensions-to-fit
 *  to get the new returned width and height.
 * 
 *   eg:
 * ```clojure
 * (fit-to-width {:width 100 :height 100} {:width 10 :height 20})
 * =>
 * {:width 100, :height 200.0, :x 0, :y -50.0, :scale 10.0}
 * ```
 */
nicheware.platform.utilities.common.graphics.fit_to_width = (function nicheware$platform$utilities$common$graphics$fit_to_width(p__9040,p__9041){
var map__9046 = p__9040;
var map__9046__$1 = ((((!((map__9046 == null)))?((((map__9046.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9046.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9046):map__9046);
var containing_dimensions = map__9046__$1;
var width = cljs.core.get.call(null,map__9046__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.call(null,map__9046__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var map__9047 = p__9041;
var map__9047__$1 = ((((!((map__9047 == null)))?((((map__9047.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9047.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9047):map__9047);
var dimensions_to_fit = map__9047__$1;
var fit_width = cljs.core.get.call(null,map__9047__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var fit_height = cljs.core.get.call(null,map__9047__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var scale = nicheware.platform.utilities.common.math.div.call(null,width,fit_width);
var new_height = nicheware.platform.utilities.common.math.mult.call(null,fit_height,scale);
var y = nicheware.platform.utilities.common.math.div.call(null,(height - new_height),(2));
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"width","width",-384071477),width,new cljs.core.Keyword(null,"height","height",1025178622),new_height,new cljs.core.Keyword(null,"x","x",2099068185),(0),new cljs.core.Keyword(null,"y","y",-1757859776),y,new cljs.core.Keyword(null,"scale","scale",-230427353),scale], null);
});
/**
 * Does a fit to size calculation of the dimensions-to-fit, within the containing-dimension.
 * 
 *   - containing-dimensions: outer dimensions setting maximum width and height,  ```{:width :height}```
 *   - dimensions-to-fit: dimension defining the aspect ratio of the final dimension to fit inside containing-dimensions. ```{:width :height}```
 *   - returns: a map ```{:width :height :scale}```
 * 
 * where:
 * 
 *   - width and height will retain the aspect ratio of dimensions-to-fit,
 *   - either width or height will equal the width or height of containing-dimensions
 *   - x and y will centre either horizontally or vertically depending on the best fit.
 *   - scale will be the scale factor to apply to width and height of dimensions-to-fit
 *  to get the new returned width and height.
 * 
 *   eg:
 * ```clojure
 * (fit-to-dimensions {:width 100 :height 100} {:width 10 :height 20})
 * =>
 * {:width 50.0, :height 100, :x 25.0, :y 0, :scale 5.0}
 * ```
 */
nicheware.platform.utilities.common.graphics.fit_to_dimensions = (function nicheware$platform$utilities$common$graphics$fit_to_dimensions(containing_dimensions,dimensions_to_fit){
if((nicheware.platform.utilities.common.graphics.aspect_ratio.call(null,containing_dimensions) < nicheware.platform.utilities.common.graphics.aspect_ratio.call(null,dimensions_to_fit))){
return nicheware.platform.utilities.common.graphics.fit_to_width.call(null,containing_dimensions,dimensions_to_fit);
} else {
return nicheware.platform.utilities.common.graphics.fit_to_height.call(null,containing_dimensions,dimensions_to_fit);
}
});
/**
 * Same calculation as [[fit-to-dimensions]], but doesn't bother returning the new width and height of the shape being fit
 * but instead the width and the height of the containing area, along with the x, y and scale needed to position
 * the shape within this area.
 * 
 *   - containing-dimensions: outer dimensions setting maximum width and height,  ```{:width :height}```
 *   - dimensions-to-fit: dimension defining the aspect ratio of the final dimension to fit inside containing-dimensions. ```{:width :height}```
 *   - returns a map ```{:width :height :x :y :scale}```
 * 
 * where:
 * 
 *   - width and height will be that of the containing-dimensions,
 *   - x and y will centre either horizontally or vertically depending on the best fit.
 *   - scale will be the scale factor to apply to width and height of dimensions-to-fit
 *  to fit the dimensions-to-fit within containing-dimensions
 * 
 *   eg:
 * ```clojure
 * (position-to-dimensions {:width 100 :height 100} {:width 10 :height 20})
 * =>
 * {:width 100, :height 100, :x 25.0, :y 0, :scale 5.0}
 * ```
 */
nicheware.platform.utilities.common.graphics.position_to_dimensions = (function nicheware$platform$utilities$common$graphics$position_to_dimensions(containing_dimensions,dimensions_to_fit){
return cljs.core.merge.call(null,nicheware.platform.utilities.common.graphics.fit_to_dimensions.call(null,containing_dimensions,dimensions_to_fit),containing_dimensions);
});
/**
 * Performs a reverse transformation of the co-ordinates, that have
 * previously been transformed according to the x, y translate and scale defined in dimensions.
 * 
 * Useful for converting mouse co-ordinates in a transform co-ordinate space to model co-ordinates.
 * 
 * - x: X co-ordinate in source space.
 * - y: Y co-ordinate in source space.
 * - transform: Original transform applied to get the supplied x, y. ```{:scale :x :y}```
 * - returns: x, y after applying reverse of transform to given x and y. ```{:x :y}```
 */
nicheware.platform.utilities.common.graphics.reverse_transform = (function nicheware$platform$utilities$common$graphics$reverse_transform(x,y,p__9050){
var map__9053 = p__9050;
var map__9053__$1 = ((((!((map__9053 == null)))?((((map__9053.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9053.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9053):map__9053);
var transform = map__9053__$1;
var trans_x = cljs.core.get.call(null,map__9053__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var trans_y = cljs.core.get.call(null,map__9053__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var scale = cljs.core.get.call(null,map__9053__$1,new cljs.core.Keyword(null,"scale","scale",-230427353));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),((x - trans_x) / scale),new cljs.core.Keyword(null,"y","y",-1757859776),((y - trans_y) / scale)], null);
});
/**
 * Updates the fill color for every shape in a collection of shapes.
 * 
 * Shapes will typically have a number of attributes (eg ```:x, :y```), but the only assumption
 * of this function is that color is specified with the ```:fill-color``` key.
 * 
 *   - shapes: Collection of shapes, where each shape is a map of the form: ```{:fill-color ...}```
 *   - fill-color: New fill color to set for each shape.
 *   - returns: Collection of shapes, where each shape has the supplied :fill-color.
 * 
 * eg:
 * ```clojure
 * (update-fill-colors [{:shape :point :x 1 :y 1 :fill-color 2}
 *                   {:shape :square :x 10 :y 10 :width 10 :fill-color 4}] 5)
 *   =>
 * [{:shape :point :x 1 :y 1 :fill-color 5}
 *  {:shape :square :x 10 :y 10 :width 10 :fill-color 5}]
 * ```
 */
nicheware.platform.utilities.common.graphics.update_fill_colors = (function nicheware$platform$utilities$common$graphics$update_fill_colors(shapes,fill_color){
return cljs.core.map.call(null,(function (p1__9055_SHARP_){
return cljs.core.assoc.call(null,p1__9055_SHARP_,new cljs.core.Keyword(null,"fill-color","fill-color",-1156875903),fill_color);
}),shapes);
});
/**
 * Updates the position all shapes in the given collection, translating the :x and :y locations by the given amounts.
 * 
 *   - shapes: Collection of shapes, where each shape is a map of the form: ```{:fill-color ...}```
 *   - trans-x: Amount to transform each shape x value by.
 *   - trans-y: Amount to transform each shape y value by.
 *   - returns: Collection of shapes where all shape x and y have been translated as specified.
 * 
 * ```clojure
 * (translate-shapes [{:shape :point :x 1 :y 1 :fill-color 2}
 *                 {:shape :square :x 10 :y 10 :width 10 :fill-color 4}] 2 3)
 *   =>
 * [{:shape :point :x 3 :y 4 :fill-color 2}
 *  {:shape :square :x 12 :y 13 :width 10 :fill-color 4}]
 * ```
 */
nicheware.platform.utilities.common.graphics.translate_shapes = (function nicheware$platform$utilities$common$graphics$translate_shapes(shapes,trans_x,trans_y){
var translate_fn = (function (shape){
return cljs.core.update.call(null,cljs.core.update.call(null,shape,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core._PLUS_,trans_x),new cljs.core.Keyword(null,"y","y",-1757859776),cljs.core._PLUS_,trans_y);
});
return cljs.core.map.call(null,translate_fn,shapes);
});

//# sourceMappingURL=graphics.js.map