// Compiled by ClojureScript 1.9.562 {}
goog.provide('nicheware.platform.utilities.common.graphics.color');
goog.require('cljs.core');
goog.require('thi.ng.strf.core');
goog.require('nicheware.platform.utilities.common.math');
goog.require('cljs.core.match');
goog.require('nicheware.platform.utilities.common.core');
nicheware.platform.utilities.common.graphics.color.hsl_precision = (2);
nicheware.platform.utilities.common.graphics.color.blue_color = (4286895332);
nicheware.platform.utilities.common.graphics.color.black_color = (4279242768);
nicheware.platform.utilities.common.graphics.color.light_grey_color = (4282664004);
nicheware.platform.utilities.common.graphics.color.dark_red_color = (4289335569);
nicheware.platform.utilities.common.graphics.color.transparent_blue_color = (1149555940);
nicheware.platform.utilities.common.graphics.color.dark_blue_color = (4286895359);
nicheware.platform.utilities.common.graphics.color.white_color = (4294967295);
nicheware.platform.utilities.common.graphics.color.dark_green_color = (4280010535);
nicheware.platform.utilities.common.graphics.color.green_color = (4279347729);
nicheware.platform.utilities.common.graphics.color.yellow_color = (4289374737);
nicheware.platform.utilities.common.graphics.color.bright_red_color = "#f44336";
nicheware.platform.utilities.common.graphics.color.css_yellow_color = "#FFEB3B";
nicheware.platform.utilities.common.graphics.color.css_blue_color = "#84D4E4";
nicheware.platform.utilities.common.graphics.color.css_pink_color = "#E91E63";
nicheware.platform.utilities.common.graphics.color.css_white_color = "#FFFFFF";
/**
 * Converts a 0 to 255 RGB value to 0 to 1.0
 * 
 *   - value: int RGB value from 0 to 255
 *   - returns: float RGB value from 0 to 1.0
 */
nicheware.platform.utilities.common.graphics.color.normalise_rgb = (function nicheware$platform$utilities$common$graphics$color$normalise_rgb(value){
return (value / (255));
});
/**
 * Converts a normalized value from 0 to 1 to an RGB int from 0 to 255
 * 
 *   - value: float RGB value from 0 to 1.0
 *   - returns: int RGB value from 0 to 255
 */
nicheware.platform.utilities.common.graphics.color.int_rgb = (function nicheware$platform$utilities$common$graphics$color$int_rgb(normalised_value){
return (((255) * normalised_value) | (0));
});
/**
 * Useful when RGB int values have been computed. Will convert any ratios to floats, round and then
 *   express as int
 * 
 *   - rgba-ratios: Collection of RGB values from 0 to 255. May be expressed as Clojure ratios due to calculations.
 *   - returns: vector of RGB values from 0 to 255 all as ints (may be rounded from original ratio value)
 */
nicheware.platform.utilities.common.graphics.color.ratio_rgba_to_int_rgba = (function nicheware$platform$utilities$common$graphics$color$ratio_rgba_to_int_rgba(rgba_ratios){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,(function (p1__10129_SHARP_){
return (Math.round(p1__10129_SHARP_) | (0));
}),rgba_ratios));
});
/**
 * Converts color values to vector of values from 0 to 255 for ```[R G B A]```.
 * Accepts a packed int or existing vector of ```[R G B]``` or ```[R G B A]```.
 * 
 * - color-value: Either a vector of ```[R G B]``` or ```[R G B A]```, or a packed int of form ```<alpha><R><G><B>```
 * - returns: vector of form ```[R G B A]```. If no alpha provided on input, 255 (opaque) is used.
 */
nicheware.platform.utilities.common.graphics.color.color_as_rgba = (function nicheware$platform$utilities$common$graphics$color$color_as_rgba(color_value){
if(cljs.core.not.call(null,color_value)){
return null;
} else {
if(cljs.core.coll_QMARK_.call(null,color_value)){
if(cljs.core._EQ_.call(null,(4),cljs.core.count.call(null,color_value))){
return color_value;
} else {
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.concat.call(null,color_value,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255)], null)));
}
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [((color_value >> (16)) & (255)),((color_value >> (8)) & (255)),(color_value & (255)),((color_value >>> (24)) & (255))], null);
}
}
});
/**
 * Converts color values to map of values from 0 to 255 for RGB and 0 to 1 for Alpha to
 * ```{:r <red> :g <green> :b <blue> :a <alpha> }```
 * 
 * Accepts a packed int or existing vector of ```[R G B]``` or ```[R G B A]```. Assumes alpha 255 on input.
 * 
 * Output suitable for use with react-color pickers.
 * 
 * - color-value: RGB color value as either ```[R G B]``` or ```[R G B A]```, or a packed int of form ```<alpha><R><G><B>```.
 * - returns: color map of the form ```{:r <red> :g <green> :b <blue> :a <alpha> }```
 */
nicheware.platform.utilities.common.graphics.color.color_as_map = (function nicheware$platform$utilities$common$graphics$color$color_as_map(color_value){
var vec__10133 = nicheware.platform.utilities.common.graphics.color.color_as_rgba.call(null,color_value);
var red = cljs.core.nth.call(null,vec__10133,(0),null);
var green = cljs.core.nth.call(null,vec__10133,(1),null);
var blue = cljs.core.nth.call(null,vec__10133,(2),null);
var alpha = cljs.core.nth.call(null,vec__10133,(3),null);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"r","r",-471384190),red,new cljs.core.Keyword(null,"g","g",1738089905),green,new cljs.core.Keyword(null,"b","b",1482224470),blue,new cljs.core.Keyword(null,"a","a",-2123407586),nicheware.platform.utilities.common.graphics.color.normalise_rgb.call(null,alpha)], null);
});
/**
 * Transform a color vector of ```[R G B A]``` into a CSS hex string such as ```#FFFFFF```, ignoring
 * the alpha.
 * 
 *   - color-value: vector of 0 to 255 values. ```[R G B A]```
 *   - returns: CSS hex RGB string ```#FFFFFF```
 */
nicheware.platform.utilities.common.graphics.color.rgba_as_css_hex = (function nicheware$platform$utilities$common$graphics$color$rgba_as_css_hex(p__10136){
var vec__10140 = p__10136;
var red = cljs.core.nth.call(null,vec__10140,(0),null);
var green = cljs.core.nth.call(null,vec__10140,(1),null);
var blue = cljs.core.nth.call(null,vec__10140,(2),null);
var alpha = cljs.core.nth.call(null,vec__10140,(3),null);
var color_value = vec__10140;
var css_value = thi.ng.strf.core.format.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#",thi.ng.strf.core.hex.call(null,(2)),thi.ng.strf.core.hex.call(null,(2)),thi.ng.strf.core.hex.call(null,(2))], null),red,green,blue);
return css_value;
});
/**
 * Converts a color array of ```[R G B A]``` all from 0 to 255 or a packed int ARGB,
 * into a CSS hex, which will ignore the alpha.
 * 
 *   - color-value: RGB color value as either ```[R G B]``` or ```[R G B A]```, or a packed int of form ```<alpha><R><G><B>```.
 *   - returns: CSS hex RGB string ```#FFFFFF```
 */
nicheware.platform.utilities.common.graphics.color.color_as_css_hex = (function nicheware$platform$utilities$common$graphics$color$color_as_css_hex(color_value){
return nicheware.platform.utilities.common.graphics.color.rgba_as_css_hex.call(null,nicheware.platform.utilities.common.graphics.color.color_as_rgba.call(null,color_value));
});
/**
 * Converts a react-col color value map. This has a number of forms within, but one is
 *   ```{ 'rgb' {'r' 255 'g' 255 'b' 255 'a' 1}}```. We convert this to ```[R G B A]```, all values 0 to 255
 * 
 *   - react-color: color as ```{ 'rgb' {'r' <red:0-255> 'g' <green:0-255> 'b' <blue:0-255> 'a' <alpha:0-1>}}```
 *   - returns: color as RGB vector ```[R G B A]```, all 0 to 255.
 */
nicheware.platform.utilities.common.graphics.color.react_color_as_rgba = (function nicheware$platform$utilities$common$graphics$color$react_color_as_rgba(p__10143){
var map__10148 = p__10143;
var map__10148__$1 = ((((!((map__10148 == null)))?((((map__10148.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10148.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10148):map__10148);
var react_color = map__10148__$1;
var rgb = cljs.core.get.call(null,map__10148__$1,"rgb");
var map__10150 = rgb;
var map__10150__$1 = ((((!((map__10150 == null)))?((((map__10150.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10150.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10150):map__10150);
var red = cljs.core.get.call(null,map__10150__$1,"r");
var green = cljs.core.get.call(null,map__10150__$1,"g");
var blue = cljs.core.get.call(null,map__10150__$1,"b");
var alpha = cljs.core.get.call(null,map__10150__$1,"a");
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [red,green,blue,nicheware.platform.utilities.common.graphics.color.int_rgb.call(null,alpha)], null);
});
/**
 * Modifies the color in a small way to make a slightly different color.
 * Currently does it by moving blue up or down by 1.
 * 
 * - color: vector of RGBA color to be nudged. ```[R G B A]```
 * - returns: slightly modified color in blue component. Either increment or decrement.
 */
nicheware.platform.utilities.common.graphics.color.nudge_color = (function nicheware$platform$utilities$common$graphics$color$nudge_color(p__10152){
var vec__10156 = p__10152;
var red = cljs.core.nth.call(null,vec__10156,(0),null);
var green = cljs.core.nth.call(null,vec__10156,(1),null);
var blue = cljs.core.nth.call(null,vec__10156,(2),null);
var alpha = cljs.core.nth.call(null,vec__10156,(3),null);
var color = vec__10156;
var new_blue = (((blue < (125)))?(blue + (1)):(blue - (1)));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [red,green,new_blue,alpha], null);
});
/**
 * Keep nudging the given color until it is unique given the existing set of unique colors.
 * 
 * - col: vector of RGBA color to be nudged. ```[R G B A]```
 * - unique-set: Set of RGBA colors, that we do not want to overlap with.
 * - returns: slightly modified color in blue component. Either increment or decrement. Will be different from all other colors in unique-set.
 */
nicheware.platform.utilities.common.graphics.color.unique_color = (function nicheware$platform$utilities$common$graphics$color$unique_color(col,unique_set){
var current_col = col;
var test_set = unique_set;
while(true){
if(cljs.core.not.call(null,cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([current_col]),test_set))){
return current_col;
} else {
var G__10159 = nicheware.platform.utilities.common.graphics.color.nudge_color.call(null,current_col);
var G__10160 = test_set;
current_col = G__10159;
test_set = G__10160;
continue;
}
break;
}
});
/**
 * Computes saturation given working values from RGB -> HSL computation
 */
nicheware.platform.utilities.common.graphics.color.calc_saturation = (function nicheware$platform$utilities$common$graphics$color$calc_saturation(delta,lightness){
if(cljs.core.truth_(delta)){
return nicheware.platform.utilities.common.math.roundn.call(null,nicheware.platform.utilities.common.graphics.color.hsl_precision,(delta / ((1) - Math.abs((((2) * lightness) - (1))))));
} else {
return (0);
}
});
/**
 * Computes hue given working values from RGB -> HSL computation
 */
nicheware.platform.utilities.common.graphics.color.calc_hue = (function nicheware$platform$utilities$common$graphics$color$calc_hue(delta,c_max,p__10161){
var vec__10165 = p__10161;
var red = cljs.core.nth.call(null,vec__10165,(0),null);
var green = cljs.core.nth.call(null,vec__10165,(1),null);
var blue = cljs.core.nth.call(null,vec__10165,(2),null);
var delta_grad_fn = ((function (vec__10165,red,green,blue){
return (function (c1,c2,delta__$1){
return ((c1 - c2) / delta__$1);
});})(vec__10165,red,green,blue))
;
var raw_hue = ((cljs.core._EQ_.call(null,delta,(0)))?(0):(((c_max === red))?cljs.core.mod.call(null,delta_grad_fn.call(null,green,blue,delta),(6)):(((c_max === green))?((2) + delta_grad_fn.call(null,blue,red,delta)):(((c_max === blue))?((4) + delta_grad_fn.call(null,red,green,delta)):null))));
var degrees = (Math.round(((60) * raw_hue)) | (0));
var normal_degrees = (((degrees < (0)))?(degrees + (360)):degrees);
return normal_degrees;
});
/**
 * Converts an RGBA vector ```[R G B A]``` all 0 to 255, to HSLA vector ```[H S L A]```
 * where H 0 to 360, and S and L are percentages and A remains unchanged (0 to 255)
 * 
 * - rgba: vector of RGBA color. ```[R G B A]```
 * - returns: HSLA version of rgba input. ```[H S L A]```
 */
nicheware.platform.utilities.common.graphics.color.rgba_to_hsla = (function nicheware$platform$utilities$common$graphics$color$rgba_to_hsla(p__10168){
var vec__10175 = p__10168;
var _ = cljs.core.nth.call(null,vec__10175,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__10175,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__10175,(2),null);
var alpha = cljs.core.nth.call(null,vec__10175,(3),null);
var rgba = vec__10175;
var vec__10178 = cljs.core.map.call(null,nicheware.platform.utilities.common.graphics.color.normalise_rgb,cljs.core.take.call(null,(3),rgba));
var red = cljs.core.nth.call(null,vec__10178,(0),null);
var green = cljs.core.nth.call(null,vec__10178,(1),null);
var blue = cljs.core.nth.call(null,vec__10178,(2),null);
var normalised_rgb = vec__10178;
var c_max = cljs.core.apply.call(null,cljs.core.max,normalised_rgb);
var c_min = cljs.core.apply.call(null,cljs.core.min,normalised_rgb);
var delta = (c_max - c_min);
var lightness = nicheware.platform.utilities.common.math.roundn.call(null,nicheware.platform.utilities.common.graphics.color.hsl_precision,((c_max + c_min) * 0.5));
var saturation = nicheware.platform.utilities.common.graphics.color.calc_saturation.call(null,delta,lightness);
var hue = nicheware.platform.utilities.common.graphics.color.calc_hue.call(null,delta,c_max,normalised_rgb);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [hue,saturation,lightness,alpha], null);
});
/**
 * Compures C in the HSL to RGB conversion formula
 */
nicheware.platform.utilities.common.graphics.color.calc_c = (function nicheware$platform$utilities$common$graphics$color$calc_c(saturation,lightness){
return (saturation * ((1) - Math.abs((((2) * lightness) - (1)))));
});
/**
 * Computes X in the HSL to RGB converson formula
 */
nicheware.platform.utilities.common.graphics.color.calc_x = (function nicheware$platform$utilities$common$graphics$color$calc_x(c,hue){
return (c * ((1) - Math.abs((cljs.core.mod.call(null,(hue / (60)),(2)) - (1)))));
});
/**
 * Calculate initial raw RGB values for HSL to RGB calculation
 */
nicheware.platform.utilities.common.graphics.color.calc_initial_rgb = (function nicheware$platform$utilities$common$graphics$color$calc_initial_rgb(c,x,hue){
var pred__10184 = cljs.core._GT_;
var expr__10185 = hue;
if(cljs.core.truth_(pred__10184.call(null,(60),expr__10185))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [c,x,(0)], null);
} else {
if(cljs.core.truth_(pred__10184.call(null,(120),expr__10185))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,c,(0)], null);
} else {
if(cljs.core.truth_(pred__10184.call(null,(180),expr__10185))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),c,x], null);
} else {
if(cljs.core.truth_(pred__10184.call(null,(240),expr__10185))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),x,c], null);
} else {
if(cljs.core.truth_(pred__10184.call(null,(300),expr__10185))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,(0),c], null);
} else {
if(cljs.core.truth_(pred__10184.call(null,(360),expr__10185))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [c,(0),x], null);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__10185)].join('')));
}
}
}
}
}
}
});
/**
 * Converts an initial rgb value in a HSL conversion to final RGB value 0 to 255
 */
nicheware.platform.utilities.common.graphics.color.calc_rgb = (function nicheware$platform$utilities$common$graphics$color$calc_rgb(m,initial_rgb_value){
return (Math.round(((255) * (m + initial_rgb_value))) | (0));
});
/**
 * Converts an HSLA vector ```[H S L A]``` where H 0 to 360, S and L percentages
 * to RGBA vector ```[R G B A]``` all 255
 * and A remains unchanged (0 to 255)
 * 
 * - hlsa: HSLA version of rgba input.  ```[H S L A]```
 * - returns: vector of RGBA color. ```[R G B A]```
 */
nicheware.platform.utilities.common.graphics.color.hsla_to_rgba = (function nicheware$platform$utilities$common$graphics$color$hsla_to_rgba(p__10188){
var vec__10195 = p__10188;
var hue = cljs.core.nth.call(null,vec__10195,(0),null);
var saturation = cljs.core.nth.call(null,vec__10195,(1),null);
var lightness = cljs.core.nth.call(null,vec__10195,(2),null);
var alpha = cljs.core.nth.call(null,vec__10195,(3),null);
var hlsa = vec__10195;
var c = nicheware.platform.utilities.common.graphics.color.calc_c.call(null,saturation,lightness);
var x = nicheware.platform.utilities.common.graphics.color.calc_x.call(null,c,hue);
var m = (lightness - (c / (2)));
var initial_rgb = nicheware.platform.utilities.common.graphics.color.calc_initial_rgb.call(null,c,x,hue);
var vec__10198 = cljs.core.map.call(null,((function (c,x,m,initial_rgb,vec__10195,hue,saturation,lightness,alpha,hlsa){
return (function (p1__10187_SHARP_){
return nicheware.platform.utilities.common.graphics.color.calc_rgb.call(null,m,p1__10187_SHARP_);
});})(c,x,m,initial_rgb,vec__10195,hue,saturation,lightness,alpha,hlsa))
,initial_rgb);
var red = cljs.core.nth.call(null,vec__10198,(0),null);
var green = cljs.core.nth.call(null,vec__10198,(1),null);
var blue = cljs.core.nth.call(null,vec__10198,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [red,green,blue,alpha], null);
});
/**
 * Keywords used to define different color model types. Allows conversion form one model to another.
 * Only currently supports ```:rgba``` and ```:hsla```
 * 
 *   - from-model: color model used by the input color value. (either ```:rgba``` or ```:hsla```)
 *   - to-model: color model to convert input color to. (either ```:rgba``` or ```:hsla```)
 *   - color: Color to be converted. Will be represented according to from-model. So either ```[R G B A]``` or ```[H S L A]```
 *   - returns: input color converted to the to-model. So either ```[R G B A]``` or ```[H S L A]```
 */
nicheware.platform.utilities.common.graphics.color.model_from_to = (function nicheware$platform$utilities$common$graphics$color$model_from_to(from_model,to_model,color){
try{if(cljs.core.keyword_identical_QMARK_.call(null,from_model,new cljs.core.Keyword(null,"rgba","rgba",-2032958718))){
try{if(cljs.core.keyword_identical_QMARK_.call(null,to_model,new cljs.core.Keyword(null,"hsla","hsla",1815162996))){
return nicheware.platform.utilities.common.graphics.color.rgba_to_hsla.call(null,color);
} else {
throw cljs.core.match.backtrack;

}
}catch (e10220){if((e10220 instanceof Error)){
var e__9203__auto__ = e10220;
if((e__9203__auto__ === cljs.core.match.backtrack)){
throw cljs.core.match.backtrack;
} else {
throw e__9203__auto__;
}
} else {
throw e10220;

}
}} else {
throw cljs.core.match.backtrack;

}
}catch (e10213){if((e10213 instanceof Error)){
var e__9203__auto__ = e10213;
if((e__9203__auto__ === cljs.core.match.backtrack)){
try{if(cljs.core.keyword_identical_QMARK_.call(null,from_model,new cljs.core.Keyword(null,"hsla","hsla",1815162996))){
try{if(cljs.core.keyword_identical_QMARK_.call(null,to_model,new cljs.core.Keyword(null,"rgba","rgba",-2032958718))){
return nicheware.platform.utilities.common.graphics.color.hsla_to_rgba.call(null,color);
} else {
throw cljs.core.match.backtrack;

}
}catch (e10219){if((e10219 instanceof Error)){
var e__9203__auto____$1 = e10219;
if((e__9203__auto____$1 === cljs.core.match.backtrack)){
throw cljs.core.match.backtrack;
} else {
throw e__9203__auto____$1;
}
} else {
throw e10219;

}
}} else {
throw cljs.core.match.backtrack;

}
}catch (e10214){if((e10214 instanceof Error)){
var e__9203__auto____$1 = e10214;
if((e__9203__auto____$1 === cljs.core.match.backtrack)){
try{if(cljs.core.keyword_identical_QMARK_.call(null,from_model,new cljs.core.Keyword(null,"rgba","rgba",-2032958718))){
try{if(cljs.core.keyword_identical_QMARK_.call(null,to_model,new cljs.core.Keyword(null,"rgba","rgba",-2032958718))){
return color;
} else {
throw cljs.core.match.backtrack;

}
}catch (e10218){if((e10218 instanceof Error)){
var e__9203__auto____$2 = e10218;
if((e__9203__auto____$2 === cljs.core.match.backtrack)){
throw cljs.core.match.backtrack;
} else {
throw e__9203__auto____$2;
}
} else {
throw e10218;

}
}} else {
throw cljs.core.match.backtrack;

}
}catch (e10215){if((e10215 instanceof Error)){
var e__9203__auto____$2 = e10215;
if((e__9203__auto____$2 === cljs.core.match.backtrack)){
try{if(cljs.core.keyword_identical_QMARK_.call(null,from_model,new cljs.core.Keyword(null,"hsla","hsla",1815162996))){
try{if(cljs.core.keyword_identical_QMARK_.call(null,to_model,new cljs.core.Keyword(null,"hsla","hsla",1815162996))){
return color;
} else {
throw cljs.core.match.backtrack;

}
}catch (e10217){if((e10217 instanceof Error)){
var e__9203__auto____$3 = e10217;
if((e__9203__auto____$3 === cljs.core.match.backtrack)){
throw cljs.core.match.backtrack;
} else {
throw e__9203__auto____$3;
}
} else {
throw e10217;

}
}} else {
throw cljs.core.match.backtrack;

}
}catch (e10216){if((e10216 instanceof Error)){
var e__9203__auto____$3 = e10216;
if((e__9203__auto____$3 === cljs.core.match.backtrack)){
return nicheware.platform.utilities.common.core.throw_illegal_arg.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unsupported color model conversion: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(from_model),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(to_model)].join(''));
} else {
throw e__9203__auto____$3;
}
} else {
throw e10216;

}
}} else {
throw e__9203__auto____$2;
}
} else {
throw e10215;

}
}} else {
throw e__9203__auto____$1;
}
} else {
throw e10214;

}
}} else {
throw e__9203__auto__;
}
} else {
throw e10213;

}
}});
/**
 * Returns a vector defining the ranges of the values in the color model.
 *   eg ```:rgba``` would give ```[255 255 255 255]```
 *   ```:hsla``` would give ```[359 1 1 255]```
 * 
 *   - color-model: Color model for which ranges required. (either ```:rgba``` or ```:hsla```)
 *   - returns: vector of ranges for each dimension,  appropriate to color model. (either ```[255 255 255 255]``` or ```[359 1 1 255]```)
 *  Throws environment specific illegal argument exception for invalid color model.
 */
nicheware.platform.utilities.common.graphics.color.model_ranges = (function nicheware$platform$utilities$common$graphics$color$model_ranges(color_model){
var G__10222 = color_model;
var G__10222__$1 = (((G__10222 instanceof cljs.core.Keyword))?G__10222.fqn:null);
switch (G__10222__$1) {
case "rgba":
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(255),(255)], null);

break;
case "hsla":
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(359),(1),(1),(255)], null);

break;
default:
return nicheware.platform.utilities.common.core.throw_illegal_arg.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unsupported color model: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(color_model)].join(''));

}
});
/**
 * Uses the difference between the two colors to create a color increment function.
 * 
 *   - start-color: Color value as starting point for difference. either  ```[R G B]``` or ```[R G B A]```, or a packed int of form ```<alpha><R><G><B>```.
 *   - end-color: Color value as starting point for difference. either ```[R G B]``` or ```[R G B A]```, or a packed int of form ```<alpha><R><G><B>```.
 *   - returns: function taking a single color argument, and modifying it by the difference between start-color and end-color.
 *  Argument can be either  ```[R G B]``` or ```[R G B A]```, or a packed int of form ```<alpha><R><G><B>```.
 *  Result will be ```[R G B A]```
 */
nicheware.platform.utilities.common.graphics.color.make_color_increment_fn = (function nicheware$platform$utilities$common$graphics$color$make_color_increment_fn(start_color,end_color){
var start = nicheware.platform.utilities.common.graphics.color.color_as_rgba.call(null,start_color);
var end = nicheware.platform.utilities.common.graphics.color.color_as_rgba.call(null,end_color);
var difference = cljs.core.map.call(null,((function (start,end){
return (function (p1__10225_SHARP_,p2__10224_SHARP_){
return (p2__10224_SHARP_ - p1__10225_SHARP_);
});})(start,end))
,start,end);
return ((function (start,end,difference){
return (function (color){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,((function (start,end,difference){
return (function (p1__10228_SHARP_){
var x__7752__auto__ = (function (){var x__7745__auto__ = p1__10228_SHARP_;
var y__7746__auto__ = (0);
return ((x__7745__auto__ > y__7746__auto__) ? x__7745__auto__ : y__7746__auto__);
})();
var y__7753__auto__ = (255);
return ((x__7752__auto__ < y__7753__auto__) ? x__7752__auto__ : y__7753__auto__);
});})(start,end,difference))
,cljs.core.map.call(null,((function (start,end,difference){
return (function (p1__10226_SHARP_,p2__10227_SHARP_){
return (p1__10226_SHARP_ + p2__10227_SHARP_);
});})(start,end,difference))
,difference,nicheware.platform.utilities.common.graphics.color.color_as_rgba.call(null,color))));
});
;})(start,end,difference))
});
/**
 * Create a color sequence that follows on from the end color, using the start/end difference.
 * Input colors in form of either Int32 or vector of RGBA
 * 
 *   - start-color: Color value as starting point for difference. either  ```[R G B]``` or ```[R G B A]```, or a packed int of form ```<alpha><R><G><B>```.
 *   - end-color: Color value as starting point for difference. either ```[R G B]``` or ```[R G B A]```, or a packed int of form ```<alpha><R><G><B>```.
 *   - count: Number of colors to generate using end-color as initial input and each resulting color as next input.
 *   - returns: vector of count colors, being a sequence after end-color, using the color difference between start-color and end-color to generate colors.
 *  All generated colors are in RGBA format ```[R G B A]```.
 */
nicheware.platform.utilities.common.graphics.color.color_difference_seq = (function nicheware$platform$utilities$common$graphics$color$color_difference_seq(start_color,end_color,count){
var inc_fn = nicheware.platform.utilities.common.graphics.color.make_color_increment_fn.call(null,start_color,end_color);
return cljs.core.take.call(null,count,cljs.core.iterate.call(null,inc_fn,inc_fn.call(null,end_color)));
});

//# sourceMappingURL=color.js.map