// Compiled by ClojureScript 1.9.562 {}
goog.provide('nicheware.platform.utilities.common.graphics.interpolate');
goog.require('cljs.core');
goog.require('nicheware.platform.utilities.common.graphics.line');
goog.require('nicheware.platform.utilities.common.core');
nicheware.platform.utilities.common.graphics.interpolate.default_ease = 0.42;
nicheware.platform.utilities.common.graphics.interpolate.default_step_fraction = 0.05;
nicheware.platform.utilities.common.graphics.interpolate.interpolation_types = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"ease-in","ease-in",-819423123),new cljs.core.Keyword(null,"ease-out","ease-out",1760664474),new cljs.core.Keyword(null,"ease-in-out","ease-in-out",1896519269),new cljs.core.Keyword(null,"cubic-bezier","cubic-bezier",536841881),new cljs.core.Keyword(null,"quadratic-bezier","quadratic-bezier",2144881673),new cljs.core.Keyword(null,"step-up","step-up",-1569697211),new cljs.core.Keyword(null,"step-down","step-down",-1564183105)], null);
/**
 * Get options for use in interpolation by merging defaults with given options.
 * 
 * - options: User provided options which will override (merge with) the default options.
 * - start: 3 arity optional argument. Start control point for interpolation. vector of co-ordindates.
 * - end: 3 arity optional argument. End control point for interpolation. vector of co-ordindates.
 * - returns: map of options used for interpolation.
 * 
 * Default options:
 * ```clojure
 * {:type :linear
 *  :ease default-ease
 *  :control1 start
 *  :control2 end
 *  :step {:fraction default-step-fraction :ranges end}}
 * ```
 */
nicheware.platform.utilities.common.graphics.interpolate.get_options = (function nicheware$platform$utilities$common$graphics$interpolate$get_options(var_args){
var args8711 = [];
var len__8628__auto___8714 = arguments.length;
var i__8629__auto___8715 = (0);
while(true){
if((i__8629__auto___8715 < len__8628__auto___8714)){
args8711.push((arguments[i__8629__auto___8715]));

var G__8716 = (i__8629__auto___8715 + (1));
i__8629__auto___8715 = G__8716;
continue;
} else {
}
break;
}

var G__8713 = args8711.length;
switch (G__8713) {
case 1:
return nicheware.platform.utilities.common.graphics.interpolate.get_options.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return nicheware.platform.utilities.common.graphics.interpolate.get_options.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args8711.length)].join('')));

}
});

nicheware.platform.utilities.common.graphics.interpolate.get_options.cljs$core$IFn$_invoke$arity$1 = (function (options){
return nicheware.platform.utilities.common.graphics.interpolate.get_options.call(null,options,null,null);
});

nicheware.platform.utilities.common.graphics.interpolate.get_options.cljs$core$IFn$_invoke$arity$3 = (function (options,start,end){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"ease","ease",-1427802543),nicheware.platform.utilities.common.graphics.interpolate.default_ease,new cljs.core.Keyword(null,"control1","control1",-1014952430),start,new cljs.core.Keyword(null,"control2","control2",368813144),end,new cljs.core.Keyword(null,"step","step",1288888124),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"fraction","fraction",107940680),nicheware.platform.utilities.common.graphics.interpolate.default_step_fraction,new cljs.core.Keyword(null,"ranges","ranges",1887686682),end], null)], null),options);
});

nicheware.platform.utilities.common.graphics.interpolate.get_options.cljs$lang$maxFixedArity = 3;

/**
 * Given a set of points in which all dimensions have been interpolated, modify them so that
 * only those dimensions selected in the :active-dimensions remain, and the rest default to the start dimension.
 */
nicheware.platform.utilities.common.graphics.interpolate.select_dimensions = (function nicheware$platform$utilities$common$graphics$interpolate$select_dimensions(points,start,options){
var temp__5276__auto__ = new cljs.core.Keyword(null,"active-dimensions","active-dimensions",540536784).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(temp__5276__auto__)){
var active_dimensions = temp__5276__auto__;
return cljs.core.map.call(null,((function (active_dimensions,temp__5276__auto__){
return (function (p1__8718_SHARP_){
return nicheware.platform.utilities.common.core.selective_merge.call(null,start,p1__8718_SHARP_,active_dimensions);
});})(active_dimensions,temp__5276__auto__))
,points);
} else {
return points;
}
});
if(typeof nicheware.platform.utilities.common.graphics.interpolate.interpolate !== 'undefined'){
} else {
/**
 * Performs interpolation between the two given points, creating the specified
 * number of interleaving points. The type of interpolation is determined by the
 * options argument, of which the :type field will determine the type of interpolation used.
 * 
 *   - start: n-dimension vector marking start of transformation
 *   - end: n-dimension vector marking end of transformation
 *   - num-points: Number of interleaving points between start and end to return, using the interpolation function defined by options
 *   - options: Set of options defining attributes of the interpolation function to be used. See below
 *   - returns: vector of n-dimension vector, with each of the num-points entries being along the interpolation space.
 * 
 *   Options is of the form:
 * 
 * ```clojure
 *  {:type :linear | :ease-in | :ease-out | :ease-in-out | :cubic-bezier | :quadratic-bezier | :step-up | :step-down
 *   :control1 [...]  - Control point 1 (eg quadratic-bezier and cubic-bezier)
 *   :control2 [...]  - Control point 2 (eg cubic-bezier)
 *   :ease <0 to 0.5> - ratio of easing. Defaults to 0.42
 *   :step { :fraction <0 to 1>  - What fraction of range for each co-ord to step up or down
 *        :ranges [x x x x]}  - Range of each dimension incoming points,
 *                              used to calculate a different step per dimension
 *   :active-dimensions [true|false  ...] - Indicate which dimension to modify during interpolation
 *                                       Any not modified will use the value of the start for that dimension.
 * }
 * ```
 * 
 *   
 */
nicheware.platform.utilities.common.graphics.interpolate.interpolate = (function (){var method_table__8438__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__8439__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__8440__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__8441__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__8442__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"nicheware.platform.utilities.common.graphics.interpolate","interpolate"),((function (method_table__8438__auto__,prefer_table__8439__auto__,method_cache__8440__auto__,cached_hierarchy__8441__auto__,hierarchy__8442__auto__){
return (function (start,end,num_points,options){
return new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(options);
});})(method_table__8438__auto__,prefer_table__8439__auto__,method_cache__8440__auto__,cached_hierarchy__8441__auto__,hierarchy__8442__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__8442__auto__,method_table__8438__auto__,prefer_table__8439__auto__,method_cache__8440__auto__,cached_hierarchy__8441__auto__));
})();
}
cljs.core._add_method.call(null,nicheware.platform.utilities.common.graphics.interpolate.interpolate,new cljs.core.Keyword(null,"linear","linear",872268697),(function (start,end,num_points,options){
return nicheware.platform.utilities.common.graphics.interpolate.select_dimensions.call(null,nicheware.platform.utilities.common.graphics.line.interpolate_n_points.call(null,nicheware.platform.utilities.common.graphics.line.make_lerp.call(null,start,end),num_points),start,options);
}));
cljs.core._add_method.call(null,nicheware.platform.utilities.common.graphics.interpolate.interpolate,new cljs.core.Keyword(null,"quadratic-bezier","quadratic-bezier",2144881673),(function (start,end,num_points,options){
var map__8719 = nicheware.platform.utilities.common.graphics.interpolate.get_options.call(null,options,start,end);
var map__8719__$1 = ((((!((map__8719 == null)))?((((map__8719.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8719.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8719):map__8719);
var control1 = cljs.core.get.call(null,map__8719__$1,new cljs.core.Keyword(null,"control1","control1",-1014952430));
return nicheware.platform.utilities.common.graphics.interpolate.select_dimensions.call(null,nicheware.platform.utilities.common.graphics.line.interpolate_n_points.call(null,nicheware.platform.utilities.common.graphics.line.bezier_quadratic_equation.call(null,start,control1,end),num_points),start,options);
}));
cljs.core._add_method.call(null,nicheware.platform.utilities.common.graphics.interpolate.interpolate,new cljs.core.Keyword(null,"cubic-bezier","cubic-bezier",536841881),(function (start,end,num_points,options){
var map__8721 = nicheware.platform.utilities.common.graphics.interpolate.get_options.call(null,options,start,end);
var map__8721__$1 = ((((!((map__8721 == null)))?((((map__8721.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8721.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8721):map__8721);
var control1 = cljs.core.get.call(null,map__8721__$1,new cljs.core.Keyword(null,"control1","control1",-1014952430));
var control2 = cljs.core.get.call(null,map__8721__$1,new cljs.core.Keyword(null,"control2","control2",368813144));
return nicheware.platform.utilities.common.graphics.interpolate.select_dimensions.call(null,nicheware.platform.utilities.common.graphics.line.interpolate_n_points.call(null,nicheware.platform.utilities.common.graphics.line.bezier_cubic_equation.call(null,start,control1,control2,end),num_points),start,options);
}));
cljs.core._add_method.call(null,nicheware.platform.utilities.common.graphics.interpolate.interpolate,new cljs.core.Keyword(null,"ease-in","ease-in",-819423123),(function (start,end,num_points,options){
var ease_in = new cljs.core.Keyword(null,"ease","ease",-1427802543).cljs$core$IFn$_invoke$arity$1(nicheware.platform.utilities.common.graphics.interpolate.get_options.call(null,options));
var control1 = cljs.core.map.call(null,((function (ease_in){
return (function (p1__8723_SHARP_){
return (ease_in * p1__8723_SHARP_);
});})(ease_in))
,end);
return nicheware.platform.utilities.common.graphics.interpolate.select_dimensions.call(null,nicheware.platform.utilities.common.graphics.line.interpolate_n_points.call(null,nicheware.platform.utilities.common.graphics.line.bezier_quadratic_equation.call(null,start,control1,end),num_points),start,options);
}));
cljs.core._add_method.call(null,nicheware.platform.utilities.common.graphics.interpolate.interpolate,new cljs.core.Keyword(null,"ease-out","ease-out",1760664474),(function (start,end,num_points,options){
var ease_out = ((1) - new cljs.core.Keyword(null,"ease","ease",-1427802543).cljs$core$IFn$_invoke$arity$1(nicheware.platform.utilities.common.graphics.interpolate.get_options.call(null,options)));
var control1 = cljs.core.map.call(null,((function (ease_out){
return (function (p1__8724_SHARP_){
return (ease_out * p1__8724_SHARP_);
});})(ease_out))
,end);
return nicheware.platform.utilities.common.graphics.interpolate.select_dimensions.call(null,nicheware.platform.utilities.common.graphics.line.interpolate_n_points.call(null,nicheware.platform.utilities.common.graphics.line.bezier_quadratic_equation.call(null,start,control1,end),num_points),start,options);
}));
cljs.core._add_method.call(null,nicheware.platform.utilities.common.graphics.interpolate.interpolate,new cljs.core.Keyword(null,"ease-in-out","ease-in-out",1896519269),(function (start,end,num_points,options){
var full_options = nicheware.platform.utilities.common.graphics.interpolate.get_options.call(null,options);
var ease_in = new cljs.core.Keyword(null,"ease","ease",-1427802543).cljs$core$IFn$_invoke$arity$1(full_options);
var ease_out = ((1) - ease_in);
var control1 = cljs.core.map.call(null,((function (full_options,ease_in,ease_out){
return (function (p1__8725_SHARP_){
return (ease_in * p1__8725_SHARP_);
});})(full_options,ease_in,ease_out))
,end);
var control2 = cljs.core.map.call(null,((function (full_options,ease_in,ease_out,control1){
return (function (p1__8726_SHARP_){
return (ease_out * p1__8726_SHARP_);
});})(full_options,ease_in,ease_out,control1))
,end);
return nicheware.platform.utilities.common.graphics.interpolate.select_dimensions.call(null,nicheware.platform.utilities.common.graphics.line.interpolate_n_points.call(null,nicheware.platform.utilities.common.graphics.line.bezier_cubic_equation.call(null,start,control1,control2,end),num_points),start,options);
}));
cljs.core._add_method.call(null,nicheware.platform.utilities.common.graphics.interpolate.interpolate,new cljs.core.Keyword(null,"step-up","step-up",-1569697211),(function (start,end,num_points,options){
var map__8731 = nicheware.platform.utilities.common.graphics.interpolate.get_options.call(null,options,start,end);
var map__8731__$1 = ((((!((map__8731 == null)))?((((map__8731.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8731.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8731):map__8731);
var full_options = map__8731__$1;
var map__8732 = cljs.core.get.call(null,map__8731__$1,new cljs.core.Keyword(null,"step","step",1288888124));
var map__8732__$1 = ((((!((map__8732 == null)))?((((map__8732.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8732.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8732):map__8732);
var fraction = cljs.core.get.call(null,map__8732__$1,new cljs.core.Keyword(null,"fraction","fraction",107940680));
var ranges = cljs.core.get.call(null,map__8732__$1,new cljs.core.Keyword(null,"ranges","ranges",1887686682));
var step_fraction = (function (){var or__7407__auto__ = fraction;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return nicheware.platform.utilities.common.graphics.interpolate.default_step_fraction;
}
})();
var steps = cljs.core.map.call(null,((function (map__8731,map__8731__$1,full_options,map__8732,map__8732__$1,fraction,ranges,step_fraction){
return (function (p1__8727_SHARP_){
return (step_fraction * p1__8727_SHARP_);
});})(map__8731,map__8731__$1,full_options,map__8732,map__8732__$1,fraction,ranges,step_fraction))
,ranges);
var step_fn = ((function (map__8731,map__8731__$1,full_options,map__8732,map__8732__$1,fraction,ranges,step_fraction,steps){
return (function (point){
return cljs.core.map.call(null,((function (map__8731,map__8731__$1,full_options,map__8732,map__8732__$1,fraction,ranges,step_fraction,steps){
return (function (p1__8728_SHARP_,p2__8729_SHARP_,p3__8730_SHARP_){
var x__7752__auto__ = (p1__8728_SHARP_ + p2__8729_SHARP_);
var y__7753__auto__ = p3__8730_SHARP_;
return ((x__7752__auto__ < y__7753__auto__) ? x__7752__auto__ : y__7753__auto__);
});})(map__8731,map__8731__$1,full_options,map__8732,map__8732__$1,fraction,ranges,step_fraction,steps))
,point,steps,ranges);
});})(map__8731,map__8731__$1,full_options,map__8732,map__8732__$1,fraction,ranges,step_fraction,steps))
;
return nicheware.platform.utilities.common.graphics.interpolate.select_dimensions.call(null,cljs.core.take.call(null,(num_points + (1)),cljs.core.iterate.call(null,step_fn,step_fn.call(null,start))),start,options);
}));
cljs.core._add_method.call(null,nicheware.platform.utilities.common.graphics.interpolate.interpolate,new cljs.core.Keyword(null,"step-down","step-down",-1564183105),(function (start,end,num_points,options){
var map__8738 = nicheware.platform.utilities.common.graphics.interpolate.get_options.call(null,options,end,start);
var map__8738__$1 = ((((!((map__8738 == null)))?((((map__8738.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8738.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8738):map__8738);
var full_options = map__8738__$1;
var map__8739 = cljs.core.get.call(null,map__8738__$1,new cljs.core.Keyword(null,"step","step",1288888124));
var map__8739__$1 = ((((!((map__8739 == null)))?((((map__8739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8739.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8739):map__8739);
var fraction = cljs.core.get.call(null,map__8739__$1,new cljs.core.Keyword(null,"fraction","fraction",107940680));
var ranges = cljs.core.get.call(null,map__8739__$1,new cljs.core.Keyword(null,"ranges","ranges",1887686682));
var step_fraction = (function (){var or__7407__auto__ = fraction;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return nicheware.platform.utilities.common.graphics.interpolate.default_step_fraction;
}
})();
var steps = cljs.core.map.call(null,((function (map__8738,map__8738__$1,full_options,map__8739,map__8739__$1,fraction,ranges,step_fraction){
return (function (p1__8735_SHARP_){
return (step_fraction * p1__8735_SHARP_);
});})(map__8738,map__8738__$1,full_options,map__8739,map__8739__$1,fraction,ranges,step_fraction))
,ranges);
var step_fn = ((function (map__8738,map__8738__$1,full_options,map__8739,map__8739__$1,fraction,ranges,step_fraction,steps){
return (function (point){
return cljs.core.map.call(null,((function (map__8738,map__8738__$1,full_options,map__8739,map__8739__$1,fraction,ranges,step_fraction,steps){
return (function (p1__8736_SHARP_,p2__8737_SHARP_){
var x__7745__auto__ = (p1__8736_SHARP_ - p2__8737_SHARP_);
var y__7746__auto__ = (0);
return ((x__7745__auto__ > y__7746__auto__) ? x__7745__auto__ : y__7746__auto__);
});})(map__8738,map__8738__$1,full_options,map__8739,map__8739__$1,fraction,ranges,step_fraction,steps))
,point,steps);
});})(map__8738,map__8738__$1,full_options,map__8739,map__8739__$1,fraction,ranges,step_fraction,steps))
;
return nicheware.platform.utilities.common.graphics.interpolate.select_dimensions.call(null,cljs.core.take.call(null,(num_points + (1)),cljs.core.iterate.call(null,step_fn,step_fn.call(null,start))),start,options);
}));

//# sourceMappingURL=interpolate.js.map