// Compiled by ClojureScript 1.9.562 {}
goog.provide('nicheware.platform.utilities.common.state.migration');
goog.require('cljs.core');
goog.require('nicheware.platform.utilities.common.core');
goog.require('clojure.string');
/**
 * Extracts the major version as an int from a version string of the form 'x.x.x'
 * 
 *   - version: version number string of the form 'x.x.x' or 'x.x'
 *   - returns: The major version (first x) as an int. nil if not a valid version number.
 */
nicheware.platform.utilities.common.state.migration.major_version = (function nicheware$platform$utilities$common$state$migration$major_version(version){
return nicheware.platform.utilities.common.core.parse_int.call(null,nicheware.platform.utilities.common.core.before.call(null,version,"."));
});
/**
 * Returns the major minor version string, removing any revision number (if present)
 * 
 *   eg:
 * ```clojure
 * (major-minor-version "2.3.1") => "2.3"
 * (major-minor-version "1.1") => "1.1"
 * ```
 */
nicheware.platform.utilities.common.state.migration.major_minor_version = (function nicheware$platform$utilities$common$state$migration$major_minor_version(version){
if((cljs.core.count.call(null,clojure.string.split.call(null,version,/\./)) < (3))){
return version;
} else {
return nicheware.platform.utilities.common.core.before_last.call(null,version,".");
}
});
/**
 * Extracts the minor version as an int from a version string of the form 'x.x.x'
 * 
 *   - version: version number string of the form 'x.x.x' or 'x.x'
 *   - returns: The minor version (second x) as an int. nil if not a valid version number.
 */
nicheware.platform.utilities.common.state.migration.minor_version = (function nicheware$platform$utilities$common$state$migration$minor_version(version){
return nicheware.platform.utilities.common.core.parse_int.call(null,nicheware.platform.utilities.common.core.after.call(null,nicheware.platform.utilities.common.state.migration.major_minor_version.call(null,version),"."));
});
/**
 * Test whether the first version is lower or equal to the second version. Just considers the major and minor versions,
 * i.e. it is possible to upgrade.
 * 
 * The revision number (last digit) is not considered, as it is deemed not necessary to upgrade for revision changes only.
 * 
 * - first: Version number of form'x.x.x'
 * - second: Version number of form'x.x.x'
 * - returns: True if possible to upgrade from first to second (i.e. first is less than or equal to second)
 */
nicheware.platform.utilities.common.state.migration.could_upgrade_version = (function nicheware$platform$utilities$common$state$migration$could_upgrade_version(first,second){
var first_major = nicheware.platform.utilities.common.state.migration.major_version.call(null,first);
var first_minor = nicheware.platform.utilities.common.state.migration.minor_version.call(null,first);
var second_major = nicheware.platform.utilities.common.state.migration.major_version.call(null,second);
var second_minor = nicheware.platform.utilities.common.state.migration.minor_version.call(null,second);
return ((first_major < second_major)) || ((cljs.core._EQ_.call(null,first_major,second_major)) && ((first_minor <= second_minor)));
});
/**
 * Migrate state from its existing version to the goal version using the
 *   supplied migration functions.
 * 
 *   - incoming-state: Current state including the version number. ```{:version "1.2", ...}```
 *   - target-version: New version state should migrate to. eg ```"1.3.1"```
 *   - migrations: Map defining migrations for different source and target versions. See below.
 *   - returns: a new state map, upgraded to the target-version.
 * 
 * migrations:
 * 
 * ```clojure
 * {<source-migration-version> {:from-version :to-version :migration-fns[]]}}
 * ```
 * 
 *   ```:migration-fns``` is a vector of functions that when applied in order will accept a state map conforming to the ```:from-version``` state
 *   schema, and will return a new state map conforming to the ```:to-version``` schema.
 * 
 *   migrate-state will work out which migrations need to be applied to convert the state to the eventual target version.
 */
nicheware.platform.utilities.common.state.migration.migrate_state = (function nicheware$platform$utilities$common$state$migration$migrate_state(p__8711,target_version,migrations){
var map__8716 = p__8711;
var map__8716__$1 = ((((!((map__8716 == null)))?((((map__8716.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8716.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8716):map__8716);
var incoming_state = map__8716__$1;
var version = cljs.core.get.call(null,map__8716__$1,new cljs.core.Keyword(null,"version","version",425292698));
var current = version;
var state = incoming_state;
while(true){
var temp__5276__auto__ = cljs.core.get.call(null,migrations,nicheware.platform.utilities.common.state.migration.major_minor_version.call(null,current));
if(cljs.core.truth_(temp__5276__auto__)){
var migration = temp__5276__auto__;
var map__8718 = migration;
var map__8718__$1 = ((((!((map__8718 == null)))?((((map__8718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8718.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8718):map__8718);
var to_version = cljs.core.get.call(null,map__8718__$1,new cljs.core.Keyword(null,"to-version","to-version",1623856910));
var migration_fns = cljs.core.get.call(null,map__8718__$1,new cljs.core.Keyword(null,"migration-fns","migration-fns",-1902018682));
if(cljs.core.truth_(nicheware.platform.utilities.common.state.migration.could_upgrade_version.call(null,to_version,target_version))){
var G__8720 = to_version;
var G__8721 = cljs.core.assoc.call(null,nicheware.platform.utilities.common.core.compose_fns.call(null,migration_fns).call(null,state),new cljs.core.Keyword(null,"version","version",425292698),to_version);
current = G__8720;
state = G__8721;
continue;
} else {
return state;
}
} else {
return state;
}
break;
}
});

//# sourceMappingURL=migration.js.map