// Compiled by ClojureScript 1.9.562 {}
goog.provide('plumbing.fnk.schema');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('schema.utils');
plumbing.fnk.schema.Schema = cljs.core.with_meta.call(null,schema.core.__GT_Protocol.call(null,schema.core.Schema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("s","Schema","s/Schema",-1305723789,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__14442__14443__auto__){
if(!((p1__14442__14443__auto__ == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__14442__14443__auto__.schema$core$Schema$))){
return true;
} else {
if((!p1__14442__14443__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__14442__14443__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__14442__14443__auto__);
}
})], null));
plumbing.fnk.schema.InputSchema = cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.cond_pre.call(null,schema.core.eq.call(null,schema.core.Keyword),schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema]);
plumbing.fnk.schema.OutputSchema = plumbing.fnk.schema.Schema;
plumbing.fnk.schema.IOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.OutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
plumbing.fnk.schema.GraphInputSchema = cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.cond_pre.call(null,schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema]);
plumbing.fnk.schema.MapOutputSchema = cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.Keyword,plumbing.fnk.schema.Schema]);
plumbing.fnk.schema.GraphIOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphInputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
/**
 * Like (assert (distinct? things)) but with a more helpful error message.
 */
plumbing.fnk.schema.assert_distinct = (function plumbing$fnk$schema$assert_distinct(things){
var repeated_things = cljs.core.seq.call(null,cljs.core.filter.call(null,(function (p1__16099_SHARP_){
return (cljs.core.val.call(null,p1__16099_SHARP_) > (1));
}),cljs.core.frequencies.call(null,things)));
if(cljs.core.empty_QMARK_.call(null,repeated_things)){
return null;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Got repeated items (expected distinct): %s",repeated_things)));
}
});
/**
 * Like (get m k), but throws if k is not present in m.
 */
plumbing.fnk.schema.safe_get = (function plumbing$fnk$schema$safe_get(m,k,key_path){
if(cljs.core.map_QMARK_.call(null,m)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Expected a map at key-path %s, got type %s",key_path,schema.utils.type_of.call(null,m))));
}

var vec__16103 = cljs.core.find.call(null,m,k);
var _ = cljs.core.nth.call(null,vec__16103,(0),null);
var v = cljs.core.nth.call(null,vec__16103,(1),null);
var p = vec__16103;
if(cljs.core.truth_(p)){
} else {
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.keys.call(null,m)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"missing-key","missing-key",1259209562),new cljs.core.Keyword(null,"key","key",-1516042587),k,new cljs.core.Keyword(null,"map","map",1371690461),m], null));
}

return v;
});
plumbing.fnk.schema.non_map_union = (function plumbing$fnk$schema$non_map_union(s1,s2){
if(cljs.core._EQ_.call(null,s1,s2)){
return s1;
} else {
if(cljs.core._EQ_.call(null,s1,schema.core.Any)){
return s2;
} else {
if(cljs.core._EQ_.call(null,s2,schema.core.Any)){
return s1;
} else {
return s1;

}
}
}
});
/**
 * Return a difference of schmas s1 and s2, where one is not a map.
 * Punt for now, assuming s2 always satisfies s1.
 */
plumbing.fnk.schema.non_map_diff = (function plumbing$fnk$schema$non_map_diff(s1,s2){
return null;
});
plumbing.fnk.schema.map_schema_QMARK_ = (function plumbing$fnk$schema$map_schema_QMARK_(m){
return ((m instanceof cljs.core.PersistentArrayMap)) || ((m instanceof cljs.core.PersistentHashMap));
});
var ufv___16111 = schema.utils.use_fn_validation;
var output_schema16106_16112 = schema.core.maybe.call(null,schema.core.pair.call(null,schema.core.Keyword,"k",schema.core.Bool,"optional?"));
var input_schema16107_16113 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker16108_16114 = schema.core.checker.call(null,input_schema16107_16113);
var output_checker16109_16115 = schema.core.checker.call(null,output_schema16106_16112);
/**
 * Inputs: [k]
 *   Returns: (s/maybe (s/pair s/Keyword "k" s/Bool "optional?"))
 * 
 *   Given a possibly-unevaluated schema map key form, unpack an explicit keyword
 * and optional? flag, or return nil for a non-explicit key
 */
plumbing.fnk.schema.unwrap_schema_form_key = ((function (ufv___16111,output_schema16106_16112,input_schema16107_16113,input_checker16108_16114,output_checker16109_16115){
return (function plumbing$fnk$schema$unwrap_schema_form_key(G__16110){
var validate__13656__auto__ = ufv___16111.get_cell();
if(cljs.core.truth_(validate__13656__auto__)){
var args__13657__auto___16116 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__16110], null);
var temp__5278__auto___16117 = input_checker16108_16114.call(null,args__13657__auto___16116);
if(cljs.core.truth_(temp__5278__auto___16117)){
var error__13658__auto___16118 = temp__5278__auto___16117;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),cljs.core.list(new cljs.core.Symbol("s","pair","s/pair",1193014306,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),"k",new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),"optional?")),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated schema map key form, unpack an explicit keyword\n   and optional? flag, or return nil for a non-explicit key"], null)),cljs.core.pr_str.call(null,error__13658__auto___16118)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema16107_16113,new cljs.core.Keyword(null,"value","value",305978217),args__13657__auto___16116,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16118], null));
} else {
}
} else {
}

var o__13659__auto__ = (function (){var k = G__16110;
while(true){
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explicit_schema_key.call(null,k),schema.core.required_key_QMARK_.call(null,k)], null);
} else {
if((cljs.core.sequential_QMARK_.call(null,k)) && (!(cljs.core.vector_QMARK_.call(null,k))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,k),(2))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,k),new cljs.core.Symbol("schema.core","optional-key","schema.core/optional-key",-170069547,null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,k),false], null);
} else {
if((cljs.core.sequential_QMARK_.call(null,k)) && (!(cljs.core.vector_QMARK_.call(null,k))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,k),new cljs.core.Symbol("cljs.core","with-meta","cljs.core/with-meta",749126446,null)))){
return plumbing.fnk.schema.unwrap_schema_form_key.call(null,cljs.core.second.call(null,k));
} else {
return null;
}
}
}
break;
}
})();
if(cljs.core.truth_(validate__13656__auto__)){
var temp__5278__auto___16119 = output_checker16109_16115.call(null,o__13659__auto__);
if(cljs.core.truth_(temp__5278__auto___16119)){
var error__13658__auto___16120 = temp__5278__auto___16119;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),cljs.core.list(new cljs.core.Symbol("s","pair","s/pair",1193014306,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),"k",new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),"optional?")),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated schema map key form, unpack an explicit keyword\n   and optional? flag, or return nil for a non-explicit key"], null)),cljs.core.pr_str.call(null,error__13658__auto___16120)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema16106_16112,new cljs.core.Keyword(null,"value","value",305978217),o__13659__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16120], null));
} else {
}
} else {
}

return o__13659__auto__;
});})(ufv___16111,output_schema16106_16112,input_schema16107_16113,input_checker16108_16114,output_checker16109_16115))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.unwrap_schema_form_key),schema.core.make_fn_schema.call(null,output_schema16106_16112,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema16107_16113], null)));
var ufv___16126 = schema.utils.use_fn_validation;
var output_schema16121_16127 = cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.Keyword,schema.core.Bool]);
var input_schema16122_16128 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker16123_16129 = schema.core.checker.call(null,input_schema16122_16128);
var output_checker16124_16130 = schema.core.checker.call(null,output_schema16121_16127);
/**
 * Inputs: [s]
 *   Returns: #:s{Keyword s/Bool}
 * 
 *   Given a possibly-unevaluated map schema, return a map from bare keyword to true
 * (for required) or false (for optional)
 */
plumbing.fnk.schema.explicit_schema_key_map = ((function (ufv___16126,output_schema16121_16127,input_schema16122_16128,input_checker16123_16129,output_checker16124_16130){
return (function plumbing$fnk$schema$explicit_schema_key_map(G__16125){
var validate__13656__auto__ = ufv___16126.get_cell();
if(cljs.core.truth_(validate__13656__auto__)){
var args__13657__auto___16131 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__16125], null);
var temp__5278__auto___16132 = input_checker16123_16129.call(null,args__13657__auto___16131);
if(cljs.core.truth_(temp__5278__auto___16132)){
var error__13658__auto___16133 = temp__5278__auto___16132;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated map schema, return a map from bare keyword to true\n   (for required) or false (for optional)"], null)),cljs.core.pr_str.call(null,error__13658__auto___16133)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema16122_16128,new cljs.core.Keyword(null,"value","value",305978217),args__13657__auto___16131,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16133], null));
} else {
}
} else {
}

var o__13659__auto__ = (function (){var s = G__16125;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,plumbing.fnk.schema.unwrap_schema_form_key,cljs.core.keys.call(null,s)));
break;
}
})();
if(cljs.core.truth_(validate__13656__auto__)){
var temp__5278__auto___16134 = output_checker16124_16130.call(null,o__13659__auto__);
if(cljs.core.truth_(temp__5278__auto___16134)){
var error__13658__auto___16135 = temp__5278__auto___16134;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated map schema, return a map from bare keyword to true\n   (for required) or false (for optional)"], null)),cljs.core.pr_str.call(null,error__13658__auto___16135)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema16121_16127,new cljs.core.Keyword(null,"value","value",305978217),o__13659__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16135], null));
} else {
}
} else {
}

return o__13659__auto__;
});})(ufv___16126,output_schema16121_16127,input_schema16122_16128,input_checker16123_16129,output_checker16124_16130))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.explicit_schema_key_map),schema.core.make_fn_schema.call(null,output_schema16121_16127,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema16122_16128], null)));
var ufv___16141 = schema.utils.use_fn_validation;
var output_schema16136_16142 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"required","required",-846788763,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"optional","optional",-600484260,null))], null);
var input_schema16137_16143 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.Keyword,schema.core.Bool]),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null)], null)))], null);
var input_checker16138_16144 = schema.core.checker.call(null,input_schema16137_16143);
var output_checker16139_16145 = schema.core.checker.call(null,output_schema16136_16142);
/**
 * Inputs: [s :- #:s{Keyword s/Bool}]
 *   Returns: [(s/one [s/Keyword] (quote required)) (s/one [s/Keyword] (quote optional))]
 * 
 *   Given output of explicit-schema-key-map, split into seq [req opt].
 */
plumbing.fnk.schema.split_schema_keys = ((function (ufv___16141,output_schema16136_16142,input_schema16137_16143,input_checker16138_16144,output_checker16139_16145){
return (function plumbing$fnk$schema$split_schema_keys(G__16140){
var validate__13656__auto__ = ufv___16141.get_cell();
if(cljs.core.truth_(validate__13656__auto__)){
var args__13657__auto___16146 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__16140], null);
var temp__5278__auto___16147 = input_checker16138_16144.call(null,args__13657__auto___16146);
if(cljs.core.truth_(temp__5278__auto___16147)){
var error__13658__auto___16148 = temp__5278__auto___16147;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"required","required",-846788763,null))),cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"optional","optional",-600484260,null)))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given output of explicit-schema-key-map, split into seq [req opt]."], null)),cljs.core.pr_str.call(null,error__13658__auto___16148)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema16137_16143,new cljs.core.Keyword(null,"value","value",305978217),args__13657__auto___16146,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16148], null));
} else {
}
} else {
}

var o__13659__auto__ = (function (){var s = G__16140;
while(true){
return cljs.core.mapv.call(null,cljs.core.partial.call(null,cljs.core.mapv,cljs.core.key),cljs.core.juxt.call(null,cljs.core.filter,cljs.core.remove).call(null,cljs.core.val,s));
break;
}
})();
if(cljs.core.truth_(validate__13656__auto__)){
var temp__5278__auto___16149 = output_checker16139_16145.call(null,o__13659__auto__);
if(cljs.core.truth_(temp__5278__auto___16149)){
var error__13658__auto___16150 = temp__5278__auto___16149;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"required","required",-846788763,null))),cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"optional","optional",-600484260,null)))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given output of explicit-schema-key-map, split into seq [req opt]."], null)),cljs.core.pr_str.call(null,error__13658__auto___16150)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema16136_16142,new cljs.core.Keyword(null,"value","value",305978217),o__13659__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16150], null));
} else {
}
} else {
}

return o__13659__auto__;
});})(ufv___16141,output_schema16136_16142,input_schema16137_16143,input_checker16138_16144,output_checker16139_16145))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema_keys),schema.core.make_fn_schema.call(null,output_schema16136_16142,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema16137_16143], null)));
/**
 * Like merge-with, but also projects keys to a smaller space and merges them similar to the
 * values.
 */
plumbing.fnk.schema.merge_on_with = (function plumbing$fnk$schema$merge_on_with(var_args){
var args__8635__auto__ = [];
var len__8628__auto___16162 = arguments.length;
var i__8629__auto___16163 = (0);
while(true){
if((i__8629__auto___16163 < len__8628__auto___16162)){
args__8635__auto__.push((arguments[i__8629__auto___16163]));

var G__16164 = (i__8629__auto___16163 + (1));
i__8629__auto___16163 = G__16164;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((3) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((3)),(0),null)):null);
return plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8636__auto__);
});

plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic = (function (key_project,key_combine,val_combine,maps){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (m,p__16155){
var vec__16156 = p__16155;
var k = cljs.core.nth.call(null,vec__16156,(0),null);
var v = cljs.core.nth.call(null,vec__16156,(1),null);
var pk = key_project.call(null,k);
var temp__5276__auto__ = cljs.core.get.call(null,m,pk);
if(cljs.core.truth_(temp__5276__auto__)){
var vec__16159 = temp__5276__auto__;
var ok = cljs.core.nth.call(null,vec__16159,(0),null);
var ov = cljs.core.nth.call(null,vec__16159,(1),null);
return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_combine.call(null,ok,k),val_combine.call(null,ov,v)], null));
} else {
return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
}
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.apply.call(null,cljs.core.concat,maps))));
});

plumbing.fnk.schema.merge_on_with.cljs$lang$maxFixedArity = (3);

plumbing.fnk.schema.merge_on_with.cljs$lang$applyTo = (function (seq16151){
var G__16152 = cljs.core.first.call(null,seq16151);
var seq16151__$1 = cljs.core.next.call(null,seq16151);
var G__16153 = cljs.core.first.call(null,seq16151__$1);
var seq16151__$2 = cljs.core.next.call(null,seq16151__$1);
var G__16154 = cljs.core.first.call(null,seq16151__$2);
var seq16151__$3 = cljs.core.next.call(null,seq16151__$2);
return plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic(G__16152,G__16153,G__16154,seq16151__$3);
});

var ufv___16172 = schema.utils.use_fn_validation;
var output_schema16166_16173 = plumbing.fnk.schema.InputSchema;
var input_schema16167_16174 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"i1","i1",-572470430,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null))),schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"i2","i2",850408895,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null)))], null);
var input_checker16168_16175 = schema.core.checker.call(null,input_schema16167_16174);
var output_checker16169_16176 = schema.core.checker.call(null,output_schema16166_16173);
/**
 * Inputs: [i1 :- InputSchema i2 :- InputSchema]
 *   Returns: InputSchema
 * 
 *   Returns a minimal input schema schema that entails satisfaction of both s1 and s2
 */
plumbing.fnk.schema.union_input_schemata = ((function (ufv___16172,output_schema16166_16173,input_schema16167_16174,input_checker16168_16175,output_checker16169_16176){
return (function plumbing$fnk$schema$union_input_schemata(G__16170,G__16171){
var validate__13656__auto__ = ufv___16172.get_cell();
if(cljs.core.truth_(validate__13656__auto__)){
var args__13657__auto___16177 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__16170,G__16171], null);
var temp__5278__auto___16178 = input_checker16168_16175.call(null,args__13657__auto___16177);
if(cljs.core.truth_(temp__5278__auto___16178)){
var error__13658__auto___16179 = temp__5278__auto___16178;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a minimal input schema schema that entails satisfaction of both s1 and s2"], null)),cljs.core.pr_str.call(null,error__13658__auto___16179)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema16167_16174,new cljs.core.Keyword(null,"value","value",305978217),args__13657__auto___16177,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16179], null));
} else {
}
} else {
}

var o__13659__auto__ = (function (){var i1 = G__16170;
var i2 = G__16171;
while(true){
return plumbing.fnk.schema.merge_on_with.call(null,((function (validate__13656__auto__,ufv___16172,output_schema16166_16173,input_schema16167_16174,input_checker16168_16175,output_checker16169_16176){
return (function (p1__16165_SHARP_){
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,p1__16165_SHARP_))){
return schema.core.explicit_schema_key.call(null,p1__16165_SHARP_);
} else {
return new cljs.core.Keyword(null,"extra","extra",1612569067);
}
});})(validate__13656__auto__,ufv___16172,output_schema16166_16173,input_schema16167_16174,input_checker16168_16175,output_checker16169_16176))
,((function (validate__13656__auto__,ufv___16172,output_schema16166_16173,input_schema16167_16174,input_checker16168_16175,output_checker16169_16176){
return (function (k1,k2){
if(cljs.core.truth_(schema.core.required_key_QMARK_.call(null,k1))){
return k1;
} else {
if(cljs.core.truth_(schema.core.required_key_QMARK_.call(null,k2))){
return k2;
} else {
if(cljs.core.truth_(schema.core.optional_key_QMARK_.call(null,k1))){
if(cljs.core._EQ_.call(null,k1,k2)){
} else {
throw (new Error("Assert failed: (= k1 k2)"));
}

return k1;
} else {
if(cljs.core._EQ_.call(null,k1,k2)){
return k1;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Only one extra schema allowed")));


}
}
}
}
});})(validate__13656__auto__,ufv___16172,output_schema16166_16173,input_schema16167_16174,input_checker16168_16175,output_checker16169_16176))
,((function (validate__13656__auto__,ufv___16172,output_schema16166_16173,input_schema16167_16174,input_checker16168_16175,output_checker16169_16176){
return (function (s1,s2){
if(cljs.core.truth_((function (){var and__7395__auto__ = plumbing.fnk.schema.map_schema_QMARK_.call(null,s1);
if(cljs.core.truth_(and__7395__auto__)){
return plumbing.fnk.schema.map_schema_QMARK_.call(null,s2);
} else {
return and__7395__auto__;
}
})())){
return plumbing.fnk.schema.union_input_schemata.call(null,s1,s2);
} else {
return plumbing.fnk.schema.non_map_union.call(null,s1,s2);
}
});})(validate__13656__auto__,ufv___16172,output_schema16166_16173,input_schema16167_16174,input_checker16168_16175,output_checker16169_16176))
,i1,i2);
break;
}
})();
if(cljs.core.truth_(validate__13656__auto__)){
var temp__5278__auto___16180 = output_checker16169_16176.call(null,o__13659__auto__);
if(cljs.core.truth_(temp__5278__auto___16180)){
var error__13658__auto___16181 = temp__5278__auto___16180;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a minimal input schema schema that entails satisfaction of both s1 and s2"], null)),cljs.core.pr_str.call(null,error__13658__auto___16181)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema16166_16173,new cljs.core.Keyword(null,"value","value",305978217),o__13659__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16181], null));
} else {
}
} else {
}

return o__13659__auto__;
});})(ufv___16172,output_schema16166_16173,input_schema16167_16174,input_checker16168_16175,output_checker16169_16176))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.union_input_schemata),schema.core.make_fn_schema.call(null,output_schema16166_16173,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema16167_16174], null)));
var ufv___16187 = schema.utils.use_fn_validation;
var output_schema16182_16188 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);
var input_schema16183_16189 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"input-schema","input-schema",1373647181,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null)))], null);
var input_checker16184_16190 = schema.core.checker.call(null,input_schema16183_16189);
var output_checker16185_16191 = schema.core.checker.call(null,output_schema16182_16188);
/**
 * Inputs: [input-schema :- InputSchema]
 *   Returns: [s/Keyword]
 * 
 *   Which top-level keys are required (i.e., non-false) by this input schema.
 */
plumbing.fnk.schema.required_toplevel_keys = ((function (ufv___16187,output_schema16182_16188,input_schema16183_16189,input_checker16184_16190,output_checker16185_16191){
return (function plumbing$fnk$schema$required_toplevel_keys(G__16186){
var validate__13656__auto__ = ufv___16187.get_cell();
if(cljs.core.truth_(validate__13656__auto__)){
var args__13657__auto___16192 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__16186], null);
var temp__5278__auto___16193 = input_checker16184_16190.call(null,args__13657__auto___16192);
if(cljs.core.truth_(temp__5278__auto___16193)){
var error__13658__auto___16194 = temp__5278__auto___16193;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Which top-level keys are required (i.e., non-false) by this input schema."], null)),cljs.core.pr_str.call(null,error__13658__auto___16194)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema16183_16189,new cljs.core.Keyword(null,"value","value",305978217),args__13657__auto___16192,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16194], null));
} else {
}
} else {
}

var o__13659__auto__ = (function (){var input_schema = G__16186;
while(true){
return cljs.core.keep.call(null,((function (validate__13656__auto__,ufv___16187,output_schema16182_16188,input_schema16183_16189,input_checker16184_16190,output_checker16185_16191){
return (function (k){
if(cljs.core.truth_(schema.core.required_key_QMARK_.call(null,k))){
return schema.core.explicit_schema_key.call(null,k);
} else {
return null;
}
});})(validate__13656__auto__,ufv___16187,output_schema16182_16188,input_schema16183_16189,input_checker16184_16190,output_checker16185_16191))
,cljs.core.keys.call(null,input_schema));
break;
}
})();
if(cljs.core.truth_(validate__13656__auto__)){
var temp__5278__auto___16195 = output_checker16185_16191.call(null,o__13659__auto__);
if(cljs.core.truth_(temp__5278__auto___16195)){
var error__13658__auto___16196 = temp__5278__auto___16195;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Which top-level keys are required (i.e., non-false) by this input schema."], null)),cljs.core.pr_str.call(null,error__13658__auto___16196)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema16182_16188,new cljs.core.Keyword(null,"value","value",305978217),o__13659__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16196], null));
} else {
}
} else {
}

return o__13659__auto__;
});})(ufv___16187,output_schema16182_16188,input_schema16183_16189,input_checker16184_16190,output_checker16185_16191))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.required_toplevel_keys),schema.core.make_fn_schema.call(null,output_schema16182_16188,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema16183_16189], null)));
/**
 * Guess an output schema for an expr.  Currently just looks for literal map structure and
 * all keyword keys.
 */
plumbing.fnk.schema.guess_expr_output_schema = (function plumbing$fnk$schema$guess_expr_output_schema(expr){
if((cljs.core.map_QMARK_.call(null,expr)) && (cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,cljs.core.keys.call(null,expr)))){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__8269__auto__ = (function plumbing$fnk$schema$guess_expr_output_schema_$_iter__16213(s__16214){
return (new cljs.core.LazySeq(null,(function (){
var s__16214__$1 = s__16214;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__16214__$1);
if(temp__5278__auto__){
var s__16214__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16214__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__16214__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__16216 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__16215 = (0);
while(true){
if((i__16215 < size__8268__auto__)){
var vec__16223 = cljs.core._nth.call(null,c__8267__auto__,i__16215);
var k = cljs.core.nth.call(null,vec__16223,(0),null);
var v = cljs.core.nth.call(null,vec__16223,(1),null);
cljs.core.chunk_append.call(null,b__16216,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,plumbing.fnk.schema.guess_expr_output_schema.call(null,v)], null));

var G__16229 = (i__16215 + (1));
i__16215 = G__16229;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16216),plumbing$fnk$schema$guess_expr_output_schema_$_iter__16213.call(null,cljs.core.chunk_rest.call(null,s__16214__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16216),null);
}
} else {
var vec__16226 = cljs.core.first.call(null,s__16214__$2);
var k = cljs.core.nth.call(null,vec__16226,(0),null);
var v = cljs.core.nth.call(null,vec__16226,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,plumbing.fnk.schema.guess_expr_output_schema.call(null,v)], null),plumbing$fnk$schema$guess_expr_output_schema_$_iter__16213.call(null,cljs.core.rest.call(null,s__16214__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,expr);
})());
} else {
return new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null);
}
});
/**
 * Subtract output-schema from input-schema, returning nil if it's possible that an object
 * satisfying the output-schema satisfies the input-schema, or otherwise a description
 * of the part(s) of input-schema not met by output-schema.  Strict about the map structure
 * of output-schema matching input-schema, but loose about everything else (only looks at
 * required keys of output-schema.
 */
plumbing.fnk.schema.schema_diff = (function plumbing$fnk$schema$schema_diff(input_schema,output_schema){
if(cljs.core.not.call(null,plumbing.fnk.schema.map_schema_QMARK_.call(null,input_schema))){
return plumbing.fnk.schema.non_map_diff.call(null,input_schema,output_schema);
} else {
if(cljs.core.not.call(null,plumbing.fnk.schema.map_schema_QMARK_.call(null,output_schema))){
return schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,input_schema,output_schema,(new cljs.core.Delay((function (){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = schema.core.explain.call(null,output_schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"map?","map?",-1780568534,null));
}),null)),null));
} else {
return cljs.core.not_empty.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__8269__auto__ = (function plumbing$fnk$schema$schema_diff_$_iter__16246(s__16247){
return (new cljs.core.LazySeq(null,(function (){
var s__16247__$1 = s__16247;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__16247__$1);
if(temp__5278__auto__){
var s__16247__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16247__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__16247__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__16249 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__16248 = (0);
while(true){
if((i__16248 < size__8268__auto__)){
var vec__16256 = cljs.core._nth.call(null,c__8267__auto__,i__16248);
var k = cljs.core.nth.call(null,vec__16256,(0),null);
var v = cljs.core.nth.call(null,vec__16256,(1),null);
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,k))){
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
var raw_k = schema.core.explicit_schema_key.call(null,k);
var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);
if(cljs.core.truth_((function (){var or__7407__auto__ = required_QMARK_;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return present_QMARK_;
}
})())){
var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):plumbing.fnk.schema.schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));
if(cljs.core.truth_(fail)){
cljs.core.chunk_append.call(null,b__16249,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null));

var G__16262 = (i__16248 + (1));
i__16248 = G__16262;
continue;
} else {
var G__16263 = (i__16248 + (1));
i__16248 = G__16263;
continue;
}
} else {
var G__16264 = (i__16248 + (1));
i__16248 = G__16264;
continue;
}
} else {
var G__16265 = (i__16248 + (1));
i__16248 = G__16265;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16249),plumbing$fnk$schema$schema_diff_$_iter__16246.call(null,cljs.core.chunk_rest.call(null,s__16247__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16249),null);
}
} else {
var vec__16259 = cljs.core.first.call(null,s__16247__$2);
var k = cljs.core.nth.call(null,vec__16259,(0),null);
var v = cljs.core.nth.call(null,vec__16259,(1),null);
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,k))){
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
var raw_k = schema.core.explicit_schema_key.call(null,k);
var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);
if(cljs.core.truth_((function (){var or__7407__auto__ = required_QMARK_;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return present_QMARK_;
}
})())){
var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):plumbing.fnk.schema.schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));
if(cljs.core.truth_(fail)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null),plumbing$fnk$schema$schema_diff_$_iter__16246.call(null,cljs.core.rest.call(null,s__16247__$2)));
} else {
var G__16266 = cljs.core.rest.call(null,s__16247__$2);
s__16247__$1 = G__16266;
continue;
}
} else {
var G__16267 = cljs.core.rest.call(null,s__16247__$2);
s__16247__$1 = G__16267;
continue;
}
} else {
var G__16268 = cljs.core.rest.call(null,s__16247__$2);
s__16247__$1 = G__16268;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,input_schema);
})()));

}
}
});
plumbing.fnk.schema.assert_satisfies_schema = (function plumbing$fnk$schema$assert_satisfies_schema(input_schema,output_schema){
var fails = plumbing.fnk.schema.schema_diff.call(null,input_schema,output_schema);
if(cljs.core.truth_(fails)){
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(fails)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"does-not-satisfy-schema","does-not-satisfy-schema",-1543152824),new cljs.core.Keyword(null,"failures","failures",-912916356),fails], null));
} else {
return null;
}
});
var ufv___16315 = schema.utils.use_fn_validation;
var output_schema16269_16316 = schema.core.Any;
var input_schema16270_16317 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);
var input_checker16271_16318 = schema.core.checker.call(null,input_schema16270_16317);
var output_checker16272_16319 = schema.core.checker.call(null,output_schema16269_16316);
/**
 * Inputs: [[i2 o2] :- IOSchemata [i1 o1] :- [(s/one InputSchema (quote input)) (s/one MapOutputSchema (quote output))]]
 * 
 *   Given pairs of input and output schemata for fnks f1 and f2,
 * return a pair of input and output schemata for #(f2 (merge % (f1 %))).
 * f1's output schema must not contain any optional keys.
 */
plumbing.fnk.schema.compose_schemata = ((function (ufv___16315,output_schema16269_16316,input_schema16270_16317,input_checker16271_16318,output_checker16272_16319){
return (function plumbing$fnk$schema$compose_schemata(G__16273,G__16274){
var validate__13656__auto__ = true;
if(validate__13656__auto__){
var args__13657__auto___16320 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__16273,G__16274], null);
var temp__5278__auto___16321 = input_checker16271_16318.call(null,args__13657__auto___16320);
if(cljs.core.truth_(temp__5278__auto___16321)){
var error__13658__auto___16322 = temp__5278__auto___16321;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2,\n   return a pair of input and output schemata for #(f2 (merge % (f1 %))).\n   f1's output schema must not contain any optional keys."], null)),cljs.core.pr_str.call(null,error__13658__auto___16322)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema16270_16317,new cljs.core.Keyword(null,"value","value",305978217),args__13657__auto___16320,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16322], null));
} else {
}
} else {
}

var o__13659__auto__ = (function (){var G__16301 = G__16273;
var vec__16303 = G__16301;
var i2 = cljs.core.nth.call(null,vec__16303,(0),null);
var o2 = cljs.core.nth.call(null,vec__16303,(1),null);
var G__16302 = G__16274;
var vec__16306 = G__16302;
var i1 = cljs.core.nth.call(null,vec__16306,(0),null);
var o1 = cljs.core.nth.call(null,vec__16306,(1),null);
var G__16301__$1 = G__16301;
var G__16302__$1 = G__16302;
while(true){
var vec__16309 = G__16301__$1;
var i2__$1 = cljs.core.nth.call(null,vec__16309,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__16309,(1),null);
var vec__16312 = G__16302__$1;
var i1__$1 = cljs.core.nth.call(null,vec__16312,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__16312,(1),null);
plumbing.fnk.schema.assert_satisfies_schema.call(null,cljs.core.select_keys.call(null,i2__$1,cljs.core.keys.call(null,o1__$1)),o1__$1);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,cljs.core.apply.call(null,cljs.core.dissoc,i2__$1,cljs.core.concat.call(null,cljs.core.keys.call(null,o1__$1),cljs.core.map.call(null,schema.core.optional_key,cljs.core.keys.call(null,o1__$1)))),i1__$1),o2__$1], null);
break;
}
})();
if(validate__13656__auto__){
var temp__5278__auto___16323 = output_checker16272_16319.call(null,o__13659__auto__);
if(cljs.core.truth_(temp__5278__auto___16323)){
var error__13658__auto___16324 = temp__5278__auto___16323;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2,\n   return a pair of input and output schemata for #(f2 (merge % (f1 %))).\n   f1's output schema must not contain any optional keys."], null)),cljs.core.pr_str.call(null,error__13658__auto___16324)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema16269_16316,new cljs.core.Keyword(null,"value","value",305978217),o__13659__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16324], null));
} else {
}
} else {
}

return o__13659__auto__;
});})(ufv___16315,output_schema16269_16316,input_schema16270_16317,input_checker16271_16318,output_checker16272_16319))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.compose_schemata),schema.core.make_fn_schema.call(null,output_schema16269_16316,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema16270_16317], null)));
plumbing.fnk.schema.schema_key = (function plumbing$fnk$schema$schema_key(m,k){
if(cljs.core.contains_QMARK_.call(null,m,k)){
return k;
} else {
if(cljs.core.contains_QMARK_.call(null,m,schema.core.optional_key.call(null,k))){
return schema.core.optional_key.call(null,k);
} else {
return null;

}
}
});
plumbing.fnk.schema.possibly_contains_QMARK_ = (function plumbing$fnk$schema$possibly_contains_QMARK_(m,k){
return cljs.core.boolean$.call(null,plumbing.fnk.schema.schema_key.call(null,m,k));
});
var ufv___16467 = schema.utils.use_fn_validation;
var output_schema16325_16468 = schema.core.Any;
var input_schema16326_16469 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null))),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"ks","ks",-754231827,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker16327_16470 = schema.core.checker.call(null,input_schema16326_16469);
var output_checker16328_16471 = schema.core.checker.call(null,output_schema16325_16468);
/**
 * Inputs: [s :- InputSchema ks :- [s/Keyword]]
 * 
 *   Return a pair [ks-part non-ks-part], with any extra schema removed.
 */
plumbing.fnk.schema.split_schema = ((function (ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471){
return (function plumbing$fnk$schema$split_schema(G__16329,G__16330){
var validate__13656__auto__ = ufv___16467.get_cell();
if(cljs.core.truth_(validate__13656__auto__)){
var args__13657__auto___16472 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__16329,G__16330], null);
var temp__5278__auto___16473 = input_checker16327_16470.call(null,args__13657__auto___16472);
if(cljs.core.truth_(temp__5278__auto___16473)){
var error__13658__auto___16474 = temp__5278__auto___16473;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a pair [ks-part non-ks-part], with any extra schema removed."], null)),cljs.core.pr_str.call(null,error__13658__auto___16474)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema16326_16469,new cljs.core.Keyword(null,"value","value",305978217),args__13657__auto___16472,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16474], null));
} else {
}
} else {
}

var o__13659__auto__ = (function (){var s = G__16329;
var ks = G__16330;
while(true){
var ks__$1 = cljs.core.set.call(null,ks);
var iter__8269__auto__ = ((function (ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471){
return (function plumbing$fnk$schema$split_schema_$_iter__16399(s__16400){
return (new cljs.core.LazySeq(null,((function (ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471){
return (function (){
var s__16400__$1 = s__16400;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__16400__$1);
if(temp__5278__auto__){
var s__16400__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16400__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__16400__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__16402 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__16401 = (0);
while(true){
if((i__16401 < size__8268__auto__)){
var in_QMARK_ = cljs.core._nth.call(null,c__8267__auto__,i__16401);
cljs.core.chunk_append.call(null,b__16402,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__8269__auto__ = ((function (i__16401,in_QMARK_,c__8267__auto__,size__8268__auto__,b__16402,s__16400__$2,temp__5278__auto__,ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471){
return (function plumbing$fnk$schema$split_schema_$_iter__16399_$_iter__16435(s__16436){
return (new cljs.core.LazySeq(null,((function (i__16401,in_QMARK_,c__8267__auto__,size__8268__auto__,b__16402,s__16400__$2,temp__5278__auto__,ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471){
return (function (){
var s__16436__$1 = s__16436;
while(true){
var temp__5278__auto____$1 = cljs.core.seq.call(null,s__16436__$1);
if(temp__5278__auto____$1){
var s__16436__$2 = temp__5278__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16436__$2)){
var c__8267__auto____$1 = cljs.core.chunk_first.call(null,s__16436__$2);
var size__8268__auto____$1 = cljs.core.count.call(null,c__8267__auto____$1);
var b__16438 = cljs.core.chunk_buffer.call(null,size__8268__auto____$1);
if((function (){var i__16437 = (0);
while(true){
if((i__16437 < size__8268__auto____$1)){
var vec__16445 = cljs.core._nth.call(null,c__8267__auto____$1,i__16437);
var k = cljs.core.nth.call(null,vec__16445,(0),null);
var v = cljs.core.nth.call(null,vec__16445,(1),null);
if(cljs.core.truth_((function (){var and__7395__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__7395__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__7395__auto__;
}
})())){
cljs.core.chunk_append.call(null,b__16438,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__16475 = (i__16437 + (1));
i__16437 = G__16475;
continue;
} else {
var G__16476 = (i__16437 + (1));
i__16437 = G__16476;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16438),plumbing$fnk$schema$split_schema_$_iter__16399_$_iter__16435.call(null,cljs.core.chunk_rest.call(null,s__16436__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16438),null);
}
} else {
var vec__16448 = cljs.core.first.call(null,s__16436__$2);
var k = cljs.core.nth.call(null,vec__16448,(0),null);
var v = cljs.core.nth.call(null,vec__16448,(1),null);
if(cljs.core.truth_((function (){var and__7395__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__7395__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__7395__auto__;
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$fnk$schema$split_schema_$_iter__16399_$_iter__16435.call(null,cljs.core.rest.call(null,s__16436__$2)));
} else {
var G__16477 = cljs.core.rest.call(null,s__16436__$2);
s__16436__$1 = G__16477;
continue;
}
}
} else {
return null;
}
break;
}
});})(i__16401,in_QMARK_,c__8267__auto__,size__8268__auto__,b__16402,s__16400__$2,temp__5278__auto__,ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471))
,null,null));
});})(i__16401,in_QMARK_,c__8267__auto__,size__8268__auto__,b__16402,s__16400__$2,temp__5278__auto__,ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471))
;
return iter__8269__auto__.call(null,s);
})()));

var G__16478 = (i__16401 + (1));
i__16401 = G__16478;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16402),plumbing$fnk$schema$split_schema_$_iter__16399.call(null,cljs.core.chunk_rest.call(null,s__16400__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16402),null);
}
} else {
var in_QMARK_ = cljs.core.first.call(null,s__16400__$2);
return cljs.core.cons.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__8269__auto__ = ((function (in_QMARK_,s__16400__$2,temp__5278__auto__,ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471){
return (function plumbing$fnk$schema$split_schema_$_iter__16399_$_iter__16451(s__16452){
return (new cljs.core.LazySeq(null,((function (in_QMARK_,s__16400__$2,temp__5278__auto__,ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471){
return (function (){
var s__16452__$1 = s__16452;
while(true){
var temp__5278__auto____$1 = cljs.core.seq.call(null,s__16452__$1);
if(temp__5278__auto____$1){
var s__16452__$2 = temp__5278__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16452__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__16452__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__16454 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__16453 = (0);
while(true){
if((i__16453 < size__8268__auto__)){
var vec__16461 = cljs.core._nth.call(null,c__8267__auto__,i__16453);
var k = cljs.core.nth.call(null,vec__16461,(0),null);
var v = cljs.core.nth.call(null,vec__16461,(1),null);
if(cljs.core.truth_((function (){var and__7395__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__7395__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__7395__auto__;
}
})())){
cljs.core.chunk_append.call(null,b__16454,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__16479 = (i__16453 + (1));
i__16453 = G__16479;
continue;
} else {
var G__16480 = (i__16453 + (1));
i__16453 = G__16480;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16454),plumbing$fnk$schema$split_schema_$_iter__16399_$_iter__16451.call(null,cljs.core.chunk_rest.call(null,s__16452__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16454),null);
}
} else {
var vec__16464 = cljs.core.first.call(null,s__16452__$2);
var k = cljs.core.nth.call(null,vec__16464,(0),null);
var v = cljs.core.nth.call(null,vec__16464,(1),null);
if(cljs.core.truth_((function (){var and__7395__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__7395__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__7395__auto__;
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$fnk$schema$split_schema_$_iter__16399_$_iter__16451.call(null,cljs.core.rest.call(null,s__16452__$2)));
} else {
var G__16481 = cljs.core.rest.call(null,s__16452__$2);
s__16452__$1 = G__16481;
continue;
}
}
} else {
return null;
}
break;
}
});})(in_QMARK_,s__16400__$2,temp__5278__auto__,ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471))
,null,null));
});})(in_QMARK_,s__16400__$2,temp__5278__auto__,ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471))
;
return iter__8269__auto__.call(null,s);
})()),plumbing$fnk$schema$split_schema_$_iter__16399.call(null,cljs.core.rest.call(null,s__16400__$2)));
}
} else {
return null;
}
break;
}
});})(ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471))
,null,null));
});})(ks__$1,validate__13656__auto__,ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471))
;
return iter__8269__auto__.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,false], null));
break;
}
})();
if(cljs.core.truth_(validate__13656__auto__)){
var temp__5278__auto___16482 = output_checker16328_16471.call(null,o__13659__auto__);
if(cljs.core.truth_(temp__5278__auto___16482)){
var error__13658__auto___16483 = temp__5278__auto___16482;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a pair [ks-part non-ks-part], with any extra schema removed."], null)),cljs.core.pr_str.call(null,error__13658__auto___16483)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema16325_16468,new cljs.core.Keyword(null,"value","value",305978217),o__13659__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16483], null));
} else {
}
} else {
}

return o__13659__auto__;
});})(ufv___16467,output_schema16325_16468,input_schema16326_16469,input_checker16327_16470,output_checker16328_16471))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema),schema.core.make_fn_schema.call(null,output_schema16325_16468,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema16326_16469], null)));
var ufv___16554 = schema.utils.use_fn_validation;
var output_schema16484_16555 = plumbing.fnk.schema.GraphIOSchemata;
var input_schema16485_16556 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphIOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,"key"),schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,"inner-schemas")], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);
var input_checker16486_16557 = schema.core.checker.call(null,input_schema16485_16556);
var output_checker16487_16558 = schema.core.checker.call(null,output_schema16484_16555);
/**
 * Inputs: [[i1 o1] :- GraphIOSchemata [k [i2 o2]] :- [(s/one s/Keyword "key") (s/one IOSchemata "inner-schemas")]]
 *   Returns: GraphIOSchemata
 * 
 *   Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,
 * return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))
 */
plumbing.fnk.schema.sequence_schemata = ((function (ufv___16554,output_schema16484_16555,input_schema16485_16556,input_checker16486_16557,output_checker16487_16558){
return (function plumbing$fnk$schema$sequence_schemata(G__16488,G__16489){
var validate__13656__auto__ = ufv___16554.get_cell();
if(cljs.core.truth_(validate__13656__auto__)){
var args__13657__auto___16559 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__16488,G__16489], null);
var temp__5278__auto___16560 = input_checker16486_16557.call(null,args__13657__auto___16559);
if(cljs.core.truth_(temp__5278__auto___16560)){
var error__13658__auto___16561 = temp__5278__auto___16560;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"GraphIOSchemata","GraphIOSchemata",-2137701253,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,\n   return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))"], null)),cljs.core.pr_str.call(null,error__13658__auto___16561)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema16485_16556,new cljs.core.Keyword(null,"value","value",305978217),args__13657__auto___16559,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16561], null));
} else {
}
} else {
}

var o__13659__auto__ = (function (){var G__16531 = G__16488;
var vec__16533 = G__16531;
var i1 = cljs.core.nth.call(null,vec__16533,(0),null);
var o1 = cljs.core.nth.call(null,vec__16533,(1),null);
var G__16532 = G__16489;
var vec__16536 = G__16532;
var k = cljs.core.nth.call(null,vec__16536,(0),null);
var vec__16539 = cljs.core.nth.call(null,vec__16536,(1),null);
var i2 = cljs.core.nth.call(null,vec__16539,(0),null);
var o2 = cljs.core.nth.call(null,vec__16539,(1),null);
var G__16531__$1 = G__16531;
var G__16532__$1 = G__16532;
while(true){
var vec__16542 = G__16531__$1;
var i1__$1 = cljs.core.nth.call(null,vec__16542,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__16542,(1),null);
var vec__16545 = G__16532__$1;
var k__$1 = cljs.core.nth.call(null,vec__16545,(0),null);
var vec__16548 = cljs.core.nth.call(null,vec__16545,(1),null);
var i2__$1 = cljs.core.nth.call(null,vec__16548,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__16548,(1),null);
if(cljs.core.not.call(null,plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i1__$1,k__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Duplicate key output (possibly due to a misordered graph) %s for input %s from input %s",k__$1,schema.core.explain.call(null,i2__$1),schema.core.explain.call(null,i1__$1))));
}

if(cljs.core.not.call(null,plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i2__$1,k__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Node outputs a key %s in its inputs %s",k__$1,schema.core.explain.call(null,i2__$1))));
}

if(cljs.core.not.call(null,plumbing.fnk.schema.possibly_contains_QMARK_.call(null,o1__$1,k__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Node outputs a duplicate key %s given inputs %s",k__$1,schema.core.explain.call(null,i1__$1))));
}

var vec__16551 = plumbing.fnk.schema.split_schema.call(null,i2__$1,cljs.core.keys.call(null,o1__$1));
var used = cljs.core.nth.call(null,vec__16551,(0),null);
var unused = cljs.core.nth.call(null,vec__16551,(1),null);
plumbing.fnk.schema.assert_satisfies_schema.call(null,used,o1__$1);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,unused,i1__$1),cljs.core.assoc.call(null,o1__$1,k__$1,o2__$1)], null);
break;
}
})();
if(cljs.core.truth_(validate__13656__auto__)){
var temp__5278__auto___16562 = output_checker16487_16558.call(null,o__13659__auto__);
if(cljs.core.truth_(temp__5278__auto___16562)){
var error__13658__auto___16563 = temp__5278__auto___16562;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"GraphIOSchemata","GraphIOSchemata",-2137701253,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,\n   return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))"], null)),cljs.core.pr_str.call(null,error__13658__auto___16563)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema16484_16555,new cljs.core.Keyword(null,"value","value",305978217),o__13659__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13658__auto___16563], null));
} else {
}
} else {
}

return o__13659__auto__;
});})(ufv___16554,output_schema16484_16555,input_schema16485_16556,input_checker16486_16557,output_checker16487_16558))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.sequence_schemata),schema.core.make_fn_schema.call(null,output_schema16484_16555,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema16485_16556], null)));

//# sourceMappingURL=schema.js.map