// Compiled by ClojureScript 1.9.562 {}
goog.provide('schema.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('schema.utils');
goog.require('schema.spec.core');
goog.require('schema.spec.leaf');
goog.require('schema.spec.variant');
goog.require('schema.spec.collection');

/**
 * @interface
 */
schema.core.Schema = function(){};

/**
 * A spec is a record of some type that expresses the structure of this schema
 *   in a declarative and/or imperative way.  See schema.spec.* for examples.
 */
schema.core.spec = (function schema$core$spec(this$){
if((!((this$ == null))) && (!((this$.schema$core$Schema$spec$arity$1 == null)))){
return this$.schema$core$Schema$spec$arity$1(this$);
} else {
var x__8125__auto__ = (((this$ == null))?null:this$);
var m__8126__auto__ = (schema.core.spec[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,this$);
} else {
var m__8126__auto____$1 = (schema.core.spec["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Schema.spec",this$);
}
}
}
});

/**
 * Expand this schema to a human-readable format suitable for pprinting,
 *   also expanding class schematas at the leaves.  Example:
 * 
 *   user> (s/explain {:a s/Keyword :b [s/Int]} )
 *   {:a Keyword, :b [Int]}
 */
schema.core.explain = (function schema$core$explain(this$){
if((!((this$ == null))) && (!((this$.schema$core$Schema$explain$arity$1 == null)))){
return this$.schema$core$Schema$explain$arity$1(this$);
} else {
var x__8125__auto__ = (((this$ == null))?null:this$);
var m__8126__auto__ = (schema.core.explain[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,this$);
} else {
var m__8126__auto____$1 = (schema.core.explain["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Schema.explain",this$);
}
}
}
});

/**
 * Compile an efficient checker for schema, which returns nil for valid values and
 * error descriptions otherwise.
 */
schema.core.checker = (function schema$core$checker(schema__$1){
return cljs.core.comp.call(null,schema.utils.error_val,schema.spec.core.run_checker.call(null,(function (s,params){
return schema.spec.core.checker.call(null,schema.core.spec.call(null,s),params);
}),false,schema__$1));
});
/**
 * Return nil if x matches schema; otherwise, returns a value that looks like the
 * 'bad' parts of x with ValidationErrors at the leaves describing the failures.
 * 
 * If you will be checking many datums, it is much more efficient to create
 * a 'checker' once and call it on each of them.
 */
schema.core.check = (function schema$core$check(schema__$1,x){
return schema.core.checker.call(null,schema__$1).call(null,x);
});
/**
 * Compile an efficient validator for schema.
 */
schema.core.validator = (function schema$core$validator(schema__$1){
var c = schema.core.checker.call(null,schema__$1);
return ((function (c){
return (function (value){
var temp__5278__auto___15290 = c.call(null,value);
if(cljs.core.truth_(temp__5278__auto___15290)){
var error_15291 = temp__5278__auto___15290;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Value does not match schema: %s",cljs.core.pr_str.call(null,error_15291)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),schema__$1,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"error","error",-978969032),error_15291], null));
} else {
}

return value;
});
;})(c))
});
/**
 * Throw an exception if value does not satisfy schema; otherwise, return value.
 * If you will be validating many datums, it is much more efficient to create
 * a 'validator' once and call it on each of them.
 */
schema.core.validate = (function schema$core$validate(schema__$1,value){
return schema.core.validator.call(null,schema__$1).call(null,value);
});
schema.core.instance_precondition = (function schema$core$instance_precondition(s,klass){
return schema.spec.core.precondition.call(null,s,(function (p1__15292_SHARP_){
var and__7395__auto__ = !((p1__15292_SHARP_ == null));
if(and__7395__auto__){
var or__7407__auto__ = (klass === p1__15292_SHARP_.constructor);
if(or__7407__auto__){
return or__7407__auto__;
} else {
return p1__15292_SHARP_ instanceof klass;
}
} else {
return and__7395__auto__;
}
}),(function (p1__15293_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = klass;
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = p1__15293_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
})(),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null));
}));
});
(schema.core.Schema["function"] = true);

(schema.core.spec["function"] = (function (this$){
var pre = schema.core.instance_precondition.call(null,this$,this$);
var temp__5276__auto__ = schema.utils.class_schema.call(null,this$);
if(cljs.core.truth_(temp__5276__auto__)){
var class_schema = temp__5276__auto__;
return schema.spec.variant.variant_spec.call(null,pre,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),class_schema], null)], null));
} else {
return schema.spec.leaf.leaf_spec.call(null,pre);
}
}));

(schema.core.explain["function"] = (function (this$){
var temp__5276__auto__ = schema.utils.class_schema.call(null,this$);
if(cljs.core.truth_(temp__5276__auto__)){
var more_schema = temp__5276__auto__;
return schema.core.explain.call(null,more_schema);
} else {
var pred__15294 = cljs.core._EQ_;
var expr__15295 = this$;
if(cljs.core.truth_(pred__15294.call(null,null,expr__15295))){
return new cljs.core.Symbol(null,"Str","Str",907970895,null);
} else {
if(cljs.core.truth_(pred__15294.call(null,Boolean,expr__15295))){
return new cljs.core.Symbol(null,"Bool","Bool",195910502,null);
} else {
if(cljs.core.truth_(pred__15294.call(null,Number,expr__15295))){
return new cljs.core.Symbol(null,"Num","Num",-2044934708,null);
} else {
if(cljs.core.truth_(pred__15294.call(null,null,expr__15295))){
return new cljs.core.Symbol(null,"Regex","Regex",205914413,null);
} else {
if(cljs.core.truth_(pred__15294.call(null,Date,expr__15295))){
return new cljs.core.Symbol(null,"Inst","Inst",292408622,null);
} else {
if(cljs.core.truth_(pred__15294.call(null,cljs.core.UUID,expr__15295))){
return new cljs.core.Symbol(null,"Uuid","Uuid",-1866694318,null);
} else {
return this$;
}
}
}
}
}
}
}
}));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.AnythingSchema = (function (_,__meta,__extmap,__hash){
this._ = _;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.AnythingSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.AnythingSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15298,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15300 = k15298;
var G__15300__$1 = (((G__15300 instanceof cljs.core.Keyword))?G__15300.fqn:null);
switch (G__15300__$1) {
case "_":
return self__._;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15298,else__8085__auto__);

}
});

schema.core.AnythingSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.AnythingSchema{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"_","_",1453416199),self__._],null))], null),self__.__extmap));
});

schema.core.AnythingSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.AnythingSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15297){
var self__ = this;
var G__15297__$1 = this;
return (new cljs.core.RecordIter((0),G__15297__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"_","_",1453416199)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.AnythingSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.AnythingSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.AnythingSchema(self__._,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.AnythingSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.AnythingSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.AnythingSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.AnythingSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"_","_",1453416199),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.AnythingSchema(self__._,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.AnythingSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15297){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15301 = cljs.core.keyword_identical_QMARK_;
var expr__15302 = k__8090__auto__;
if(cljs.core.truth_(pred__15301.call(null,new cljs.core.Keyword(null,"_","_",1453416199),expr__15302))){
return (new schema.core.AnythingSchema(G__15297,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.AnythingSchema(self__._,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15297),null));
}
});

schema.core.AnythingSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"_","_",1453416199),self__._],null))], null),self__.__extmap));
});

schema.core.AnythingSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15297){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.AnythingSchema(self__._,G__15297,self__.__extmap,self__.__hash));
});

schema.core.AnythingSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.AnythingSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.AnythingSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_);
});

schema.core.AnythingSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Symbol(null,"Any","Any",1277492269,null);
});

schema.core.AnythingSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null)], null);
});

schema.core.AnythingSchema.cljs$lang$type = true;

schema.core.AnythingSchema.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/AnythingSchema");
});

schema.core.AnythingSchema.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/AnythingSchema");
});

schema.core.__GT_AnythingSchema = (function schema$core$__GT_AnythingSchema(_){
return (new schema.core.AnythingSchema(_,null,null,null));
});

schema.core.map__GT_AnythingSchema = (function schema$core$map__GT_AnythingSchema(G__15299){
return (new schema.core.AnythingSchema(new cljs.core.Keyword(null,"_","_",1453416199).cljs$core$IFn$_invoke$arity$1(G__15299),null,cljs.core.dissoc.call(null,G__15299,new cljs.core.Keyword(null,"_","_",1453416199)),null));
});

/**
 * Any value, including nil.
 */
schema.core.Any = (new schema.core.AnythingSchema(null,null,null,null));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.EqSchema = (function (v,__meta,__extmap,__hash){
this.v = v;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.EqSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.EqSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15308,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15310 = k15308;
var G__15310__$1 = (((G__15310 instanceof cljs.core.Keyword))?G__15310.fqn:null);
switch (G__15310__$1) {
case "v":
return self__.v;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15308,else__8085__auto__);

}
});

schema.core.EqSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.EqSchema{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"v","v",21465059),self__.v],null))], null),self__.__extmap));
});

schema.core.EqSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.EqSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15307){
var self__ = this;
var G__15307__$1 = this;
return (new cljs.core.RecordIter((0),G__15307__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"v","v",21465059)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.EqSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.EqSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.EqSchema(self__.v,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.EqSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.EqSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.EqSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.EqSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"v","v",21465059),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.EqSchema(self__.v,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.EqSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15307){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15311 = cljs.core.keyword_identical_QMARK_;
var expr__15312 = k__8090__auto__;
if(cljs.core.truth_(pred__15311.call(null,new cljs.core.Keyword(null,"v","v",21465059),expr__15312))){
return (new schema.core.EqSchema(G__15307,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.EqSchema(self__.v,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15307),null));
}
});

schema.core.EqSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"v","v",21465059),self__.v],null))], null),self__.__extmap));
});

schema.core.EqSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15307){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.EqSchema(self__.v,G__15307,self__.__extmap,self__.__hash));
});

schema.core.EqSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.EqSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.EqSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__15305_SHARP_){
return cljs.core._EQ_.call(null,self__.v,p1__15305_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__15306_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = self__.v;
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = p1__15306_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
})(),new cljs.core.Symbol(null,"=","=",-1501502141,null));
});})(this$__$1))
));
});

schema.core.EqSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = self__.v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"eq","eq",1021992460,null));
});

schema.core.EqSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null);
});

schema.core.EqSchema.cljs$lang$type = true;

schema.core.EqSchema.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/EqSchema");
});

schema.core.EqSchema.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/EqSchema");
});

schema.core.__GT_EqSchema = (function schema$core$__GT_EqSchema(v){
return (new schema.core.EqSchema(v,null,null,null));
});

schema.core.map__GT_EqSchema = (function schema$core$map__GT_EqSchema(G__15309){
return (new schema.core.EqSchema(new cljs.core.Keyword(null,"v","v",21465059).cljs$core$IFn$_invoke$arity$1(G__15309),null,cljs.core.dissoc.call(null,G__15309,new cljs.core.Keyword(null,"v","v",21465059)),null));
});

/**
 * A value that must be (= v).
 */
schema.core.eq = (function schema$core$eq(v){
return (new schema.core.EqSchema(v,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Isa = (function (h,parent,__meta,__extmap,__hash){
this.h = h;
this.parent = parent;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Isa.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.Isa.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15318,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15320 = k15318;
var G__15320__$1 = (((G__15320 instanceof cljs.core.Keyword))?G__15320.fqn:null);
switch (G__15320__$1) {
case "h":
return self__.h;

break;
case "parent":
return self__.parent;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15318,else__8085__auto__);

}
});

schema.core.Isa.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.Isa{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parent","parent",-878878779),self__.parent],null))], null),self__.__extmap));
});

schema.core.Isa.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Isa.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15317){
var self__ = this;
var G__15317__$1 = this;
return (new cljs.core.RecordIter((0),G__15317__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h","h",1109658740),new cljs.core.Keyword(null,"parent","parent",-878878779)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Isa.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.Isa.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.Isa(self__.h,self__.parent,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Isa.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Isa.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.Isa.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Isa.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"parent","parent",-878878779),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.Isa(self__.h,self__.parent,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.Isa.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15317){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15321 = cljs.core.keyword_identical_QMARK_;
var expr__15322 = k__8090__auto__;
if(cljs.core.truth_(pred__15321.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__15322))){
return (new schema.core.Isa(G__15317,self__.parent,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__15321.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),expr__15322))){
return (new schema.core.Isa(self__.h,G__15317,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Isa(self__.h,self__.parent,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15317),null));
}
}
});

schema.core.Isa.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parent","parent",-878878779),self__.parent],null))], null),self__.__extmap));
});

schema.core.Isa.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15317){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.Isa(self__.h,self__.parent,G__15317,self__.__extmap,self__.__hash));
});

schema.core.Isa.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.Isa.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Isa.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__15315_SHARP_){
return cljs.core.isa_QMARK_.call(null,self__.h,p1__15315_SHARP_,self__.parent);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__15316_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__15316_SHARP_;
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = self__.parent;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
})(),new cljs.core.Symbol(null,"isa?","isa?",1358492324,null));
});})(this$__$1))
));
});

schema.core.Isa.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = self__.parent;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"isa?","isa?",1358492324,null));
});

schema.core.Isa.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null);
});

schema.core.Isa.cljs$lang$type = true;

schema.core.Isa.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Isa");
});

schema.core.Isa.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/Isa");
});

schema.core.__GT_Isa = (function schema$core$__GT_Isa(h,parent){
return (new schema.core.Isa(h,parent,null,null,null));
});

schema.core.map__GT_Isa = (function schema$core$map__GT_Isa(G__15319){
return (new schema.core.Isa(new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__15319),new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(G__15319),null,cljs.core.dissoc.call(null,G__15319,new cljs.core.Keyword(null,"h","h",1109658740),new cljs.core.Keyword(null,"parent","parent",-878878779)),null));
});

/**
 * A value that must be a child of parent.
 */
schema.core.isa = (function schema$core$isa(var_args){
var args15325 = [];
var len__8628__auto___15328 = arguments.length;
var i__8629__auto___15329 = (0);
while(true){
if((i__8629__auto___15329 < len__8628__auto___15328)){
args15325.push((arguments[i__8629__auto___15329]));

var G__15330 = (i__8629__auto___15329 + (1));
i__8629__auto___15329 = G__15330;
continue;
} else {
}
break;
}

var G__15327 = args15325.length;
switch (G__15327) {
case 1:
return schema.core.isa.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return schema.core.isa.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15325.length)].join('')));

}
});

schema.core.isa.cljs$core$IFn$_invoke$arity$1 = (function (parent){
return (new schema.core.Isa(null,parent,null,null,null));
});

schema.core.isa.cljs$core$IFn$_invoke$arity$2 = (function (h,parent){
return (new schema.core.Isa(h,parent,null,null,null));
});

schema.core.isa.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.EnumSchema = (function (vs,__meta,__extmap,__hash){
this.vs = vs;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.EnumSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.EnumSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15335,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15337 = k15335;
var G__15337__$1 = (((G__15337 instanceof cljs.core.Keyword))?G__15337.fqn:null);
switch (G__15337__$1) {
case "vs":
return self__.vs;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15335,else__8085__auto__);

}
});

schema.core.EnumSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.EnumSchema{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"vs","vs",-2022097090),self__.vs],null))], null),self__.__extmap));
});

schema.core.EnumSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.EnumSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15334){
var self__ = this;
var G__15334__$1 = this;
return (new cljs.core.RecordIter((0),G__15334__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"vs","vs",-2022097090)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.EnumSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.EnumSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.EnumSchema(self__.vs,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.EnumSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.EnumSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.EnumSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.EnumSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"vs","vs",-2022097090),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.EnumSchema(self__.vs,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.EnumSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15334){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15338 = cljs.core.keyword_identical_QMARK_;
var expr__15339 = k__8090__auto__;
if(cljs.core.truth_(pred__15338.call(null,new cljs.core.Keyword(null,"vs","vs",-2022097090),expr__15339))){
return (new schema.core.EnumSchema(G__15334,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.EnumSchema(self__.vs,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15334),null));
}
});

schema.core.EnumSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"vs","vs",-2022097090),self__.vs],null))], null),self__.__extmap));
});

schema.core.EnumSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15334){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.EnumSchema(self__.vs,G__15334,self__.__extmap,self__.__hash));
});

schema.core.EnumSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.EnumSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.EnumSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__15332_SHARP_){
return cljs.core.contains_QMARK_.call(null,self__.vs,p1__15332_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__15333_SHARP_){
var x__8341__auto__ = self__.vs;
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = p1__15333_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
});})(this$__$1))
));
});

schema.core.EnumSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"enum","enum",-975417337,null),self__.vs);
});

schema.core.EnumSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vs","vs",-381565563,null)], null);
});

schema.core.EnumSchema.cljs$lang$type = true;

schema.core.EnumSchema.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/EnumSchema");
});

schema.core.EnumSchema.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/EnumSchema");
});

schema.core.__GT_EnumSchema = (function schema$core$__GT_EnumSchema(vs){
return (new schema.core.EnumSchema(vs,null,null,null));
});

schema.core.map__GT_EnumSchema = (function schema$core$map__GT_EnumSchema(G__15336){
return (new schema.core.EnumSchema(new cljs.core.Keyword(null,"vs","vs",-2022097090).cljs$core$IFn$_invoke$arity$1(G__15336),null,cljs.core.dissoc.call(null,G__15336,new cljs.core.Keyword(null,"vs","vs",-2022097090)),null));
});

/**
 * A value that must be = to some element of vs.
 */
schema.core.enum$ = (function schema$core$enum(var_args){
var args__8635__auto__ = [];
var len__8628__auto___15343 = arguments.length;
var i__8629__auto___15344 = (0);
while(true){
if((i__8629__auto___15344 < len__8628__auto___15343)){
args__8635__auto__.push((arguments[i__8629__auto___15344]));

var G__15345 = (i__8629__auto___15344 + (1));
i__8629__auto___15344 = G__15345;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((0) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((0)),(0),null)):null);
return schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(argseq__8636__auto__);
});

schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic = (function (vs){
return (new schema.core.EnumSchema(cljs.core.set.call(null,vs),null,null,null));
});

schema.core.enum$.cljs$lang$maxFixedArity = (0);

schema.core.enum$.cljs$lang$applyTo = (function (seq15342){
return schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq15342));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Predicate = (function (p_QMARK_,pred_name,__meta,__extmap,__hash){
this.p_QMARK_ = p_QMARK_;
this.pred_name = pred_name;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Predicate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.Predicate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15348,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15350 = k15348;
var G__15350__$1 = (((G__15350 instanceof cljs.core.Keyword))?G__15350.fqn:null);
switch (G__15350__$1) {
case "p?":
return self__.p_QMARK_;

break;
case "pred-name":
return self__.pred_name;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15348,else__8085__auto__);

}
});

schema.core.Predicate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.Predicate{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p?","p?",-1172161701),self__.p_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),self__.pred_name],null))], null),self__.__extmap));
});

schema.core.Predicate.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Predicate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15347){
var self__ = this;
var G__15347__$1 = this;
return (new cljs.core.RecordIter((0),G__15347__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p?","p?",-1172161701),new cljs.core.Keyword(null,"pred-name","pred-name",-3677451)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Predicate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.Predicate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Predicate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Predicate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.Predicate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Predicate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),null,new cljs.core.Keyword(null,"p?","p?",-1172161701),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.Predicate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15347){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15351 = cljs.core.keyword_identical_QMARK_;
var expr__15352 = k__8090__auto__;
if(cljs.core.truth_(pred__15351.call(null,new cljs.core.Keyword(null,"p?","p?",-1172161701),expr__15352))){
return (new schema.core.Predicate(G__15347,self__.pred_name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__15351.call(null,new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),expr__15352))){
return (new schema.core.Predicate(self__.p_QMARK_,G__15347,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15347),null));
}
}
});

schema.core.Predicate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p?","p?",-1172161701),self__.p_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),self__.pred_name],null))], null),self__.__extmap));
});

schema.core.Predicate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15347){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,G__15347,self__.__extmap,self__.__hash));
});

schema.core.Predicate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.Predicate.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Predicate.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,self__.p_QMARK_,((function (this$__$1){
return (function (p1__15346_SHARP_){
var x__8341__auto__ = self__.pred_name;
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = p1__15346_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
});})(this$__$1))
));
});

schema.core.Predicate.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.integer_QMARK_)){
return new cljs.core.Symbol(null,"Int","Int",-2116888740,null);
} else {
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.keyword_QMARK_)){
return new cljs.core.Symbol(null,"Keyword","Keyword",-850065993,null);
} else {
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.symbol_QMARK_)){
return new cljs.core.Symbol(null,"Symbol","Symbol",716452869,null);
} else {
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.string_QMARK_)){
return new cljs.core.Symbol(null,"Str","Str",907970895,null);
} else {
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = self__.pred_name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"pred","pred",-727012372,null));

}
}
}
}
});

schema.core.Predicate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p?","p?",468369826,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null);
});

schema.core.Predicate.cljs$lang$type = true;

schema.core.Predicate.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Predicate");
});

schema.core.Predicate.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/Predicate");
});

schema.core.__GT_Predicate = (function schema$core$__GT_Predicate(p_QMARK_,pred_name){
return (new schema.core.Predicate(p_QMARK_,pred_name,null,null,null));
});

schema.core.map__GT_Predicate = (function schema$core$map__GT_Predicate(G__15349){
return (new schema.core.Predicate(new cljs.core.Keyword(null,"p?","p?",-1172161701).cljs$core$IFn$_invoke$arity$1(G__15349),new cljs.core.Keyword(null,"pred-name","pred-name",-3677451).cljs$core$IFn$_invoke$arity$1(G__15349),null,cljs.core.dissoc.call(null,G__15349,new cljs.core.Keyword(null,"p?","p?",-1172161701),new cljs.core.Keyword(null,"pred-name","pred-name",-3677451)),null));
});

/**
 * A value for which p? returns true (and does not throw).
 * Optional pred-name can be passed for nicer validation errors.
 */
schema.core.pred = (function schema$core$pred(var_args){
var args15355 = [];
var len__8628__auto___15358 = arguments.length;
var i__8629__auto___15359 = (0);
while(true){
if((i__8629__auto___15359 < len__8628__auto___15358)){
args15355.push((arguments[i__8629__auto___15359]));

var G__15360 = (i__8629__auto___15359 + (1));
i__8629__auto___15359 = G__15360;
continue;
} else {
}
break;
}

var G__15357 = args15355.length;
switch (G__15357) {
case 1:
return schema.core.pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return schema.core.pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15355.length)].join('')));

}
});

schema.core.pred.cljs$core$IFn$_invoke$arity$1 = (function (p_QMARK_){
return schema.core.pred.call(null,p_QMARK_,cljs.core.symbol.call(null,schema.utils.fn_name.call(null,p_QMARK_)));
});

schema.core.pred.cljs$core$IFn$_invoke$arity$2 = (function (p_QMARK_,pred_name){
if(cljs.core.ifn_QMARK_.call(null,p_QMARK_)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Not a function: %s",p_QMARK_)));
}

return (new schema.core.Predicate(p_QMARK_,pred_name,null,null,null));
});

schema.core.pred.cljs$lang$maxFixedArity = 2;

schema.core.protocol_name = (function schema$core$protocol_name(protocol){
return new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,protocol));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Protocol = (function (p,__meta,__extmap,__hash){
this.p = p;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Protocol.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.Protocol.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15365,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15367 = k15365;
var G__15367__$1 = (((G__15367 instanceof cljs.core.Keyword))?G__15367.fqn:null);
switch (G__15367__$1) {
case "p":
return self__.p;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15365,else__8085__auto__);

}
});

schema.core.Protocol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.Protocol{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p","p",151049309),self__.p],null))], null),self__.__extmap));
});

schema.core.Protocol.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Protocol.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15364){
var self__ = this;
var G__15364__$1 = this;
return (new cljs.core.RecordIter((0),G__15364__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Protocol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.Protocol.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.Protocol(self__.p,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Protocol.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Protocol.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.Protocol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Protocol.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"p","p",151049309),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.Protocol(self__.p,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.Protocol.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15364){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15368 = cljs.core.keyword_identical_QMARK_;
var expr__15369 = k__8090__auto__;
if(cljs.core.truth_(pred__15368.call(null,new cljs.core.Keyword(null,"p","p",151049309),expr__15369))){
return (new schema.core.Protocol(G__15364,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Protocol(self__.p,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15364),null));
}
});

schema.core.Protocol.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p","p",151049309),self__.p],null))], null),self__.__extmap));
});

schema.core.Protocol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15364){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.Protocol(self__.p,G__15364,self__.__extmap,self__.__hash));
});

schema.core.Protocol.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.Protocol.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Protocol.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__15362_SHARP_){
return new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,this$__$1)).call(null,p1__15362_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__15363_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = schema.core.protocol_name.call(null,this$__$1);
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = p1__15363_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
})(),new cljs.core.Symbol(null,"satisfies?","satisfies?",-433227199,null));
});})(this$__$1))
));
});

schema.core.Protocol.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = schema.core.protocol_name.call(null,this$__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"protocol","protocol",-2001965651,null));
});

schema.core.Protocol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null)], null);
});

schema.core.Protocol.cljs$lang$type = true;

schema.core.Protocol.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Protocol");
});

schema.core.Protocol.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/Protocol");
});

schema.core.__GT_Protocol = (function schema$core$__GT_Protocol(p){
return (new schema.core.Protocol(p,null,null,null));
});

schema.core.map__GT_Protocol = (function schema$core$map__GT_Protocol(G__15366){
return (new schema.core.Protocol(new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(G__15366),null,cljs.core.dissoc.call(null,G__15366,new cljs.core.Keyword(null,"p","p",151049309)),null));
});

RegExp.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

RegExp.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,cljs.core.some_fn.call(null,schema.spec.core.precondition.call(null,this$__$1,cljs.core.string_QMARK_,((function (this$__$1){
return (function (p1__13882__13883__auto__){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__13882__13883__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"string?","string?",-1129175764,null));
});})(this$__$1))
),schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__15372_SHARP_){
return cljs.core.re_find.call(null,this$__$1,p1__15372_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__15373_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = schema.core.explain.call(null,this$__$1);
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = p1__15373_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
})(),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null));
});})(this$__$1))
)));
});

RegExp.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("#\""),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)].join('').slice((1),(-1))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join(''));
});
/**
 * Satisfied only by String.
 * Is (pred string?) and not js/String in cljs because of keywords.
 */
schema.core.Str = schema.core.pred.call(null,cljs.core.string_QMARK_);
/**
 * Boolean true or false
 */
schema.core.Bool = Boolean;
/**
 * Any number
 */
schema.core.Num = Number;
/**
 * Any integral number
 */
schema.core.Int = schema.core.pred.call(null,cljs.core.integer_QMARK_);
/**
 * A keyword
 */
schema.core.Keyword = schema.core.pred.call(null,cljs.core.keyword_QMARK_);
/**
 * A symbol
 */
schema.core.Symbol = schema.core.pred.call(null,cljs.core.symbol_QMARK_);
/**
 * A regular expression
 */
schema.core.Regex = (function (){
if(typeof schema.core.t_schema$core15376 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {schema.core.Schema}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
schema.core.t_schema$core15376 = (function (meta15377){
this.meta15377 = meta15377;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
schema.core.t_schema$core15376.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15378,meta15377__$1){
var self__ = this;
var _15378__$1 = this;
return (new schema.core.t_schema$core15376(meta15377__$1));
});

schema.core.t_schema$core15376.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15378){
var self__ = this;
var _15378__$1 = this;
return self__.meta15377;
});

schema.core.t_schema$core15376.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.t_schema$core15376.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__15374_SHARP_){
return (p1__15374_SHARP_ instanceof RegExp);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__15375_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__15375_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol("js","RegExp","js/RegExp",1778210562,null)),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null));
});})(this$__$1))
));
});

schema.core.t_schema$core15376.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Symbol(null,"Regex","Regex",205914413,null);
});

schema.core.t_schema$core15376.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta15377","meta15377",-1233909373,null)], null);
});

schema.core.t_schema$core15376.cljs$lang$type = true;

schema.core.t_schema$core15376.cljs$lang$ctorStr = "schema.core/t_schema$core15376";

schema.core.t_schema$core15376.cljs$lang$ctorPrWriter = (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"schema.core/t_schema$core15376");
});

schema.core.__GT_t_schema$core15376 = (function schema$core$__GT_t_schema$core15376(meta15377){
return (new schema.core.t_schema$core15376(meta15377));
});

}

return (new schema.core.t_schema$core15376(cljs.core.PersistentArrayMap.EMPTY));
})()
;
/**
 * The local representation of #inst ...
 */
schema.core.Inst = Date;
/**
 * The local representation of #uuid ...
 */
schema.core.Uuid = cljs.core.UUID;

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Maybe = (function (schema,__meta,__extmap,__hash){
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Maybe.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.Maybe.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15380,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15382 = k15380;
var G__15382__$1 = (((G__15382 instanceof cljs.core.Keyword))?G__15382.fqn:null);
switch (G__15382__$1) {
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15380,else__8085__auto__);

}
});

schema.core.Maybe.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.Maybe{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Maybe.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Maybe.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15379){
var self__ = this;
var G__15379__$1 = this;
return (new cljs.core.RecordIter((0),G__15379__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Maybe.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.Maybe.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.Maybe(self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Maybe.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Maybe.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.Maybe.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Maybe.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.Maybe(self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.Maybe.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15379){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15383 = cljs.core.keyword_identical_QMARK_;
var expr__15384 = k__8090__auto__;
if(cljs.core.truth_(pred__15383.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__15384))){
return (new schema.core.Maybe(G__15379,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Maybe(self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15379),null));
}
});

schema.core.Maybe.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Maybe.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15379){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.Maybe(self__.schema,G__15379,self__.__extmap,self__.__hash));
});

schema.core.Maybe.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.Maybe.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Maybe.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),cljs.core.nil_QMARK_,new cljs.core.Keyword(null,"schema","schema",-1582001791),schema.core.eq.call(null,null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema], null)], null));
});

schema.core.Maybe.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = schema.core.explain.call(null,self__.schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"maybe","maybe",1326133967,null));
});

schema.core.Maybe.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

schema.core.Maybe.cljs$lang$type = true;

schema.core.Maybe.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Maybe");
});

schema.core.Maybe.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/Maybe");
});

schema.core.__GT_Maybe = (function schema$core$__GT_Maybe(schema__$1){
return (new schema.core.Maybe(schema__$1,null,null,null));
});

schema.core.map__GT_Maybe = (function schema$core$map__GT_Maybe(G__15381){
return (new schema.core.Maybe(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__15381),null,cljs.core.dissoc.call(null,G__15381,new cljs.core.Keyword(null,"schema","schema",-1582001791)),null));
});

/**
 * A value that must either be nil or satisfy schema
 */
schema.core.maybe = (function schema$core$maybe(schema__$1){
return (new schema.core.Maybe(schema__$1,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.NamedSchema = (function (schema,name,__meta,__extmap,__hash){
this.schema = schema;
this.name = name;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.NamedSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.NamedSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15389,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15391 = k15389;
var G__15391__$1 = (((G__15391 instanceof cljs.core.Keyword))?G__15391.fqn:null);
switch (G__15391__$1) {
case "schema":
return self__.schema;

break;
case "name":
return self__.name;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15389,else__8085__auto__);

}
});

schema.core.NamedSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.NamedSchema{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.NamedSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.NamedSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15388){
var self__ = this;
var G__15388__$1 = this;
return (new cljs.core.RecordIter((0),G__15388__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"name","name",1843675177)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.NamedSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.NamedSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.NamedSchema(self__.schema,self__.name,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.NamedSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.NamedSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.NamedSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.NamedSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"name","name",1843675177),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.NamedSchema(self__.schema,self__.name,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.NamedSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15388){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15392 = cljs.core.keyword_identical_QMARK_;
var expr__15393 = k__8090__auto__;
if(cljs.core.truth_(pred__15392.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__15393))){
return (new schema.core.NamedSchema(G__15388,self__.name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__15392.call(null,new cljs.core.Keyword(null,"name","name",1843675177),expr__15393))){
return (new schema.core.NamedSchema(self__.schema,G__15388,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.NamedSchema(self__.schema,self__.name,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15388),null));
}
}
});

schema.core.NamedSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.NamedSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15388){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.NamedSchema(self__.schema,self__.name,G__15388,self__.__extmap,self__.__hash));
});

schema.core.NamedSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.NamedSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.NamedSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,new cljs.core.Keyword(null,"wrap-error","wrap-error",536732809),((function (this$__$1){
return (function (p1__15387_SHARP_){
return schema.utils.__GT_NamedError.call(null,self__.name,p1__15387_SHARP_);
});})(this$__$1))
], null)], null));
});

schema.core.NamedSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = schema.core.explain.call(null,self__.schema);
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = self__.name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
})(),new cljs.core.Symbol(null,"named","named",1218138048,null));
});

schema.core.NamedSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"name","name",-810760592,null)], null);
});

schema.core.NamedSchema.cljs$lang$type = true;

schema.core.NamedSchema.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/NamedSchema");
});

schema.core.NamedSchema.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/NamedSchema");
});

schema.core.__GT_NamedSchema = (function schema$core$__GT_NamedSchema(schema__$1,name){
return (new schema.core.NamedSchema(schema__$1,name,null,null,null));
});

schema.core.map__GT_NamedSchema = (function schema$core$map__GT_NamedSchema(G__15390){
return (new schema.core.NamedSchema(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__15390),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(G__15390),null,cljs.core.dissoc.call(null,G__15390,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"name","name",1843675177)),null));
});

/**
 * A value that must satisfy schema, and has a name for documentation purposes.
 */
schema.core.named = (function schema$core$named(schema__$1,name){
return (new schema.core.NamedSchema(schema__$1,name,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Either = (function (schemas,__meta,__extmap,__hash){
this.schemas = schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Either.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.Either.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15398,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15400 = k15398;
var G__15400__$1 = (((G__15400 instanceof cljs.core.Keyword))?G__15400.fqn:null);
switch (G__15400__$1) {
case "schemas":
return self__.schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15398,else__8085__auto__);

}
});

schema.core.Either.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.Either{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Either.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Either.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15397){
var self__ = this;
var G__15397__$1 = this;
return (new cljs.core.RecordIter((0),G__15397__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schemas","schemas",575070579)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Either.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.Either.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.Either(self__.schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Either.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Either.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.Either.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Either.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schemas","schemas",575070579),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.Either(self__.schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.Either.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15397){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15401 = cljs.core.keyword_identical_QMARK_;
var expr__15402 = k__8090__auto__;
if(cljs.core.truth_(pred__15401.call(null,new cljs.core.Keyword(null,"schemas","schemas",575070579),expr__15402))){
return (new schema.core.Either(G__15397,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Either(self__.schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15397),null));
}
});

schema.core.Either.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Either.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15397){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.Either(self__.schemas,G__15397,self__.__extmap,self__.__hash));
});

schema.core.Either.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.Either.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Either.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,(function (){var iter__8269__auto__ = ((function (this$__$1){
return (function schema$core$iter__15404(s__15405){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__15405__$1 = s__15405;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__15405__$1);
if(temp__5278__auto__){
var s__15405__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15405__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__15405__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__15407 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__15406 = (0);
while(true){
if((i__15406 < size__8268__auto__)){
var s = cljs.core._nth.call(null,c__8267__auto__,i__15406);
cljs.core.chunk_append.call(null,b__15407,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),cljs.core.complement.call(null,schema.core.checker.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null));

var G__15409 = (i__15406 + (1));
i__15406 = G__15409;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15407),schema$core$iter__15404.call(null,cljs.core.chunk_rest.call(null,s__15405__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15407),null);
}
} else {
var s = cljs.core.first.call(null,s__15405__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),cljs.core.complement.call(null,schema.core.checker.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null),schema$core$iter__15404.call(null,cljs.core.rest.call(null,s__15405__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__8269__auto__.call(null,self__.schemas);
})(),((function (this$__$1){
return (function (p1__15396_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__15396_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"some-matching-either-clause?","some-matching-either-clause?",-1443305015,null));
});})(this$__$1))
);
});

schema.core.Either.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"either","either",-2144373018,null),cljs.core.map.call(null,schema.core.explain,self__.schemas));
});

schema.core.Either.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schemas","schemas",-2079365190,null)], null);
});

schema.core.Either.cljs$lang$type = true;

schema.core.Either.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Either");
});

schema.core.Either.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/Either");
});

schema.core.__GT_Either = (function schema$core$__GT_Either(schemas){
return (new schema.core.Either(schemas,null,null,null));
});

schema.core.map__GT_Either = (function schema$core$map__GT_Either(G__15399){
return (new schema.core.Either(new cljs.core.Keyword(null,"schemas","schemas",575070579).cljs$core$IFn$_invoke$arity$1(G__15399),null,cljs.core.dissoc.call(null,G__15399,new cljs.core.Keyword(null,"schemas","schemas",575070579)),null));
});

/**
 * A value that must satisfy at least one schema in schemas.
 * Note that `either` does not work properly with coercion
 * 
 * DEPRECATED: prefer `cond-pre`
 * 
 * WARNING: either does not work with coercion.  It is also slow and gives
 * bad error messages.  Please consider using `conditional` and friends
 * instead; they are more efficient, provide better error messages,
 * and work with coercion.
 */
schema.core.either = (function schema$core$either(var_args){
var args__8635__auto__ = [];
var len__8628__auto___15411 = arguments.length;
var i__8629__auto___15412 = (0);
while(true){
if((i__8629__auto___15412 < len__8628__auto___15411)){
args__8635__auto__.push((arguments[i__8629__auto___15412]));

var G__15413 = (i__8629__auto___15412 + (1));
i__8629__auto___15412 = G__15413;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((0) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((0)),(0),null)):null);
return schema.core.either.cljs$core$IFn$_invoke$arity$variadic(argseq__8636__auto__);
});

schema.core.either.cljs$core$IFn$_invoke$arity$variadic = (function (schemas){
return (new schema.core.Either(schemas,null,null,null));
});

schema.core.either.cljs$lang$maxFixedArity = (0);

schema.core.either.cljs$lang$applyTo = (function (seq15410){
return schema.core.either.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq15410));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.ConditionalSchema = (function (preds_and_schemas,error_symbol,__meta,__extmap,__hash){
this.preds_and_schemas = preds_and_schemas;
this.error_symbol = error_symbol;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.ConditionalSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.ConditionalSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15416,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15418 = k15416;
var G__15418__$1 = (((G__15418 instanceof cljs.core.Keyword))?G__15418.fqn:null);
switch (G__15418__$1) {
case "preds-and-schemas":
return self__.preds_and_schemas;

break;
case "error-symbol":
return self__.error_symbol;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15416,else__8085__auto__);

}
});

schema.core.ConditionalSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.ConditionalSchema{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),self__.preds_and_schemas],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),self__.error_symbol],null))], null),self__.__extmap));
});

schema.core.ConditionalSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.ConditionalSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15415){
var self__ = this;
var G__15415__$1 = this;
return (new cljs.core.RecordIter((0),G__15415__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.ConditionalSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.ConditionalSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.ConditionalSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.ConditionalSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.ConditionalSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.ConditionalSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),null,new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.ConditionalSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15415){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15419 = cljs.core.keyword_identical_QMARK_;
var expr__15420 = k__8090__auto__;
if(cljs.core.truth_(pred__15419.call(null,new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),expr__15420))){
return (new schema.core.ConditionalSchema(G__15415,self__.error_symbol,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__15419.call(null,new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),expr__15420))){
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,G__15415,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15415),null));
}
}
});

schema.core.ConditionalSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),self__.preds_and_schemas],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),self__.error_symbol],null))], null),self__.__extmap));
});

schema.core.ConditionalSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15415){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,G__15415,self__.__extmap,self__.__hash));
});

schema.core.ConditionalSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.ConditionalSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.ConditionalSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,(function (){var iter__8269__auto__ = ((function (this$__$1){
return (function schema$core$iter__15422(s__15423){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__15423__$1 = s__15423;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__15423__$1);
if(temp__5278__auto__){
var s__15423__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15423__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__15423__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__15425 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__15424 = (0);
while(true){
if((i__15424 < size__8268__auto__)){
var vec__15432 = cljs.core._nth.call(null,c__8267__auto__,i__15424);
var p = cljs.core.nth.call(null,vec__15432,(0),null);
var s = cljs.core.nth.call(null,vec__15432,(1),null);
cljs.core.chunk_append.call(null,b__15425,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),p,new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null));

var G__15443 = (i__15424 + (1));
i__15424 = G__15443;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15425),schema$core$iter__15422.call(null,cljs.core.chunk_rest.call(null,s__15423__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15425),null);
}
} else {
var vec__15435 = cljs.core.first.call(null,s__15423__$2);
var p = cljs.core.nth.call(null,vec__15435,(0),null);
var s = cljs.core.nth.call(null,vec__15435,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),p,new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null),schema$core$iter__15422.call(null,cljs.core.rest.call(null,s__15423__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__8269__auto__.call(null,self__.preds_and_schemas);
})(),((function (this$__$1){
return (function (p1__15414_SHARP_){
var x__8341__auto__ = (function (){var or__7407__auto__ = self__.error_symbol;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,self__.preds_and_schemas))){
return cljs.core.symbol.call(null,schema.utils.fn_name.call(null,cljs.core.ffirst.call(null,self__.preds_and_schemas)));
} else {
return new cljs.core.Symbol(null,"some-matching-condition?","some-matching-condition?",1512398506,null);
}
}
})();
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = p1__15414_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
});})(this$__$1))
);
});

schema.core.ConditionalSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"conditional","conditional",-1212542970,null),cljs.core.concat.call(null,cljs.core.mapcat.call(null,((function (this$__$1){
return (function (p__15438){
var vec__15439 = p__15438;
var pred = cljs.core.nth.call(null,vec__15439,(0),null);
var schema__$1 = cljs.core.nth.call(null,vec__15439,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,schema.utils.fn_name.call(null,pred)),schema.core.explain.call(null,schema__$1)], null);
});})(this$__$1))
,self__.preds_and_schemas),(cljs.core.truth_(self__.error_symbol)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.error_symbol], null):null)));
});

schema.core.ConditionalSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"preds-and-schemas","preds-and-schemas",333765172,null),new cljs.core.Symbol(null,"error-symbol","error-symbol",817051099,null)], null);
});

schema.core.ConditionalSchema.cljs$lang$type = true;

schema.core.ConditionalSchema.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/ConditionalSchema");
});

schema.core.ConditionalSchema.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/ConditionalSchema");
});

schema.core.__GT_ConditionalSchema = (function schema$core$__GT_ConditionalSchema(preds_and_schemas,error_symbol){
return (new schema.core.ConditionalSchema(preds_and_schemas,error_symbol,null,null,null));
});

schema.core.map__GT_ConditionalSchema = (function schema$core$map__GT_ConditionalSchema(G__15417){
return (new schema.core.ConditionalSchema(new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355).cljs$core$IFn$_invoke$arity$1(G__15417),new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428).cljs$core$IFn$_invoke$arity$1(G__15417),null,cljs.core.dissoc.call(null,G__15417,new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428)),null));
});

/**
 * Define a conditional schema.  Takes args like cond,
 * (conditional pred1 schema1 pred2 schema2 ...),
 * and checks the first schema where pred is true on the value.
 * Unlike cond, throws if the value does not match any condition.
 * :else may be used as a final condition in the place of (constantly true).
 * More efficient than either, since only one schema must be checked.
 * An optional final argument can be passed, a symbol to appear in
 * error messages when none of the conditions match.
 */
schema.core.conditional = (function schema$core$conditional(var_args){
var args__8635__auto__ = [];
var len__8628__auto___15461 = arguments.length;
var i__8629__auto___15462 = (0);
while(true){
if((i__8629__auto___15462 < len__8628__auto___15461)){
args__8635__auto__.push((arguments[i__8629__auto___15462]));

var G__15463 = (i__8629__auto___15462 + (1));
i__8629__auto___15462 = G__15463;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((0) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((0)),(0),null)):null);
return schema.core.conditional.cljs$core$IFn$_invoke$arity$variadic(argseq__8636__auto__);
});

schema.core.conditional.cljs$core$IFn$_invoke$arity$variadic = (function (preds_and_schemas){
if((cljs.core.seq.call(null,preds_and_schemas)) && ((cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,preds_and_schemas))) || ((cljs.core.last.call(null,preds_and_schemas) instanceof cljs.core.Symbol)))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Expected even, nonzero number of args (with optional trailing symbol); got %s",cljs.core.count.call(null,preds_and_schemas))));
}

return (new schema.core.ConditionalSchema((function (){var iter__8269__auto__ = (function schema$core$iter__15445(s__15446){
return (new cljs.core.LazySeq(null,(function (){
var s__15446__$1 = s__15446;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__15446__$1);
if(temp__5278__auto__){
var s__15446__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15446__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__15446__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__15448 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__15447 = (0);
while(true){
if((i__15447 < size__8268__auto__)){
var vec__15455 = cljs.core._nth.call(null,c__8267__auto__,i__15447);
var pred = cljs.core.nth.call(null,vec__15455,(0),null);
var schema__$1 = cljs.core.nth.call(null,vec__15455,(1),null);
cljs.core.chunk_append.call(null,b__15448,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((cljs.core._EQ_.call(null,pred,new cljs.core.Keyword(null,"else","else",-1508377146)))?cljs.core.constantly.call(null,true):pred),schema__$1], null));

var G__15464 = (i__15447 + (1));
i__15447 = G__15464;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15448),schema$core$iter__15445.call(null,cljs.core.chunk_rest.call(null,s__15446__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15448),null);
}
} else {
var vec__15458 = cljs.core.first.call(null,s__15446__$2);
var pred = cljs.core.nth.call(null,vec__15458,(0),null);
var schema__$1 = cljs.core.nth.call(null,vec__15458,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((cljs.core._EQ_.call(null,pred,new cljs.core.Keyword(null,"else","else",-1508377146)))?cljs.core.constantly.call(null,true):pred),schema__$1], null),schema$core$iter__15445.call(null,cljs.core.rest.call(null,s__15446__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,cljs.core.partition.call(null,(2),preds_and_schemas));
})(),((cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,preds_and_schemas)))?cljs.core.last.call(null,preds_and_schemas):null),null,null,null));
});

schema.core.conditional.cljs$lang$maxFixedArity = (0);

schema.core.conditional.cljs$lang$applyTo = (function (seq15444){
return schema.core.conditional.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq15444));
});


/**
 * @interface
 */
schema.core.HasPrecondition = function(){};

/**
 * Return a predicate representing the Precondition for this schema:
 *   the predicate returns true if the precondition is satisfied.
 *   (See spec.core for more details)
 */
schema.core.precondition = (function schema$core$precondition(this$){
if((!((this$ == null))) && (!((this$.schema$core$HasPrecondition$precondition$arity$1 == null)))){
return this$.schema$core$HasPrecondition$precondition$arity$1(this$);
} else {
var x__8125__auto__ = (((this$ == null))?null:this$);
var m__8126__auto__ = (schema.core.precondition[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,this$);
} else {
var m__8126__auto____$1 = (schema.core.precondition["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"HasPrecondition.precondition",this$);
}
}
}
});

schema.spec.leaf.LeafSpec.prototype.schema$core$HasPrecondition$ = cljs.core.PROTOCOL_SENTINEL;

schema.spec.leaf.LeafSpec.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.complement.call(null,this$__$1.pre);
});

schema.spec.variant.VariantSpec.prototype.schema$core$HasPrecondition$ = cljs.core.PROTOCOL_SENTINEL;

schema.spec.variant.VariantSpec.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.every_pred.call(null,cljs.core.complement.call(null,this$__$1.pre),cljs.core.apply.call(null,cljs.core.some_fn,(function (){var iter__8269__auto__ = ((function (this$__$1){
return (function schema$core$iter__15465(s__15466){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__15466__$1 = s__15466;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__15466__$1);
if(temp__5278__auto__){
var s__15466__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15466__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__15466__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__15468 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__15467 = (0);
while(true){
if((i__15467 < size__8268__auto__)){
var map__15473 = cljs.core._nth.call(null,c__8267__auto__,i__15467);
var map__15473__$1 = ((((!((map__15473 == null)))?((((map__15473.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15473.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15473):map__15473);
var guard = cljs.core.get.call(null,map__15473__$1,new cljs.core.Keyword(null,"guard","guard",-873147811));
var schema__$1 = cljs.core.get.call(null,map__15473__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
cljs.core.chunk_append.call(null,b__15468,(cljs.core.truth_(guard)?cljs.core.every_pred.call(null,guard,schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))):schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))));

var G__15477 = (i__15467 + (1));
i__15467 = G__15477;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15468),schema$core$iter__15465.call(null,cljs.core.chunk_rest.call(null,s__15466__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15468),null);
}
} else {
var map__15475 = cljs.core.first.call(null,s__15466__$2);
var map__15475__$1 = ((((!((map__15475 == null)))?((((map__15475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15475.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15475):map__15475);
var guard = cljs.core.get.call(null,map__15475__$1,new cljs.core.Keyword(null,"guard","guard",-873147811));
var schema__$1 = cljs.core.get.call(null,map__15475__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
return cljs.core.cons.call(null,(cljs.core.truth_(guard)?cljs.core.every_pred.call(null,guard,schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))):schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))),schema$core$iter__15465.call(null,cljs.core.rest.call(null,s__15466__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__8269__auto__.call(null,this$__$1.options);
})()));
});

schema.spec.collection.CollectionSpec.prototype.schema$core$HasPrecondition$ = cljs.core.PROTOCOL_SENTINEL;

schema.spec.collection.CollectionSpec.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.complement.call(null,this$__$1.pre);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.CondPre = (function (schemas,__meta,__extmap,__hash){
this.schemas = schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.CondPre.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.CondPre.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15480,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15482 = k15480;
var G__15482__$1 = (((G__15482 instanceof cljs.core.Keyword))?G__15482.fqn:null);
switch (G__15482__$1) {
case "schemas":
return self__.schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15480,else__8085__auto__);

}
});

schema.core.CondPre.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.CondPre{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.CondPre.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.CondPre.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15479){
var self__ = this;
var G__15479__$1 = this;
return (new cljs.core.RecordIter((0),G__15479__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schemas","schemas",575070579)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.CondPre.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.CondPre.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.CondPre(self__.schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.CondPre.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.CondPre.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.CondPre.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.CondPre.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schemas","schemas",575070579),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.CondPre(self__.schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.CondPre.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15479){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15483 = cljs.core.keyword_identical_QMARK_;
var expr__15484 = k__8090__auto__;
if(cljs.core.truth_(pred__15483.call(null,new cljs.core.Keyword(null,"schemas","schemas",575070579),expr__15484))){
return (new schema.core.CondPre(G__15479,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.CondPre(self__.schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15479),null));
}
});

schema.core.CondPre.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.CondPre.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15479){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.CondPre(self__.schemas,G__15479,self__.__extmap,self__.__hash));
});

schema.core.CondPre.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.CondPre.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.CondPre.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,(function (){var iter__8269__auto__ = ((function (this$__$1){
return (function schema$core$iter__15486(s__15487){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__15487__$1 = s__15487;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__15487__$1);
if(temp__5278__auto__){
var s__15487__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15487__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__15487__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__15489 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__15488 = (0);
while(true){
if((i__15488 < size__8268__auto__)){
var s = cljs.core._nth.call(null,c__8267__auto__,i__15488);
cljs.core.chunk_append.call(null,b__15489,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),schema.core.precondition.call(null,schema.core.spec.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null));

var G__15491 = (i__15488 + (1));
i__15488 = G__15491;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15489),schema$core$iter__15486.call(null,cljs.core.chunk_rest.call(null,s__15487__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15489),null);
}
} else {
var s = cljs.core.first.call(null,s__15487__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),schema.core.precondition.call(null,schema.core.spec.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null),schema$core$iter__15486.call(null,cljs.core.rest.call(null,s__15487__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__8269__auto__.call(null,self__.schemas);
})(),((function (this$__$1){
return (function (p1__15478_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__15478_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"matches-some-precondition?","matches-some-precondition?",2123072832,null));
});})(this$__$1))
);
});

schema.core.CondPre.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"cond-pre","cond-pre",-923707731,null),cljs.core.map.call(null,schema.core.explain,self__.schemas));
});

schema.core.CondPre.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schemas","schemas",-2079365190,null)], null);
});

schema.core.CondPre.cljs$lang$type = true;

schema.core.CondPre.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/CondPre");
});

schema.core.CondPre.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/CondPre");
});

schema.core.__GT_CondPre = (function schema$core$__GT_CondPre(schemas){
return (new schema.core.CondPre(schemas,null,null,null));
});

schema.core.map__GT_CondPre = (function schema$core$map__GT_CondPre(G__15481){
return (new schema.core.CondPre(new cljs.core.Keyword(null,"schemas","schemas",575070579).cljs$core$IFn$_invoke$arity$1(G__15481),null,cljs.core.dissoc.call(null,G__15481,new cljs.core.Keyword(null,"schemas","schemas",575070579)),null));
});

/**
 * A replacement for `either` that constructs a conditional schema
 * based on the schema spec preconditions of the component schemas.
 * 
 * EXPERIMENTAL
 */
schema.core.cond_pre = (function schema$core$cond_pre(var_args){
var args__8635__auto__ = [];
var len__8628__auto___15493 = arguments.length;
var i__8629__auto___15494 = (0);
while(true){
if((i__8629__auto___15494 < len__8628__auto___15493)){
args__8635__auto__.push((arguments[i__8629__auto___15494]));

var G__15495 = (i__8629__auto___15494 + (1));
i__8629__auto___15494 = G__15495;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((0) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((0)),(0),null)):null);
return schema.core.cond_pre.cljs$core$IFn$_invoke$arity$variadic(argseq__8636__auto__);
});

schema.core.cond_pre.cljs$core$IFn$_invoke$arity$variadic = (function (schemas){
return (new schema.core.CondPre(schemas,null,null,null));
});

schema.core.cond_pre.cljs$lang$maxFixedArity = (0);

schema.core.cond_pre.cljs$lang$applyTo = (function (seq15492){
return schema.core.cond_pre.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq15492));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {schema.core.HasPrecondition}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {schema.spec.core.CoreSpec}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Both = (function (schemas,__meta,__extmap,__hash){
this.schemas = schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Both.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.Both.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15498,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15500 = k15498;
var G__15500__$1 = (((G__15500 instanceof cljs.core.Keyword))?G__15500.fqn:null);
switch (G__15500__$1) {
case "schemas":
return self__.schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15498,else__8085__auto__);

}
});

schema.core.Both.prototype.schema$spec$core$CoreSpec$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Both.prototype.schema$spec$core$CoreSpec$subschemas$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.schemas;
});

schema.core.Both.prototype.schema$spec$core$CoreSpec$checker$arity$2 = (function (this$,params){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.call(null,((function (this$__$1){
return (function (f,t){
return ((function (this$__$1){
return (function (x){
var tx = t.call(null,x);
if(cljs.core.truth_(schema.utils.error_QMARK_.call(null,tx))){
return tx;
} else {
return f.call(null,(function (){var or__7407__auto__ = tx;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return x;
}
})());
}
});
;})(this$__$1))
});})(this$__$1))
,cljs.core.map.call(null,((function (this$__$1){
return (function (p1__15496_SHARP_){
return schema.spec.core.sub_checker.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),p1__15496_SHARP_], null),params);
});})(this$__$1))
,cljs.core.reverse.call(null,self__.schemas)));
});

schema.core.Both.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.Both{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Both.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Both.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15497){
var self__ = this;
var G__15497__$1 = this;
return (new cljs.core.RecordIter((0),G__15497__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schemas","schemas",575070579)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Both.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.Both.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.Both(self__.schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Both.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Both.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.Both.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Both.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schemas","schemas",575070579),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.Both(self__.schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.Both.prototype.schema$core$HasPrecondition$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Both.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.apply.call(null,cljs.core.every_pred,cljs.core.map.call(null,cljs.core.comp.call(null,schema.core.precondition,schema.core.spec),self__.schemas));
});

schema.core.Both.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15497){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15501 = cljs.core.keyword_identical_QMARK_;
var expr__15502 = k__8090__auto__;
if(cljs.core.truth_(pred__15501.call(null,new cljs.core.Keyword(null,"schemas","schemas",575070579),expr__15502))){
return (new schema.core.Both(G__15497,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Both(self__.schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15497),null));
}
});

schema.core.Both.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Both.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15497){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.Both(self__.schemas,G__15497,self__.__extmap,self__.__hash));
});

schema.core.Both.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.Both.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Both.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

schema.core.Both.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"both","both",1246882687,null),cljs.core.map.call(null,schema.core.explain,self__.schemas));
});

schema.core.Both.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schemas","schemas",-2079365190,null)], null);
});

schema.core.Both.cljs$lang$type = true;

schema.core.Both.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Both");
});

schema.core.Both.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/Both");
});

schema.core.__GT_Both = (function schema$core$__GT_Both(schemas){
return (new schema.core.Both(schemas,null,null,null));
});

schema.core.map__GT_Both = (function schema$core$map__GT_Both(G__15499){
return (new schema.core.Both(new cljs.core.Keyword(null,"schemas","schemas",575070579).cljs$core$IFn$_invoke$arity$1(G__15499),null,cljs.core.dissoc.call(null,G__15499,new cljs.core.Keyword(null,"schemas","schemas",575070579)),null));
});

/**
 * A value that must satisfy every schema in schemas.
 * 
 * DEPRECATED: prefer 'conditional' with a single condition
 * instead.
 * 
 * When used with coercion, coerces each schema in sequence.
 */
schema.core.both = (function schema$core$both(var_args){
var args__8635__auto__ = [];
var len__8628__auto___15506 = arguments.length;
var i__8629__auto___15507 = (0);
while(true){
if((i__8629__auto___15507 < len__8628__auto___15506)){
args__8635__auto__.push((arguments[i__8629__auto___15507]));

var G__15508 = (i__8629__auto___15507 + (1));
i__8629__auto___15507 = G__15508;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((0) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((0)),(0),null)):null);
return schema.core.both.cljs$core$IFn$_invoke$arity$variadic(argseq__8636__auto__);
});

schema.core.both.cljs$core$IFn$_invoke$arity$variadic = (function (schemas){
return (new schema.core.Both(schemas,null,null,null));
});

schema.core.both.cljs$lang$maxFixedArity = (0);

schema.core.both.cljs$lang$applyTo = (function (seq15505){
return schema.core.both.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq15505));
});

/**
 * if the predicate returns truthy, use the if-schema, otherwise use the else-schema
 */
schema.core.if$ = (function schema$core$if(pred,if_schema,else_schema){
return schema.core.conditional.call(null,pred,if_schema,cljs.core.constantly.call(null,true),else_schema);
});
schema.core.var_name = (function schema$core$var_name(v){
var map__15511 = cljs.core.meta.call(null,v);
var map__15511__$1 = ((((!((map__15511 == null)))?((((map__15511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15511.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15511):map__15511);
var ns = cljs.core.get.call(null,map__15511__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var name = cljs.core.get.call(null,map__15511__$1,new cljs.core.Keyword(null,"name","name",1843675177));
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Recursive = (function (derefable,__meta,__extmap,__hash){
this.derefable = derefable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Recursive.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.Recursive.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15514,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15516 = k15514;
var G__15516__$1 = (((G__15516 instanceof cljs.core.Keyword))?G__15516.fqn:null);
switch (G__15516__$1) {
case "derefable":
return self__.derefable;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15514,else__8085__auto__);

}
});

schema.core.Recursive.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.Recursive{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"derefable","derefable",377265868),self__.derefable],null))], null),self__.__extmap));
});

schema.core.Recursive.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Recursive.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15513){
var self__ = this;
var G__15513__$1 = this;
return (new cljs.core.RecordIter((0),G__15513__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"derefable","derefable",377265868)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Recursive.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.Recursive.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.Recursive(self__.derefable,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Recursive.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Recursive.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.Recursive.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Recursive.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"derefable","derefable",377265868),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.Recursive(self__.derefable,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.Recursive.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15513){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15517 = cljs.core.keyword_identical_QMARK_;
var expr__15518 = k__8090__auto__;
if(cljs.core.truth_(pred__15517.call(null,new cljs.core.Keyword(null,"derefable","derefable",377265868),expr__15518))){
return (new schema.core.Recursive(G__15513,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Recursive(self__.derefable,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15513),null));
}
});

schema.core.Recursive.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"derefable","derefable",377265868),self__.derefable],null))], null),self__.__extmap));
});

schema.core.Recursive.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15513){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.Recursive(self__.derefable,G__15513,self__.__extmap,self__.__hash));
});

schema.core.Recursive.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.Recursive.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Recursive.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.deref.call(null,self__.derefable)], null)], null));
});

schema.core.Recursive.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = (((self__.derefable instanceof cljs.core.Var))?cljs.core._conj.call(null,(function (){var x__8341__auto__ = schema.core.var_name.call(null,self__.derefable);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"var","var",870848730,null)):new cljs.core.Symbol(null,"...","...",-1926939749,null));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"recursive","recursive",-1935549897,null));
});

schema.core.Recursive.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"derefable","derefable",2017797395,null)], null);
});

schema.core.Recursive.cljs$lang$type = true;

schema.core.Recursive.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Recursive");
});

schema.core.Recursive.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/Recursive");
});

schema.core.__GT_Recursive = (function schema$core$__GT_Recursive(derefable){
return (new schema.core.Recursive(derefable,null,null,null));
});

schema.core.map__GT_Recursive = (function schema$core$map__GT_Recursive(G__15515){
return (new schema.core.Recursive(new cljs.core.Keyword(null,"derefable","derefable",377265868).cljs$core$IFn$_invoke$arity$1(G__15515),null,cljs.core.dissoc.call(null,G__15515,new cljs.core.Keyword(null,"derefable","derefable",377265868)),null));
});

/**
 * Support for (mutually) recursive schemas by passing a var that points to a schema,
 * e.g (recursive #'ExampleRecursiveSchema).
 */
schema.core.recursive = (function schema$core$recursive(schema__$1){
if(((!((schema__$1 == null)))?((((schema__$1.cljs$lang$protocol_mask$partition0$ & (32768))) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.cljs$core$IDeref$)))?true:(((!schema__$1.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,schema__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,schema__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Not an IDeref: %s",schema__$1)));
}

return (new schema.core.Recursive(schema__$1,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.RequiredKey = (function (k,__meta,__extmap,__hash){
this.k = k;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.RequiredKey.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.RequiredKey.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15524,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15526 = k15524;
var G__15526__$1 = (((G__15526 instanceof cljs.core.Keyword))?G__15526.fqn:null);
switch (G__15526__$1) {
case "k":
return self__.k;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15524,else__8085__auto__);

}
});

schema.core.RequiredKey.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.RequiredKey{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.RequiredKey.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.RequiredKey.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15523){
var self__ = this;
var G__15523__$1 = this;
return (new cljs.core.RecordIter((0),G__15523__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"k","k",-2146297393)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.RequiredKey.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.RequiredKey.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.RequiredKey(self__.k,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.RequiredKey.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.RequiredKey.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.RequiredKey.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.RequiredKey.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"k","k",-2146297393),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.RequiredKey(self__.k,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.RequiredKey.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15523){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15527 = cljs.core.keyword_identical_QMARK_;
var expr__15528 = k__8090__auto__;
if(cljs.core.truth_(pred__15527.call(null,new cljs.core.Keyword(null,"k","k",-2146297393),expr__15528))){
return (new schema.core.RequiredKey(G__15523,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.RequiredKey(self__.k,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15523),null));
}
});

schema.core.RequiredKey.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.RequiredKey.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15523){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.RequiredKey(self__.k,G__15523,self__.__extmap,self__.__hash));
});

schema.core.RequiredKey.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.RequiredKey.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"k","k",-505765866,null)], null);
});

schema.core.RequiredKey.cljs$lang$type = true;

schema.core.RequiredKey.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/RequiredKey");
});

schema.core.RequiredKey.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/RequiredKey");
});

schema.core.__GT_RequiredKey = (function schema$core$__GT_RequiredKey(k){
return (new schema.core.RequiredKey(k,null,null,null));
});

schema.core.map__GT_RequiredKey = (function schema$core$map__GT_RequiredKey(G__15525){
return (new schema.core.RequiredKey(new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(G__15525),null,cljs.core.dissoc.call(null,G__15525,new cljs.core.Keyword(null,"k","k",-2146297393)),null));
});

/**
 * A required key in a map
 */
schema.core.required_key = (function schema$core$required_key(k){
if((k instanceof cljs.core.Keyword)){
return k;
} else {
return (new schema.core.RequiredKey(k,null,null,null));
}
});
schema.core.required_key_QMARK_ = (function schema$core$required_key_QMARK_(ks){
return ((ks instanceof cljs.core.Keyword)) || ((ks instanceof schema.core.RequiredKey));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.OptionalKey = (function (k,__meta,__extmap,__hash){
this.k = k;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.OptionalKey.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.OptionalKey.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15532,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15534 = k15532;
var G__15534__$1 = (((G__15534 instanceof cljs.core.Keyword))?G__15534.fqn:null);
switch (G__15534__$1) {
case "k":
return self__.k;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15532,else__8085__auto__);

}
});

schema.core.OptionalKey.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.OptionalKey{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.OptionalKey.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.OptionalKey.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15531){
var self__ = this;
var G__15531__$1 = this;
return (new cljs.core.RecordIter((0),G__15531__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"k","k",-2146297393)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.OptionalKey.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.OptionalKey.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.OptionalKey(self__.k,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.OptionalKey.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.OptionalKey.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.OptionalKey.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.OptionalKey.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"k","k",-2146297393),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.OptionalKey(self__.k,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.OptionalKey.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15531){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15535 = cljs.core.keyword_identical_QMARK_;
var expr__15536 = k__8090__auto__;
if(cljs.core.truth_(pred__15535.call(null,new cljs.core.Keyword(null,"k","k",-2146297393),expr__15536))){
return (new schema.core.OptionalKey(G__15531,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.OptionalKey(self__.k,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15531),null));
}
});

schema.core.OptionalKey.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.OptionalKey.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15531){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.OptionalKey(self__.k,G__15531,self__.__extmap,self__.__hash));
});

schema.core.OptionalKey.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.OptionalKey.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"k","k",-505765866,null)], null);
});

schema.core.OptionalKey.cljs$lang$type = true;

schema.core.OptionalKey.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/OptionalKey");
});

schema.core.OptionalKey.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/OptionalKey");
});

schema.core.__GT_OptionalKey = (function schema$core$__GT_OptionalKey(k){
return (new schema.core.OptionalKey(k,null,null,null));
});

schema.core.map__GT_OptionalKey = (function schema$core$map__GT_OptionalKey(G__15533){
return (new schema.core.OptionalKey(new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(G__15533),null,cljs.core.dissoc.call(null,G__15533,new cljs.core.Keyword(null,"k","k",-2146297393)),null));
});

/**
 * An optional key in a map
 */
schema.core.optional_key = (function schema$core$optional_key(k){
return (new schema.core.OptionalKey(k,null,null,null));
});
schema.core.optional_key_QMARK_ = (function schema$core$optional_key_QMARK_(ks){
return (ks instanceof schema.core.OptionalKey);
});
schema.core.explicit_schema_key = (function schema$core$explicit_schema_key(ks){
if((ks instanceof cljs.core.Keyword)){
return ks;
} else {
if((ks instanceof schema.core.RequiredKey)){
return ks.k;
} else {
if(cljs.core.truth_(schema.core.optional_key_QMARK_.call(null,ks))){
return ks.k;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Bad explicit key: %s",ks)));

}
}
}
});
schema.core.specific_key_QMARK_ = (function schema$core$specific_key_QMARK_(ks){
var or__7407__auto__ = schema.core.required_key_QMARK_.call(null,ks);
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return schema.core.optional_key_QMARK_.call(null,ks);
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.MapEntry = (function (key_schema,val_schema,__meta,__extmap,__hash){
this.key_schema = key_schema;
this.val_schema = val_schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15540,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15542 = k15540;
var G__15542__$1 = (((G__15542 instanceof cljs.core.Keyword))?G__15542.fqn:null);
switch (G__15542__$1) {
case "key-schema":
return self__.key_schema;

break;
case "val-schema":
return self__.val_schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15540,else__8085__auto__);

}
});

schema.core.MapEntry.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#cljs.core.MapEntry{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),self__.key_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),self__.val_schema],null))], null),self__.__extmap));
});

schema.core.MapEntry.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.MapEntry.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15539){
var self__ = this;
var G__15539__$1 = this;
return (new cljs.core.RecordIter((0),G__15539__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.MapEntry.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.MapEntry.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),null,new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15539){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15543 = cljs.core.keyword_identical_QMARK_;
var expr__15544 = k__8090__auto__;
if(cljs.core.truth_(pred__15543.call(null,new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),expr__15544))){
return (new schema.core.MapEntry(G__15539,self__.val_schema,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__15543.call(null,new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),expr__15544))){
return (new schema.core.MapEntry(self__.key_schema,G__15539,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15539),null));
}
}
});

schema.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),self__.key_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),self__.val_schema],null))], null),self__.__extmap));
});

schema.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15539){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,G__15539,self__.__extmap,self__.__hash));
});

schema.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.MapEntry.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.MapEntry.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,cljs.core.vec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.one_element.call(null,true,self__.key_schema,((function (this$__$1){
return (function (item_fn,e){
item_fn.call(null,cljs.core.key.call(null,e));

return e;
});})(this$__$1))
),schema.spec.collection.one_element.call(null,true,self__.val_schema,((function (this$__$1){
return (function (item_fn,e){
item_fn.call(null,cljs.core.val.call(null,e));

return null;
});})(this$__$1))
)], null),((function (this$__$1){
return (function (p__15546,p__15547,_){
var vec__15548 = p__15546;
var k = cljs.core.nth.call(null,vec__15548,(0),null);
var vec__15551 = p__15547;
var xk = cljs.core.nth.call(null,vec__15551,(0),null);
var xv = cljs.core.nth.call(null,vec__15551,(1),null);
var temp__5276__auto__ = schema.utils.error_val.call(null,xk);
if(cljs.core.truth_(temp__5276__auto__)){
var k_err = temp__5276__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_err,new cljs.core.Symbol(null,"invalid-key","invalid-key",-1461682245,null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,schema.utils.error_val.call(null,xv)], null);
}
});})(this$__$1))
);
});

schema.core.MapEntry.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = schema.core.explain.call(null,self__.key_schema);
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = schema.core.explain.call(null,self__.val_schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
})(),new cljs.core.Symbol(null,"map-entry","map-entry",329617471,null));
});

cljs.core.MapEntry.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key-schema","key-schema",543870801,null),new cljs.core.Symbol(null,"val-schema","val-schema",-374242092,null)], null);
});

cljs.core.MapEntry.cljs$lang$type = true;

cljs.core.MapEntry.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"cljs.core/MapEntry");
});

cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"cljs.core/MapEntry");
});

schema.core.__GT_MapEntry = (function schema$core$__GT_MapEntry(key_schema,val_schema){
return (new cljs.core.MapEntry(key_schema,val_schema,null,null,null));
});

schema.core.map__GT_MapEntry = (function schema$core$map__GT_MapEntry(G__15541){
return (new cljs.core.MapEntry(new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726).cljs$core$IFn$_invoke$arity$1(G__15541),new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619).cljs$core$IFn$_invoke$arity$1(G__15541),null,cljs.core.dissoc.call(null,G__15541,new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619)),null));
});

schema.core.map_entry = (function schema$core$map_entry(key_schema,val_schema){
return (new schema.core.MapEntry(key_schema,val_schema,null,null,null));
});
schema.core.find_extra_keys_schema = (function schema$core$find_extra_keys_schema(map_schema){
var key_schemata = cljs.core.remove.call(null,schema.core.specific_key_QMARK_,cljs.core.keys.call(null,map_schema));
if((cljs.core.count.call(null,key_schemata) < (2))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"More than one non-optional/required key schemata: %s",cljs.core.vec.call(null,key_schemata))));
}

return cljs.core.first.call(null,key_schemata);
});
schema.core.explain_kspec = (function schema$core$explain_kspec(kspec){
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,kspec))){
if((kspec instanceof cljs.core.Keyword)){
return kspec;
} else {
var x__8341__auto__ = (cljs.core.truth_(schema.core.required_key_QMARK_.call(null,kspec))?new cljs.core.Symbol(null,"required-key","required-key",1624616412,null):(cljs.core.truth_(schema.core.optional_key_QMARK_.call(null,kspec))?new cljs.core.Symbol(null,"optional-key","optional-key",988406145,null):null));
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = schema.core.explicit_schema_key.call(null,kspec);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
}
} else {
return schema.core.explain.call(null,kspec);
}
});
schema.core.map_elements = (function schema$core$map_elements(this$){
var extra_keys_schema = schema.core.find_extra_keys_schema.call(null,this$);
var duplicate_keys_15588 = cljs.core.mapv.call(null,schema.core.explain_kspec,cljs.core.apply.call(null,cljs.core.concat,cljs.core.filter.call(null,((function (extra_keys_schema){
return (function (p1__15555_SHARP_){
return (cljs.core.count.call(null,p1__15555_SHARP_) > (1));
});})(extra_keys_schema))
,cljs.core.vals.call(null,cljs.core.group_by.call(null,schema.core.explicit_schema_key,cljs.core.keys.call(null,cljs.core.dissoc.call(null,this$,extra_keys_schema)))))));
if(cljs.core.empty_QMARK_.call(null,duplicate_keys_15588)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Schema has multiple variants of the same explicit key: %s",duplicate_keys_15588)));
}

return cljs.core.concat.call(null,(function (){var iter__8269__auto__ = ((function (extra_keys_schema){
return (function schema$core$map_elements_$_iter__15572(s__15573){
return (new cljs.core.LazySeq(null,((function (extra_keys_schema){
return (function (){
var s__15573__$1 = s__15573;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__15573__$1);
if(temp__5278__auto__){
var s__15573__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15573__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__15573__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__15575 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__15574 = (0);
while(true){
if((i__15574 < size__8268__auto__)){
var vec__15582 = cljs.core._nth.call(null,c__8267__auto__,i__15574);
var k = cljs.core.nth.call(null,vec__15582,(0),null);
var v = cljs.core.nth.call(null,vec__15582,(1),null);
cljs.core.chunk_append.call(null,b__15575,(function (){var rk = schema.core.explicit_schema_key.call(null,k);
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
return schema.spec.collection.one_element.call(null,required_QMARK_,schema.core.map_entry.call(null,schema.core.eq.call(null,rk),v),((function (i__15574,rk,required_QMARK_,vec__15582,k,v,c__8267__auto__,size__8268__auto__,b__15575,s__15573__$2,temp__5278__auto__,extra_keys_schema){
return (function (item_fn,m){
var e = cljs.core.find.call(null,m,rk);
if(cljs.core.truth_(e)){
item_fn.call(null,e);
} else {
if(cljs.core.truth_(required_QMARK_)){
item_fn.call(null,schema.utils.error.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rk,new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null)], null)));
} else {
}
}

if(cljs.core.truth_(e)){
return cljs.core.dissoc.call(null,m,rk);
} else {
return m;
}
});})(i__15574,rk,required_QMARK_,vec__15582,k,v,c__8267__auto__,size__8268__auto__,b__15575,s__15573__$2,temp__5278__auto__,extra_keys_schema))
);
})());

var G__15589 = (i__15574 + (1));
i__15574 = G__15589;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15575),schema$core$map_elements_$_iter__15572.call(null,cljs.core.chunk_rest.call(null,s__15573__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15575),null);
}
} else {
var vec__15585 = cljs.core.first.call(null,s__15573__$2);
var k = cljs.core.nth.call(null,vec__15585,(0),null);
var v = cljs.core.nth.call(null,vec__15585,(1),null);
return cljs.core.cons.call(null,(function (){var rk = schema.core.explicit_schema_key.call(null,k);
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
return schema.spec.collection.one_element.call(null,required_QMARK_,schema.core.map_entry.call(null,schema.core.eq.call(null,rk),v),((function (rk,required_QMARK_,vec__15585,k,v,s__15573__$2,temp__5278__auto__,extra_keys_schema){
return (function (item_fn,m){
var e = cljs.core.find.call(null,m,rk);
if(cljs.core.truth_(e)){
item_fn.call(null,e);
} else {
if(cljs.core.truth_(required_QMARK_)){
item_fn.call(null,schema.utils.error.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rk,new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null)], null)));
} else {
}
}

if(cljs.core.truth_(e)){
return cljs.core.dissoc.call(null,m,rk);
} else {
return m;
}
});})(rk,required_QMARK_,vec__15585,k,v,s__15573__$2,temp__5278__auto__,extra_keys_schema))
);
})(),schema$core$map_elements_$_iter__15572.call(null,cljs.core.rest.call(null,s__15573__$2)));
}
} else {
return null;
}
break;
}
});})(extra_keys_schema))
,null,null));
});})(extra_keys_schema))
;
return iter__8269__auto__.call(null,cljs.core.dissoc.call(null,this$,extra_keys_schema));
})(),(cljs.core.truth_(extra_keys_schema)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,cljs.core.apply.call(null,schema.core.map_entry,cljs.core.find.call(null,this$,extra_keys_schema)))], null):null));
});
schema.core.map_error = (function schema$core$map_error(){
return (function (_,elts,extra){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.concat.call(null,cljs.core.keep.call(null,schema.utils.error_val,elts),(function (){var iter__8269__auto__ = (function schema$core$map_error_$_iter__15606(s__15607){
return (new cljs.core.LazySeq(null,(function (){
var s__15607__$1 = s__15607;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__15607__$1);
if(temp__5278__auto__){
var s__15607__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15607__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__15607__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__15609 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__15608 = (0);
while(true){
if((i__15608 < size__8268__auto__)){
var vec__15616 = cljs.core._nth.call(null,c__8267__auto__,i__15608);
var k = cljs.core.nth.call(null,vec__15616,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__15616,(1),null);
cljs.core.chunk_append.call(null,b__15609,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Symbol(null,"disallowed-key","disallowed-key",-1877785633,null)], null));

var G__15622 = (i__15608 + (1));
i__15608 = G__15622;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15609),schema$core$map_error_$_iter__15606.call(null,cljs.core.chunk_rest.call(null,s__15607__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15609),null);
}
} else {
var vec__15619 = cljs.core.first.call(null,s__15607__$2);
var k = cljs.core.nth.call(null,vec__15619,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__15619,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Symbol(null,"disallowed-key","disallowed-key",-1877785633,null)], null),schema$core$map_error_$_iter__15606.call(null,cljs.core.rest.call(null,s__15607__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,extra);
})()));
});
});
schema.core.map_spec = (function schema$core$map_spec(this$){
return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$,cljs.core.map_QMARK_,(function (p1__13882__13883__auto__){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__13882__13883__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"map?","map?",-1780568534,null));
})),(function (p1__15623_SHARP_){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,p1__15623_SHARP_);
}),schema.core.map_elements.call(null,this$),schema.core.map_error.call(null));
});
schema.core.map_explain = (function schema$core$map_explain(this$){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__8269__auto__ = (function schema$core$map_explain_$_iter__15640(s__15641){
return (new cljs.core.LazySeq(null,(function (){
var s__15641__$1 = s__15641;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__15641__$1);
if(temp__5278__auto__){
var s__15641__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15641__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__15641__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__15643 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__15642 = (0);
while(true){
if((i__15642 < size__8268__auto__)){
var vec__15650 = cljs.core._nth.call(null,c__8267__auto__,i__15642);
var k = cljs.core.nth.call(null,vec__15650,(0),null);
var v = cljs.core.nth.call(null,vec__15650,(1),null);
cljs.core.chunk_append.call(null,b__15643,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain_kspec.call(null,k),schema.core.explain.call(null,v)], null));

var G__15656 = (i__15642 + (1));
i__15642 = G__15656;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15643),schema$core$map_explain_$_iter__15640.call(null,cljs.core.chunk_rest.call(null,s__15641__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15643),null);
}
} else {
var vec__15653 = cljs.core.first.call(null,s__15641__$2);
var k = cljs.core.nth.call(null,vec__15653,(0),null);
var v = cljs.core.nth.call(null,vec__15653,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain_kspec.call(null,k),schema.core.explain.call(null,v)], null),schema$core$map_explain_$_iter__15640.call(null,cljs.core.rest.call(null,s__15641__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,this$);
})());
});
cljs.core.PersistentArrayMap.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentArrayMap.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_spec.call(null,this$__$1);
});

cljs.core.PersistentArrayMap.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_explain.call(null,this$__$1);
});

cljs.core.PersistentHashMap.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashMap.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_spec.call(null,this$__$1);
});

cljs.core.PersistentHashMap.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_explain.call(null,this$__$1);
});
cljs.core.PersistentHashSet.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashSet.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,this$__$1),(1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Set schema must have exactly one element")));
}

return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,cljs.core.set_QMARK_,((function (this$__$1){
return (function (p1__13882__13883__auto__){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__13882__13883__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"set?","set?",1636014792,null));
});})(this$__$1))
),cljs.core.set,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,cljs.core.first.call(null,this$__$1))], null),((function (this$__$1){
return (function (_,xs,___$1){
return cljs.core.set.call(null,cljs.core.keep.call(null,schema.utils.error_val,xs));
});})(this$__$1))
);
});

cljs.core.PersistentHashSet.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain.call(null,cljs.core.first.call(null,this$__$1))], null));
});
schema.core.queue_QMARK_ = (function schema$core$queue_QMARK_(x){
return (x instanceof cljs.core.PersistentQueue);
});
schema.core.as_queue = (function schema$core$as_queue(col){
return cljs.core.reduce.call(null,cljs.core.conj,cljs.core.PersistentQueue.EMPTY,col);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Queue = (function (schema,__meta,__extmap,__hash){
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Queue.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.Queue.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15658,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15660 = k15658;
var G__15660__$1 = (((G__15660 instanceof cljs.core.Keyword))?G__15660.fqn:null);
switch (G__15660__$1) {
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15658,else__8085__auto__);

}
});

schema.core.Queue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.Queue{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Queue.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Queue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15657){
var self__ = this;
var G__15657__$1 = this;
return (new cljs.core.RecordIter((0),G__15657__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Queue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.Queue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.Queue(self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Queue.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Queue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.Queue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Queue.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.Queue(self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.Queue.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15657){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15661 = cljs.core.keyword_identical_QMARK_;
var expr__15662 = k__8090__auto__;
if(cljs.core.truth_(pred__15661.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__15662))){
return (new schema.core.Queue(G__15657,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Queue(self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15657),null));
}
});

schema.core.Queue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Queue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15657){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.Queue(self__.schema,G__15657,self__.__extmap,self__.__hash));
});

schema.core.Queue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.Queue.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Queue.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,schema.core.queue_QMARK_,((function (this$__$1){
return (function (p1__13882__13883__auto__){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__13882__13883__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"queue?","queue?",-880510795,null));
});})(this$__$1))
),schema.core.as_queue,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,self__.schema)], null),((function (this$__$1){
return (function (_,xs,___$1){
return schema.core.as_queue.call(null,cljs.core.keep.call(null,schema.utils.error_val,xs));
});})(this$__$1))
);
});

schema.core.Queue.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = schema.core.explain.call(null,self__.schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"queue","queue",-1198599890,null));
});

schema.core.Queue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

schema.core.Queue.cljs$lang$type = true;

schema.core.Queue.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Queue");
});

schema.core.Queue.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/Queue");
});

schema.core.__GT_Queue = (function schema$core$__GT_Queue(schema__$1){
return (new schema.core.Queue(schema__$1,null,null,null));
});

schema.core.map__GT_Queue = (function schema$core$map__GT_Queue(G__15659){
return (new schema.core.Queue(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__15659),null,cljs.core.dissoc.call(null,G__15659,new cljs.core.Keyword(null,"schema","schema",-1582001791)),null));
});

/**
 * Defines a schema satisfied by instances of clojure.lang.PersistentQueue
 *   (clj.core/PersistentQueue in ClojureScript) whose values satisfy x.
 */
schema.core.queue = (function schema$core$queue(x){
return (new schema.core.Queue(x,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.One = (function (schema,optional_QMARK_,name,__meta,__extmap,__hash){
this.schema = schema;
this.optional_QMARK_ = optional_QMARK_;
this.name = name;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.One.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.One.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15666,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15668 = k15666;
var G__15668__$1 = (((G__15668 instanceof cljs.core.Keyword))?G__15668.fqn:null);
switch (G__15668__$1) {
case "schema":
return self__.schema;

break;
case "optional?":
return self__.optional_QMARK_;

break;
case "name":
return self__.name;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15666,else__8085__auto__);

}
});

schema.core.One.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.One{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"optional?","optional?",1184638129),self__.optional_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.One.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.One.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15665){
var self__ = this;
var G__15665__$1 = this;
return (new cljs.core.RecordIter((0),G__15665__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"optional?","optional?",1184638129),new cljs.core.Keyword(null,"name","name",1843675177)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.One.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.One.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.One.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.One.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.One.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.One.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"optional?","optional?",1184638129),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.One.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15665){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15669 = cljs.core.keyword_identical_QMARK_;
var expr__15670 = k__8090__auto__;
if(cljs.core.truth_(pred__15669.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__15670))){
return (new schema.core.One(G__15665,self__.optional_QMARK_,self__.name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__15669.call(null,new cljs.core.Keyword(null,"optional?","optional?",1184638129),expr__15670))){
return (new schema.core.One(self__.schema,G__15665,self__.name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__15669.call(null,new cljs.core.Keyword(null,"name","name",1843675177),expr__15670))){
return (new schema.core.One(self__.schema,self__.optional_QMARK_,G__15665,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15665),null));
}
}
}
});

schema.core.One.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"optional?","optional?",1184638129),self__.optional_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.One.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15665){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,G__15665,self__.__extmap,self__.__hash));
});

schema.core.One.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.One.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"optional?","optional?",-1469797640,null),new cljs.core.Symbol(null,"name","name",-810760592,null)], null);
});

schema.core.One.cljs$lang$type = true;

schema.core.One.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/One");
});

schema.core.One.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/One");
});

schema.core.__GT_One = (function schema$core$__GT_One(schema__$1,optional_QMARK_,name){
return (new schema.core.One(schema__$1,optional_QMARK_,name,null,null,null));
});

schema.core.map__GT_One = (function schema$core$map__GT_One(G__15667){
return (new schema.core.One(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__15667),new cljs.core.Keyword(null,"optional?","optional?",1184638129).cljs$core$IFn$_invoke$arity$1(G__15667),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(G__15667),null,cljs.core.dissoc.call(null,G__15667,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"optional?","optional?",1184638129),new cljs.core.Keyword(null,"name","name",1843675177)),null));
});

/**
 * A single required element of a sequence (not repeated, the implicit default)
 */
schema.core.one = (function schema$core$one(schema__$1,name){
return (new schema.core.One(schema__$1,false,name,null,null,null));
});
/**
 * A single optional element of a sequence (not repeated, the implicit default)
 */
schema.core.optional = (function schema$core$optional(schema__$1,name){
return (new schema.core.One(schema__$1,true,name,null,null,null));
});
schema.core.parse_sequence_schema = (function schema$core$parse_sequence_schema(s){

var vec__15682 = cljs.core.split_with.call(null,(function (p1__15673_SHARP_){
return ((p1__15673_SHARP_ instanceof schema.core.One)) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"optional?","optional?",1184638129).cljs$core$IFn$_invoke$arity$1(p1__15673_SHARP_)));
}),s);
var required = cljs.core.nth.call(null,vec__15682,(0),null);
var more = cljs.core.nth.call(null,vec__15682,(1),null);
var vec__15685 = cljs.core.split_with.call(null,((function (vec__15682,required,more){
return (function (p1__15674_SHARP_){
var and__7395__auto__ = (p1__15674_SHARP_ instanceof schema.core.One);
if(and__7395__auto__){
return new cljs.core.Keyword(null,"optional?","optional?",1184638129).cljs$core$IFn$_invoke$arity$1(p1__15674_SHARP_);
} else {
return and__7395__auto__;
}
});})(vec__15682,required,more))
,more);
var optional = cljs.core.nth.call(null,vec__15685,(0),null);
var more__$1 = cljs.core.nth.call(null,vec__15685,(1),null);
if(((cljs.core.count.call(null,more__$1) <= (1))) && (cljs.core.every_QMARK_.call(null,((function (vec__15682,required,more,vec__15685,optional,more__$1){
return (function (p1__15675_SHARP_){
return !((p1__15675_SHARP_ instanceof schema.core.One));
});})(vec__15682,required,more,vec__15685,optional,more__$1))
,more__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Sequence schema %s does not match [one* optional* rest-schema?]",s)));
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,required,optional),cljs.core.first.call(null,more__$1)], null);
});
cljs.core.PersistentVector.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (x){
return ((x == null)) || (cljs.core.sequential_QMARK_.call(null,x));
});})(this$__$1))
,((function (this$__$1){
return (function (p1__15688_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__15688_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null));
});})(this$__$1))
),cljs.core.vec,(function (){var vec__15689 = schema.core.parse_sequence_schema.call(null,this$__$1);
var singles = cljs.core.nth.call(null,vec__15689,(0),null);
var multi = cljs.core.nth.call(null,vec__15689,(1),null);
return cljs.core.concat.call(null,(function (){var iter__8269__auto__ = ((function (vec__15689,singles,multi,this$__$1){
return (function schema$core$iter__15692(s__15693){
return (new cljs.core.LazySeq(null,((function (vec__15689,singles,multi,this$__$1){
return (function (){
var s__15693__$1 = s__15693;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__15693__$1);
if(temp__5278__auto__){
var s__15693__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15693__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__15693__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__15695 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__15694 = (0);
while(true){
if((i__15694 < size__8268__auto__)){
var s = cljs.core._nth.call(null,c__8267__auto__,i__15694);
cljs.core.chunk_append.call(null,b__15695,(function (){var required_QMARK_ = cljs.core.not.call(null,s.optional_QMARK_);
return schema.spec.collection.one_element.call(null,required_QMARK_,schema.core.named.call(null,s.schema,s.name),((function (i__15694,required_QMARK_,s,c__8267__auto__,size__8268__auto__,b__15695,s__15693__$2,temp__5278__auto__,vec__15689,singles,multi,this$__$1){
return (function (item_fn,x){
var temp__5276__auto__ = cljs.core.seq.call(null,x);
if(temp__5276__auto__){
var x__$1 = temp__5276__auto__;
item_fn.call(null,cljs.core.first.call(null,x__$1));

return cljs.core.rest.call(null,x__$1);
} else {
if(required_QMARK_){
item_fn.call(null,schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,s.schema,new cljs.core.Keyword("schema.core","missing","schema.core/missing",1420181325),(new cljs.core.Delay(((function (i__15694,temp__5276__auto__,required_QMARK_,s,c__8267__auto__,size__8268__auto__,b__15695,s__15693__$2,temp__5278__auto__,vec__15689,singles,multi,this$__$1){
return (function (){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = s.name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"present?","present?",-1810613791,null));
});})(i__15694,temp__5276__auto__,required_QMARK_,s,c__8267__auto__,size__8268__auto__,b__15695,s__15693__$2,temp__5278__auto__,vec__15689,singles,multi,this$__$1))
,null)),null)));
} else {
}

return null;
}
});})(i__15694,required_QMARK_,s,c__8267__auto__,size__8268__auto__,b__15695,s__15693__$2,temp__5278__auto__,vec__15689,singles,multi,this$__$1))
);
})());

var G__15703 = (i__15694 + (1));
i__15694 = G__15703;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15695),schema$core$iter__15692.call(null,cljs.core.chunk_rest.call(null,s__15693__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15695),null);
}
} else {
var s = cljs.core.first.call(null,s__15693__$2);
return cljs.core.cons.call(null,(function (){var required_QMARK_ = cljs.core.not.call(null,s.optional_QMARK_);
return schema.spec.collection.one_element.call(null,required_QMARK_,schema.core.named.call(null,s.schema,s.name),((function (required_QMARK_,s,s__15693__$2,temp__5278__auto__,vec__15689,singles,multi,this$__$1){
return (function (item_fn,x){
var temp__5276__auto__ = cljs.core.seq.call(null,x);
if(temp__5276__auto__){
var x__$1 = temp__5276__auto__;
item_fn.call(null,cljs.core.first.call(null,x__$1));

return cljs.core.rest.call(null,x__$1);
} else {
if(required_QMARK_){
item_fn.call(null,schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,s.schema,new cljs.core.Keyword("schema.core","missing","schema.core/missing",1420181325),(new cljs.core.Delay(((function (temp__5276__auto__,required_QMARK_,s,s__15693__$2,temp__5278__auto__,vec__15689,singles,multi,this$__$1){
return (function (){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = s.name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"present?","present?",-1810613791,null));
});})(temp__5276__auto__,required_QMARK_,s,s__15693__$2,temp__5278__auto__,vec__15689,singles,multi,this$__$1))
,null)),null)));
} else {
}

return null;
}
});})(required_QMARK_,s,s__15693__$2,temp__5278__auto__,vec__15689,singles,multi,this$__$1))
);
})(),schema$core$iter__15692.call(null,cljs.core.rest.call(null,s__15693__$2)));
}
} else {
return null;
}
break;
}
});})(vec__15689,singles,multi,this$__$1))
,null,null));
});})(vec__15689,singles,multi,this$__$1))
;
return iter__8269__auto__.call(null,singles);
})(),(cljs.core.truth_(multi)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,multi)], null):null));
})(),((function (this$__$1){
return (function (_,elts,extra){
var head = cljs.core.mapv.call(null,schema.utils.error_val,elts);
if(cljs.core.seq.call(null,extra)){
return cljs.core.conj.call(null,head,schema.utils.error_val.call(null,schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,null,extra,(new cljs.core.Delay(((function (head,this$__$1){
return (function (){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = cljs.core.count.call(null,extra);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"has-extra-elts?","has-extra-elts?",-1376562869,null));
});})(head,this$__$1))
,null)),null))));
} else {
return head;
}
});})(this$__$1))
);
});

cljs.core.PersistentVector.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
var vec__15696 = schema.core.parse_sequence_schema.call(null,this$__$1);
var singles = cljs.core.nth.call(null,vec__15696,(0),null);
var multi = cljs.core.nth.call(null,vec__15696,(1),null);
return cljs.core.vec.call(null,cljs.core.concat.call(null,(function (){var iter__8269__auto__ = ((function (vec__15696,singles,multi,this$__$1){
return (function schema$core$iter__15699(s__15700){
return (new cljs.core.LazySeq(null,((function (vec__15696,singles,multi,this$__$1){
return (function (){
var s__15700__$1 = s__15700;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__15700__$1);
if(temp__5278__auto__){
var s__15700__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15700__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__15700__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__15702 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__15701 = (0);
while(true){
if((i__15701 < size__8268__auto__)){
var s = cljs.core._nth.call(null,c__8267__auto__,i__15701);
cljs.core.chunk_append.call(null,b__15702,(function (){var x__8341__auto__ = (cljs.core.truth_(s.optional_QMARK_)?new cljs.core.Symbol(null,"optional","optional",-600484260,null):new cljs.core.Symbol(null,"one","one",-1719427865,null));
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = schema.core.explain.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(s));
return cljs.core._conj.call(null,(function (){var x__8341__auto____$2 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$2);
})(),x__8341__auto____$1);
})(),x__8341__auto__);
})());

var G__15704 = (i__15701 + (1));
i__15701 = G__15704;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15702),schema$core$iter__15699.call(null,cljs.core.chunk_rest.call(null,s__15700__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15702),null);
}
} else {
var s = cljs.core.first.call(null,s__15700__$2);
return cljs.core.cons.call(null,(function (){var x__8341__auto__ = (cljs.core.truth_(s.optional_QMARK_)?new cljs.core.Symbol(null,"optional","optional",-600484260,null):new cljs.core.Symbol(null,"one","one",-1719427865,null));
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = schema.core.explain.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(s));
return cljs.core._conj.call(null,(function (){var x__8341__auto____$2 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$2);
})(),x__8341__auto____$1);
})(),x__8341__auto__);
})(),schema$core$iter__15699.call(null,cljs.core.rest.call(null,s__15700__$2)));
}
} else {
return null;
}
break;
}
});})(vec__15696,singles,multi,this$__$1))
,null,null));
});})(vec__15696,singles,multi,this$__$1))
;
return iter__8269__auto__.call(null,singles);
})(),(cljs.core.truth_(multi)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain.call(null,multi)], null):null)));
});
/**
 * A schema for a pair of schemas and their names
 */
schema.core.pair = (function schema$core$pair(first_schema,first_name,second_schema,second_name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,first_schema,first_name),schema.core.one.call(null,second_schema,second_name)], null);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Record = (function (klass,schema,__meta,__extmap,__hash){
this.klass = klass;
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Record.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.Record.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15709,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15711 = k15709;
var G__15711__$1 = (((G__15711 instanceof cljs.core.Keyword))?G__15711.fqn:null);
switch (G__15711__$1) {
case "klass":
return self__.klass;

break;
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15709,else__8085__auto__);

}
});

schema.core.Record.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.Record{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"klass","klass",-1386752349),self__.klass],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Record.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Record.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15708){
var self__ = this;
var G__15708__$1 = this;
return (new cljs.core.RecordIter((0),G__15708__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"klass","klass",-1386752349),new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Record.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.Record.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.Record(self__.klass,self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Record.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Record.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.Record.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Record.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"klass","klass",-1386752349),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.Record(self__.klass,self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.Record.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15708){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15712 = cljs.core.keyword_identical_QMARK_;
var expr__15713 = k__8090__auto__;
if(cljs.core.truth_(pred__15712.call(null,new cljs.core.Keyword(null,"klass","klass",-1386752349),expr__15713))){
return (new schema.core.Record(G__15708,self__.schema,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__15712.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__15713))){
return (new schema.core.Record(self__.klass,G__15708,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Record(self__.klass,self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15708),null));
}
}
});

schema.core.Record.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"klass","klass",-1386752349),self__.klass],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Record.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15708){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.Record(self__.klass,self__.schema,G__15708,self__.__extmap,self__.__hash));
});

schema.core.Record.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.Record.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Record.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,(function (){var p = schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__15705_SHARP_){
return (p1__15705_SHARP_ instanceof self__.klass);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__15706_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = self__.klass;
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = p1__15706_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
})(),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null));
});})(this$__$1))
);
var temp__5276__auto__ = new cljs.core.Keyword(null,"extra-validator-fn","extra-validator-fn",1562905865).cljs$core$IFn$_invoke$arity$1(this$__$1);
if(cljs.core.truth_(temp__5276__auto__)){
var evf = temp__5276__auto__;
return cljs.core.some_fn.call(null,p,schema.spec.core.precondition.call(null,this$__$1,evf,((function (evf,temp__5276__auto__,p,this$__$1){
return (function (p1__15707_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__15707_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"passes-extra-validation?","passes-extra-validation?",-1964809231,null));
});})(evf,temp__5276__auto__,p,this$__$1))
));
} else {
return p;
}
})(),new cljs.core.Keyword(null,"constructor","constructor",-1953928811).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,this$__$1)),schema.core.map_elements.call(null,self__.schema),schema.core.map_error.call(null));
});

schema.core.Record.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = cljs.core.symbol.call(null,cljs.core.pr_str.call(null,self__.klass));
return cljs.core._conj.call(null,(function (){var x__8341__auto____$1 = schema.core.explain.call(null,self__.schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto____$1);
})(),x__8341__auto__);
})(),new cljs.core.Symbol(null,"record","record",861424668,null));
});

schema.core.Record.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"klass","klass",253779178,null),new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

schema.core.Record.cljs$lang$type = true;

schema.core.Record.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Record");
});

schema.core.Record.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/Record");
});

schema.core.__GT_Record = (function schema$core$__GT_Record(klass,schema__$1){
return (new schema.core.Record(klass,schema__$1,null,null,null));
});

schema.core.map__GT_Record = (function schema$core$map__GT_Record(G__15710){
return (new schema.core.Record(new cljs.core.Keyword(null,"klass","klass",-1386752349).cljs$core$IFn$_invoke$arity$1(G__15710),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__15710),null,cljs.core.dissoc.call(null,G__15710,new cljs.core.Keyword(null,"klass","klass",-1386752349),new cljs.core.Keyword(null,"schema","schema",-1582001791)),null));
});

schema.core.record_STAR_ = (function schema$core$record_STAR_(klass,schema__$1,map_constructor){
if(cljs.core.map_QMARK_.call(null,schema__$1)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Expected map, got %s",schema.utils.type_of.call(null,schema__$1))));
}

return cljs.core.with_meta.call(null,(new schema.core.Record(klass,schema__$1,null,null,null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"constructor","constructor",-1953928811),map_constructor], null));
});
schema.core.explain_input_schema = (function schema$core$explain_input_schema(input_schema){
var vec__15721 = cljs.core.split_with.call(null,(function (p1__15716_SHARP_){
return (p1__15716_SHARP_ instanceof schema.core.One);
}),input_schema);
var required = cljs.core.nth.call(null,vec__15721,(0),null);
var more = cljs.core.nth.call(null,vec__15721,(1),null);
return cljs.core.concat.call(null,cljs.core.map.call(null,((function (vec__15721,required,more){
return (function (p1__15717_SHARP_){
return schema.core.explain.call(null,p1__15717_SHARP_.schema);
});})(vec__15721,required,more))
,required),((cljs.core.seq.call(null,more))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),cljs.core.mapv.call(null,schema.core.explain,more)], null):null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.FnSchema = (function (output_schema,input_schemas,__meta,__extmap,__hash){
this.output_schema = output_schema;
this.input_schemas = input_schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.FnSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8082__auto__,k__8083__auto__){
var self__ = this;
var this__8082__auto____$1 = this;
return this__8082__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8083__auto__,null);
});

schema.core.FnSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8084__auto__,k15725,else__8085__auto__){
var self__ = this;
var this__8084__auto____$1 = this;
var G__15727 = k15725;
var G__15727__$1 = (((G__15727 instanceof cljs.core.Keyword))?G__15727.fqn:null);
switch (G__15727__$1) {
case "output-schema":
return self__.output_schema;

break;
case "input-schemas":
return self__.input_schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k15725,else__8085__auto__);

}
});

schema.core.FnSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8096__auto__,writer__8097__auto__,opts__8098__auto__){
var self__ = this;
var this__8096__auto____$1 = this;
var pr_pair__8099__auto__ = ((function (this__8096__auto____$1){
return (function (keyval__8100__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,cljs.core.pr_writer,""," ","",opts__8098__auto__,keyval__8100__auto__);
});})(this__8096__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8097__auto__,pr_pair__8099__auto__,"#schema.core.FnSchema{",", ","}",opts__8098__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"output-schema","output-schema",272504137),self__.output_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),self__.input_schemas],null))], null),self__.__extmap));
});

schema.core.FnSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.FnSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__15724){
var self__ = this;
var G__15724__$1 = this;
return (new cljs.core.RecordIter((0),G__15724__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"output-schema","output-schema",272504137),new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.FnSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8080__auto__){
var self__ = this;
var this__8080__auto____$1 = this;
return self__.__meta;
});

schema.core.FnSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8076__auto__){
var self__ = this;
var this__8076__auto____$1 = this;
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.FnSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8086__auto__){
var self__ = this;
var this__8086__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.FnSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8077__auto__){
var self__ = this;
var this__8077__auto____$1 = this;
var h__7849__auto__ = self__.__hash;
if(!((h__7849__auto__ == null))){
return h__7849__auto__;
} else {
var h__7849__auto____$1 = cljs.core.hash_imap.call(null,this__8077__auto____$1);
self__.__hash = h__7849__auto____$1;

return h__7849__auto____$1;
}
});

schema.core.FnSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8078__auto__,other__8079__auto__){
var self__ = this;
var this__8078__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7395__auto__ = other__8079__auto__;
if(cljs.core.truth_(and__7395__auto__)){
return ((this__8078__auto____$1.constructor === other__8079__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8078__auto____$1,other__8079__auto__));
} else {
return and__7395__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.FnSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8091__auto__,k__8092__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"output-schema","output-schema",272504137),null,new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),null], null), null),k__8092__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8091__auto____$1),self__.__meta),k__8092__auto__);
} else {
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8092__auto__)),null));
}
});

schema.core.FnSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8089__auto__,k__8090__auto__,G__15724){
var self__ = this;
var this__8089__auto____$1 = this;
var pred__15728 = cljs.core.keyword_identical_QMARK_;
var expr__15729 = k__8090__auto__;
if(cljs.core.truth_(pred__15728.call(null,new cljs.core.Keyword(null,"output-schema","output-schema",272504137),expr__15729))){
return (new schema.core.FnSchema(G__15724,self__.input_schemas,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__15728.call(null,new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),expr__15729))){
return (new schema.core.FnSchema(self__.output_schema,G__15724,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8090__auto__,G__15724),null));
}
}
});

schema.core.FnSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8094__auto__){
var self__ = this;
var this__8094__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"output-schema","output-schema",272504137),self__.output_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),self__.input_schemas],null))], null),self__.__extmap));
});

schema.core.FnSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8081__auto__,G__15724){
var self__ = this;
var this__8081__auto____$1 = this;
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,G__15724,self__.__extmap,self__.__hash));
});

schema.core.FnSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8087__auto__,entry__8088__auto__){
var self__ = this;
var this__8087__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8088__auto__)){
return this__8087__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8088__auto__,(0)),cljs.core._nth.call(null,entry__8088__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8087__auto____$1,entry__8088__auto__);
}
});

schema.core.FnSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.FnSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,cljs.core.ifn_QMARK_,((function (this$__$1){
return (function (p1__13882__13883__auto__){
return cljs.core._conj.call(null,(function (){var x__8341__auto__ = p1__13882__13883__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),new cljs.core.Symbol(null,"ifn?","ifn?",-2106461064,null));
});})(this$__$1))
));
});

schema.core.FnSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.input_schemas) > (1))){
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"=>*","=>*",1909690043,null),schema.core.explain.call(null,self__.output_schema),cljs.core.map.call(null,schema.core.explain_input_schema,self__.input_schemas));
} else {
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"=>","=>",-813269641,null),schema.core.explain.call(null,self__.output_schema),schema.core.explain_input_schema.call(null,cljs.core.first.call(null,self__.input_schemas)));
}
});

schema.core.FnSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"output-schema","output-schema",1913035664,null),new cljs.core.Symbol(null,"input-schemas","input-schemas",658376722,null)], null);
});

schema.core.FnSchema.cljs$lang$type = true;

schema.core.FnSchema.cljs$lang$ctorPrSeq = (function (this__8118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/FnSchema");
});

schema.core.FnSchema.cljs$lang$ctorPrWriter = (function (this__8118__auto__,writer__8119__auto__){
return cljs.core._write.call(null,writer__8119__auto__,"schema.core/FnSchema");
});

schema.core.__GT_FnSchema = (function schema$core$__GT_FnSchema(output_schema,input_schemas){
return (new schema.core.FnSchema(output_schema,input_schemas,null,null,null));
});

schema.core.map__GT_FnSchema = (function schema$core$map__GT_FnSchema(G__15726){
return (new schema.core.FnSchema(new cljs.core.Keyword(null,"output-schema","output-schema",272504137).cljs$core$IFn$_invoke$arity$1(G__15726),new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805).cljs$core$IFn$_invoke$arity$1(G__15726),null,cljs.core.dissoc.call(null,G__15726,new cljs.core.Keyword(null,"output-schema","output-schema",272504137),new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805)),null));
});

schema.core.arity = (function schema$core$arity(input_schema){
if(cljs.core.seq.call(null,input_schema)){
if((cljs.core.last.call(null,input_schema) instanceof schema.core.One)){
return cljs.core.count.call(null,input_schema);
} else {
return Number.MAX_VALUE;
}
} else {
return (0);
}
});
/**
 * A function outputting a value in output schema, whose argument vector must match one of
 * input-schemas, each of which should be a sequence schema.
 * Currently function schemas are purely descriptive; they validate against any function,
 * regardless of actual input and output types.
 */
schema.core.make_fn_schema = (function schema$core$make_fn_schema(output_schema,input_schemas){
if(cljs.core.seq.call(null,input_schemas)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Function must have at least one input schema")));
}

if(cljs.core.every_QMARK_.call(null,cljs.core.vector_QMARK_,input_schemas)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Each arity must be a vector.")));
}

if(cljs.core.truth_(cljs.core.apply.call(null,cljs.core.distinct_QMARK_,cljs.core.map.call(null,schema.core.arity,input_schemas)))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Arities must be distinct")));
}

return (new schema.core.FnSchema(output_schema,cljs.core.sort_by.call(null,schema.core.arity,input_schemas),null,null,null));
});
/**
 * Records name in schema's metadata.
 */
schema.core.schema_with_name = (function schema$core$schema_with_name(schema__$1,name){
return cljs.core.vary_meta.call(null,schema__$1,cljs.core.assoc,new cljs.core.Keyword(null,"name","name",1843675177),name);
});
/**
 * Returns the name of a schema attached via schema-with-name (or defschema).
 */
schema.core.schema_name = (function schema$core$schema_name(schema__$1){
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,schema__$1));
});
/**
 * Returns the namespace of a schema attached via defschema.
 */
schema.core.schema_ns = (function schema$core$schema_ns(schema__$1){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,schema__$1));
});
/**
 * Get the current global schema validation setting.
 */
schema.core.fn_validation_QMARK_ = (function schema$core$fn_validation_QMARK_(){
return schema.utils.use_fn_validation.get_cell();
});
/**
 * Globally turn on (or off) schema validation for all s/fn and s/defn instances.
 */
schema.core.set_fn_validation_BANG_ = (function schema$core$set_fn_validation_BANG_(on_QMARK_){
return schema.utils.use_fn_validation.set_cell(on_QMARK_);
});
/**
 * Attach the schema to fn f at runtime, extractable by fn-schema.
 */
schema.core.schematize_fn = (function schema$core$schematize_fn(f,schema__$1){
return cljs.core.vary_meta.call(null,f,cljs.core.assoc,new cljs.core.Keyword(null,"schema","schema",-1582001791),schema__$1);
});
/**
 * Produce the schema for a function defined with s/fn or s/defn.
 */
schema.core.fn_schema = (function schema$core$fn_schema(f){
if(cljs.core.fn_QMARK_.call(null,f)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Non-function %s",schema.utils.type_of.call(null,f))));
}

var or__7407__auto__ = schema.utils.class_schema.call(null,schema.utils.fn_schema_bearer.call(null,f));
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
var m__13573__auto__ = cljs.core.meta.call(null,f);
var k__13574__auto__ = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var temp__5276__auto__ = cljs.core.find.call(null,m__13573__auto__,k__13574__auto__);
if(cljs.core.truth_(temp__5276__auto__)){
var pair__13575__auto__ = temp__5276__auto__;
return cljs.core.val.call(null,pair__13575__auto__);
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Key %s not found in %s",k__13574__auto__,m__13573__auto__)));
}
}
});
/**
 * Sets the maximum length of value to be output before it is contracted to a prettier name.
 */
schema.core.set_max_value_length_BANG_ = (function schema$core$set_max_value_length_BANG_(max_length){
return cljs.core.reset_BANG_.call(null,schema.utils.max_value_length,max_length);
});

//# sourceMappingURL=core.js.map