# Ring middleware implementing the W3C Trace Context Standard

# Middleware

This package defines the
`nl.jomco.ring-trace-context/wrap-trace-context` middleware function.

This parses the `traceparent` header if present or generates new
`traceparent` data and sets it on the request for the wrapped handler
under the `:traceparent` key.

```
request =>
{:request-method :get
 # ...
 :traceparent {:version "00",
               :trace-id "74e744b8a6cb016a0ebf84d7d7932512",
               :parent-id "23fc93418d1e37bd",
               :trace-flags "00"}}
```

# Headers

The standard defines two headers; `traceparent` and
`tracestate`.

## `traceparent`

The `traceparent` header contains 4 fields, `version`, `trace-id`,
`parent-id` and `flags`. The only currenly defined versions are "00"
(hexadecimal), and the "invalid version" "ff".

## `tracestate`

TODO: document further

# References

https://newrelic.com/blog/nerdlog/w3c-trace-context-distributed-tracing-standard

https://www.w3.org/TR/trace-context/

