(defproject nl.jomco/ring-trace-context "0.0.7"
  :description "Ring middleware and functions for W3C Trace Context"
  :dependencies [[org.clojure/clojure "1.10.0" :scope "provided"]
                 [commons-codec/commons-codec "1.15"]]
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url  "https://www.eclipse.org/legal/epl-2.0/"}
  :url  "https://git.sr.ht/~jomco/ring-trace-context"
  :scm {:name "git"
        :url  "https://git.sr.ht/~jomco/ring-trace-context"}
  ;; setup `vX.Y.Z` tags, deploy to clojars
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :profiles {:dev {:dependencies [[clj-kondo "2022.11.02"]]
                   :aliases      {"lint"           ["run" "-m" "clj-kondo.main" "--lint" "src" "test"]}}})
