
package eduroute;

import java.math.BigInteger;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.Holder;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6 in JDK 6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "KeyPortType", targetNamespace = "urn:edurouteNamespace")
@SOAPBinding(style = SOAPBinding.Style.RPC)
public interface KeyPortType {


    /**
     * Maak een batchnummer aan voor deze overdracht.
     * 
     * @param resString
     * @param resParam
     * @param distributeurBatchnummer
     * @param omschrijving
     * @param controleCode
     * @param leverancierCode
     */
    @WebMethod(action = "urn:Magic-KeyPortType#maakBatch")
    public void maakBatch(
        @WebParam(name = "LeverancierCode", partName = "LeverancierCode")
        String leverancierCode,
        @WebParam(name = "ControleCode", partName = "ControleCode")
        String controleCode,
        @WebParam(name = "Omschrijving", partName = "Omschrijving")
        String omschrijving,
        @WebParam(name = "DistributeurBatchnummer", partName = "DistributeurBatchnummer")
        String distributeurBatchnummer,
        @WebParam(name = "ResParam", mode = WebParam.Mode.OUT, partName = "ResParam")
        Holder<BigInteger> resParam,
        @WebParam(name = "ResString", mode = WebParam.Mode.OUT, partName = "ResString")
        Holder<String> resString);

    /**
     * Maak een content-record aan.
     * 
     * @param scormLocatie
     * @param password
     * @param activatiecodeNodig
     * @param url
     * @param scormurl
     * @param ean
     * @param beschikbaarVanaf
     * @param resString
     * @param resParam
     * @param sessieID
     * @param titel
     * @param downloadPath
     * @param user
     * @param soort
     */
    @WebMethod(action = "urn:Magic-KeyPortType#maakContent")
    public void maakContent(
        @WebParam(name = "SessieID", partName = "SessieID")
        String sessieID,
        @WebParam(name = "EAN", partName = "EAN")
        String ean,
        @WebParam(name = "Titel", partName = "Titel")
        String titel,
        @WebParam(name = "Soort", partName = "Soort")
        String soort,
        @WebParam(name = "URL", partName = "URL")
        String url,
        @WebParam(name = "User", partName = "User")
        String user,
        @WebParam(name = "Password", partName = "Password")
        String password,
        @WebParam(name = "BeschikbaarVanaf", partName = "BeschikbaarVanaf")
        String beschikbaarVanaf,
        @WebParam(name = "DownloadPath", partName = "DownloadPath")
        String downloadPath,
        @WebParam(name = "SCORMURL", partName = "SCORMURL")
        String scormurl,
        @WebParam(name = "SCORMLocatie", partName = "SCORMLocatie")
        String scormLocatie,
        @WebParam(name = "ActivatiecodeNodig", partName = "ActivatiecodeNodig")
        String activatiecodeNodig,
        @WebParam(name = "ResParam", mode = WebParam.Mode.OUT, partName = "ResParam")
        Holder<BigInteger> resParam,
        @WebParam(name = "ResString", mode = WebParam.Mode.OUT, partName = "ResString")
        Holder<String> resString);

    /**
     * Verwijdert een content-record.
     * 
     * @param ean
     * @param resString
     * @param resParam
     * @param sessieID
     */
    @WebMethod(action = "urn:Magic-KeyPortType#verwijderContent")
    public void verwijderContent(
        @WebParam(name = "SessieID", partName = "SessieID")
        String sessieID,
        @WebParam(name = "EAN", partName = "EAN")
        String ean,
        @WebParam(name = "ResParam", mode = WebParam.Mode.OUT, partName = "ResParam")
        Holder<BigInteger> resParam,
        @WebParam(name = "ResString", mode = WebParam.Mode.OUT, partName = "ResString")
        Holder<String> resString);

    /**
     * MAak een CRHLicentie-record.
     * 
     * @param ean
     * @param resString
     * @param resParam
     * @param sessieID
     * @param crhCode
     * @param verloopDatum
     * @param leverancierCRHLicentieID
     * @param licentieDatum
     */
    @WebMethod(action = "urn:Magic-KeyPortType#maakCRHLicentie")
    public void maakCRHLicentie(
        @WebParam(name = "SessieID", partName = "SessieID")
        String sessieID,
        @WebParam(name = "LeverancierCRHLicentieID", partName = "LeverancierCRHLicentieID")
        String leverancierCRHLicentieID,
        @WebParam(name = "CRHCode", partName = "CRHCode")
        String crhCode,
        @WebParam(name = "EAN", partName = "EAN")
        String ean,
        @WebParam(name = "LicentieDatum", partName = "LicentieDatum")
        String licentieDatum,
        @WebParam(name = "VerloopDatum", partName = "VerloopDatum")
        String verloopDatum,
        @WebParam(name = "ResParam", mode = WebParam.Mode.OUT, partName = "ResParam")
        Holder<BigInteger> resParam,
        @WebParam(name = "ResString", mode = WebParam.Mode.OUT, partName = "ResString")
        Holder<String> resString);

    /**
     * Maak een schoollicentie-record aan.
     * 
     * @param ean
     * @param resString
     * @param resParam
     * @param assuNr
     * @param sessieID
     * @param status
     * @param verloopDatum
     * @param leverancierSchoolLicentieID
     * @param heleSchool
     * @param licentieDatum
     */
    @WebMethod(action = "urn:Magic-KeyPortType#maakSchoolLicentie")
    public void maakSchoolLicentie(
        @WebParam(name = "SessieID", partName = "SessieID")
        String sessieID,
        @WebParam(name = "LeverancierSchoolLicentieID", partName = "LeverancierSchoolLicentieID")
        String leverancierSchoolLicentieID,
        @WebParam(name = "AssuNr", partName = "AssuNr")
        String assuNr,
        @WebParam(name = "EAN", partName = "EAN")
        String ean,
        @WebParam(name = "LicentieDatum", partName = "LicentieDatum")
        String licentieDatum,
        @WebParam(name = "VerloopDatum", partName = "VerloopDatum")
        String verloopDatum,
        @WebParam(name = "Status", partName = "Status")
        String status,
        @WebParam(name = "HeleSchool", partName = "HeleSchool")
        String heleSchool,
        @WebParam(name = "ResParam", mode = WebParam.Mode.OUT, partName = "ResParam")
        Holder<BigInteger> resParam,
        @WebParam(name = "ResString", mode = WebParam.Mode.OUT, partName = "ResString")
        Holder<String> resString);

    /**
     * Checkt de login van een account via een sessie
     * 
     * @param resString
     * @param resParam
     * @param sessieID
     * @param controleCode
     * @param leverancierCode
     */
    @WebMethod(action = "urn:Magic-KeyPortType#sessieLogin")
    public void sessieLogin(
        @WebParam(name = "LeverancierCode", partName = "LeverancierCode")
        String leverancierCode,
        @WebParam(name = "ControleCode", partName = "ControleCode")
        String controleCode,
        @WebParam(name = "SessieID", partName = "SessieID")
        String sessieID,
        @WebParam(name = "ResParam", mode = WebParam.Mode.OUT, partName = "ResParam")
        Holder<BigInteger> resParam,
        @WebParam(name = "ResString", mode = WebParam.Mode.OUT, partName = "ResString")
        Holder<String> resString);

    /**
     * Vraagt de licenties van een account op.
     * 
     * @param resString
     * @param resParam
     * @param persoonID
     * @param controleCode
     * @param leverancierCode
     */
    @WebMethod(action = "urn:Magic-KeyPortType#licenties")
    public void licenties(
        @WebParam(name = "LeverancierCode", partName = "LeverancierCode")
        String leverancierCode,
        @WebParam(name = "ControleCode", partName = "ControleCode")
        String controleCode,
        @WebParam(name = "persoon_ID", partName = "persoon_ID")
        String persoonID,
        @WebParam(name = "ResParam", mode = WebParam.Mode.OUT, partName = "ResParam")
        Holder<BigInteger> resParam,
        @WebParam(name = "ResString", mode = WebParam.Mode.OUT, partName = "ResString")
        Holder<String> resString);

    /**
     * Vraagt de gegevens van een ASSUnr of Brin op.
     * 
     * @param resString
     * @param resParam
     * @param assuNr
     * @param brin
     * @param uitgeverCode
     * @param controleCode
     */
    @WebMethod(action = "urn:Magic-KeyPortType#getSchoolInfo")
    public void getSchoolInfo(
        @WebParam(name = "UitgeverCode", partName = "UitgeverCode")
        String uitgeverCode,
        @WebParam(name = "ControleCode", partName = "ControleCode")
        String controleCode,
        @WebParam(name = "AssuNr", partName = "AssuNr")
        String assuNr,
        @WebParam(name = "Brin", partName = "Brin")
        String brin,
        @WebParam(name = "ResParam", mode = WebParam.Mode.OUT, partName = "ResParam")
        Holder<BigInteger> resParam,
        @WebParam(name = "ResString", mode = WebParam.Mode.OUT, partName = "ResString")
        Holder<String> resString);

    /**
     * Lever Activatiecodes uit naar de Eduroute activatiecode voorraad voor distributeurs.
     * 
     * @param ean
     * @param resString
     * @param resParam
     * @param vervaldatum
     * @param factuurNummer
     * @param orderReferentie
     * @param sessieID
     * @param activatiecodes
     * @param distributeurID
     */
    @WebMethod(action = "urn:Magic-KeyPortType#leverActivatiecodes")
    public void leverActivatiecodes(
        @WebParam(name = "SessieID", partName = "SessieID")
        String sessieID,
        @WebParam(name = "Distributeur_ID", partName = "Distributeur_ID")
        BigInteger distributeurID,
        @WebParam(name = "EAN", partName = "EAN")
        String ean,
        @WebParam(name = "OrderReferentie", partName = "OrderReferentie")
        String orderReferentie,
        @WebParam(name = "Activatiecodes", partName = "Activatiecodes")
        String activatiecodes,
        @WebParam(name = "Vervaldatum", partName = "Vervaldatum")
        String vervaldatum,
        @WebParam(name = "FactuurNummer", partName = "FactuurNummer")
        String factuurNummer,
        @WebParam(name = "ResParam", mode = WebParam.Mode.OUT, partName = "ResParam")
        Holder<BigInteger> resParam,
        @WebParam(name = "ResString", mode = WebParam.Mode.OUT, partName = "ResString")
        Holder<String> resString);

}
