(defproject nl.studyflow/rill "0.3.0-SNAPSHOT"
  :deploy-repositories [["releases" {:url "https://clojars.org"
                                     :creds :gpg}]]
  :description "An Event Sourcing Toolkit"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/core.async "0.3.443"]
                 [org.clojure/tools.logging "0.2.6"]
                 [prismatic/schema "0.2.2"]
                 [slingshot "0.10.3"]
                 [environ "0.5.0"]
                 [identifiers "1.1.0"]
                 [org.clojure/java.jdbc "0.6.1"]
                 [org.postgresql/postgresql "42.1.1"]
                 [com.taoensso/nippy "2.6.3"]]
  :profiles {:dev {:plugins [[lein-repack "0.2.8"]
                             [lein-set-version "0.4.1"]]}}
  :set-version
  {:updates [{:path "README.org" :no-snapshot true}]}
  :repack [{:path "src"
            :type :clojure
            :levels 2}])
