/*
 * Decompiled with CFR 0.152.
 */
package com.kikini.logging.simpledb;

import com.google.common.collect.ImmutableMap;
import com.kikini.logging.simpledb.GranularDelay;
import java.util.Map;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

class SimpleDBRow
implements Delayed {
    private final Delayed delayed;
    private String msg;
    private String host;
    private String context;
    private String logger;
    private String level;
    private long time;
    private Map<String, String> mdcPropertyMap;

    SimpleDBRow(String msg, String host, String context, String logger, String level, long time, long granularity, Map<String, String> mdcPropertyMap) {
        this.msg = msg;
        this.host = host;
        this.context = context;
        this.logger = logger;
        this.level = level;
        this.time = time;
        this.delayed = new GranularDelay(granularity);
        this.mdcPropertyMap = ImmutableMap.copyOf(mdcPropertyMap);
    }

    public String getMsg() {
        return this.msg;
    }

    public String getHost() {
        return this.host;
    }

    public String getContext() {
        return this.context;
    }

    public String getLogger() {
        return this.logger;
    }

    public String getLevel() {
        return this.level;
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.delayed.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.delayed.compareTo(o);
    }

    public Map<String, String> getMDCPropertyMap() {
        return this.mdcPropertyMap;
    }
}

