/*
 * Decompiled with CFR 0.152.
 */
package com.kikini.logging.simpledb;

import com.kikini.logging.simpledb.SimpleDBRow;
import com.kikini.logging.simpledb.SimpleDBWriter;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;

class SimpleDBShutdownHook
implements Runnable {
    private BlockingQueue<SimpleDBRow> queue;
    private SimpleDBWriter writer;
    private Thread consumerThread;

    SimpleDBShutdownHook(BlockingQueue<SimpleDBRow> queue, SimpleDBWriter writer, Thread consumerThread) {
        this.queue = queue;
        this.writer = writer;
        this.consumerThread = consumerThread;
    }

    private void drainQueue() {
        ArrayList<SimpleDBRow> rows = new ArrayList<SimpleDBRow>();
        while (!this.queue.isEmpty()) {
            SimpleDBRow row = (SimpleDBRow)this.queue.peek();
            rows.add(row);
            this.queue.remove(row);
        }
        this.writer.writeRows(rows);
    }

    @Override
    public void run() {
        this.consumerThread.interrupt();
        try {
            this.consumerThread.join();
        }
        catch (InterruptedException e) {
            return;
        }
        this.drainQueue();
    }
}

