/*
 * Decompiled with CFR 0.152.
 */
package com.kikini.logging;

import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineLogger
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LineLogger.class);
    private final InputStreamReader input;
    private final LogAtLevel logAtLevel;

    public LineLogger(InputStreamReader input, LogAtLevel level) {
        this.input = input;
        this.logAtLevel = level;
    }

    String readLine() throws IOException {
        int c;
        String s = "";
        while ((c = this.input.read()) != -1) {
            if (c == 13 || c == 10) {
                if (s.length() <= 0) continue;
                return s;
            }
            s = s + (char)c;
        }
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    @Override
    public void run() {
        try {
            String s = this.readLine();
            while (s != null) {
                this.logAtLevel.log(s);
                s = this.readLine();
            }
        }
        catch (IOException e) {
            return;
        }
    }

    public static enum LogAtLevel {
        DEBUG{

            @Override
            public void log(String msg) {
                LOGGER.debug(msg);
            }
        }
        ,
        ERROR{

            @Override
            public void log(String msg) {
                LOGGER.error(msg);
            }
        }
        ,
        INFO{

            @Override
            public void log(String msg) {
                LOGGER.info(msg);
            }
        }
        ,
        TRACE{

            @Override
            public void log(String msg) {
                LOGGER.trace(msg);
            }
        }
        ,
        WARN{

            @Override
            public void log(String msg) {
                LOGGER.warn(msg);
            }
        };


        public abstract void log(String var1);
    }
}

