/*
 * Decompiled with CFR 0.152.
 */
package com.kikini.logging.simpledb;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.google.common.collect.ImmutableMap;
import com.kikini.logging.simpledb.SimpleDBConsumer;
import com.kikini.logging.simpledb.SimpleDBRow;
import com.kikini.logging.simpledb.SimpleDBShutdownHook;
import com.kikini.logging.simpledb.SimpleDBWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import org.joda.time.DateTimeZone;

public class SimpleDBAppender
extends AppenderBase<LoggingEvent> {
    private AmazonSimpleDB sdb = null;
    private SimpleDBConsumer consumer = null;
    private SimpleDBWriter writer = null;
    private BlockingQueue<SimpleDBRow> queue = null;
    private String contextName = null;
    private String host = null;
    private long loggingPeriodMillis = 10000L;
    private String timeZone = null;
    private String domainName;
    private String accessId;
    private String secretKey;

    public void setCommonProperties(String filename) throws FileNotFoundException, IOException {
        this.setCommonProperties(new FileInputStream(filename));
    }

    void setCommonProperties(InputStream propStream) throws IOException {
        Properties props = new Properties();
        props.load(propStream);
        String dom = props.getProperty("domainName");
        String host = props.getProperty("host");
        String accessId = props.getProperty("accessId");
        String secretKey = props.getProperty("secretKey");
        String timeZone = props.getProperty("timeZone");
        if (null != dom) {
            this.setDomainName(dom);
        }
        if (null != host) {
            this.setHost(host);
        }
        if (null != accessId) {
            this.setAccessId(accessId);
        }
        if (null != secretKey) {
            this.setSecretKey(secretKey);
        }
        if (null != timeZone) {
            this.setTimeZone(timeZone);
        }
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setLoggingPeriodMillis(long loggingPeriodMillis) {
        this.loggingPeriodMillis = loggingPeriodMillis;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public SimpleDBAppender(AmazonSimpleDB sdb, String dom, SimpleDBConsumer consumer, SimpleDBWriter writer, BlockingQueue<SimpleDBRow> queue, String instanceId) {
        this.sdb = sdb;
        this.domainName = dom;
        this.consumer = consumer;
        this.writer = writer;
        this.queue = queue;
        this.host = instanceId;
    }

    public SimpleDBAppender() {
    }

    public void start() {
        boolean requiredPropsSet = true;
        if (null == this.accessId) {
            this.addStatus((Status)new ErrorStatus("Access ID not set", (Object)this));
            requiredPropsSet = false;
        }
        if (null == this.secretKey) {
            this.addStatus((Status)new ErrorStatus("Secret key not set", (Object)this));
            requiredPropsSet = false;
        }
        if (null == this.domainName) {
            this.addStatus((Status)new ErrorStatus("Domain name not set", (Object)this));
            requiredPropsSet = false;
        }
        if (!requiredPropsSet) {
            return;
        }
        if (this.sdb == null) {
            try {
                BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessId, this.secretKey);
                this.sdb = new AmazonSimpleDBClient((AWSCredentials)credentials);
                boolean found = false;
                ListDomainsResult result = this.sdb.listDomains();
                for (String dom : result.getDomainNames()) {
                    if (!dom.equals(this.domainName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.sdb.createDomain(new CreateDomainRequest(this.domainName));
                }
            }
            catch (AmazonClientException e) {
                this.addStatus((Status)new ErrorStatus("Could not get access SimpleDB", (Object)this, (Throwable)e));
                return;
            }
        }
        if (this.queue == null) {
            this.queue = new DelayQueue<SimpleDBRow>();
        }
        if (this.writer == null) {
            this.writer = new SimpleDBWriter(this.sdb, this.domainName);
        }
        if (this.timeZone != null) {
            this.writer.setTimeZone(DateTimeZone.forID((String)this.timeZone));
        }
        if (this.consumer == null) {
            this.consumer = new SimpleDBConsumer(this.queue, this.writer);
        }
        Thread consumerThread = new Thread(this.consumer);
        SimpleDBShutdownHook shutdown = new SimpleDBShutdownHook(this.queue, this.writer, consumerThread);
        Runtime.getRuntime().addShutdownHook(new Thread(shutdown));
        consumerThread.setDaemon(true);
        consumerThread.start();
        super.start();
    }

    private void queueForProcessing(String msg, String context, String logger, String level, long time, Map<String, String> mdcPropertyMap) {
        SimpleDBRow row = new SimpleDBRow(msg, this.host, context, logger, level, time, this.loggingPeriodMillis, mdcPropertyMap);
        this.queue.add(row);
    }

    public void append(LoggingEvent event) {
        ImmutableMap mdcPropertyMap = ImmutableMap.copyOf((Map)event.getMDCPropertyMap());
        this.queueForProcessing(event.getFormattedMessage(), this.contextName, event.getLoggerName(), event.getLevel().toString(), event.getTimeStamp(), (Map<String, String>)mdcPropertyMap);
    }
}

